/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.elements;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.extension.CompatibilityStatus;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.extension.ICompatibleReportItem;
import org.eclipse.birt.report.model.api.extension.IPropertyDefinition;
import org.eclipse.birt.report.model.api.extension.IReportItem;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.validators.ExtensionValidator;
import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.PropertySearchStrategy;
import org.eclipse.birt.report.model.elements.ElementVisitor;
import org.eclipse.birt.report.model.elements.ReportItem;
import org.eclipse.birt.report.model.elements.interfaces.IExtendedItemModel;
import org.eclipse.birt.report.model.elements.strategy.CopyPolicy;
import org.eclipse.birt.report.model.elements.strategy.ExtendedItemPropSearchStrategy;
import org.eclipse.birt.report.model.extension.DummyPeerExtensibilityProvider;
import org.eclipse.birt.report.model.extension.IExtendableElement;
import org.eclipse.birt.report.model.extension.PeerExtensibilityProvider;
import org.eclipse.birt.report.model.extension.PeerExtensibilityProviderFactory;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ExtensionElementDefn;
import org.eclipse.birt.report.model.util.ContentIterator;

public class ExtendedItem
extends ReportItem
implements IExtendableElement,
IExtendedItemModel {
    protected String extensionName = null;
    protected String extensionVersion = null;
    protected PeerExtensibilityProvider provider = new DummyPeerExtensibilityProvider(this, null);
    private List methods = null;

    public ExtendedItem() {
    }

    public ExtendedItem(String theName) {
        super(theName);
    }

    public void apply(ElementVisitor visitor) {
        visitor.visitExtendedItem(this);
    }

    public String getElementName() {
        return "ExtendedItem";
    }

    public DesignElementHandle getHandle(Module module) {
        return this.handle(module);
    }

    public ExtendedItemHandle handle(Module module) {
        if (this.handle == null) {
            this.handle = new ExtendedItemHandle(module, this);
            IReportItem item = this.provider.getExtensionElement();
            if (item != null) {
                item.setHandle((ExtendedItemHandle)this.handle);
            }
        }
        return (ExtendedItemHandle)this.handle;
    }

    public boolean hasLocalPropertyValues() {
        if (super.hasLocalPropertyValues()) {
            return true;
        }
        return this.provider.hasLocalPropertyValues();
    }

    public Object getLocalProperty(Module module, ElementPropertyDefn prop) {
        assert (prop != null);
        if (!prop.isExtended()) {
            return super.getLocalProperty(module, prop);
        }
        return this.provider.getExtensionProperty(module, prop);
    }

    public void setProperty(ElementPropertyDefn prop, Object value) {
        assert (prop != null);
        if (!prop.isExtended()) {
            super.setProperty(prop, value);
        } else {
            this.provider.setExtensionProperty(prop, value);
        }
    }

    public ElementPropertyDefn getPropertyDefn(String propName) {
        assert (propName != null);
        ElementPropertyDefn propDefn = super.getPropertyDefn(propName);
        if (propDefn != null) {
            return propDefn;
        }
        return (ElementPropertyDefn)this.provider.getPropertyDefn(propName);
    }

    public List getPropertyDefns() {
        return this.provider.getPropertyDefns();
    }

    public ExtensionElementDefn getExtDefn() {
        return this.provider.getExtDefn();
    }

    public void initializeReportItem(Module module) throws ExtendedElementException {
        this.provider.initializeReportItem(module);
    }

    public PeerExtensibilityProvider getExtensibilityProvider() {
        return this.provider;
    }

    protected Object getIntrinsicProperty(String propName) {
        if ("extensionName".equals(propName)) {
            return this.extensionName;
        }
        if ("extensionVersion".equals(propName)) {
            return this.extensionVersion;
        }
        return super.getIntrinsicProperty(propName);
    }

    protected void setIntrinsicProperty(String propName, Object value) {
        if ("extensionName".equals(propName)) {
            this.setExtensionName((String)value);
        } else if ("extensionVersion".equals(propName)) {
            this.extensionVersion = (String)value;
        } else {
            super.setIntrinsicProperty(propName, value);
        }
    }

    public List validate(Module module) {
        List list = super.validate(module);
        list.addAll(ExtensionValidator.getInstance().validate(module, this));
        return list;
    }

    public IReportItem getExtendedElement() {
        return this.provider.getExtensionElement();
    }

    public boolean isExtensionModelProperty(String propName) {
        return this.provider.isExtensionModelProperty(propName);
    }

    public boolean isExtensionXMLProperty(String propName) {
        return this.provider.isExtensionXMLProperty(propName);
    }

    public List getMethods() {
        if (this.methods == null) {
            this.methods = this.provider.getModelMethodDefns();
        }
        return this.methods;
    }

    public String getScriptPropertyName() {
        IPropertyDefinition defn = this.provider.getScriptPropertyDefinition();
        return defn == null ? null : defn.getName();
    }

    public PropertySearchStrategy getStrategy() {
        return ExtendedItemPropSearchStrategy.getInstance();
    }

    private void setExtensionName(String extension) {
        this.extensionName = extension;
        this.provider = PeerExtensibilityProviderFactory.createProvider(this, this.extensionName);
        this.initSlots();
    }

    public ContainerSlot getSlot(int slot) {
        assert (slot >= 0 && slot < this.getDefn().getSlotCount());
        return this.slots[slot];
    }

    public IElementDefn getDefn() {
        ExtensionElementDefn extDefn = this.getExtDefn();
        if (extDefn != null) {
            return extDefn;
        }
        return super.getDefn();
    }

    public IElementDefn getDefaultDefn() {
        return super.getDefn();
    }

    public boolean hasLocalPropertyValuesOnOwnModel() {
        return this.provider.hasLocalPropertyValuesOnOwnModel();
    }

    public List getReportItemDefinedSelectors(Module module) {
        IReportItem reportItem = this.getExtendedElement();
        try {
            if (reportItem == null) {
                this.initializeReportItem(module);
                reportItem = this.getExtendedElement();
            }
        }
        catch (ExtendedElementException extendedElementException) {}
        if (reportItem == null) {
            return Collections.EMPTY_LIST;
        }
        return reportItem.getPredefinedStyles();
    }

    public String getLocalEncryptionID(ElementPropertyDefn propDefn) {
        if (propDefn == null || !propDefn.isEncryptable()) {
            return null;
        }
        if (!propDefn.isExtended()) {
            return super.getLocalEncryptionID(propDefn);
        }
        return this.provider.getEncryptionHelperID(propDefn);
    }

    public void setEncryptionHelper(ElementPropertyDefn propDefn, String encryptionID) {
        if (!propDefn.isExtended()) {
            super.setEncryptionHelper(propDefn, encryptionID);
        }
        this.provider.setEncryptionHelper(propDefn, encryptionID);
    }

    protected boolean hasLocalValue(ElementPropertyDefn propDefn) {
        if (propDefn == null) {
            return false;
        }
        if (!propDefn.isExtended()) {
            return super.hasLocalValue(propDefn);
        }
        return this.provider.getExtensionProperty(this.getRoot(), propDefn) != null;
    }

    public Object getFactoryProperty(Module module, ElementPropertyDefn prop) {
        if (!prop.enableContextSearch() || !prop.isStyleProperty()) {
            return super.getFactoryProperty(module, prop);
        }
        return ((ExtendedItemPropSearchStrategy)ExtendedItemPropSearchStrategy.getInstance()).getMetaFactoryProperty(module, this, prop);
    }

    public StatusInfo checkCompatibility(Module module) {
        StatusInfo status = this.doCheck(module);
        ArrayList errors = new ArrayList();
        boolean hasCompatibilities = false;
        if (status != null) {
            errors.addAll(status.getErrors());
            hasCompatibilities = status.hasCompatibilities();
        }
        if (this.getExtendsElement() != null) {
            ContentIterator iter = new ContentIterator(module, this);
            while (iter.hasNext()) {
                DesignElement content = (DesignElement)iter.next();
                if (!(content instanceof ExtendedItem) || (status = ((ExtendedItem)content).doCheck(module)) == null) continue;
                errors.addAll(status.getErrors());
                if (hasCompatibilities || !status.hasCompatibilities()) continue;
                hasCompatibilities = true;
            }
        }
        return new StatusInfo(errors, hasCompatibilities);
    }

    private StatusInfo doCheck(Module module) {
        if (!this.provider.needCheckCompatibility()) {
            return new StatusInfo(Collections.EMPTY_LIST, false);
        }
        try {
            this.initializeReportItem(module);
        }
        catch (ExtendedElementException extendedElementException) {
            return new StatusInfo(Collections.EMPTY_LIST, false);
        }
        IReportItem item = this.getExtendedElement();
        if (item instanceof ICompatibleReportItem) {
            CompatibilityStatus status = ((ICompatibleReportItem)((Object)item)).checkCompatibility();
            boolean hasCompatibilities = false;
            List errors = Collections.EMPTY_LIST;
            if (status != null) {
                errors = status.getErrors();
                hasCompatibilities = status.getStatusType() != 0;
            }
            return new StatusInfo(errors, hasCompatibilities);
        }
        return new StatusInfo(Collections.EMPTY_LIST, false);
    }

    public Object doClone(CopyPolicy policy) throws CloneNotSupportedException {
        ExtendedItem clonedElement = (ExtendedItem)super.doClone(null);
        clonedElement.provider.copyFromWithElementType(this.provider, policy);
        if (policy != null) {
            policy.execute(this, clonedElement);
        }
        return clonedElement;
    }

    protected Object baseClone() throws CloneNotSupportedException {
        ExtendedItem clonedElement = (ExtendedItem)super.baseClone();
        clonedElement.provider = PeerExtensibilityProviderFactory.createProvider(clonedElement, clonedElement.extensionName);
        clonedElement.provider.copyFromWithNonElementType(this.provider);
        return clonedElement;
    }

    public class StatusInfo {
        private List errors;
        private boolean hasCompatibilities = false;

        public StatusInfo(List errors, boolean hasCompatibilities) {
            this.errors = errors;
            this.hasCompatibilities = hasCompatibilities;
        }

        public List getErrors() {
            return this.errors == null ? Collections.EMPTY_LIST : this.errors;
        }

        public boolean hasCompatibilities() {
            return this.hasCompatibilities;
        }
    }
}

