/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.extension;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.extension.IPropertyDefinition;
import org.eclipse.birt.report.model.api.extension.IReportItem;
import org.eclipse.birt.report.model.api.extension.IReportItemFactory;
import org.eclipse.birt.report.model.api.metadata.IPropertyDefn;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.ExtendedItem;
import org.eclipse.birt.report.model.elements.strategy.CopyPolicy;
import org.eclipse.birt.report.model.extension.ModelExtensibilityProvider;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.metadata.ExtensionElementDefn;
import org.eclipse.birt.report.model.metadata.ExtensionModelPropertyDefn;
import org.eclipse.birt.report.model.metadata.PeerExtensionElementDefn;
import org.eclipse.birt.report.model.metadata.ReferenceValue;
import org.eclipse.birt.report.model.parser.treebuild.IContentHandler;
import org.eclipse.birt.report.model.util.ModelUtil;
import org.eclipse.birt.report.model.util.ReferenceValueUtil;

public abstract class PeerExtensibilityProvider
extends ModelExtensibilityProvider
implements IContentHandler {
    IReportItem reportItem = null;
    HashMap extensionPropValues = new HashMap();
    Map encryptionMap = null;

    public PeerExtensibilityProvider(DesignElement element, String extensionName) {
        super(element, extensionName);
    }

    public List getPropertyDefns() {
        List props = super.getPropertyDefns();
        PeerExtensionElementDefn extDefn = (PeerExtensionElementDefn)this.getExtDefn();
        if (extDefn == null) {
            return props;
        }
        IPropertyDefinition[] dynamicProps = this.getExtensionModelPropertyDefns();
        if (dynamicProps != null) {
            int i = 0;
            while (i < dynamicProps.length) {
                IPropertyDefinition extProp = dynamicProps[i];
                props.add(new ExtensionModelPropertyDefn(extProp, extDefn.getReportItemFactory().getMessages()));
                ++i;
            }
        }
        return props;
    }

    public List getModelMethodDefns() {
        PeerExtensionElementDefn extDefn = (PeerExtensionElementDefn)this.getExtDefn();
        if (extDefn == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ExtensionModelPropertyDefn> methods = new ArrayList<ExtensionModelPropertyDefn>();
        if (extDefn.getMethods() != null) {
            methods.addAll(extDefn.getMethods());
        }
        if (this.reportItem == null) {
            this.reportItem = ((ExtendedItem)this.element).getExtendedElement();
        }
        if (this.reportItem == null) {
            return methods;
        }
        IPropertyDefinition[] dynamicProps = this.getExtensionModelPropertyDefns();
        if (dynamicProps != null) {
            int i = 0;
            while (i < dynamicProps.length) {
                IPropertyDefinition prop = dynamicProps[i];
                if (prop.getType() == 18) {
                    methods.add(new ExtensionModelPropertyDefn(prop, extDefn.getReportItemFactory().getMessages()));
                }
                ++i;
            }
        }
        return methods;
    }

    public IPropertyDefn getPropertyDefn(String propName) {
        IPropertyDefn propDefn = super.getPropertyDefn(propName);
        if (propDefn == null) {
            PeerExtensionElementDefn extDefn = (PeerExtensionElementDefn)this.getExtDefn();
            IPropertyDefinition[] extProps = this.getExtensionModelPropertyDefns();
            if (extProps != null) {
                int i = 0;
                while (i < extProps.length) {
                    if (propName.equalsIgnoreCase(extProps[i].getName())) {
                        return new ExtensionModelPropertyDefn(extProps[i], extDefn.getReportItemFactory().getMessages());
                    }
                    ++i;
                }
            }
        }
        return propDefn;
    }

    private IPropertyDefinition[] getExtensionModelPropertyDefns() {
        if (this.reportItem == null) {
            return null;
        }
        return this.reportItem.getPropertyDefinitions();
    }

    protected List getStyleMasks() {
        return Collections.EMPTY_LIST;
    }

    public Object getExtensionProperty(Module module, ElementPropertyDefn prop) {
        Module root;
        assert (prop != null);
        String propName = prop.getName();
        Object value = this.getReportItemExtensionProperty(module, prop, propName);
        if (value != null) {
            return value;
        }
        value = this.extensionPropValues.get(propName);
        if (value == null) {
            return null;
        }
        ElementPropertyDefn defn = (ElementPropertyDefn)this.getPropertyDefn(propName);
        if (defn.getTypeCode() == 15 && (root = this.element.getRoot()) != null) {
            return ReferenceValueUtil.resolveElementReference(root, this.element, defn, (ElementRefValue)value);
        }
        return defn.isEncryptable() ? ModelUtil.decryptLocalProperty(this.element, defn, this.extensionPropValues.get(propName)) : this.extensionPropValues.get(propName);
    }

    private Object getReportItemExtensionProperty(Module module, ElementPropertyDefn prop, String propName) {
        if (this.isExtensionXMLProperty(propName) && prop.hasOwnModel()) {
            if (this.reportItem != null) {
                String retValue;
                block10: {
                    ByteArrayOutputStream stream = this.reportItem.serialize(propName);
                    if (stream == null) {
                        return null;
                    }
                    retValue = null;
                    try {
                        retValue = stream.toString("UTF-8");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        if ($assertionsDisabled) break block10;
                        throw new AssertionError();
                    }
                }
                return retValue;
            }
        } else if (this.isExtensionModelProperty(propName)) {
            try {
                if (this.reportItem == null) {
                    this.initializeReportItem(module);
                }
            }
            catch (ExtendedElementException extendedElementException) {
                return null;
            }
            return this.reportItem == null ? null : this.reportItem.getProperty(propName);
        }
        return null;
    }

    public Object getNonReportItemProperty(Module module, ElementPropertyDefn prop) {
        Module root;
        assert (prop != null);
        String propName = prop.getName();
        Object value = this.extensionPropValues.get(propName);
        if (value == null) {
            return null;
        }
        ElementPropertyDefn defn = (ElementPropertyDefn)this.getPropertyDefn(propName);
        if (defn.getTypeCode() == 15 && (root = this.element.getRoot()) != null) {
            return ReferenceValueUtil.resolveElementReference(root, this.element, defn, (ElementRefValue)value);
        }
        return defn.isEncryptable() ? ModelUtil.decryptLocalProperty(this.element, defn, this.extensionPropValues.get(propName)) : this.extensionPropValues.get(propName);
    }

    public void setExtensionProperty(ElementPropertyDefn prop, Object value) {
        if (this.isExtensionXMLProperty(prop.getName()) && prop.hasOwnModel()) {
            if (this.reportItem != null) {
                try {
                    if (value != null) {
                        byte[] raw;
                        block13: {
                            raw = null;
                            try {
                                raw = value.toString().getBytes("UTF-8");
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {
                                if ($assertionsDisabled) break block13;
                                throw new AssertionError();
                            }
                        }
                        this.reportItem.deserialize(prop.getName(), new ByteArrayInputStream(raw));
                    }
                    this.reportItem.deserialize(prop.getName(), new ByteArrayInputStream(new byte[0]));
                }
                catch (ExtendedElementException extendedElementException) {
                    assert (false);
                }
            } else {
                this.setExtensionPropertyValue(prop, value);
            }
        } else if (this.isExtensionModelProperty(prop.getName())) {
            assert (this.reportItem != null);
            this.reportItem.setProperty(prop.getName(), value);
        } else {
            this.setExtensionPropertyValue(prop, value);
        }
    }

    private void setExtensionPropertyValue(ElementPropertyDefn prop, Object value) {
        String propName = prop.getName();
        Object oldValue = this.extensionPropValues.get(propName);
        if (prop.getTypeCode() == 15) {
            ElementRefValue oldRef = (ElementRefValue)oldValue;
            ReferenceValueUtil.updateReference(this.element, oldRef, (ReferenceValue)value, prop);
        }
        if (value != null) {
            this.extensionPropValues.put(propName, value);
        } else {
            this.extensionPropValues.remove(propName);
        }
    }

    public void initializeReportItem(Module module) throws ExtendedElementException {
        if (this.reportItem != null) {
            return;
        }
        PeerExtensionElementDefn extDefn = (PeerExtensionElementDefn)this.getExtDefn();
        if (extDefn == null) {
            throw new ExtendedElementException(this.element, "org.eclipse.birt.report.model", "Error.SemanticError.EXTENSION_NOT_FOUND", null);
        }
        IReportItemFactory elementFactory = extDefn.getReportItemFactory();
        assert (elementFactory != null);
        this.reportItem = elementFactory.newReportItem(this.element.getHandle(module));
        List localPropDefns = extDefn.getLocalProperties();
        int i = 0;
        while (i < localPropDefns.size()) {
            ElementPropertyDefn propDefn = (ElementPropertyDefn)localPropDefns.get(i);
            if (propDefn.getTypeCode() == 12 && propDefn.canInherit() && propDefn.hasOwnModel()) {
                String propName = propDefn.getName();
                Object value = this.extensionPropValues.get(propName);
                if (value == null) {
                    ExtendedItem parent = (ExtendedItem)ModelUtil.getParent(this.element);
                    while (parent != null) {
                        PeerExtensibilityProvider parentProvider = parent.getExtensibilityProvider();
                        HashMap propValues = parentProvider.extensionPropValues;
                        value = propValues.get(propName);
                        if (value == null && parentProvider.reportItem != null) {
                            value = parentProvider.reportItem.serialize(propName);
                        }
                        if (value == null) {
                            parent = (ExtendedItem)ModelUtil.getParent(parent);
                            continue;
                        }
                        break;
                    }
                } else {
                    this.extensionPropValues.remove(propName);
                }
                if (value != null) {
                    byte[] raw;
                    block15: {
                        raw = null;
                        try {
                            raw = value instanceof ByteArrayOutputStream ? ((ByteArrayOutputStream)value).toByteArray() : value.toString().getBytes("UTF-8");
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            if ($assertionsDisabled) break block15;
                            throw new AssertionError();
                        }
                    }
                    if (this.reportItem != null) {
                        this.reportItem.deserialize(propName, new ByteArrayInputStream(raw));
                    }
                }
            }
            ++i;
        }
    }

    public boolean isExtensionModelProperty(String propName) {
        IPropertyDefinition[] extProps;
        if (this.reportItem != null && (extProps = this.reportItem.getPropertyDefinitions()) != null) {
            int i = 0;
            while (i < extProps.length) {
                IPropertyDefinition extProp = extProps[i];
                assert (extProp != null);
                if (propName.equals(extProp.getName())) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean isExtensionXMLProperty(String propName) {
        ElementPropertyDefn propDefn;
        ExtensionElementDefn extDefn = this.getExtDefn();
        return extDefn != null && (propDefn = (ElementPropertyDefn)extDefn.getProperty(propName)) != null && propDefn.hasOwnModel() && 12 == propDefn.getTypeCode();
    }

    public void copyFromWithElementType(PeerExtensibilityProvider source, CopyPolicy policy) {
        for (String propName : source.extensionPropValues.keySet()) {
            Object valueToSet;
            Object value;
            ElementPropertyDefn propDefn = this.element.getPropertyDefn(propName);
            if (!propDefn.isElementType() || (value = source.extensionPropValues.get(propName)) == null || (valueToSet = ModelUtil.copyValue(propDefn, value, policy)) == null) continue;
            this.extensionPropValues.put(propName, valueToSet);
            if (propDefn.isList()) {
                List values = (List)valueToSet;
                int i = 0;
                while (i < values.size()) {
                    DesignElement item = (DesignElement)values.get(i);
                    item.setContainer(this.element, propName);
                    ++i;
                }
                continue;
            }
            ((DesignElement)valueToSet).setContainer(this.element, propName);
        }
    }

    public void copyFromWithNonElementType(PeerExtensibilityProvider source) {
        this.reportItem = null;
        if (source.reportItem != null) {
            this.reportItem = source.reportItem.copy();
        }
        if (source.encryptionMap != null && !source.encryptionMap.isEmpty()) {
            if (this.encryptionMap == null) {
                this.encryptionMap = new HashMap();
            }
            this.encryptionMap.putAll(source.encryptionMap);
        }
        if (this.extensionPropValues == null) {
            this.extensionPropValues = new HashMap();
        }
        for (String propName : source.extensionPropValues.keySet()) {
            Object valueToSet;
            Object value;
            ElementPropertyDefn propDefn = this.element.getPropertyDefn(propName);
            if (propDefn.isElementType() || (value = source.extensionPropValues.get(propName)) == null || (valueToSet = ModelUtil.copyValue(propDefn, value)) == null) continue;
            this.extensionPropValues.put(propName, valueToSet);
        }
    }

    public IReportItem getExtensionElement() {
        return this.reportItem;
    }

    public IPropertyDefinition getScriptPropertyDefinition() {
        if (this.reportItem != null) {
            return this.reportItem.getScriptPropertyDefinition();
        }
        return null;
    }

    public boolean hasLocalPropertyValues() {
        return !this.extensionPropValues.isEmpty() || this.hasLocalPropertyValuesOnOwnModel();
    }

    public void clearOwnModel() {
        if (this.reportItem != null) {
            this.reportItem = null;
        }
    }

    public boolean hasLocalPropertyValuesOnOwnModel() {
        List localPropDefns = this.getExtDefn().getLocalProperties();
        int i = 0;
        while (i < localPropDefns.size()) {
            block15: {
                Object childValue;
                String propName;
                block17: {
                    block16: {
                        ElementPropertyDefn propDefn = (ElementPropertyDefn)localPropDefns.get(i);
                        if (propDefn.getTypeCode() != 12 || !propDefn.canInherit() || !propDefn.hasOwnModel()) break block15;
                        propName = propDefn.getName();
                        childValue = this.extensionPropValues.get(propName);
                        if (childValue == null) break block16;
                        try {
                            this.initializeReportItem(this.element.getRoot());
                        }
                        catch (ExtendedElementException extendedElementException) {}
                        break block17;
                    }
                    if (this.reportItem == null) break block15;
                }
                ByteArrayOutputStream byteArrayOutputStream = childValue = this.reportItem == null ? null : this.reportItem.serialize(propName);
                if (childValue != null) {
                    Object parentValue = null;
                    ExtendedItem parent = (ExtendedItem)ModelUtil.getParent(this.element);
                    while (parent != null) {
                        PeerExtensibilityProvider parentProvider = parent.getExtensibilityProvider();
                        parentValue = parentProvider.extensionPropValues.get(propName);
                        if (parentValue != null) {
                            try {
                                parent.initializeReportItem(parent.getRoot());
                            }
                            catch (ExtendedElementException extendedElementException) {}
                        } else if (parentProvider.reportItem == null) {
                            parent = (ExtendedItem)ModelUtil.getParent(parent);
                            continue;
                        }
                        Object object = parentValue = parentProvider.reportItem == null ? null : parentProvider.reportItem.serialize(propName);
                        if (parentValue != null) break;
                        parent = (ExtendedItem)ModelUtil.getParent(parent);
                    }
                    if (parentValue == null) {
                        return true;
                    }
                    if (!childValue.toString().equals(parentValue.toString())) {
                        return true;
                    }
                }
            }
            ++i;
        }
        return false;
    }

    public final String getEncryptionHelperID(ElementPropertyDefn propDefn) {
        if (propDefn == null || !propDefn.isEncryptable()) {
            return null;
        }
        if (this.encryptionMap != null && this.encryptionMap.get(propDefn.getName()) != null) {
            String encryptionID = (String)this.encryptionMap.get(propDefn.getName());
            return encryptionID;
        }
        return null;
    }

    public void setEncryptionHelper(ElementPropertyDefn propDefn, String encryptionID) {
        String id = StringUtil.trimString(encryptionID);
        if (this.encryptionMap == null) {
            this.encryptionMap = new HashMap();
        }
        if (id == null) {
            this.encryptionMap.remove(propDefn.getName());
        } else {
            this.encryptionMap.put(propDefn.getName(), id);
        }
    }

    public abstract void handleInvalidPropertyValue(String var1, Object var2);

    public abstract void handleUndefinedProperty(String var1, Object var2);

    public abstract void handleIllegalChildren(String var1, DesignElement var2);

    public abstract Map getInvalidPropertyValueMap();

    public abstract Map getUndefinedPropertyMap();

    public abstract Map getIllegalContents();

    public boolean needCheckCompatibility() {
        return true;
    }
}

