/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Properties;
import org.eclipse.osgi.baseadaptor.BaseAdaptor;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.launch.SystemBundle;

public class EquinoxSystemBundle
implements SystemBundle {
    private static String FULLPATH = " [fullpath]";
    private volatile Framework framework;
    private volatile Bundle systemBundle;

    public void init(Properties configuration) {
        this.internalInit(configuration);
    }

    private Framework internalInit(Properties configuration) {
        Framework current = this.framework;
        if (current != null) {
            current.close();
            this.framework = null;
            this.systemBundle = null;
        }
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            FrameworkProperties.setProperties(configuration);
            FrameworkProperties.initializeProperties();
            this.setEquinoxProperties(configuration);
            current = new Framework(new BaseAdaptor(new String[0]));
            current.launch();
            this.framework = current;
            this.systemBundle = current.systemBundle;
        }
        finally {
            ClassLoader currentCCL = Thread.currentThread().getContextClassLoader();
            if (currentCCL != tccl) {
                Thread.currentThread().setContextClassLoader(tccl);
            }
        }
        return current;
    }

    private void setEquinoxProperties(Properties configuration) {
        String execPermission;
        String storage;
        String windowSystem;
        FrameworkProperties.setProperty("osgi.framework.activeThreadType", "normal");
        String string = windowSystem = configuration == null ? null : configuration.getProperty("org.osgi.framework.windowsystem");
        if (windowSystem == null && (windowSystem = FrameworkProperties.getProperty("osgi.ws")) != null) {
            FrameworkProperties.setProperty("org.osgi.framework.windowsystem", windowSystem);
        }
        if (configuration == null) {
            return;
        }
        String security = configuration.getProperty("org.osgi.framework.security");
        if (security != null) {
            if (Boolean.valueOf(security).booleanValue()) {
                FrameworkProperties.setProperty("eclipse.security", "osgi");
            } else {
                FrameworkProperties.setProperty("eclipse.security", security);
            }
        }
        if ((storage = configuration.getProperty("org.osgi.framework.storage")) != null) {
            FrameworkProperties.setProperty("osgi.configuration.area", storage);
            FrameworkProperties.setProperty("osgi.configuration.area.default", storage);
        }
        if ((execPermission = configuration.getProperty("org.osgi.framework.command.execpermission")) != null) {
            if (!execPermission.endsWith(FULLPATH)) {
                execPermission = String.valueOf(execPermission) + FULLPATH;
            }
            FrameworkProperties.setProperty("osgi.filepermissions.command", execPermission);
        }
    }

    public void waitForStop(long timeout) throws InterruptedException {
        Framework current = this.framework;
        if (current == null) {
            return;
        }
        current.waitForStop(timeout);
    }

    public Enumeration findEntries(String path, String filePattern, boolean recurse) {
        Bundle current = this.systemBundle;
        if (current == null) {
            return null;
        }
        return current.findEntries(path, filePattern, recurse);
    }

    public BundleContext getBundleContext() {
        Bundle current = this.systemBundle;
        if (current == null) {
            return null;
        }
        return current.getBundleContext();
    }

    public long getBundleId() {
        return 0L;
    }

    public URL getEntry(String path) {
        Bundle current = this.systemBundle;
        if (current == null) {
            return null;
        }
        return current.getEntry(path);
    }

    public Enumeration getEntryPaths(String path) {
        Bundle current = this.systemBundle;
        if (current == null) {
            return null;
        }
        return current.getEntryPaths(path);
    }

    public Dictionary getHeaders() {
        Bundle current = this.systemBundle;
        if (current == null) {
            return null;
        }
        return current.getHeaders();
    }

    public Dictionary getHeaders(String locale) {
        Bundle current = this.systemBundle;
        if (current == null) {
            return null;
        }
        return current.getHeaders(locale);
    }

    public long getLastModified() {
        Bundle current = this.systemBundle;
        if (current == null) {
            return System.currentTimeMillis();
        }
        return current.getLastModified();
    }

    public String getLocation() {
        return "System Bundle";
    }

    public ServiceReference[] getRegisteredServices() {
        Bundle current = this.systemBundle;
        if (current == null) {
            return null;
        }
        return current.getRegisteredServices();
    }

    public URL getResource(String name) {
        Bundle current = this.systemBundle;
        if (current == null) {
            return null;
        }
        return current.getResource(name);
    }

    public Enumeration getResources(String name) throws IOException {
        Bundle current = this.systemBundle;
        if (current == null) {
            return null;
        }
        return current.getResources(name);
    }

    public ServiceReference[] getServicesInUse() {
        Bundle current = this.systemBundle;
        if (current == null) {
            return null;
        }
        return current.getServicesInUse();
    }

    public int getState() {
        Bundle current = this.systemBundle;
        if (current == null) {
            return 2;
        }
        return current.getState();
    }

    public String getSymbolicName() {
        return "org.eclipse.osgi";
    }

    public boolean hasPermission(Object permission) {
        Bundle current = this.systemBundle;
        if (current == null) {
            return false;
        }
        return current.hasPermission(permission);
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        Bundle current = this.systemBundle;
        if (current == null) {
            return null;
        }
        return current.loadClass(name);
    }

    public void start(int options) throws BundleException {
        this.start();
    }

    public void start() throws BundleException {
        Framework current = this.framework;
        if (this.getState() == 32) {
            return;
        }
        if (this.getState() != 8) {
            current = this.internalInit(null);
        }
        current.startLevelManager.doSetStartLevel(1);
    }

    public void stop(int options) throws BundleException {
        this.stop();
    }

    public void stop() throws BundleException {
        Bundle current = this.systemBundle;
        if (current == null) {
            return;
        }
        current.stop();
    }

    public void uninstall() throws BundleException {
        throw new BundleException(Msg.BUNDLE_SYSTEMBUNDLE_UNINSTALL_EXCEPTION, 2);
    }

    public void update() throws BundleException {
        Bundle current = this.systemBundle;
        if (current == null) {
            return;
        }
        current.update();
    }

    public void update(InputStream in) throws BundleException {
        try {
            in.close();
        }
        catch (IOException iOException) {}
        this.update();
    }
}

