/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ListingHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.ThemeHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.PropertyBinding;
import org.eclipse.birt.report.model.api.metadata.IPropertyDefn;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.command.GroupElementCommand;
import org.eclipse.birt.report.model.core.ContainerContext;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.NameSpace;
import org.eclipse.birt.report.model.core.ReferencableStructure;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.elements.Theme;
import org.eclipse.birt.report.model.i18n.ModelMessages;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.util.ContentIterator;
import org.eclipse.birt.report.model.util.ElementFactoryUtil;
import org.eclipse.birt.report.model.util.ModelUtil;

class ElementExporter {
    private LibraryHandle targetLibraryHandle;
    private Map propBindingMap = new HashMap();

    ElementExporter(LibraryHandle libraryHandle) {
        this.targetLibraryHandle = libraryHandle;
    }

    static void checkElementToExport(DesignElementHandle elementToExport, boolean ignoreName) {
        ModuleHandle root = elementToExport.getRoot();
        if (!(root instanceof ReportDesignHandle)) {
            throw new IllegalArgumentException("The element to export must be in design file.");
        }
        if (StringUtil.isBlank(elementToExport.getName()) && !ignoreName) {
            throw new IllegalArgumentException("The element must have name defined.");
        }
    }

    static void checkStructureToExport(StructureHandle structToExport, boolean ignoreName) {
        String memberName = null;
        String propName = null;
        String structName = structToExport.getDefn().getName();
        if ("EmbeddedImage".equals(structName)) {
            propName = "images";
            memberName = "name";
        } else if ("CustomColor".equals(structName)) {
            propName = "colorPalette";
            memberName = "name";
        } else if ("ConfigVar".equals(structName)) {
            propName = "configVars";
            memberName = "name";
        } else {
            throw new IllegalArgumentException("The structure \"" + structName + "\" is not allowed to export.");
        }
        Object value = structToExport.getMember(memberName).getValue();
        if (StringUtil.isBlank((String)value) && !ignoreName) {
            throw new IllegalArgumentException("The structure \"" + structName + "\" must have member \"" + memberName + "\" defined.");
        }
        boolean found = false;
        ModuleHandle moduleHandle = structToExport.getElementHandle().getModuleHandle();
        PropertyHandle propertyHandle = moduleHandle.getPropertyHandle(propName);
        ArrayList list = propertyHandle.getListValue();
        if (list != null) {
            for (Structure struct : list) {
                if (struct != structToExport.getStructure()) continue;
                found = true;
                break;
            }
        }
        if (!found) {
            throw new IllegalArgumentException("The structure to export must be in design file.");
        }
    }

    void exportStructure(StructureHandle structToExport, boolean canOverride) throws SemanticException {
        Object value;
        Object nameValue;
        String structName = structToExport.getDefn().getName();
        String nameMemberName = null;
        ReferencableStructure newStruct = null;
        PropertyHandle newPropertyHandle = null;
        if ("EmbeddedImage".equals(structName)) {
            nameMemberName = "name";
            newStruct = StructureFactory.createEmbeddedImage();
            newPropertyHandle = this.targetLibraryHandle.getPropertyHandle("images");
        } else if ("CustomColor".equals(structName)) {
            nameMemberName = "name";
            newStruct = StructureFactory.createCustomColor();
            newPropertyHandle = this.targetLibraryHandle.getPropertyHandle("colorPalette");
        } else if ("ConfigVar".equals(structName)) {
            nameMemberName = "name";
            newStruct = StructureFactory.createConfigVar();
            newPropertyHandle = this.targetLibraryHandle.getPropertyHandle("configVars");
        } else {
            throw new IllegalArgumentException("The structure \"" + structName + "\" is not allowed to export.");
        }
        assert (newStruct != null);
        assert (newPropertyHandle != null);
        if (canOverride && (nameValue = structToExport.getMember(nameMemberName).getValue()) != null) {
            Iterator iter = newPropertyHandle.iterator();
            while (iter.hasNext()) {
                StructureHandle structureHandle = (StructureHandle)iter.next();
                value = structureHandle.getMember(nameMemberName).getValue();
                if (!nameValue.equals(value)) continue;
                IStructure struct = structureHandle.getStructure();
                newPropertyHandle.removeItem(struct);
                break;
            }
        }
        Iterator iter = structToExport.getDefn().propertiesIterator();
        while (iter.hasNext()) {
            PropertyDefn memberDefn = (PropertyDefn)iter.next();
            String memberName = memberDefn.getName();
            if ("libReference".equals(memberName)) continue;
            value = structToExport.getMember(memberName).getValue();
            Object valueToSet = ModelUtil.copyValue(memberDefn, value);
            newStruct.setProperty(memberName, valueToSet);
        }
        newPropertyHandle.addItem(newStruct);
    }

    private void findAndDropDuplicatedElement(DesignElementHandle handle) throws SemanticException {
        ContentIterator iter = new ContentIterator(handle.getModule(), handle.getElement());
        while (iter.hasNext()) {
            DesignElement element = (DesignElement)iter.next();
            if (element.getName() == null) continue;
            this.dropDuplicatedElement(element);
        }
        if (handle.getName() == null) {
            return;
        }
        this.dropDuplicatedElement(handle.getElement());
    }

    private void dropDuplicatedElement(DesignElement element) throws SemanticException {
        int nameSpaceID = ((ElementDefn)element.getDefn()).getNameSpaceID();
        NameSpace nameSpace = this.targetLibraryHandle.getModule().getNameHelper().getNameSpace(nameSpaceID);
        DesignElement duplicateElement = nameSpace.getElement(element.getName());
        if (duplicateElement != null) {
            duplicateElement.getHandle(this.targetLibraryHandle.getModule()).drop();
        }
    }

    void exportElement(DesignElementHandle elementToExport, boolean canOverride) throws SemanticException {
        int slotID;
        if (elementToExport instanceof StyleHandle) {
            this.exportStyle((StyleHandle)elementToExport, canOverride);
            return;
        }
        if (canOverride) {
            this.findAndDropDuplicatedElement(elementToExport);
        }
        if ((slotID = this.getTopContainerSlot(elementToExport.getElement())) == 6) {
            slotID = 5;
        } else if (slotID == 4 && elementToExport.getContainer() != elementToExport.getModuleHandle()) {
            slotID = 5;
        } else if (slotID == 9) {
            slotID = 6;
        }
        if (slotID >= 7) {
            return;
        }
        DesignElementHandle newElementHandle = this.duplicateElement(elementToExport, false);
        SlotHandle slotHandle = this.targetLibraryHandle.getSlot(slotID);
        this.addToSlot(slotHandle, newElementHandle);
        if (this.propBindingMap.keySet().contains(elementToExport)) {
            this.propBindingMap.put(elementToExport, newElementHandle);
        }
    }

    void exportStyle(StyleHandle elementToExport, boolean canOverride) throws SemanticException {
        SlotHandle themes = this.targetLibraryHandle.getThemes();
        String defaultThemeName = ModelMessages.getMessage("Theme.defaultThemeName");
        NameSpace nameSpace = this.targetLibraryHandle.getModule().getNameHelper().getNameSpace(6);
        Theme theme = (Theme)nameSpace.getElement(defaultThemeName);
        ThemeHandle themeHandle = null;
        if (theme == null) {
            themeHandle = this.targetLibraryHandle.getElementFactory().newTheme(defaultThemeName);
            themes.add(themeHandle);
        } else {
            themeHandle = (ThemeHandle)theme.getHandle(this.targetLibraryHandle.getModule());
        }
        this.exportStyle(elementToExport, themeHandle, canOverride);
    }

    void exportStyle(StyleHandle elementToExport, ThemeHandle theme, boolean canOverride) throws SemanticException {
        StyleHandle style;
        assert (theme != null);
        if (canOverride && (style = theme.findStyle(elementToExport.getName())) != null) {
            style.drop();
        }
        DesignElementHandle newElementHandle = this.duplicateElement(elementToExport, false);
        this.addToSlot(theme.getStyles(), newElementHandle);
    }

    private void changePropertyBindingID(ReportDesignHandle designToExport) {
        List propertyBindings = this.targetLibraryHandle.getListProperty("propertyBindings");
        if (propertyBindings == null) {
            return;
        }
        for (PropertyBinding struct : propertyBindings) {
            long id = struct.getID().longValue();
            DesignElementHandle tempHandle = designToExport.getElementByID(id);
            DesignElementHandle tempCopyInLibHandle = (DesignElementHandle)this.propBindingMap.get(tempHandle);
            if (tempCopyInLibHandle == null) continue;
            struct.setID(tempCopyInLibHandle.getID());
        }
    }

    private void initPropBindingList(ReportDesignHandle designToExport) {
        List propertyBindings = designToExport.getListProperty("propertyBindings");
        int i = 0;
        while (propertyBindings != null && i < propertyBindings.size()) {
            PropertyBinding struct = (PropertyBinding)propertyBindings.get(i);
            long id = struct.getID().longValue();
            DesignElementHandle tempHandle = designToExport.getElementByID(id);
            if (tempHandle != null && !this.propBindingMap.keySet().contains(tempHandle)) {
                this.propBindingMap.put(tempHandle, null);
            }
            ++i;
        }
    }

    void exportDesign(ReportDesignHandle designToExport, boolean canOverride, boolean genDefaultName) throws SemanticException {
        ModelUtil.duplicateProperties(designToExport, this.targetLibraryHandle, false, false);
        this.initPropBindingList(designToExport);
        int slotCount = designToExport.getDefn().getSlotCount();
        int i = 0;
        while (i < slotCount) {
            SlotHandle sourceSlotHandle = designToExport.getSlot(i);
            Iterator iter = sourceSlotHandle.iterator();
            ArrayList<DesignElementHandle> noNameList = new ArrayList<DesignElementHandle>();
            while (iter.hasNext()) {
                DesignElementHandle contentHandle = (DesignElementHandle)iter.next();
                if (StringUtil.isBlank(contentHandle.getName())) {
                    noNameList.add(contentHandle);
                    continue;
                }
                this.exportElement(contentHandle, canOverride);
            }
            for (DesignElementHandle contentHandle : noNameList) {
                if (!genDefaultName) {
                    String typeName = contentHandle.getDefn().getDisplayName();
                    String location = contentHandle.getElement().getIdentifier();
                    throw new IllegalArgumentException("The element [type=\"" + typeName + "\"," + "location=\"" + location + "\"] must have name defined.");
                }
                this.exportElement(contentHandle, canOverride);
            }
            ++i;
        }
        this.changePropertyBindingID(designToExport);
    }

    private int getTopContainerSlot(DesignElement element) {
        int slotID = element.getContainerInfo().getSlotID();
        DesignElement container = element.getContainer();
        while (!(container instanceof Module)) {
            slotID = container.getContainerInfo().getSlotID();
            container = container.getContainer();
            assert (container != null);
        }
        return slotID;
    }

    private DesignElementHandle duplicateElement(DesignElementHandle elementHandle, boolean onlyFactoryProperty) throws SemanticException {
        String elementName = elementHandle.getDefn().getName();
        String name = elementHandle.getName();
        DesignElementHandle newElementHandle = ElementFactoryUtil.newElement(this.targetLibraryHandle.getModule(), elementName, name, false);
        ModelUtil.duplicateProperties(elementHandle, newElementHandle, onlyFactoryProperty, true);
        this.duplicateSlots(elementHandle, newElementHandle);
        if (!onlyFactoryProperty && newElementHandle.getName() == null) {
            this.targetLibraryHandle.getModule().makeUniqueName(newElementHandle.getElement());
        }
        return newElementHandle;
    }

    private void duplicateSlots(DesignElementHandle source, DesignElementHandle destination) throws SemanticException {
        DesignElementHandle newContentHandle;
        int slotCount = source.getDefn().getSlotCount();
        int i = 0;
        while (i < slotCount) {
            SlotHandle sourceSlotHandle = source.getSlot(i);
            SlotHandle destinationSlotHandle = destination.getSlot(i);
            Iterator iter = sourceSlotHandle.iterator();
            while (iter.hasNext()) {
                DesignElementHandle contentHandle = (DesignElementHandle)iter.next();
                newContentHandle = this.duplicateElement(contentHandle, true);
                if (source instanceof ListingHandle && i == 1) {
                    Object bindingRef = source.getProperty("dataBindingRef");
                    if (bindingRef != null) {
                        GroupElementCommand cmd = new GroupElementCommand(destination.getModule(), new ContainerContext(destination.getElement(), i));
                        cmd.setupSharedDataGroups(source.getElement());
                        continue;
                    }
                    this.addToSlot(destinationSlotHandle, newContentHandle);
                    continue;
                }
                this.addToSlot(destinationSlotHandle, newContentHandle);
            }
            ++i;
        }
        List props = source.getElement().getDefn().getContents();
        int i2 = 0;
        while (i2 < props.size()) {
            String propName;
            Object value;
            IPropertyDefn propDefn = (IPropertyDefn)props.get(i2);
            if (propDefn.getTypeCode() == 23 && (value = source.getProperty(propName = propDefn.getName())) != null) {
                if (propDefn.isList()) {
                    int j = 0;
                    while (j < ((List)value).size()) {
                        DesignElementHandle contentHandle = (DesignElementHandle)((ArrayList)value).get(j);
                        DesignElementHandle newContentHandle2 = this.duplicateElement(contentHandle, true);
                        destination.add(propName, newContentHandle2);
                        ++j;
                    }
                } else {
                    newContentHandle = this.duplicateElement((DesignElementHandle)value, true);
                    destination.add(propName, newContentHandle);
                }
            }
            ++i2;
        }
    }

    private void addToSlot(SlotHandle slotHandle, DesignElementHandle contentHandle) throws SemanticException {
        slotHandle.add(contentHandle);
    }
}

