/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.device.util;

import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.eclipse.birt.chart.computation.BoundingBox;
import org.eclipse.birt.chart.computation.Methods;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.device.IPrimitiveRenderer;
import org.eclipse.birt.chart.device.ITextMetrics;
import org.eclipse.birt.chart.device.TextRendererAdapter;
import org.eclipse.birt.chart.device.extension.i18n.Messages;
import org.eclipse.birt.chart.device.swing.SwingRendererImpl;
import org.eclipse.birt.chart.device.util.ChartTextLayout;
import org.eclipse.birt.chart.device.util.ChartTextMetrics;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.attribute.AttributeFactory;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.FontDefinition;
import org.eclipse.birt.chart.model.attribute.HorizontalAlignment;
import org.eclipse.birt.chart.model.attribute.Insets;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.Location;
import org.eclipse.birt.chart.model.attribute.Text;
import org.eclipse.birt.chart.model.attribute.TextAlignment;
import org.eclipse.birt.chart.model.attribute.VerticalAlignment;
import org.eclipse.birt.chart.model.attribute.impl.LocationImpl;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.util.ChartUtil;

public class ChartTextRenderer
extends TextRendererAdapter {
    public ChartTextRenderer(IDisplayServer dispServer) {
        super(dispServer);
    }

    public final void renderShadowAtLocation(IPrimitiveRenderer renderer, int labelPosition, Location location, Label label) throws ChartException {
        ColorDefinition cdShadow = label.getShadowColor();
        if (cdShadow == null) {
            throw new ChartException("org.eclipse.birt.chart.device.extension", 11, "exception.undefined.shadow.color", Messages.getResourceBundle(this._sxs.getULocale()));
        }
        Graphics2D g2d = (Graphics2D)((IDeviceRenderer)renderer).getGraphicsContext();
        g2d.setFont((Font)this._sxs.createFont(label.getCaption().getFont()));
        switch (labelPosition & 0x3F) {
            case 4: {
                this.showTopValue(renderer, location, label, labelPosition, true);
                break;
            }
            case 8: {
                this.showBottomValue(renderer, location, label, labelPosition, true);
                break;
            }
            case 1: {
                this.showLeftValue(renderer, location, label, labelPosition, true);
                break;
            }
            case 2: {
                this.showRightValue(renderer, location, label, labelPosition, true);
            }
        }
    }

    public final void renderTextAtLocation(IPrimitiveRenderer renderer, int labelPosition, Location location, Label label) throws ChartException {
        ColorDefinition colorDef = label.getCaption().getColor();
        if (colorDef == null) {
            throw new ChartException("org.eclipse.birt.chart.device.extension", 11, "exception.undefined.text.color", Messages.getResourceBundle(this._sxs.getULocale()));
        }
        Graphics2D g2d = (Graphics2D)((IDeviceRenderer)renderer).getGraphicsContext();
        g2d.setFont((Font)this._sxs.createFont(label.getCaption().getFont()));
        switch (labelPosition & 0x3F) {
            case 4: {
                if (ChartUtil.isShadowDefined((Label)label)) {
                    this.showTopValue(renderer, location, label, labelPosition, true);
                }
                this.showTopValue(renderer, location, label, labelPosition, false);
                break;
            }
            case 8: {
                if (ChartUtil.isShadowDefined((Label)label)) {
                    this.showBottomValue(renderer, location, label, labelPosition, true);
                }
                this.showBottomValue(renderer, location, label, labelPosition, false);
                break;
            }
            case 1: {
                if (ChartUtil.isShadowDefined((Label)label)) {
                    this.showLeftValue(renderer, location, label, labelPosition, true);
                }
                this.showLeftValue(renderer, location, label, labelPosition, false);
                break;
            }
            case 2: {
                if (ChartUtil.isShadowDefined((Label)label)) {
                    this.showRightValue(renderer, location, label, labelPosition, true);
                }
                this.showRightValue(renderer, location, label, labelPosition, false);
                break;
            }
            case 32: {
                if (ChartUtil.isShadowDefined((Label)label)) {
                    this.showCenterValue(renderer, location, label, true);
                }
                this.showCenterValue(renderer, location, label, false);
            }
        }
    }

    public final void renderTextInBlock(IDeviceRenderer renderer, Bounds boBlock, TextAlignment taBlock, Label label) throws ChartException {
        Text t = label.getCaption();
        String labelText = t.getValue();
        FontDefinition fontDef = t.getFont();
        ColorDefinition cdText = t.getColor();
        if (cdText == null) {
            throw new ChartException("org.eclipse.birt.chart.device.extension", 11, "exception.undefined.text.color", Messages.getResourceBundle(this._sxs.getULocale()));
        }
        IDisplayServer dispServer = renderer.getDisplayServer();
        Graphics2D g2d = (Graphics2D)renderer.getGraphicsContext();
        g2d.setFont((Font)dispServer.createFont(fontDef));
        label.getCaption().setValue(labelText);
        BoundingBox boundBox = null;
        try {
            boundBox = Methods.computeBox((IDisplayServer)dispServer, (int)4, (Label)label, (double)0.0, (double)0.0);
        }
        catch (IllegalArgumentException uiex) {
            throw new ChartException("org.eclipse.birt.chart.device.extension", 11, (Throwable)uiex);
        }
        if (taBlock == null) {
            taBlock = AttributeFactory.eINSTANCE.createTextAlignment();
            taBlock.setHorizontalAlignment(HorizontalAlignment.CENTER_LITERAL);
            taBlock.setVerticalAlignment(VerticalAlignment.CENTER_LITERAL);
        }
        HorizontalAlignment haBlock = taBlock.getHorizontalAlignment();
        VerticalAlignment vaBlock = taBlock.getVerticalAlignment();
        switch (haBlock.getValue()) {
            case 1: {
                boundBox.setLeft(boBlock.getLeft() + (boBlock.getWidth() - boundBox.getWidth()) / 2.0);
                break;
            }
            case 0: {
                boundBox.setLeft(boBlock.getLeft());
                break;
            }
            case 2: {
                boundBox.setLeft(boBlock.getLeft() + boBlock.getWidth() - boundBox.getWidth());
            }
        }
        switch (vaBlock.getValue()) {
            case 0: {
                boundBox.setTop(boBlock.getTop());
                break;
            }
            case 1: {
                boundBox.setTop(boBlock.getTop() + (boBlock.getHeight() - boundBox.getHeight()) / 2.0);
                break;
            }
            case 2: {
                boundBox.setTop(boBlock.getTop() + boBlock.getHeight() - boundBox.getHeight());
            }
        }
        boundBox.setLeft(boundBox.getLeft() + boundBox.getHotPoint());
        if (ChartUtil.isShadowDefined((Label)label)) {
            this.showTopValue((IPrimitiveRenderer)renderer, LocationImpl.create((double)boundBox.getLeft(), (double)(boundBox.getTop() + boundBox.getHeight())), label, 0, true);
        }
        this.showTopValue((IPrimitiveRenderer)renderer, LocationImpl.create((double)boundBox.getLeft(), (double)(boundBox.getTop() + boundBox.getHeight())), label, 0, false);
    }

    private final void showLeftValue(IPrimitiveRenderer renderer, Location location, Label label, int labelPosition, boolean bShadow) {
        Graphics2D g2d = (Graphics2D)((IDeviceRenderer)renderer).getGraphicsContext();
        FontDefinition fontDef = label.getCaption().getFont();
        double dAngleInDegrees = fontDef.getRotation();
        if (bShadow) {
            bShadow = label.getShadowColor() != null;
        }
        Color clrText = (Color)this._sxs.getColor(label.getCaption().getColor());
        Color clrBackground = null;
        if (label.getBackground() != null) {
            clrBackground = (Color)this._sxs.getColor((ColorDefinition)label.getBackground());
        }
        double dAngleInRadians = -dAngleInDegrees * Math.PI / 180.0;
        double dSineTheta = Math.sin(dAngleInRadians);
        double dCosTheta = Math.cos(dAngleInRadians);
        ITextMetrics textMetrics = this._sxs.getTextMetrics(label);
        location = this.adjustTextPosition(labelPosition, location, textMetrics, dAngleInDegrees);
        double dX = location.getX();
        double dY = location.getY();
        try {
            double dFullWidth = textMetrics.getFullWidth();
            double dHeight = textMetrics.getHeight();
            double dDescent = textMetrics.getDescent();
            double dFullHeight = textMetrics.getFullHeight();
            double dXOffset = 0.0;
            double dWidth = 0.0;
            int lineCount = textMetrics.getLineCount();
            Insets insets = label.getInsets().scaledInstance((double)this._sxs.getDpiResolution() / 72.0);
            double shadowness = (double)(3 * this._sxs.getDpiResolution()) / 72.0;
            boolean bEmptyText = "".equals(label.getCaption().getValue());
            double dYDiff = dY - dFullHeight;
            HorizontalAlignment hAlign = label.getCaption().getFont().getAlignment().getHorizontalAlignment();
            boolean bRightAligned = hAlign.getValue() == 2;
            boolean bCenterAligned = hAlign.getValue() == 1;
            double dRotateX = dX - dFullWidth;
            double dRotateY = dY + dHeight / 2.0;
            dX -= dFullWidth;
            dY += dHeight / 2.0;
            if (dAngleInDegrees == 0.0) {
                double dYHalfOffset = (dFullHeight + dHeight) / 2.0;
                if (bShadow) {
                    g2d.setPaint(new GradientPaint(new Point2D.Double(dX + shadowness, dY - dYHalfOffset + shadowness), (Color)this._sxs.getColor(label.getShadowColor()), new Point2D.Double(dX + shadowness + dFullWidth, dY - dYHalfOffset + shadowness + dFullHeight), (Color)this._sxs.getColor(label.getShadowColor().translucent())));
                    this.fillShadow(g2d, new Rectangle2D.Double(dX + shadowness, dY - dYHalfOffset + shadowness, dFullWidth, dFullHeight));
                } else {
                    Rectangle2D.Double r2d = new Rectangle2D.Double(dX, dY - dYHalfOffset, dFullWidth, dFullHeight);
                    if (clrBackground != null) {
                        g2d.setColor(clrBackground);
                        g2d.fill(r2d);
                    }
                    if (!bEmptyText) {
                        g2d.setColor(clrText);
                        int i = 0;
                        while (i < lineCount) {
                            ChartTextLayout textLayout = ((ChartTextMetrics)textMetrics).getLayout(i);
                            if (bRightAligned) {
                                dWidth = textLayout.getBounds().getWidth();
                                dXOffset = -insets.getLeft() + dFullWidth - dWidth - insets.getRight();
                            } else if (bCenterAligned) {
                                dWidth = textLayout.getBounds().getWidth();
                                dXOffset = -insets.getLeft() + (dFullWidth - dWidth) / 2.0;
                            }
                            textLayout.draw(g2d, (float)(dX + dXOffset + insets.getLeft()), (float)(dY - dYHalfOffset + insets.getTop() + dHeight * (double)(i + 1) - dDescent));
                            ++i;
                        }
                    }
                    this.renderOutline(renderer, label.getOutline(), r2d);
                }
            } else if (dAngleInDegrees > 0.0 && dAngleInDegrees < 90.0) {
                double dDeltaX = dFullWidth - dFullWidth * dCosTheta;
                double dDeltaY = dFullWidth * dSineTheta + dHeight / 2.0;
                dX += dDeltaX;
                dY -= dDeltaY;
                g2d.rotate(dAngleInRadians, dRotateX + dDeltaX, dRotateY - dDeltaY);
                if (bShadow) {
                    g2d.setPaint(new GradientPaint(new Point2D.Double(dX + shadowness, dYDiff + shadowness), (Color)this._sxs.getColor(label.getShadowColor()), new Point2D.Double(dX + shadowness + dFullWidth, dYDiff + shadowness + dFullHeight), (Color)this._sxs.getColor(label.getShadowColor().translucent())));
                    this.fillShadow(g2d, new Rectangle2D.Double(dX + shadowness, dYDiff + shadowness, dFullWidth, dFullHeight));
                } else {
                    Rectangle2D.Double r2d = new Rectangle2D.Double(dX, dYDiff, dFullWidth, dFullHeight);
                    if (clrBackground != null) {
                        g2d.setColor(clrBackground);
                        g2d.fill(r2d);
                    }
                    if (!bEmptyText) {
                        g2d.setColor(clrText);
                        int i = 0;
                        while (i < textMetrics.getLineCount()) {
                            ChartTextLayout textLayout = ((ChartTextMetrics)textMetrics).getLayout(lineCount - i - 1);
                            if (bRightAligned) {
                                dWidth = textLayout.getBounds().getWidth();
                                dXOffset = -insets.getLeft() + dFullWidth - dWidth - insets.getRight();
                            } else if (bCenterAligned) {
                                dWidth = textLayout.getBounds().getWidth();
                                dXOffset = -insets.getLeft() + (dFullWidth - dWidth) / 2.0;
                            }
                            textLayout.draw(g2d, (float)(dX + dXOffset + insets.getLeft()), (float)(dY - dDescent - dHeight * (double)i - insets.getBottom()));
                            ++i;
                        }
                    }
                    this.renderOutline(renderer, label.getOutline(), r2d);
                }
                g2d.rotate(-dAngleInRadians, dRotateX + dDeltaX, dRotateY - dDeltaY);
            } else if (dAngleInDegrees < 0.0 && dAngleInDegrees > -90.0) {
                double dDeltaX = dFullWidth - dFullWidth * dCosTheta - dHeight * dSineTheta;
                double dDeltaY = dFullWidth * dSineTheta + dHeight / 2.0 - dHeight * dCosTheta;
                dX += dDeltaX;
                dY -= dDeltaY;
                g2d.rotate(dAngleInRadians, dRotateX + dDeltaX, dRotateY - dDeltaY);
                if (bShadow) {
                    g2d.setPaint(new GradientPaint(new Point2D.Double(dX + shadowness, dY - dHeight + shadowness), (Color)this._sxs.getColor(label.getShadowColor()), new Point2D.Double(dX + shadowness + dFullWidth, dY - dHeight + shadowness + dFullHeight), (Color)this._sxs.getColor(label.getShadowColor().translucent())));
                    this.fillShadow(g2d, new Rectangle2D.Double(dX + shadowness, dY - dHeight + shadowness, dFullWidth, dFullHeight));
                } else {
                    Rectangle2D.Double r2d = new Rectangle2D.Double(dX, dY - dHeight, dFullWidth, dFullHeight);
                    if (clrBackground != null) {
                        g2d.setColor(clrBackground);
                        g2d.fill(r2d);
                    }
                    if (!bEmptyText) {
                        g2d.setColor(clrText);
                        int i = 0;
                        while (i < lineCount) {
                            ChartTextLayout textLayout = ((ChartTextMetrics)textMetrics).getLayout(i);
                            if (bRightAligned) {
                                dWidth = textLayout.getBounds().getWidth();
                                dXOffset = -insets.getLeft() + dFullWidth - dWidth - insets.getRight();
                            } else if (bCenterAligned) {
                                dWidth = textLayout.getBounds().getWidth();
                                dXOffset = -insets.getLeft() + (dFullWidth - dWidth) / 2.0;
                            }
                            textLayout.draw(g2d, (float)(dX + dXOffset + insets.getLeft()), (float)(dY - dDescent + dHeight * (double)i + insets.getTop()));
                            ++i;
                        }
                    }
                    this.renderOutline(renderer, label.getOutline(), r2d);
                }
                g2d.rotate(-dAngleInRadians, dRotateX + dDeltaX, dRotateY - dDeltaY);
            } else if (dAngleInDegrees == 90.0) {
                double dDeltaX = dFullWidth;
                double dDeltaY = (dFullWidth - dHeight) / 2.0;
                g2d.rotate(dAngleInRadians, dX += dDeltaX, dY += dDeltaY);
                if (bShadow) {
                    g2d.setPaint(new GradientPaint(new Point2D.Double(dX + shadowness, dYDiff + shadowness), (Color)this._sxs.getColor(label.getShadowColor()), new Point2D.Double(dX + shadowness + dFullWidth, dYDiff + shadowness + dFullHeight), (Color)this._sxs.getColor(label.getShadowColor().translucent())));
                    this.fillShadow(g2d, new Rectangle2D.Double(dX + shadowness, dYDiff + shadowness, dFullWidth, dFullHeight));
                } else {
                    Rectangle2D.Double r2d = new Rectangle2D.Double(dX, dYDiff, dFullWidth, dFullHeight);
                    if (clrBackground != null) {
                        g2d.setColor(clrBackground);
                        g2d.fill(r2d);
                    }
                    if (!bEmptyText) {
                        g2d.setColor(clrText);
                        int i = 0;
                        while (i < lineCount) {
                            ChartTextLayout textLayout = ((ChartTextMetrics)textMetrics).getLayout(i);
                            if (bRightAligned) {
                                dWidth = textLayout.getBounds().getWidth();
                                dXOffset = -insets.getLeft() + dFullWidth - dWidth - insets.getRight();
                            } else if (bCenterAligned) {
                                dWidth = textLayout.getBounds().getWidth();
                                dXOffset = -insets.getLeft() + (dFullWidth - dWidth) / 2.0;
                            }
                            textLayout.draw(g2d, (float)(dX + dXOffset + insets.getLeft()), (float)(dY - dDescent - dHeight * (double)(lineCount - i - 1) + insets.getTop()));
                            ++i;
                        }
                    }
                    this.renderOutline(renderer, label.getOutline(), r2d);
                }
                g2d.rotate(-dAngleInRadians, dX, dY);
            } else if (dAngleInDegrees == -90.0) {
                double dDeltaX = dFullWidth - dHeight;
                double dDeltaY = (dFullWidth + dHeight) / 2.0;
                g2d.rotate(dAngleInRadians, dX += dDeltaX, dY -= dDeltaY);
                if (bShadow) {
                    g2d.setPaint(new GradientPaint(new Point2D.Double(dX + shadowness, dYDiff + shadowness), (Color)this._sxs.getColor(label.getShadowColor()), new Point2D.Double(dX + shadowness + dFullWidth, dYDiff + shadowness + dFullHeight), (Color)this._sxs.getColor(label.getShadowColor().translucent())));
                    this.fillShadow(g2d, new Rectangle2D.Double(dX + shadowness, dYDiff + shadowness, dFullWidth, dFullHeight));
                } else {
                    Rectangle2D.Double r2d = new Rectangle2D.Double(dX, dY - dHeight, dFullWidth, dFullHeight);
                    if (clrBackground != null) {
                        g2d.setColor(clrBackground);
                        g2d.fill(r2d);
                    }
                    if (!bEmptyText) {
                        g2d.setColor(clrText);
                        int i = 0;
                        while (i < lineCount) {
                            ChartTextLayout textLayout = ((ChartTextMetrics)textMetrics).getLayout(i);
                            if (bRightAligned) {
                                dWidth = textLayout.getBounds().getWidth();
                                dXOffset = -insets.getLeft() + dFullWidth - dWidth - insets.getRight();
                            } else if (bCenterAligned) {
                                dWidth = textLayout.getBounds().getWidth();
                                dXOffset = -insets.getLeft() + (dFullWidth - dWidth) / 2.0;
                            }
                            textLayout.draw(g2d, (float)(dX + dXOffset + insets.getLeft()), (float)(dY - dDescent + dHeight * (double)i + insets.getTop()));
                            ++i;
                        }
                    }
                    this.renderOutline(renderer, label.getOutline(), r2d);
                }
                g2d.rotate(-dAngleInRadians, dX, dY);
            }
        }
        finally {
            textMetrics.dispose();
        }
    }

    private final void showRightValue(IPrimitiveRenderer renderer, Location location, Label label, int labelPosition, boolean bShadow) {
        Graphics2D g2d = (Graphics2D)((IDeviceRenderer)renderer).getGraphicsContext();
        FontDefinition fontDef = label.getCaption().getFont();
        double dAngleInDegrees = fontDef.getRotation();
        if (bShadow) {
            bShadow = label.getShadowColor() != null;
        }
        Color clrText = (Color)this._sxs.getColor(label.getCaption().getColor());
        Color clrBackground = null;
        if (label.getBackground() != null) {
            clrBackground = (Color)this._sxs.getColor((ColorDefinition)label.getBackground());
        }
        ITextMetrics textMetrics = this._sxs.getTextMetrics(label);
        location = this.adjustTextPosition(labelPosition, location, textMetrics, dAngleInDegrees);
        double dX = location.getX();
        double dY = location.getY();
        dY += 1.0;
        try {
            double dFullWidth = textMetrics.getFullWidth();
            double dHeight = textMetrics.getHeight();
            double dDescent = textMetrics.getDescent();
            double dFullHeight = textMetrics.getFullHeight();
            double dXOffset = 0.0;
            double dWidth = 0.0;
            int lineCount = textMetrics.getLineCount();
            Insets insets = label.getInsets().scaledInstance((double)this._sxs.getDpiResolution() / 72.0);
            double shadowness = (double)(3 * this._sxs.getDpiResolution()) / 72.0;
            boolean bEmptyText = "".equals(label.getCaption().getValue());
            double dYDiff = dY - dHeight;
            HorizontalAlignment hAlign = label.getCaption().getFont().getAlignment().getHorizontalAlignment();
            boolean bRightAligned = hAlign.getValue() == 2;
            boolean bCenterAligned = hAlign.getValue() == 1;
            double dAngleInRadians = -dAngleInDegrees * Math.PI / 180.0;
            int iRotateX = (int)dX;
            int iRotateY = (int)(dY + dHeight / 2.0);
            dY += dHeight / 2.0;
            if (dAngleInDegrees == 0.0) {
                double dYHalfOffset = (dFullHeight + dHeight) / 2.0;
                if (bShadow) {
                    g2d.setPaint(new GradientPaint(new Point2D.Double(dX + shadowness, dY - dYHalfOffset + shadowness), (Color)this._sxs.getColor(label.getShadowColor()), new Point2D.Double(dX + shadowness + dFullWidth, dY - dYHalfOffset + shadowness + dFullHeight), (Color)this._sxs.getColor(label.getShadowColor().translucent())));
                    this.fillShadow(g2d, new Rectangle2D.Double(dX + shadowness, dY - dYHalfOffset + shadowness, dFullWidth, dFullHeight));
                } else {
                    Rectangle2D.Double r2d = new Rectangle2D.Double(dX, dY - dYHalfOffset, dFullWidth, dFullHeight);
                    if (clrBackground != null) {
                        g2d.setColor(clrBackground);
                        g2d.fill(r2d);
                    }
                    if (!bEmptyText) {
                        g2d.setColor(clrText);
                        int i = 0;
                        while (i < lineCount) {
                            ChartTextLayout textLayout = ((ChartTextMetrics)textMetrics).getLayout(i);
                            if (bRightAligned) {
                                dWidth = textLayout.getBounds().getWidth();
                                dXOffset = -insets.getLeft() + dFullWidth - dWidth - insets.getRight();
                            } else if (bCenterAligned) {
                                dWidth = textLayout.getBounds().getWidth();
                                dXOffset = -insets.getLeft() + (dFullWidth - dWidth) / 2.0;
                            }
                            textLayout.draw(g2d, (float)(dX + dXOffset + insets.getLeft()), (float)(dY - dYHalfOffset + insets.getTop() + dHeight * (double)(i + 1) - dDescent));
                            ++i;
                        }
                    }
                    this.renderOutline(renderer, label.getOutline(), r2d);
                }
            } else if (dAngleInDegrees > 0.0 && dAngleInDegrees < 90.0) {
                double dDeltaX = dHeight * Math.sin(dAngleInRadians);
                double dDeltaY = dHeight * Math.cos(dAngleInRadians) - dHeight / 2.0;
                dX -= dDeltaX;
                dY += dDeltaY;
                g2d.rotate(dAngleInRadians, (double)iRotateX - dDeltaX, (double)iRotateY + dDeltaY);
                if (bShadow) {
                    g2d.setPaint(new GradientPaint(new Point2D.Double(dX + shadowness, dYDiff + shadowness), (Color)this._sxs.getColor(label.getShadowColor()), new Point2D.Double(dX + shadowness + dFullWidth, dYDiff + shadowness + dFullHeight), (Color)this._sxs.getColor(label.getShadowColor().translucent())));
                    this.fillShadow(g2d, new Rectangle2D.Double(dX + shadowness, dYDiff + shadowness, dFullWidth, dFullHeight));
                } else {
                    Rectangle2D.Double r2d = new Rectangle2D.Double(dX, dYDiff, dFullWidth, dFullHeight);
                    if (clrBackground != null) {
                        g2d.setColor(clrBackground);
                        g2d.fill(r2d);
                    }
                    if (!bEmptyText) {
                        g2d.setColor(clrText);
                        int i = 0;
                        while (i < lineCount) {
                            ChartTextLayout textLayout = ((ChartTextMetrics)textMetrics).getLayout(i);
                            if (bRightAligned) {
                                dWidth = textLayout.getBounds().getWidth();
                                dXOffset = -insets.getLeft() + dFullWidth - dWidth - insets.getRight();
                            } else if (bCenterAligned) {
                                dWidth = textLayout.getBounds().getWidth();
                                dXOffset = -insets.getLeft() + (dFullWidth - dWidth) / 2.0;
                            }
                            textLayout.draw(g2d, (float)(dX + dXOffset + insets.getLeft()), (float)(dY - dDescent + dHeight * (double)i + insets.getTop()));
                            ++i;
                        }
                    }
                    this.renderOutline(renderer, label.getOutline(), r2d);
                }
                g2d.rotate(-dAngleInRadians, (double)iRotateX - dDeltaX, (double)iRotateY + dDeltaY);
            } else if (dAngleInDegrees < 0.0 && dAngleInDegrees > -90.0) {
                double dDeltaY = -dHeight / 2.0;
                dY += dDeltaY;
                g2d.rotate(dAngleInRadians, iRotateX, (double)iRotateY + dDeltaY);
                if (bShadow) {
                    g2d.setPaint(new GradientPaint(new Point2D.Double(dX + shadowness, dY - dFullHeight + shadowness), (Color)this._sxs.getColor(label.getShadowColor()), new Point2D.Double(dX + shadowness + dFullWidth, dY - dFullHeight + shadowness + dFullHeight), (Color)this._sxs.getColor(label.getShadowColor().translucent())));
                    this.fillShadow(g2d, new Rectangle2D.Double(dX + shadowness, dY - dFullHeight + shadowness, dFullWidth, dFullHeight));
                } else {
                    Rectangle2D.Double r2d = new Rectangle2D.Double(dX, dY - dFullHeight, dFullWidth, dFullHeight);
                    if (clrBackground != null) {
                        g2d.setColor(clrBackground);
                        g2d.fill(r2d);
                    }
                    if (!bEmptyText) {
                        g2d.setColor(clrText);
                        int i = 0;
                        while (i < lineCount) {
                            ChartTextLayout textLayout = ((ChartTextMetrics)textMetrics).getLayout(i);
                            if (bRightAligned) {
                                dWidth = textLayout.getBounds().getWidth();
                                dXOffset = -insets.getLeft() + dFullWidth - dWidth - insets.getRight();
                            } else if (bCenterAligned) {
                                dWidth = textLayout.getBounds().getWidth();
                                dXOffset = -insets.getLeft() + (dFullWidth - dWidth) / 2.0;
                            }
                            textLayout.draw(g2d, (float)(dX + dXOffset + insets.getLeft()), (float)(dY - dDescent - dHeight * (double)(lineCount - i - 1) - insets.getBottom()));
                            ++i;
                        }
                    }
                    this.renderOutline(renderer, label.getOutline(), r2d);
                }
                g2d.rotate(-dAngleInRadians, iRotateX, (double)iRotateY + dDeltaY);
            } else if (dAngleInDegrees == 90.0) {
                double dDeltaX = dHeight;
                double dDeltaY = (dFullWidth - dHeight) / 2.0;
                g2d.rotate(dAngleInRadians, dX += dDeltaX, dY += dDeltaY);
                if (bShadow) {
                    g2d.setPaint(new GradientPaint(new Point2D.Double(dX + shadowness, dYDiff + shadowness), (Color)this._sxs.getColor(label.getShadowColor()), new Point2D.Double(dX + shadowness + dFullWidth, dYDiff + shadowness + dFullHeight), (Color)this._sxs.getColor(label.getShadowColor().translucent())));
                    this.fillShadow(g2d, new Rectangle2D.Double(dX + shadowness, dYDiff + shadowness, dFullWidth, dFullHeight));
                } else {
                    Rectangle2D.Double r2d = new Rectangle2D.Double(dX, dYDiff, dFullWidth, dFullHeight);
                    if (clrBackground != null) {
                        g2d.setColor(clrBackground);
                        g2d.fill(r2d);
                    }
                    if (!bEmptyText) {
                        g2d.setColor(clrText);
                        int i = 0;
                        while (i < lineCount) {
                            ChartTextLayout textLayout = ((ChartTextMetrics)textMetrics).getLayout(i);
                            if (bRightAligned) {
                                dWidth = textLayout.getBounds().getWidth();
                                dXOffset = -insets.getLeft() + dFullWidth - dWidth - insets.getRight();
                            } else if (bCenterAligned) {
                                dWidth = textLayout.getBounds().getWidth();
                                dXOffset = -insets.getLeft() + (dFullWidth - dWidth) / 2.0;
                            }
                            textLayout.draw(g2d, (float)(dX + dXOffset + insets.getLeft()), (float)(dY - dDescent + dHeight * (double)i + insets.getTop()));
                            ++i;
                        }
                    }
                    this.renderOutline(renderer, label.getOutline(), r2d);
                }
                g2d.rotate(-dAngleInRadians, dX, dY);
            } else if (dAngleInDegrees == -90.0) {
                double dDeltaX = 0.0;
                double dDeltaY = (dFullWidth + dHeight) / 2.0;
                g2d.rotate(dAngleInRadians, dX += dDeltaX, dY -= dDeltaY);
                if (bShadow) {
                    g2d.setPaint(new GradientPaint(new Point2D.Double(dX + shadowness, dYDiff + shadowness), (Color)this._sxs.getColor(label.getShadowColor()), new Point2D.Double(dX + shadowness + dFullWidth, dYDiff + shadowness + dFullHeight), (Color)this._sxs.getColor(label.getShadowColor().translucent())));
                    this.fillShadow(g2d, new Rectangle2D.Double(dX + shadowness, dYDiff + shadowness, dFullWidth, dFullHeight));
                } else {
                    Rectangle2D.Double r2d = new Rectangle2D.Double(dX, dYDiff, dFullWidth, dFullHeight);
                    if (clrBackground != null) {
                        g2d.setColor(clrBackground);
                        g2d.fill(r2d);
                    }
                    if (!bEmptyText) {
                        g2d.setColor(clrText);
                        int i = 0;
                        while (i < lineCount) {
                            ChartTextLayout textLayout = ((ChartTextMetrics)textMetrics).getLayout(i);
                            if (bRightAligned) {
                                dWidth = textLayout.getBounds().getWidth();
                                dXOffset = -insets.getLeft() + dFullWidth - dWidth - insets.getRight();
                            } else if (bCenterAligned) {
                                dWidth = textLayout.getBounds().getWidth();
                                dXOffset = -insets.getLeft() + (dFullWidth - dWidth) / 2.0;
                            }
                            textLayout.draw(g2d, (float)(dX + dXOffset + insets.getLeft()), (float)(dY - dDescent + dHeight * (double)i + insets.getTop()));
                            ++i;
                        }
                    }
                    this.renderOutline(renderer, label.getOutline(), r2d);
                }
                g2d.rotate(-dAngleInRadians, dX, dY);
            }
        }
        finally {
            textMetrics.dispose();
        }
    }

    private final void showBottomValue(IPrimitiveRenderer renderer, Location location, Label label, int labelPosition, boolean bShadow) {
        Graphics2D g2d = (Graphics2D)((IDeviceRenderer)renderer).getGraphicsContext();
        FontDefinition fontDef = label.getCaption().getFont();
        double dAngleInDegrees = fontDef.getRotation();
        Color clrText = (Color)this._sxs.getColor(label.getCaption().getColor());
        Color clrBackground = null;
        if (label.getBackground() != null) {
            clrBackground = (Color)this._sxs.getColor((ColorDefinition)label.getBackground());
        }
        double dAngleInRadians = -dAngleInDegrees * Math.PI / 180.0;
        ITextMetrics textMetrics = this._sxs.getTextMetrics(label);
        location = this.adjustTextPosition(labelPosition, location, textMetrics, dAngleInDegrees);
        double dX = location.getX();
        double dY = location.getY();
        try {
            double dFullWidth = textMetrics.getFullWidth();
            double dHeight = textMetrics.getHeight();
            double dDescent = textMetrics.getDescent();
            double dFullHeight = textMetrics.getFullHeight();
            double dXOffset = 0.0;
            double dWidth = 0.0;
            int lineCount = textMetrics.getLineCount();
            Insets insets = label.getInsets().scaledInstance((double)this._sxs.getDpiResolution() / 72.0);
            double shadowness = (double)(3 * this._sxs.getDpiResolution()) / 72.0;
            boolean bEmptyText = "".equals(label.getCaption().getValue());
            HorizontalAlignment hAlignment = label.getCaption().getFont().getAlignment().getHorizontalAlignment();
            boolean bRightAligned = hAlignment.getValue() == 2;
            boolean bCenterAligned = hAlignment.getValue() == 1;
            dX -= dFullWidth / 2.0;
            dY += dHeight;
            if (dAngleInDegrees == 0.0) {
                if (bShadow) {
                    g2d.setPaint(new GradientPaint(new Point2D.Double(dX + shadowness, dY - dHeight + shadowness), (Color)this._sxs.getColor(label.getShadowColor()), new Point2D.Double(dX + shadowness + dFullWidth, dY - dHeight + shadowness + dFullHeight), (Color)this._sxs.getColor(label.getShadowColor().translucent())));
                    this.fillShadow(g2d, new Rectangle2D.Double(dX + shadowness, dY - dHeight + shadowness, dFullWidth, dFullHeight));
                } else {
                    Rectangle2D.Double r2d = new Rectangle2D.Double(dX, dY - dHeight, dFullWidth, dFullHeight);
                    if (clrBackground != null) {
                        g2d.setColor(clrBackground);
                        g2d.fill(r2d);
                    }
                    if (!bEmptyText) {
                        g2d.setColor(clrText);
                        int i = 0;
                        while (i < lineCount) {
                            ChartTextLayout textLayout = ((ChartTextMetrics)textMetrics).getLayout(i);
                            if (bRightAligned) {
                                dWidth = textLayout.getBounds().getWidth();
                                dXOffset = -insets.getLeft() + dFullWidth - dWidth - insets.getRight();
                            } else if (bCenterAligned) {
                                dWidth = textLayout.getBounds().getWidth();
                                dXOffset = -insets.getLeft() + (dFullWidth - dWidth) / 2.0;
                            }
                            textLayout.draw(g2d, (float)(dX + dXOffset + insets.getLeft()), (float)(dY - dDescent + dHeight * (double)i + insets.getTop()));
                            ++i;
                        }
                    }
                    this.renderOutline(renderer, label.getOutline(), r2d);
                }
            } else if (dAngleInDegrees > 0.0 && dAngleInDegrees < 90.0) {
                double dSineTheta = Math.abs(Math.sin(dAngleInRadians));
                double dCosTheta = Math.abs(Math.cos(dAngleInRadians));
                double dDeltaX = dFullWidth * dCosTheta - dHeight * dSineTheta - dFullWidth / 2.0;
                double dDeltaY = dHeight * dCosTheta + dFullWidth * dSineTheta - dHeight;
                g2d.rotate(dAngleInRadians, dX -= dDeltaX, dY += dDeltaY);
                if (bShadow) {
                    g2d.setPaint(new GradientPaint(new Point2D.Double(dX + shadowness, dY - dHeight + shadowness), (Color)this._sxs.getColor(label.getShadowColor()), new Point2D.Double(dX + shadowness + dFullWidth, dY - dHeight + shadowness + dFullHeight), (Color)this._sxs.getColor(label.getShadowColor().translucent())));
                    this.fillShadow(g2d, new Rectangle2D.Double(dX + shadowness, dY - dHeight + shadowness, dFullWidth, dFullHeight));
                } else {
                    Rectangle2D.Double r2d = new Rectangle2D.Double(dX, dY - dHeight, dFullWidth, dFullHeight);
                    if (clrBackground != null) {
                        g2d.setColor(clrBackground);
                        g2d.fill(r2d);
                    }
                    if (!bEmptyText) {
                        g2d.setColor(clrText);
                        int i = 0;
                        while (i < lineCount) {
                            ChartTextLayout textLayout = ((ChartTextMetrics)textMetrics).getLayout(i);
                            if (bRightAligned) {
                                dWidth = textLayout.getBounds().getWidth();
                                dXOffset = -insets.getLeft() + dFullWidth - dWidth - insets.getRight();
                            } else if (bCenterAligned) {
                                dWidth = textLayout.getBounds().getWidth();
                                dXOffset = -insets.getLeft() + (dFullWidth - dWidth) / 2.0;
                            }
                            textLayout.draw(g2d, (float)(dX + dXOffset + insets.getLeft()), (float)(dY - dDescent + dHeight * (double)i + insets.getTop()));
                            ++i;
                        }
                    }
                    this.renderOutline(renderer, label.getOutline(), r2d);
                }
                g2d.rotate(-dAngleInRadians, dX, dY);
            } else if (dAngleInDegrees < 0.0 && dAngleInDegrees > -90.0) {
                g2d.rotate(dAngleInRadians, dX += dFullWidth / 2.0, dY - dHeight);
                if (bShadow) {
                    g2d.setPaint(new GradientPaint(new Point2D.Double(dX + shadowness, dY - dHeight + shadowness), (Color)this._sxs.getColor(label.getShadowColor()), new Point2D.Double(dX + shadowness + dFullWidth, dY - dHeight + shadowness + dFullHeight), (Color)this._sxs.getColor(label.getShadowColor().translucent())));
                    this.fillShadow(g2d, new Rectangle2D.Double(dX + shadowness, dY - dHeight + shadowness, dFullWidth, dFullHeight));
                } else {
                    Rectangle2D.Double r2d = new Rectangle2D.Double(dX, dY - dHeight, dFullWidth, dFullHeight);
                    if (clrBackground != null) {
                        g2d.setColor(clrBackground);
                        g2d.fill(r2d);
                    }
                    if (!bEmptyText) {
                        g2d.setColor(clrText);
                        int i = 0;
                        while (i < lineCount) {
                            ChartTextLayout textLayout = ((ChartTextMetrics)textMetrics).getLayout(i);
                            if (bRightAligned) {
                                dWidth = textLayout.getBounds().getWidth();
                                dXOffset = -insets.getLeft() + dFullWidth - dWidth - insets.getRight();
                            } else if (bCenterAligned) {
                                dWidth = textLayout.getBounds().getWidth();
                                dXOffset = -insets.getLeft() + (dFullWidth - dWidth) / 2.0;
                            }
                            textLayout.draw(g2d, (float)(dX + dXOffset + insets.getLeft()), (float)(dY - dDescent + dHeight * (double)i + insets.getTop()));
                            ++i;
                        }
                    }
                    this.renderOutline(renderer, label.getOutline(), r2d);
                }
                g2d.rotate(-dAngleInRadians, dX, dY - dHeight);
            } else if (dAngleInDegrees == 90.0) {
                double dYHalfOffset = (dFullHeight + dHeight) / 2.0;
                double dDeltaX = (dFullWidth + dHeight) / 2.0;
                double dDeltaY = dFullWidth - dHeight;
                g2d.rotate(dAngleInRadians, dX += dDeltaX, dY += dDeltaY);
                if (bShadow) {
                    g2d.setPaint(new GradientPaint(new Point2D.Double(dX + shadowness, dY - dYHalfOffset + shadowness), (Color)this._sxs.getColor(label.getShadowColor()), new Point2D.Double(dX + shadowness + dFullWidth, dY - dYHalfOffset + shadowness + dFullHeight), (Color)this._sxs.getColor(label.getShadowColor().translucent())));
                    this.fillShadow(g2d, new Rectangle2D.Double(dX + shadowness, dY - dYHalfOffset + shadowness, dFullWidth, dFullHeight));
                } else {
                    Rectangle2D.Double r2d = new Rectangle2D.Double(dX, dY - dYHalfOffset, dFullWidth, dFullHeight);
                    if (clrBackground != null) {
                        g2d.setColor(clrBackground);
                        g2d.fill(r2d);
                    }
                    if (!bEmptyText) {
                        g2d.setColor(clrText);
                        int i = 0;
                        while (i < lineCount) {
                            ChartTextLayout textLayout = ((ChartTextMetrics)textMetrics).getLayout(i);
                            if (bRightAligned) {
                                dWidth = textLayout.getBounds().getWidth();
                                dXOffset = -insets.getLeft() + dFullWidth - dWidth - insets.getRight();
                            } else if (bCenterAligned) {
                                dWidth = textLayout.getBounds().getWidth();
                                dXOffset = -insets.getLeft() + (dFullWidth - dWidth) / 2.0;
                            }
                            textLayout.draw(g2d, (float)(dX + dXOffset + insets.getLeft()), (float)(dY - dDescent - ((double)(lineCount - i) * dHeight - (double)(lineCount + 1) * dHeight / 2.0) + insets.getTop()));
                            ++i;
                        }
                    }
                    this.renderOutline(renderer, label.getOutline(), r2d);
                }
                g2d.rotate(-dAngleInRadians, dX, dY);
            } else if (dAngleInDegrees == -90.0) {
                dX += dFullWidth / 2.0;
                double dYHalfOffset = (dFullHeight + dHeight) / 2.0;
                double dDeltaX = dYHalfOffset - dFullHeight / 2.0;
                g2d.rotate(dAngleInRadians, dX -= dDeltaX, dY -= dHeight);
                if (bShadow) {
                    g2d.setPaint(new GradientPaint(new Point2D.Double(dX + shadowness, dY - dYHalfOffset + shadowness), (Color)this._sxs.getColor(label.getShadowColor()), new Point2D.Double(dX + shadowness + dFullWidth, dY - dYHalfOffset + shadowness + dFullHeight), (Color)this._sxs.getColor(label.getShadowColor().translucent())));
                    this.fillShadow(g2d, new Rectangle2D.Double(dX + shadowness, dY - dYHalfOffset + shadowness, dFullWidth, dFullHeight));
                } else {
                    Rectangle2D.Double r2d = new Rectangle2D.Double(dX, dY - dYHalfOffset, dFullWidth, dFullHeight);
                    if (clrBackground != null) {
                        g2d.setColor(clrBackground);
                        g2d.fill(r2d);
                    }
                    if (!bEmptyText) {
                        g2d.setColor(clrText);
                        int i = 0;
                        while (i < lineCount) {
                            ChartTextLayout textLayout = ((ChartTextMetrics)textMetrics).getLayout(i);
                            if (bRightAligned) {
                                dWidth = textLayout.getBounds().getWidth();
                                dXOffset = -insets.getLeft() + dFullWidth - dWidth - insets.getRight();
                            } else if (bCenterAligned) {
                                dWidth = textLayout.getBounds().getWidth();
                                dXOffset = -insets.getLeft() + (dFullWidth - dWidth) / 2.0;
                            }
                            textLayout.draw(g2d, (float)(dX + dXOffset + insets.getLeft()), (float)(dY - dDescent - dYHalfOffset + dHeight * (double)(i + 1) + insets.getTop()));
                            ++i;
                        }
                    }
                    this.renderOutline(renderer, label.getOutline(), r2d);
                }
                g2d.rotate(-dAngleInRadians, dX, dY);
            }
        }
        finally {
            textMetrics.dispose();
        }
    }

    protected void fillShadow(Graphics2D g2d, Shape shape) {
        g2d.fill(shape);
    }

    private final void showTopValue(IPrimitiveRenderer renderer, Location location, Label label, int labelPosition, boolean bShadow) {
        Graphics2D g2d = (Graphics2D)((IDeviceRenderer)renderer).getGraphicsContext();
        FontDefinition fontDef = label.getCaption().getFont();
        double dAngleInDegrees = fontDef.getRotation();
        Color clrText = (Color)this._sxs.getColor(label.getCaption().getColor());
        Color clrBackground = null;
        if (label.getBackground() != null) {
            clrBackground = (Color)this._sxs.getColor((ColorDefinition)label.getBackground());
        }
        double dAngleInRadians = -dAngleInDegrees * Math.PI / 180.0;
        ITextMetrics textMetrics = this._sxs.getTextMetrics(label);
        location = this.adjustTextPosition(labelPosition, location, textMetrics, dAngleInDegrees);
        double dX = location.getX();
        double dY = location.getY();
        try {
            double dFullWidth = textMetrics.getFullWidth();
            double dHeight = textMetrics.getHeight();
            double dDescent = textMetrics.getDescent();
            double dFullHeight = textMetrics.getFullHeight();
            double dXOffset = 0.0;
            double dWidth = 0.0;
            int lineCount = textMetrics.getLineCount();
            Insets insets = label.getInsets().scaledInstance((double)this._sxs.getDpiResolution() / 72.0);
            double shadowness = (double)(3 * this._sxs.getDpiResolution()) / 72.0;
            boolean bEmptyText = "".equals(label.getCaption().getValue());
            HorizontalAlignment hAlignment = label.getCaption().getFont().getAlignment().getHorizontalAlignment();
            boolean bRightAligned = hAlignment.getValue() == 2;
            boolean bCenterAligned = hAlignment.getValue() == 1;
            dX -= dFullWidth / 2.0;
            if (dAngleInDegrees == 0.0) {
                if (bShadow) {
                    g2d.setPaint(new GradientPaint(new Point2D.Double(dX + shadowness, dY - dFullHeight + shadowness), (Color)this._sxs.getColor(label.getShadowColor()), new Point2D.Double(dX + shadowness + dFullWidth, dY - dFullHeight + shadowness + dFullHeight), (Color)this._sxs.getColor(label.getShadowColor().translucent())));
                    this.fillShadow(g2d, new Rectangle2D.Double(dX + shadowness, dY - dFullHeight + shadowness, dFullWidth, dFullHeight));
                } else {
                    Rectangle2D.Double r2d = new Rectangle2D.Double(dX, dY - dFullHeight, dFullWidth, dFullHeight);
                    if (clrBackground != null) {
                        g2d.setColor(clrBackground);
                        g2d.fill(r2d);
                    }
                    if (!bEmptyText) {
                        g2d.setColor(clrText);
                        int i = 0;
                        while (i < textMetrics.getLineCount()) {
                            ChartTextLayout textLayout = ((ChartTextMetrics)textMetrics).getLayout(lineCount - i - 1);
                            if (bRightAligned) {
                                dWidth = textLayout.getBounds().getWidth();
                                dXOffset = -insets.getLeft() + dFullWidth - dWidth - insets.getRight();
                            } else if (bCenterAligned) {
                                dWidth = textLayout.getBounds().getWidth();
                                dXOffset = -insets.getLeft() + (dFullWidth - dWidth) / 2.0;
                            }
                            textLayout.draw(g2d, (float)(dX + dXOffset + insets.getLeft()), (float)(dY - dDescent - dHeight * (double)i - insets.getBottom()));
                            ++i;
                        }
                    }
                    this.renderOutline(renderer, label.getOutline(), r2d);
                }
            } else if (dAngleInDegrees > 0.0 && dAngleInDegrees < 90.0) {
                double dDeltaX = dFullWidth / 2.0;
                g2d.rotate(dAngleInRadians, dX += dDeltaX, dY);
                if (bShadow) {
                    g2d.setPaint(new GradientPaint(new Point2D.Double(dX + shadowness, dY - dFullHeight + shadowness), (Color)this._sxs.getColor(label.getShadowColor()), new Point2D.Double(dX + shadowness + dFullWidth, dY - dFullHeight + shadowness + dFullHeight), (Color)this._sxs.getColor(label.getShadowColor().translucent())));
                    this.fillShadow(g2d, new Rectangle2D.Double(dX + shadowness, dY - dFullHeight + shadowness, dFullWidth, dFullHeight));
                } else {
                    Rectangle2D.Double r2d = new Rectangle2D.Double(dX, dY - dFullHeight, dFullWidth, dFullHeight);
                    if (clrBackground != null) {
                        g2d.setColor(clrBackground);
                        g2d.fill(r2d);
                    }
                    if (!bEmptyText) {
                        g2d.setColor(clrText);
                        int i = 0;
                        while (i < textMetrics.getLineCount()) {
                            ChartTextLayout textLayout = new ChartTextLayout(textMetrics.getLine(lineCount - i - 1), g2d.getFont().getAttributes(), g2d.getFontRenderContext());
                            if (bRightAligned) {
                                dWidth = textLayout.getBounds().getWidth();
                                dXOffset = -insets.getLeft() + dFullWidth - dWidth - insets.getRight();
                            } else if (bCenterAligned) {
                                dWidth = textLayout.getBounds().getWidth();
                                dXOffset = -insets.getLeft() + (dFullWidth - dWidth) / 2.0;
                            }
                            textLayout.draw(g2d, (float)(dX + dXOffset + insets.getLeft()), (float)(dY - dDescent - dHeight * (double)i - insets.getBottom()));
                            ++i;
                        }
                    }
                    this.renderOutline(renderer, label.getOutline(), r2d);
                }
                g2d.rotate(-dAngleInRadians, dX, dY);
            } else if (dAngleInDegrees < 0.0 && dAngleInDegrees > -90.0) {
                double dCosTheta = Math.abs(Math.cos(dAngleInRadians));
                double dSineTheta = Math.abs(Math.sin(dAngleInRadians));
                g2d.rotate(dAngleInRadians, dX -= dFullWidth / 2.0 - (dFullWidth - dFullWidth * dCosTheta), dY -= dFullWidth * dSineTheta);
                if (bShadow) {
                    g2d.setPaint(new GradientPaint(new Point2D.Double(dX + shadowness, dY - dFullHeight + shadowness), (Color)this._sxs.getColor(label.getShadowColor()), new Point2D.Double(dX + shadowness + dFullWidth, dY - dFullHeight + shadowness + dFullHeight), (Color)this._sxs.getColor(label.getShadowColor().translucent())));
                    this.fillShadow(g2d, new Rectangle2D.Double(dX + shadowness, dY - dFullHeight + shadowness, dFullWidth, dFullHeight));
                } else {
                    Rectangle2D.Double r2d = new Rectangle2D.Double(dX, dY - dFullHeight, dFullWidth, dFullHeight);
                    if (clrBackground != null) {
                        g2d.setColor(clrBackground);
                        g2d.fill(r2d);
                    }
                    if (!bEmptyText) {
                        g2d.setColor(clrText);
                        int i = 0;
                        while (i < textMetrics.getLineCount()) {
                            ChartTextLayout textLayout = ((ChartTextMetrics)textMetrics).getLayout(lineCount - i - 1);
                            if (bRightAligned) {
                                dWidth = textLayout.getBounds().getWidth();
                                dXOffset = -insets.getLeft() + dFullWidth - dWidth - insets.getRight();
                            } else if (bCenterAligned) {
                                dWidth = textLayout.getBounds().getWidth();
                                dXOffset = -insets.getLeft() + (dFullWidth - dWidth) / 2.0;
                            }
                            textLayout.draw(g2d, (float)(dX + dXOffset + insets.getLeft()), (float)(dY - dDescent - dHeight * (double)i - insets.getBottom()));
                            ++i;
                        }
                    }
                    this.renderOutline(renderer, label.getOutline(), r2d);
                }
                g2d.rotate(-dAngleInRadians, dX, dY);
            } else if (dAngleInDegrees == 90.0) {
                double dYHalfOffset = (dFullHeight + dHeight) / 2.0;
                double dDeltaX = (dFullWidth + dHeight) / 2.0;
                g2d.rotate(dAngleInRadians, dX += dDeltaX, dY);
                if (bShadow) {
                    g2d.setPaint(new GradientPaint(new Point2D.Double(dX + shadowness, dY - dYHalfOffset + shadowness), (Color)this._sxs.getColor(label.getShadowColor()), new Point2D.Double(dX + shadowness + dFullWidth, dY - dYHalfOffset + shadowness + dFullHeight), (Color)this._sxs.getColor(label.getShadowColor().translucent())));
                    this.fillShadow(g2d, new Rectangle2D.Double(dX + shadowness, dY - dYHalfOffset + shadowness, dFullWidth, dFullHeight));
                } else {
                    Rectangle2D.Double r2d = new Rectangle2D.Double(dX, dY - dYHalfOffset, dFullWidth, dFullHeight);
                    if (clrBackground != null) {
                        g2d.setColor(clrBackground);
                        g2d.fill(r2d);
                    }
                    if (!bEmptyText) {
                        g2d.setColor(clrText);
                        int i = 0;
                        while (i < textMetrics.getLineCount()) {
                            ChartTextLayout textLayout = ((ChartTextMetrics)textMetrics).getLayout(i);
                            if (bRightAligned) {
                                dWidth = textLayout.getBounds().getWidth();
                                dXOffset = -insets.getLeft() + dFullWidth - dWidth - insets.getRight();
                            } else if (bCenterAligned) {
                                dWidth = textLayout.getBounds().getWidth();
                                dXOffset = -insets.getLeft() + (dFullWidth - dWidth) / 2.0;
                            }
                            textLayout.draw(g2d, (float)(dX + dXOffset + insets.getLeft()), (float)(dY - dDescent - ((double)(textMetrics.getLineCount() - i) * dHeight - (double)(lineCount + 1) * dHeight / 2.0) + insets.getTop()));
                            ++i;
                        }
                    }
                    this.renderOutline(renderer, label.getOutline(), r2d);
                }
                g2d.rotate(-dAngleInRadians, dX, dY);
            } else if (dAngleInDegrees == -90.0) {
                double dYHalfOffset = (dFullHeight + dHeight) / 2.0;
                double dDeltaX = (dFullWidth - dHeight) / 2.0;
                double dDeltaY = dFullWidth;
                g2d.rotate(dAngleInRadians, dX += dDeltaX, dY -= dDeltaY);
                if (bShadow) {
                    g2d.setPaint(new GradientPaint(new Point2D.Double(dX + shadowness, dY - dYHalfOffset + shadowness), (Color)this._sxs.getColor(label.getShadowColor()), new Point2D.Double(dX + shadowness + dFullWidth, dY - dYHalfOffset + shadowness + dFullHeight), (Color)this._sxs.getColor(label.getShadowColor().translucent())));
                    this.fillShadow(g2d, new Rectangle2D.Double(dX + shadowness, dY - dYHalfOffset + shadowness, dFullWidth, dFullHeight));
                } else {
                    Rectangle2D.Double r2d = new Rectangle2D.Double(dX, dY - dYHalfOffset, dFullWidth, dFullHeight);
                    if (clrBackground != null) {
                        g2d.setColor(clrBackground);
                        g2d.fill(r2d);
                    }
                    if (!bEmptyText) {
                        g2d.setColor(clrText);
                        int i = 0;
                        while (i < textMetrics.getLineCount()) {
                            ChartTextLayout textLayout = ((ChartTextMetrics)textMetrics).getLayout(i);
                            if (bRightAligned) {
                                dWidth = textLayout.getBounds().getWidth();
                                dXOffset = -insets.getLeft() + dFullWidth - dWidth - insets.getRight();
                            } else if (bCenterAligned) {
                                dWidth = textLayout.getBounds().getWidth();
                                dXOffset = -insets.getLeft() + (dFullWidth - dWidth) / 2.0;
                            }
                            textLayout.draw(g2d, (float)(dX + dXOffset + insets.getLeft()), (float)(dY - dDescent - ((double)(textMetrics.getLineCount() - i) * dHeight - (double)(lineCount + 1) * dHeight / 2.0) + insets.getTop()));
                            ++i;
                        }
                    }
                    this.renderOutline(renderer, label.getOutline(), r2d);
                }
                g2d.rotate(-dAngleInRadians, dX, dY);
            }
        }
        finally {
            textMetrics.dispose();
        }
    }

    private final void showCenterValue(IPrimitiveRenderer renderer, Location location, Label label, boolean bShadow) {
        Graphics2D g2d = (Graphics2D)((IDeviceRenderer)renderer).getGraphicsContext();
        double dX = location.getX();
        double dY = location.getY();
        FontDefinition fontDef = label.getCaption().getFont();
        double dAngleInDegrees = fontDef.getRotation();
        if (bShadow) {
            bShadow = label.getShadowColor() != null;
        }
        Color clrText = (Color)this._sxs.getColor(label.getCaption().getColor());
        Color clrBackground = null;
        if (label.getBackground() != null) {
            clrBackground = (Color)this._sxs.getColor((ColorDefinition)label.getBackground());
        }
        double dAngleInRadians = -dAngleInDegrees * Math.PI / 180.0;
        double dSineTheta = Math.sin(dAngleInRadians);
        double dCosTheta = Math.cos(dAngleInRadians);
        ITextMetrics textMetrics = this._sxs.getTextMetrics(label);
        try {
            double dFullWidth = textMetrics.getFullWidth();
            double dHeight = textMetrics.getHeight();
            double dDescent = textMetrics.getDescent();
            double dFullHeight = textMetrics.getFullHeight();
            double dXOffset = 0.0;
            double dWidth = 0.0;
            int lineCount = textMetrics.getLineCount();
            Insets insets = label.getInsets().scaledInstance((double)this._sxs.getDpiResolution() / 72.0);
            double shadowness = (double)(3 * this._sxs.getDpiResolution()) / 72.0;
            boolean bEmptyText = "".equals(label.getCaption().getValue());
            HorizontalAlignment hAlign = label.getCaption().getFont().getAlignment().getHorizontalAlignment();
            boolean bRightAligned = hAlign.getValue() == 2;
            boolean bCenterAligned = hAlign.getValue() == 1;
            double dRotateX = dX;
            double dRotateY = dY;
            dX -= dFullWidth / 2.0;
            dY += dHeight / 2.0;
            if (dAngleInDegrees == 0.0) {
                double dYHalfOffset = (dFullHeight + dHeight) / 2.0;
                if (bShadow) {
                    g2d.setPaint(new GradientPaint(new Point2D.Double(dX + shadowness, dY - dYHalfOffset + shadowness), (Color)this._sxs.getColor(label.getShadowColor()), new Point2D.Double(dX + shadowness + dFullWidth, dY - dYHalfOffset + shadowness + dFullHeight), (Color)this._sxs.getColor(label.getShadowColor().translucent())));
                    this.fillShadow(g2d, new Rectangle2D.Double(dX + shadowness, dY - dYHalfOffset + shadowness, dFullWidth, dFullHeight));
                } else {
                    Rectangle2D.Double r2d = new Rectangle2D.Double(dX, dY - dYHalfOffset, dFullWidth, dFullHeight);
                    if (clrBackground != null) {
                        g2d.setColor(clrBackground);
                        g2d.fill(r2d);
                    }
                    if (!bEmptyText) {
                        g2d.setColor(clrText);
                        int i = 0;
                        while (i < lineCount) {
                            ChartTextLayout textLayout = ((ChartTextMetrics)textMetrics).getLayout(i);
                            if (bRightAligned) {
                                dWidth = textLayout.getBounds().getWidth();
                                dXOffset = -insets.getLeft() + dFullWidth - dWidth - insets.getRight();
                            } else if (bCenterAligned) {
                                dWidth = textLayout.getBounds().getWidth();
                                dXOffset = -insets.getLeft() + (dFullWidth - dWidth) / 2.0;
                            }
                            textLayout.draw(g2d, (float)(dX + dXOffset + insets.getLeft()), (float)(dY - dYHalfOffset + insets.getTop() + dHeight * (double)(i + 1) - dDescent));
                            ++i;
                        }
                    }
                    this.renderOutline(renderer, label.getOutline(), r2d);
                }
            } else if (dAngleInDegrees > 0.0 && dAngleInDegrees < 90.0) {
                double dDeltaX = dFullWidth - dFullWidth * dCosTheta;
                double dDeltaY = dFullWidth * dSineTheta + dHeight / 2.0;
                dX += dDeltaX;
                dY -= dDeltaY;
                g2d.rotate(dAngleInRadians, dRotateX + dDeltaX, dRotateY - dDeltaY);
                if (bShadow) {
                    g2d.setPaint(new GradientPaint(new Point2D.Double(dX + shadowness, dY - dFullHeight + shadowness), (Color)this._sxs.getColor(label.getShadowColor()), new Point2D.Double(dX + shadowness + dFullWidth, dY - dFullHeight + shadowness + dFullHeight), (Color)this._sxs.getColor(label.getShadowColor().translucent())));
                    this.fillShadow(g2d, new Rectangle2D.Double(dX + shadowness, dY - dFullHeight + shadowness, dFullWidth, dFullHeight));
                } else {
                    Rectangle2D.Double r2d = new Rectangle2D.Double(dX, dY - dFullHeight, dFullWidth, dFullHeight);
                    if (clrBackground != null) {
                        g2d.setColor(clrBackground);
                        g2d.fill(r2d);
                    }
                    if (!bEmptyText) {
                        g2d.setColor(clrText);
                        int i = 0;
                        while (i < textMetrics.getLineCount()) {
                            ChartTextLayout textLayout = ((ChartTextMetrics)textMetrics).getLayout(lineCount - i - 1);
                            if (bRightAligned) {
                                dWidth = textLayout.getBounds().getWidth();
                                dXOffset = -insets.getLeft() + dFullWidth - dWidth - insets.getRight();
                            } else if (bCenterAligned) {
                                dWidth = textLayout.getBounds().getWidth();
                                dXOffset = -insets.getLeft() + (dFullWidth - dWidth) / 2.0;
                            }
                            textLayout.draw(g2d, (float)(dX + dXOffset + insets.getLeft()), (float)(dY - dDescent - dHeight * (double)i - insets.getBottom()));
                            ++i;
                        }
                    }
                    this.renderOutline(renderer, label.getOutline(), r2d);
                }
                g2d.rotate(-dAngleInRadians, dRotateX + dDeltaX, dRotateY - dDeltaY);
            } else if (dAngleInDegrees < 0.0 && dAngleInDegrees > -90.0) {
                double dDeltaX = dFullWidth - dFullWidth * dCosTheta - dHeight * dSineTheta;
                double dDeltaY = dFullWidth * dSineTheta + dHeight / 2.0 - dHeight * dCosTheta;
                dX += dDeltaX;
                dY -= dDeltaY;
                g2d.rotate(dAngleInRadians, dRotateX + dDeltaX, dRotateY - dDeltaY);
                if (bShadow) {
                    g2d.setPaint(new GradientPaint(new Point2D.Double(dX + shadowness, dY - dHeight + shadowness), (Color)this._sxs.getColor(label.getShadowColor()), new Point2D.Double(dX + shadowness + dFullWidth, dY - dHeight + shadowness + dFullHeight), (Color)this._sxs.getColor(label.getShadowColor().translucent())));
                    this.fillShadow(g2d, new Rectangle2D.Double(dX + shadowness, dY - dHeight + shadowness, dFullWidth, dFullHeight));
                } else {
                    Rectangle2D.Double r2d = new Rectangle2D.Double(dX, dY - dHeight, dFullWidth, dFullHeight);
                    if (clrBackground != null) {
                        g2d.setColor(clrBackground);
                        g2d.fill(r2d);
                    }
                    if (!bEmptyText) {
                        g2d.setColor(clrText);
                        int i = 0;
                        while (i < lineCount) {
                            ChartTextLayout textLayout = ((ChartTextMetrics)textMetrics).getLayout(i);
                            if (bRightAligned) {
                                dWidth = textLayout.getBounds().getWidth();
                                dXOffset = -insets.getLeft() + dFullWidth - dWidth - insets.getRight();
                            } else if (bCenterAligned) {
                                dWidth = textLayout.getBounds().getWidth();
                                dXOffset = -insets.getLeft() + (dFullWidth - dWidth) / 2.0;
                            }
                            textLayout.draw(g2d, (float)(dX + dXOffset + insets.getLeft()), (float)(dY - dDescent + dHeight * (double)i + insets.getTop()));
                            ++i;
                        }
                    }
                    this.renderOutline(renderer, label.getOutline(), r2d);
                }
                g2d.rotate(-dAngleInRadians, dRotateX + dDeltaX, dRotateY - dDeltaY);
            } else if (dAngleInDegrees == 90.0) {
                double dDeltaX = dFullWidth;
                double dDeltaY = (dFullWidth - dHeight) / 2.0;
                g2d.rotate(dAngleInRadians, dX += dDeltaX, dY += dDeltaY);
                if (bShadow) {
                    g2d.setPaint(new GradientPaint(new Point2D.Double(dX + shadowness, dY - dFullHeight + shadowness), (Color)this._sxs.getColor(label.getShadowColor()), new Point2D.Double(dX + shadowness + dFullWidth, dY - dFullHeight + shadowness + dFullHeight), (Color)this._sxs.getColor(label.getShadowColor().translucent())));
                    this.fillShadow(g2d, new Rectangle2D.Double(dX + shadowness, dY - dFullHeight + shadowness, dFullWidth, dFullHeight));
                } else {
                    Rectangle2D.Double r2d = new Rectangle2D.Double(dX, dY - dFullHeight, dFullWidth, dFullHeight);
                    if (clrBackground != null) {
                        g2d.setColor(clrBackground);
                        g2d.fill(r2d);
                    }
                    if (!bEmptyText) {
                        g2d.setColor(clrText);
                        int i = 0;
                        while (i < lineCount) {
                            ChartTextLayout textLayout = ((ChartTextMetrics)textMetrics).getLayout(i);
                            if (bRightAligned) {
                                dWidth = textLayout.getBounds().getWidth();
                                dXOffset = -insets.getLeft() + dFullWidth - dWidth - insets.getRight();
                            } else if (bCenterAligned) {
                                dWidth = textLayout.getBounds().getWidth();
                                dXOffset = -insets.getLeft() + (dFullWidth - dWidth) / 2.0;
                            }
                            textLayout.draw(g2d, (float)(dX + dXOffset + insets.getLeft()), (float)(dY - dDescent - dHeight * (double)(lineCount - i - 1) + insets.getTop()));
                            ++i;
                        }
                    }
                    this.renderOutline(renderer, label.getOutline(), r2d);
                }
                g2d.rotate(-dAngleInRadians, dX, dY);
            } else if (dAngleInDegrees == -90.0) {
                double dDeltaX = dFullWidth - dHeight;
                double dDeltaY = (dFullWidth + dHeight) / 2.0;
                g2d.rotate(dAngleInRadians, dX += dDeltaX, dY -= dDeltaY);
                if (bShadow) {
                    g2d.setPaint(new GradientPaint(new Point2D.Double(dX + shadowness, dY - dFullHeight + shadowness), (Color)this._sxs.getColor(label.getShadowColor()), new Point2D.Double(dX + shadowness + dFullWidth, dY - dFullHeight + shadowness + dFullHeight), (Color)this._sxs.getColor(label.getShadowColor().translucent())));
                    this.fillShadow(g2d, new Rectangle2D.Double(dX + shadowness, dY - dFullHeight + shadowness, dFullWidth, dFullHeight));
                } else {
                    Rectangle2D.Double r2d = new Rectangle2D.Double(dX, dY - dHeight, dFullWidth, dFullHeight);
                    if (clrBackground != null) {
                        g2d.setColor(clrBackground);
                        g2d.fill(r2d);
                    }
                    if (!bEmptyText) {
                        g2d.setColor(clrText);
                        int i = 0;
                        while (i < lineCount) {
                            ChartTextLayout textLayout = ((ChartTextMetrics)textMetrics).getLayout(i);
                            if (bRightAligned) {
                                dWidth = textLayout.getBounds().getWidth();
                                dXOffset = -insets.getLeft() + dFullWidth - dWidth - insets.getRight();
                            } else if (bCenterAligned) {
                                dWidth = textLayout.getBounds().getWidth();
                                dXOffset = -insets.getLeft() + (dFullWidth - dWidth) / 2.0;
                            }
                            textLayout.draw(g2d, (float)(dX + dXOffset + insets.getLeft()), (float)(dY - dDescent + dHeight * (double)i + insets.getTop()));
                            ++i;
                        }
                    }
                    this.renderOutline(renderer, label.getOutline(), r2d);
                }
                g2d.rotate(-dAngleInRadians, dX, dY);
            }
        }
        finally {
            textMetrics.dispose();
        }
    }

    protected void renderOutline(IPrimitiveRenderer renderer, LineAttributes lineAttribs, Rectangle2D.Double rect) {
        if (lineAttribs != null && lineAttribs.isVisible() && lineAttribs.getColor() != null) {
            Graphics2D g2d = (Graphics2D)((IDeviceRenderer)renderer).getGraphicsContext();
            Stroke sPrevious = null;
            ColorDefinition cd = lineAttribs.getColor();
            Stroke sCurrent = ((SwingRendererImpl)renderer).getCachedStroke(lineAttribs);
            if (sCurrent != null) {
                sPrevious = g2d.getStroke();
                g2d.setStroke(sCurrent);
            }
            g2d.setColor((Color)this._sxs.getColor(cd));
            g2d.draw(rect);
            if (sPrevious != null) {
                g2d.setStroke(sPrevious);
            }
        }
    }
}

