/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.integration.wtp.ui.internal.util;

import java.util.Map;
import org.eclipse.birt.integration.wtp.ui.internal.dialogs.FolderSelectionGroup;
import org.eclipse.birt.integration.wtp.ui.internal.resource.BirtWTPMessages;
import org.eclipse.birt.integration.wtp.ui.internal.util.DataUtil;
import org.eclipse.birt.integration.wtp.ui.internal.util.WebArtifactUtil;
import org.eclipse.birt.integration.wtp.ui.internal.wizards.BirtWizardUtil;
import org.eclipse.birt.integration.wtp.ui.internal.wizards.IBirtWizardConstants;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class UIUtil
implements IBirtWizardConstants {
    private Map properties;
    private static final int MAX_MAX_ROWS = Integer.MAX_VALUE;
    private static final int MAX_MAX_LEVELS = Integer.MAX_VALUE;
    private static final int MAX_CUBE_MEMORYSIZE = Integer.MAX_VALUE;

    public UIUtil(Map properties) {
        this.properties = properties;
    }

    public Text createResourceFolderGroup(Composite parent) {
        Text txtResourceFolder = null;
        String defaultFolder = BirtWizardUtil.getDefaultResourceFolder();
        FolderSelectionGroup group = new FolderSelectionGroup();
        group.setLabelText(BirtWTPMessages.BIRTConfiguration_resource_label);
        group.setButtonText(BirtWTPMessages.BIRTConfiguration_folder_button_text);
        group.setDialogTitle(BirtWTPMessages.BIRTConfiguration_resource_dialog_title);
        group.setDialogMessage(BirtWTPMessages.BIRTConfiguration_resource_dialog_message);
        group.setDialogFilterPath(defaultFolder);
        group.setTextValue(defaultFolder);
        group.create(parent);
        txtResourceFolder = group.getText();
        txtResourceFolder.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WebArtifactUtil.setContextParamValue(UIUtil.this.properties, "BIRT_RESOURCE_PATH", ((Text)e.getSource()).getText());
            }
        });
        return txtResourceFolder;
    }

    public Text createWorkingFolderGroup(Composite parent) {
        Text txtWorkingFolder = null;
        FolderSelectionGroup group = new FolderSelectionGroup();
        group.setLabelText(BirtWTPMessages.BIRTConfiguration_working_label);
        group.setButtonText(BirtWTPMessages.BIRTConfiguration_folder_button_text);
        group.setDialogTitle(BirtWTPMessages.BIRTConfiguration_working_dialog_title);
        group.setDialogMessage(BirtWTPMessages.BIRTConfiguration_working_dialog_message);
        group.setTextValue(DataUtil.getString(WebArtifactUtil.getContextParamValue(this.properties, "BIRT_VIEWER_WORKING_FOLDER"), false));
        group.create(parent);
        txtWorkingFolder = group.getText();
        txtWorkingFolder.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WebArtifactUtil.setContextParamValue(UIUtil.this.properties, "BIRT_VIEWER_WORKING_FOLDER", ((Text)e.getSource()).getText());
            }
        });
        return txtWorkingFolder;
    }

    public Text createDocumentFolderGroup(Composite parent) {
        Text txtDocumentFolder = null;
        FolderSelectionGroup group = new FolderSelectionGroup();
        group.setLabelText(BirtWTPMessages.BIRTConfiguration_document_label);
        group.setButtonText(BirtWTPMessages.BIRTConfiguration_folder_button_text);
        group.setDialogTitle(BirtWTPMessages.BIRTConfiguration_document_dialog_title);
        group.setDialogMessage(BirtWTPMessages.BIRTConfiguration_document_dialog_message);
        group.setTextValue(DataUtil.getString(WebArtifactUtil.getContextParamValue(this.properties, "BIRT_VIEWER_DOCUMENT_FOLDER"), false));
        group.create(parent);
        txtDocumentFolder = group.getText();
        txtDocumentFolder.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WebArtifactUtil.setContextParamValue(UIUtil.this.properties, "BIRT_VIEWER_DOCUMENT_FOLDER", ((Text)e.getSource()).getText());
            }
        });
        return txtDocumentFolder;
    }

    public Text createImageFolderGroup(Composite parent) {
        Text txtImageFolder = null;
        FolderSelectionGroup group = new FolderSelectionGroup();
        group.setLabelText(BirtWTPMessages.BIRTConfiguration_image_label);
        group.setButtonText(BirtWTPMessages.BIRTConfiguration_folder_button_text);
        group.setDialogTitle(BirtWTPMessages.BIRTConfiguration_image_dialog_title);
        group.setDialogMessage(BirtWTPMessages.BIRTConfiguration_image_dialog_message);
        group.setTextValue(DataUtil.getString(WebArtifactUtil.getContextParamValue(this.properties, "BIRT_VIEWER_IMAGE_DIR"), false));
        group.create(parent);
        txtImageFolder = group.getText();
        txtImageFolder.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WebArtifactUtil.setContextParamValue(UIUtil.this.properties, "BIRT_VIEWER_IMAGE_DIR", ((Text)e.getSource()).getText());
            }
        });
        return txtImageFolder;
    }

    public Text createScriptLibFolderGroup(Composite parent) {
        Text txtScriptlibFolder = null;
        FolderSelectionGroup group = new FolderSelectionGroup();
        group.setLabelText(BirtWTPMessages.BIRTConfiguration_scriptlib_label);
        group.setButtonText(BirtWTPMessages.BIRTConfiguration_folder_button_text);
        group.setDialogTitle(BirtWTPMessages.BIRTConfiguration_scriptlib_dialog_title);
        group.setDialogMessage(BirtWTPMessages.BIRTConfiguration_scriptlib_dialog_message);
        group.setTextValue(DataUtil.getString(WebArtifactUtil.getContextParamValue(this.properties, "BIRT_VIEWER_SCRIPTLIB_DIR"), false));
        group.create(parent);
        txtScriptlibFolder = group.getText();
        txtScriptlibFolder.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WebArtifactUtil.setContextParamValue(UIUtil.this.properties, "BIRT_VIEWER_SCRIPTLIB_DIR", ((Text)e.getSource()).getText());
            }
        });
        return txtScriptlibFolder;
    }

    public Text createLogFolderGroup(Composite parent) {
        Text txtLogFolder = null;
        FolderSelectionGroup group = new FolderSelectionGroup();
        group.setLabelText(BirtWTPMessages.BIRTConfiguration_log_label);
        group.setButtonText(BirtWTPMessages.BIRTConfiguration_folder_button_text);
        group.setDialogTitle(BirtWTPMessages.BIRTConfiguration_log_dialog_title);
        group.setDialogMessage(BirtWTPMessages.BIRTConfiguration_log_dialog_message);
        group.setTextValue(DataUtil.getString(WebArtifactUtil.getContextParamValue(this.properties, "BIRT_VIEWER_LOG_DIR"), false));
        group.create(parent);
        txtLogFolder = group.getText();
        txtLogFolder.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WebArtifactUtil.setContextParamValue(UIUtil.this.properties, "BIRT_VIEWER_LOG_DIR", ((Text)e.getSource()).getText());
            }
        });
        return txtLogFolder;
    }

    public Button createAccessOnlyGroup(Composite parent) {
        Button btAccessOnly = new Button(parent, 32);
        boolean defaultValue = DataUtil.getBoolean(WebArtifactUtil.getContextParamValue(this.properties, "WORKING_FOLDER_ACCESS_ONLY"));
        btAccessOnly.setSelection(defaultValue);
        btAccessOnly.setText(BirtWTPMessages.BIRTConfiguration_report_access_message);
        btAccessOnly.setLayoutData((Object)new GridData(3));
        btAccessOnly.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WebArtifactUtil.setContextParamValue(UIUtil.this.properties, "WORKING_FOLDER_ACCESS_ONLY", new String("" + ((Button)e.getSource()).getSelection()));
            }
        });
        return btAccessOnly;
    }

    public Button createOverwriteGroup(Composite parent) {
        Button btOverwrite = new Button(parent, 32);
        boolean defaultValue = DataUtil.getBoolean(WebArtifactUtil.getContextParamValue(this.properties, "BIRT_OVERWRITE_DOCUMENT"));
        btOverwrite.setSelection(defaultValue);
        btOverwrite.setText(BirtWTPMessages.BIRTConfiguration_overwrite_message);
        btOverwrite.setLayoutData((Object)new GridData(3));
        btOverwrite.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WebArtifactUtil.setContextParamValue(UIUtil.this.properties, "BIRT_OVERWRITE_DOCUMENT", new String("" + ((Button)e.getSource()).getSelection()));
            }
        });
        return btOverwrite;
    }

    public Text createMaxRowsGroup(Composite parent) {
        Text txtMaxRows = null;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(768);
        composite.setLayoutData((Object)data);
        Font font = parent.getFont();
        Label label = new Label(composite, 16384);
        label.setFont(font);
        label.setText(BirtWTPMessages.BIRTConfiguration_maxrows_label);
        txtMaxRows = new Text(composite, 2048);
        txtMaxRows.setLayoutData((Object)new GridData(768));
        txtMaxRows.setFont(font);
        txtMaxRows.setTextLimit(Integer.toString(Integer.MAX_VALUE).length());
        int defaultValue = DataUtil.getInt(WebArtifactUtil.getContextParamValue(this.properties, "BIRT_VIEWER_MAX_ROWS"));
        if (defaultValue > 0) {
            txtMaxRows.setText("" + defaultValue);
        }
        txtMaxRows.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = e.text.matches("[0-9]*");
            }
        });
        txtMaxRows.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WebArtifactUtil.setContextParamValue(UIUtil.this.properties, "BIRT_VIEWER_MAX_ROWS", DataUtil.getNumberSetting(((Text)e.getSource()).getText()));
            }
        });
        return txtMaxRows;
    }

    public Text createMaxRowLevelsGroup(Composite parent) {
        Text txtMaxLevels = null;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(768);
        composite.setLayoutData((Object)data);
        Font font = parent.getFont();
        Label label = new Label(composite, 16384);
        label.setFont(font);
        label.setText(BirtWTPMessages.BIRTConfiguration_maxrowlevels_label);
        txtMaxLevels = new Text(composite, 2048);
        txtMaxLevels.setLayoutData((Object)new GridData(768));
        txtMaxLevels.setFont(font);
        txtMaxLevels.setTextLimit(Integer.toString(Integer.MAX_VALUE).length());
        int defaultValue = DataUtil.getInt(WebArtifactUtil.getContextParamValue(this.properties, "BIRT_VIEWER_MAX_CUBE_ROWLEVELS"));
        if (defaultValue > 0) {
            txtMaxLevels.setText("" + defaultValue);
        }
        txtMaxLevels.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = e.text.matches("[0-9]*");
            }
        });
        txtMaxLevels.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WebArtifactUtil.setContextParamValue(UIUtil.this.properties, "BIRT_VIEWER_MAX_CUBE_ROWLEVELS", DataUtil.getNumberSetting(((Text)e.getSource()).getText()));
            }
        });
        return txtMaxLevels;
    }

    public Text createMaxColumnLevelsGroup(Composite parent) {
        Text txtMaxLevels = null;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(768);
        composite.setLayoutData((Object)data);
        Font font = parent.getFont();
        Label label = new Label(composite, 16384);
        label.setFont(font);
        label.setText(BirtWTPMessages.BIRTConfiguration_maxcolumnlevels_label);
        txtMaxLevels = new Text(composite, 2048);
        txtMaxLevels.setLayoutData((Object)new GridData(768));
        txtMaxLevels.setFont(font);
        txtMaxLevels.setTextLimit(Integer.toString(Integer.MAX_VALUE).length());
        int defaultValue = DataUtil.getInt(WebArtifactUtil.getContextParamValue(this.properties, "BIRT_VIEWER_MAX_CUBE_COLUMNLEVELS"));
        if (defaultValue > 0) {
            txtMaxLevels.setText("" + defaultValue);
        }
        txtMaxLevels.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = e.text.matches("[0-9]*");
            }
        });
        txtMaxLevels.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WebArtifactUtil.setContextParamValue(UIUtil.this.properties, "BIRT_VIEWER_MAX_CUBE_COLUMNLEVELS", DataUtil.getNumberSetting(((Text)e.getSource()).getText()));
            }
        });
        return txtMaxLevels;
    }

    public Text createCubeMemorySizeGroup(Composite parent) {
        Text txtCubeMemorySize = null;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(768);
        composite.setLayoutData((Object)data);
        Font font = parent.getFont();
        Label label = new Label(composite, 16384);
        label.setFont(font);
        label.setText(BirtWTPMessages.BIRTConfiguration_cubememsize_label);
        txtCubeMemorySize = new Text(composite, 2048);
        txtCubeMemorySize.setLayoutData((Object)new GridData(768));
        txtCubeMemorySize.setFont(font);
        txtCubeMemorySize.setTextLimit(Integer.toString(Integer.MAX_VALUE).length());
        int defaultValue = DataUtil.getInt(WebArtifactUtil.getContextParamValue(this.properties, "BIRT_VIEWER_CUBE_MEMORY_SIZE"));
        if (defaultValue > 0) {
            txtCubeMemorySize.setText("" + defaultValue);
        }
        txtCubeMemorySize.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = e.text.matches("[0-9]*");
            }
        });
        txtCubeMemorySize.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WebArtifactUtil.setContextParamValue(UIUtil.this.properties, "BIRT_VIEWER_CUBE_MEMORY_SIZE", DataUtil.getNumberSetting(((Text)e.getSource()).getText()));
            }
        });
        return txtCubeMemorySize;
    }

    public Combo createLogLevelGroup(Composite parent) {
        Combo cbLogLevel = null;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(32);
        composite.setLayoutData((Object)data);
        Font font = parent.getFont();
        Label label = new Label(composite, 16384);
        label.setFont(font);
        label.setText(BirtWTPMessages.BIRTConfiguration_loglevel_label);
        cbLogLevel = new Combo(composite, 256);
        cbLogLevel.setFont(font);
        cbLogLevel.setItems(BirtWizardUtil.getLogLevels());
        cbLogLevel.setText(DataUtil.getString(WebArtifactUtil.getContextParamValue(this.properties, "BIRT_VIEWER_LOG_LEVEL"), false));
        cbLogLevel.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                WebArtifactUtil.setContextParamValue(UIUtil.this.properties, "BIRT_VIEWER_LOG_LEVEL", ((Combo)e.getSource()).getText());
            }
        });
        return cbLogLevel;
    }

    public Combo createPrintServerGroup(Composite parent) {
        Combo cbPrintServer = null;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(32);
        composite.setLayoutData((Object)data);
        Font font = parent.getFont();
        Label label = new Label(composite, 16384);
        label.setFont(font);
        label.setText(BirtWTPMessages.BIRTConfiguration_printserver_label);
        cbPrintServer = new Combo(composite, 256);
        cbPrintServer.setFont(font);
        cbPrintServer.setItems(new String[]{"ON", "OFF"});
        cbPrintServer.setText(DataUtil.getString(WebArtifactUtil.getContextParamValue(this.properties, "BIRT_VIEWER_PRINT_SERVERSIDE"), false));
        cbPrintServer.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                WebArtifactUtil.setContextParamValue(UIUtil.this.properties, "BIRT_VIEWER_PRINT_SERVERSIDE", ((Combo)e.getSource()).getText());
            }
        });
        return cbPrintServer;
    }

    public Button createImportClearSetting(Composite parent) {
        Button btClear = new Button(parent, 32);
        btClear.setSelection(true);
        btClear.setText(BirtWTPMessages.BIRTConfiguration_import_clear_message);
        btClear.setLayoutData((Object)new GridData(3));
        return btClear;
    }

    public Map getProperties() {
        return this.properties;
    }
}

