/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.device.image;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.chart.device.IScriptMenuHelper;
import org.eclipse.birt.chart.device.ScriptMenuHelper;
import org.eclipse.birt.chart.device.util.CSSHelper;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.attribute.ActionValue;
import org.eclipse.birt.chart.model.attribute.MenuStylesKeyType;
import org.eclipse.birt.chart.model.attribute.MultiURLValues;
import org.eclipse.birt.chart.model.attribute.ScriptValue;
import org.eclipse.birt.chart.model.attribute.URLValue;
import org.eclipse.birt.chart.model.data.Action;
import org.eclipse.birt.chart.model.data.MultipleActions;
import org.eclipse.emf.common.util.EMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiActionValuesScriptGenerator {
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.device.extension/image");
    private static String MENU_JS_CODE;
    private static IScriptMenuHelper SCRIPT_MENU_HELPER;

    static {
        SCRIPT_MENU_HELPER = ScriptMenuHelper.instance();
    }

    public static String getJSContent(ActionValue values) {
        StringBuilder sb = MultiActionValuesScriptGenerator.getJSContext(values);
        sb.append("var popMenu = BirtChartMenuHelper.createPopupMenu(evt, menuInfo);\n");
        sb.append("popMenu.show();\n");
        return sb.toString();
    }

    public static String getJSContent(MultipleActions actions) {
        StringBuilder sb = MultiActionValuesScriptGenerator.getJSContext(actions);
        sb.append("var popMenu = BirtChartMenuHelper.createPopupMenu(evt, menuInfo);\n");
        sb.append("popMenu.show();\n");
        return sb.toString();
    }

    public static String getJSKey(ActionValue values) {
        return MultiActionValuesScriptGenerator.getJSContext(values).toString();
    }

    public static String getJSKey(MultipleActions actions) {
        return MultiActionValuesScriptGenerator.getJSContext(actions).toString();
    }

    private static StringBuilder getJSContext(ActionValue values) {
        StringBuilder sb = new StringBuilder();
        if (values instanceof MultiURLValues) {
            MultiURLValues muv = (MultiURLValues)values;
            sb.append("\n\t var menuInfo = new BirtChartMenuInfo();\n");
            EMap propMap = muv.getPropertiesMap();
            sb.append(MultiActionValuesScriptGenerator.getPropertiesJS((EMap<String, String>)propMap).toString());
            int i = 0;
            for (URLValue uv : MultiActionValuesScriptGenerator.getValidURLValues(muv)) {
                sb = MultiActionValuesScriptGenerator.getURLValueJS(sb, i, uv);
                ++i;
            }
        }
        MultiActionValuesScriptGenerator.appendInteractivityVariables(sb);
        return sb;
    }

    public static StringBuilder appendInteractivityVariables(StringBuilder sb) {
        sb.append("\t if ( typeof categoryData != 'undefined' ) menuInfo.categoryData = categoryData;\n");
        sb.append("\t if ( typeof valueData != 'undefined' ) menuInfo.valueData = valueData;\n");
        sb.append("\t if ( typeof valueSeriesName != 'undefined' ) menuInfo.valueSeriesName = valueSeriesName;\n");
        sb.append("\t if ( typeof legendItemText != 'undefined' ) menuInfo.legendItemText = legendItemText;\n");
        sb.append("\t if ( typeof legendItemValue != 'undefined' ) menuInfo.legendItemValue = legendItemValue;\n");
        sb.append("\t if ( typeof axisLabel != 'undefined' ) menuInfo.axisLabel = axisLabel;\n");
        sb.append("\t if ( typeof id != 'undefined' ) menuInfo.id2 = id;\n");
        sb.append("\t if ( typeof compList != 'undefined' ) menuInfo.compList = compList;\n");
        sb.append("\t if ( typeof labelList != 'undefined' ) menuInfo.labelList = labelList;\n");
        sb.append("\t menuInfo.id = " + sb.toString().hashCode() + ";\n");
        return sb;
    }

    private static StringBuilder getJSContext(MultipleActions actions) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n\t var menuInfo = new BirtChartMenuInfo();\n");
        EMap propMap = actions.getPropertiesMap();
        sb.append(MultiActionValuesScriptGenerator.getPropertiesJS((EMap<String, String>)propMap).toString());
        int i = 0;
        for (Action subAction : MultiActionValuesScriptGenerator.getValidActions(actions)) {
            ActionValue av = subAction.getValue();
            if (av instanceof URLValue) {
                sb = MultiActionValuesScriptGenerator.getURLValueJS(sb, i, (URLValue)av);
            } else if (av instanceof ScriptValue) {
                sb = MultiActionValuesScriptGenerator.getScriptValueJS(sb, i, (ScriptValue)av);
            }
            ++i;
        }
        MultiActionValuesScriptGenerator.appendInteractivityVariables(sb);
        return sb;
    }

    public static StringBuilder getScriptValueJS(StringBuilder sb, int index, ScriptValue sv) {
        if (index == 0) {
            sb.append("\t var mii = new BirtChartMenuItemInfo();\n");
        } else {
            sb.append("\t mii = new BirtChartMenuItemInfo();\n");
        }
        sb.append(SCRIPT_MENU_HELPER.getScriptValueJS(index, sv));
        return sb;
    }

    public static StringBuilder getVisualJS(StringBuilder sb, int index, ActionValue av, String scriptActionType) {
        if (index == 0) {
            sb.append("\t var mii = new BirtChartMenuItemInfo();");
        } else {
            sb.append("\t mii = new BirtChartMenuItemInfo();");
        }
        sb.append("\t mii.text = '" + av.getLabel().getCaption().getValue() + "';\n");
        sb.append("\t mii.actionType = " + scriptActionType + ";\n");
        sb.append("\t menuInfo.addItemInfo(mii);\n");
        return sb;
    }

    public static StringBuilder getURLValueJS(StringBuilder sb, int index, URLValue uv) {
        if (index == 0) {
            sb.append("\t var mii = new BirtChartMenuItemInfo();\n");
        } else {
            sb.append("\t mii = new BirtChartMenuItemInfo();\n");
        }
        sb.append("\t mii.text = '" + uv.getLabel().getCaption().getValue() + "';\n");
        String url = uv.getBaseUrl();
        if (!url.startsWith("\"") && !url.endsWith("\"")) {
            url = "\"" + url + "\"";
        }
        sb.append("\t mii.actionType = BirtChartInteractivityActions.HYPER_LINK;\n");
        sb.append("\t mii.actionValue = " + url + ";\n");
        String target = uv.getTarget() == null ? "" : uv.getTarget();
        sb.append("\t mii.target = '" + target + "';\n");
        if (uv.getTooltip() != null && uv.getTooltip().trim().length() > 0) {
            if (uv.getTooltip().startsWith("\"") || uv.getTooltip().startsWith("'")) {
                sb.append("\t mii.tooltip = " + uv.getTooltip() + ";\n");
            } else {
                sb.append("\t mii.tooltip = \"" + uv.getTooltip() + "\";\n");
            }
        }
        sb.append("\t menuInfo.addItemInfo(mii);\n");
        return sb;
    }

    private static StringBuilder getPropertiesJS(EMap<String, String> propMap) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : propMap.entrySet()) {
            String key = (String)entry.getKey();
            String properties = (String)entry.getValue();
            if (MenuStylesKeyType.MENU.getName().equals(key)) {
                if (!properties.matches(".*position[ ]*:.*")) {
                    properties = String.valueOf(properties) + ";position:absolute";
                }
                sb.append("\t menuInfo.menuStyles = '" + CSSHelper.getStylingNonHyphenFormat(properties) + "';\n");
                continue;
            }
            if (MenuStylesKeyType.MENU_ITEM.getName().equals(key)) {
                if (!properties.matches(".*cursor[ ]*:.*")) {
                    properties = String.valueOf(properties) + ";cursor:default";
                }
                sb.append("\t menuInfo.menuItemStyles = '" + CSSHelper.getStylingNonHyphenFormat(properties) + "';\n");
                continue;
            }
            if (MenuStylesKeyType.ON_MOUSE_OVER.getName().equals(key)) {
                sb.append("\t menuInfo.mouseOverStyles = '" + CSSHelper.getStylingNonHyphenFormat(properties) + "';\n");
                continue;
            }
            if (!MenuStylesKeyType.ON_MOUSE_OUT.getName().equals(key)) continue;
            sb.append("\tmenuInfo.mouseOutStyles = '" + CSSHelper.getStylingNonHyphenFormat(properties) + "';\n");
        }
        return sb;
    }

    public static List<URLValue> getValidURLValues(MultiURLValues multiUrlValue) {
        ArrayList<URLValue> validURLValues = new ArrayList<URLValue>();
        if (multiUrlValue == null) {
            return validURLValues;
        }
        for (URLValue uv : multiUrlValue.getURLValues()) {
            if (uv.getBaseUrl() == null || uv.getBaseUrl().length() <= 0 || uv.getBaseUrl().equals("\"\"")) continue;
            validURLValues.add(uv);
        }
        return validURLValues;
    }

    public static List<Action> getValidActions(MultipleActions multiActions) {
        ArrayList<Action> validActions = new ArrayList<Action>();
        if (multiActions == null) {
            return validActions;
        }
        for (Action subAction : multiActions.getActions()) {
            ScriptValue sv;
            URLValue uv;
            ActionValue av = subAction.getValue();
            if (av instanceof URLValue ? (uv = (URLValue)av).getBaseUrl() == null || uv.getBaseUrl().length() <= 0 || uv.getBaseUrl().equals("\"\"") : av instanceof ScriptValue && ((sv = (ScriptValue)av).getScript() == null || sv.getScript().length() == 0 || sv.getScript().equals("\"\""))) continue;
            validActions.add(subAction);
        }
        return validActions;
    }

    public static String getBirtChartMenuLib() {
        if (MENU_JS_CODE == null) {
            StringBuilder sb = new StringBuilder();
            try {
                InputStream is = MultiActionValuesScriptGenerator.class.getResourceAsStream("/org/eclipse/birt/chart/device/util/ImageActionMenu.js");
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                String s = null;
                while ((s = br.readLine()) != null) {
                    sb.append(s);
                    sb.append("\n");
                }
                br.close();
            }
            catch (FileNotFoundException e) {
                logger.log((Exception)e);
            }
            catch (IOException e) {
                logger.log((Exception)e);
            }
            MENU_JS_CODE = sb.toString();
        }
        return MENU_JS_CODE;
    }
}

