/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.data.DataElement;
import org.eclipse.birt.chart.model.data.DateTimeDataElement;
import org.eclipse.birt.chart.model.data.NumberDataElement;
import org.eclipse.birt.chart.model.data.Query;
import org.eclipse.birt.chart.model.data.TextDataElement;
import org.eclipse.birt.chart.ui.swt.ColorPalette;
import org.eclipse.birt.chart.ui.swt.IQueryExpressionManager;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Control;

public class DataDefinitionTextManager {
    private static DataDefinitionTextManager instance;
    private HashMap<Control, IQueryExpressionManager> textCollection = new HashMap(10);

    private DataDefinitionTextManager() {
    }

    public static synchronized DataDefinitionTextManager getInstance() {
        if (instance == null) {
            instance = new DataDefinitionTextManager();
        }
        return instance;
    }

    public void addDataDefinitionText(Control text, IQueryExpressionManager queryManager) {
        this.textCollection.put(text, queryManager);
        text.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (e.widget instanceof Control) {
                    DataDefinitionTextManager.this.removeDataDefinitionText((Control)e.widget);
                }
            }
        });
    }

    public void removeDataDefinitionText(Control text) {
        this.textCollection.remove(text);
    }

    public void removeAll() {
        this.textCollection.clear();
    }

    public void refreshAll() {
        this.checkAll();
        for (Control text : this.textCollection.keySet()) {
            this.updateText(text);
        }
    }

    private void checkAll() {
        ArrayList<Control> listToRemove = new ArrayList<Control>(this.textCollection.size());
        for (Control text : this.textCollection.keySet()) {
            if (!text.isDisposed()) continue;
            listToRemove.add(text);
        }
        int i = 0;
        while (i < listToRemove.size()) {
            this.textCollection.remove(listToRemove.get(i));
            ++i;
        }
    }

    public int getNumberOfSameDataDefinition(String expression) {
        this.checkAll();
        int number = 0;
        for (Control text : this.textCollection.keySet()) {
            if (!ChartUIUtil.getText(text).equals(expression)) continue;
            ++number;
        }
        return number;
    }

    public Control findText(Query query) {
        for (Map.Entry<Control, IQueryExpressionManager> entry : this.textCollection.entrySet()) {
            if (entry.getValue().getQuery() != query) continue;
            return entry.getKey();
        }
        return null;
    }

    public void updateText(Control text) {
        if (this.textCollection.containsKey(text)) {
            IQueryExpressionManager query = this.textCollection.get(text);
            if (query.getQuery() != null) {
                query.updateText(query.getQuery().getDefinition());
            }
            Color color = ColorPalette.getInstance().getColor(ChartUIUtil.getText(text));
            text.setBackground(color);
        }
    }

    public void updateText(Query query) {
        if (query == null) {
            return;
        }
        Control text = this.findText(query);
        if (text != null) {
            IQueryExpressionManager queryManager = this.textCollection.get(text);
            queryManager.updateText(query.getDefinition());
            String displayExpr = queryManager.getDisplayExpression();
            this.updateControlBackground(text, displayExpr);
        }
    }

    public void updateQuery(Query query, String expression) {
        Control control = this.findText(query);
        if (control != null) {
            IQueryExpressionManager queryManager = this.textCollection.get(control);
            queryManager.updateQuery(expression);
        }
    }

    public void updateQuery(Control control) {
        if (this.textCollection.containsKey(control)) {
            IQueryExpressionManager queryManager = this.textCollection.get(control);
            queryManager.updateQuery(ChartUIUtil.getText(control));
            this.adjustScaleData(queryManager.getQuery());
            if (control.isDisposed()) {
                control = this.findText(queryManager.getQuery());
            }
            if (control != null) {
                this.updateControlBackground(control, ChartUIUtil.getText(control));
            }
        }
    }

    private void updateControlBackground(Control control, String expression) {
        ColorPalette.getInstance().putColor(expression);
        control.setBackground(ColorPalette.getInstance().getColor(expression));
    }

    private void adjustScaleData(Query query) {
        Query object = query;
        while (!(object instanceof Axis)) {
            if (object != null) {
                object = object.eContainer();
                continue;
            }
            return;
        }
        Axis axis = (Axis)object;
        AxisType axisType = axis.getType();
        DataElement minElement = axis.getScale().getMin();
        DataElement maxElement = axis.getScale().getMax();
        if (axisType == AxisType.DATE_TIME_LITERAL) {
            if (!(minElement instanceof DateTimeDataElement)) {
                axis.getScale().setMin(null);
            }
            if (!(maxElement instanceof DateTimeDataElement)) {
                axis.getScale().setMax(null);
            }
        } else if (axisType == AxisType.TEXT_LITERAL) {
            if (!(minElement instanceof TextDataElement)) {
                axis.getScale().setMin(null);
            }
            if (!(maxElement instanceof TextDataElement)) {
                axis.getScale().setMax(null);
            }
        } else if (axisType == AxisType.LINEAR_LITERAL || axisType == AxisType.LOGARITHMIC_LITERAL) {
            if (!(minElement instanceof NumberDataElement)) {
                axis.getScale().setMin(null);
            }
            if (!(maxElement instanceof NumberDataElement)) {
                axis.getScale().setMax(null);
            }
        }
    }

    public boolean isValidExpression(Control control, String expression) {
        if (this.textCollection.containsKey(control)) {
            IQueryExpressionManager queryManager = this.textCollection.get(control);
            return queryManager.isValidExpression(expression);
        }
        return false;
    }

    public boolean isAcceptableExpression(Query query, String expr, boolean isShareBinding) {
        if (!isShareBinding) {
            return true;
        }
        Control control = this.findText(query);
        if (control != null) {
            return this.isValidExpression(control, expr);
        }
        return false;
    }

    public void updateTooltip() {
        for (IQueryExpressionManager queryExprM : this.textCollection.values()) {
            queryExprM.setTooltipForInputControl();
        }
    }
}

