/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.extension.aggregate;

import com.ibm.icu.util.ULocale;
import java.math.BigDecimal;
import org.eclipse.birt.chart.aggregate.AggregateFunctionAdapter;
import org.eclipse.birt.chart.engine.i18n.Messages;

public class Average
extends AggregateFunctionAdapter {
    private Object oSum = null;
    private int iIterationCount = 0;

    public void initialize() {
        super.initialize();
        this.oSum = null;
        this.iIterationCount = 0;
    }

    public void accumulate(Object oValue) throws IllegalArgumentException {
        super.accumulate(oValue);
        if (oValue != null) {
            ++this.iIterationCount;
        }
        if (this.getDataType() != 0 && this.getDataType() != 4 && this.getDataType() != 5) {
            throw new IllegalArgumentException(Messages.getString((String)"exception.unsupported.aggregate.function.input", (Object)((Object)((Object)this)).getClass().getName(), (ULocale)this.getLocale()));
        }
        switch (this.getDataType()) {
            case 4: {
                if (this.oSum == null) {
                    this.oSum = new double[1];
                    ((double[])this.oSum)[0] = 0.0;
                }
                double[] dArray = (double[])this.oSum;
                dArray[0] = dArray[0] + ((Number)oValue).doubleValue();
                break;
            }
            case 5: {
                if (this.oSum == null) {
                    this.oSum = new BigDecimal(0);
                }
                this.oSum = ((BigDecimal)this.oSum).add((BigDecimal)this.oSum);
            }
        }
    }

    public Object getAggregatedValue() {
        switch (this.getDataType()) {
            case 4: {
                return new Double(((double[])this.oSum)[0] / (double)this.iIterationCount);
            }
            case 5: {
                return ((BigDecimal)this.oSum).divide(new BigDecimal(this.iIterationCount), 7);
            }
        }
        return null;
    }
}

