/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.extension.render;

import org.eclipse.birt.chart.computation.DataPointHints;
import org.eclipse.birt.chart.computation.Methods;
import org.eclipse.birt.chart.computation.PlotComputation;
import org.eclipse.birt.chart.computation.withaxes.AutoScale;
import org.eclipse.birt.chart.computation.withaxes.OneAxis;
import org.eclipse.birt.chart.computation.withaxes.PlotWith2DAxes;
import org.eclipse.birt.chart.computation.withaxes.SeriesRenderingHints;
import org.eclipse.birt.chart.device.IPrimitiveRenderer;
import org.eclipse.birt.chart.engine.extension.i18n.Messages;
import org.eclipse.birt.chart.event.EventObjectCache;
import org.eclipse.birt.chart.event.LineRenderEvent;
import org.eclipse.birt.chart.event.StructureSource;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.extension.datafeed.BubbleEntry;
import org.eclipse.birt.chart.extension.render.Scatter;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.Location;
import org.eclipse.birt.chart.model.attribute.Marker;
import org.eclipse.birt.chart.model.attribute.Orientation;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.model.type.BubbleSeries;
import org.eclipse.birt.chart.render.BaseRenderer;
import org.eclipse.birt.chart.render.CurveRenderer;
import org.eclipse.birt.chart.render.ISeriesRenderingHints;
import org.eclipse.birt.chart.script.AbstractScriptHandler;
import org.eclipse.birt.chart.script.ScriptHandler;
import org.eclipse.birt.chart.util.CDateTime;
import org.eclipse.birt.chart.util.FillUtil;
import org.eclipse.emf.common.util.EList;

public class Bubble
extends Scatter {
    public void renderSeries(IPrimitiveRenderer ipr, Plot p, ISeriesRenderingHints isrh) throws ChartException {
        double dAxisMin;
        AutoScale sc;
        OneAxis oaxaBase;
        int iThisSeriesIndex;
        ChartWithAxes cwa = (ChartWithAxes)this.getModel();
        if (cwa.getDimension() != ChartDimension.TWO_DIMENSIONAL_LITERAL && cwa.getDimension() != ChartDimension.TWO_DIMENSIONAL_WITH_DEPTH_LITERAL) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.bubble.dimension", new Object[]{cwa.getDimension().getName()}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        logger.log(1, Messages.getString("info.render.series", new Object[]{((Object)((Object)this)).getClass().getName(), this.iSeriesIndex + 1, this.iSeriesCount}, this.getRunTimeContext().getULocale()));
        BubbleSeries bs = (BubbleSeries)this.getSeries();
        if (!bs.isVisible()) {
            return;
        }
        AbstractScriptHandler sh = this.getRunTimeContext().getScriptHandler();
        SeriesRenderingHints srh = (SeriesRenderingHints)isrh;
        DataPointHints[] dpha = srh.getDataPoints();
        LineAttributes lia = bs.getLineAttributes();
        LineAttributes accLia = bs.getAccLineAttributes();
        Orientation accOrientation = bs.getAccOrientation();
        double[] faX = new double[dpha.length];
        double[] faY = new double[dpha.length];
        Integer[] iSize = new Integer[dpha.length];
        double[] dSizePixel = new double[dpha.length];
        SeriesDefinition sd = this.getSeriesDefinition();
        EList elPalette = sd.getSeriesPalette().getEntries();
        if (elPalette.isEmpty()) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.empty.palette", new Object[]{bs}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        boolean bPaletteByCategory = this.isPaletteByCategory();
        if (bPaletteByCategory && bs.eContainer() instanceof SeriesDefinition) {
            sd = (SeriesDefinition)bs.eContainer();
        }
        if ((iThisSeriesIndex = sd.getRunTimeSeries().indexOf(bs)) < 0) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.missing.series.for.palette.index", new Object[]{bs, sd}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        Fill fPaletteEntry = null;
        if (!bPaletteByCategory) {
            fPaletteEntry = FillUtil.getPaletteFill((EList)elPalette, (int)iThisSeriesIndex);
            this.updateTranslucency(fPaletteEntry, (Series)bs);
        }
        Marker m = null;
        if (bs.getMarkers().size() > 0) {
            m = (Marker)bs.getMarkers().get(iThisSeriesIndex % bs.getMarkers().size());
        }
        boolean isCategoryAxis = srh.isCategoryScale();
        Bounds plotBounds = this.getPlotBoundsWithMargin();
        double dPointCoefficient = this.computeBestFit(srh, plotBounds, isCategoryAxis);
        if (dPointCoefficient == 0.0) {
            this.restoreClipping(ipr);
            return;
        }
        int i = 0;
        while (i < dpha.length) {
            BubbleEntry be = (BubbleEntry)dpha[i].getOrthogonalValue();
            if (!this.isValidBubbleEntry(be)) {
                faX[i] = Double.NaN;
                faY[i] = Double.NaN;
            } else {
                double unitSize = dpha[i].getSize();
                Location lo = dpha[i].getLocation();
                if (cwa.isTransposed()) {
                    faX[i] = srh.getLocationOnOrthogonal(be.getValue());
                    faY[i] = lo.getY() + (isCategoryAxis ? unitSize / 2.0 : 0.0);
                } else {
                    faX[i] = lo.getX() + (isCategoryAxis ? unitSize / 2.0 : 0.0);
                    faY[i] = srh.getLocationOnOrthogonal(be.getValue());
                }
                dSizePixel[i] = be.getSize() * dPointCoefficient;
                iSize[i] = (int)(dSizePixel[i] / this.getDeviceScale());
            }
            ++i;
        }
        this.handleOutsideDataPoints(ipr, srh, faX, faY, false);
        PlotWith2DAxes pwa = (PlotWith2DAxes)this.getComputations();
        if (accOrientation == Orientation.HORIZONTAL_LITERAL) {
            oaxaBase = pwa.getAxes().getPrimaryBase();
            sc = oaxaBase.getScale();
            dAxisMin = sc.getTickCordinates().getStart();
        } else {
            oaxaBase = pwa.getAxes().getPrimaryOrthogonal();
            sc = oaxaBase.getScale();
            dAxisMin = sc.getTickCordinates().getStart();
        }
        if (accLia.isVisible()) {
            Location[] loa = new Location[2];
            int i2 = 0;
            while (i2 < dpha.length) {
                if (this.isValidBubbleEntry((BubbleEntry)dpha[i2].getOrthogonalValue())) {
                    loa[0] = accOrientation == Orientation.HORIZONTAL_LITERAL ? (cwa.isTransposed() ? goFactory.createLocation(faX[i2], dAxisMin) : goFactory.createLocation(dAxisMin, faY[i2])) : (cwa.isTransposed() ? goFactory.createLocation(dAxisMin, faY[i2]) : goFactory.createLocation(faX[i2], dAxisMin));
                    loa[1] = goFactory.createLocation(faX[i2], faY[i2]);
                    LineRenderEvent lre = (LineRenderEvent)((EventObjectCache)ipr).getEventObject((Object)StructureSource.createSeries((Series)bs), LineRenderEvent.class);
                    lre.setLineAttributes(accLia);
                    lre.setStart(loa[0]);
                    lre.setEnd(loa[1]);
                    ipr.drawLine(lre);
                }
                ++i2;
            }
        }
        if (bs.isCurve()) {
            CurveRenderer cr = new CurveRenderer(cwa, (BaseRenderer)this, lia, goFactory.createLocations(faX, faY), false, -1.0, true, true, fPaletteEntry, bs.isPaletteLineColor(), true);
            cr.draw(ipr);
            this.renderShadowAsCurve(ipr, lia, (ISeriesRenderingHints)srh, goFactory.createLocations(faX, faY), false, -1.0);
            if (m != null) {
                int i3 = 0;
                while (i3 < dpha.length) {
                    if (!dpha[i3].isOutside()) {
                        fPaletteEntry = bPaletteByCategory ? FillUtil.getPaletteFill((EList)elPalette, (int)i3) : FillUtil.getPaletteFill((EList)elPalette, (int)iThisSeriesIndex);
                        this.updateTranslucency(fPaletteEntry, (Series)bs);
                        ScriptHandler.callFunction((AbstractScriptHandler)sh, (String)"beforeDrawDataPoint", (Object)dpha[i3], (Object)fPaletteEntry, (Object)this.getRunTimeContext().getScriptContext());
                        this.getRunTimeContext().notifyStructureChange("beforeDrawDataPoint", (Object)dpha[i3]);
                        this.renderMarker(bs, ipr, m, goFactory.createLocation(faX[i3], faY[i3]), bs.getLineAttributes(), fPaletteEntry, dpha[i3], iSize[i3], true, true);
                        ScriptHandler.callFunction((AbstractScriptHandler)sh, (String)"afterDrawDataPoint", (Object)dpha[i3], (Object)fPaletteEntry, (Object)this.getRunTimeContext().getScriptContext());
                        this.getRunTimeContext().notifyStructureChange("afterDrawDataPoint", (Object)dpha[i3]);
                    }
                    ++i3;
                }
            }
        } else {
            Location positionDelta = cwa.isTransposed() ? goFactory.createLocation(-3.0 * this.getDeviceScale(), 0.0) : goFactory.createLocation(0.0, 3.0 * this.getDeviceScale());
            Location[] loaShadow = null;
            LineRenderEvent lre = (LineRenderEvent)((EventObjectCache)ipr).getEventObject((Object)StructureSource.createSeries((Series)bs), LineRenderEvent.class);
            ColorDefinition cLineShadow = bs.getShadowColor();
            if (cLineShadow != null && cLineShadow.getTransparency() != goFactory.TRANSPARENT().getTransparency()) {
                int i4 = 1;
                while (i4 < dpha.length) {
                    int pindex;
                    if (this.isValidBubbleEntry((BubbleEntry)dpha[i4].getOrthogonalValue()) && (pindex = this.getPreviousNonNullIndex(i4, dpha)) != -1) {
                        if (loaShadow == null) {
                            loaShadow = new Location[]{goFactory.createLocation(faX[pindex] + positionDelta.getX(), faY[pindex] + positionDelta.getY()), goFactory.createLocation(faX[i4] + positionDelta.getX(), faY[i4] + positionDelta.getY())};
                        } else {
                            loaShadow[0].set(faX[pindex] + positionDelta.getX(), faY[pindex] + positionDelta.getY());
                            loaShadow[1].set(faX[i4] + positionDelta.getX(), faY[i4] + positionDelta.getY());
                        }
                        lre.setStart(loaShadow[0]);
                        lre.setEnd(loaShadow[1]);
                        LineAttributes liaShadow = goFactory.copyOf(lia);
                        liaShadow.setColor(cLineShadow);
                        lre.setLineAttributes(liaShadow);
                        ipr.drawLine(lre);
                    }
                    ++i4;
                }
            }
            if (lia.isVisible()) {
                Location[] loa = new Location[2];
                int i5 = 1;
                while (i5 < dpha.length) {
                    int pindex;
                    if (this.isValidBubbleEntry((BubbleEntry)dpha[i5].getOrthogonalValue()) && (pindex = this.getPreviousNonNullIndex(i5, dpha)) != -1) {
                        loa[0] = goFactory.createLocation(faX[pindex], faY[pindex]);
                        loa[1] = goFactory.createLocation(faX[i5], faY[i5]);
                        lre = (LineRenderEvent)((EventObjectCache)ipr).getEventObject((Object)StructureSource.createSeries((Series)bs), LineRenderEvent.class);
                        if (bs.isPaletteLineColor()) {
                            LineAttributes newLia = goFactory.copyOf(lia);
                            newLia.setColor(FillUtil.getColor((Fill)fPaletteEntry));
                            lre.setLineAttributes(newLia);
                        } else {
                            lre.setLineAttributes(lia);
                        }
                        lre.setStart(loa[0]);
                        lre.setEnd(loa[1]);
                        ipr.drawLine(lre);
                    }
                    ++i5;
                }
            }
            if (m != null) {
                int i6 = 0;
                while (i6 < dpha.length) {
                    if (this.isValidBubbleEntry((BubbleEntry)dpha[i6].getOrthogonalValue()) && !dpha[i6].isOutside()) {
                        fPaletteEntry = bPaletteByCategory ? FillUtil.getPaletteFill((EList)elPalette, (int)i6) : FillUtil.getPaletteFill((EList)elPalette, (int)iThisSeriesIndex);
                        this.updateTranslucency(fPaletteEntry, (Series)bs);
                        ScriptHandler.callFunction((AbstractScriptHandler)sh, (String)"beforeDrawDataPoint", (Object)dpha[i6], (Object)fPaletteEntry, (Object)this.getRunTimeContext().getScriptContext());
                        this.getRunTimeContext().notifyStructureChange("beforeDrawDataPoint", (Object)dpha[i6]);
                        this.renderMarker(bs, ipr, m, goFactory.createLocation(faX[i6], faY[i6]), bs.getLineAttributes(), fPaletteEntry, dpha[i6], iSize[i6], true, true);
                        ScriptHandler.callFunction((AbstractScriptHandler)sh, (String)"afterDrawDataPoint", (Object)dpha[i6], (Object)fPaletteEntry, (Object)this.getRunTimeContext().getScriptContext());
                        this.getRunTimeContext().notifyStructureChange("afterDrawDataPoint", (Object)dpha[i6]);
                    }
                    ++i6;
                }
            }
        }
        Label laDataPoint = null;
        Position pDataPoint = null;
        Location loDataPoint = null;
        try {
            laDataPoint = srh.getLabelAttributes((Series)bs);
            pDataPoint = srh.getLabelPosition((Series)bs);
            loDataPoint = goFactory.createLocation(0.0, 0.0);
        }
        catch (Exception ex) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, (Throwable)ex);
        }
        if (laDataPoint.isVisible()) {
            int i7 = 0;
            while (i7 < dpha.length) {
                if (this.isValidBubbleEntry((BubbleEntry)dpha[i7].getOrthogonalValue()) && !dpha[i7].isOutside()) {
                    laDataPoint.getCaption().setValue(dpha[i7].getDisplayValue());
                    double dSize = dSizePixel[i7];
                    switch (pDataPoint.getValue()) {
                        case 0: {
                            loDataPoint.set(faX[i7], faY[i7] - dSize - (double)p.getVerticalSpacing());
                            break;
                        }
                        case 1: {
                            loDataPoint.set(faX[i7], faY[i7] + dSize + (double)p.getVerticalSpacing());
                            break;
                        }
                        case 2: {
                            loDataPoint.set(faX[i7] - dSize - (double)p.getHorizontalSpacing(), faY[i7]);
                            break;
                        }
                        case 3: {
                            loDataPoint.set(faX[i7] + dSize + (double)p.getHorizontalSpacing(), faY[i7]);
                            break;
                        }
                        case 4: {
                            loDataPoint.set(faX[i7], faY[i7]);
                            break;
                        }
                        default: {
                            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.invalid.data.point.position.bubble", new Object[]{pDataPoint}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
                        }
                    }
                    ScriptHandler.callFunction((AbstractScriptHandler)sh, (String)"beforeDrawDataPointLabel", (Object)dpha[i7], (Object)laDataPoint, (Object)this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("beforeDrawDataPointLabel", (Object)dpha[i7]);
                    if (laDataPoint.isVisible()) {
                        this.renderLabel(StructureSource.createSeries((Series)bs), 2, laDataPoint, pDataPoint, loDataPoint, null);
                    }
                    ScriptHandler.callFunction((AbstractScriptHandler)sh, (String)"afterDrawDataPointLabel", (Object)dpha[i7], (Object)laDataPoint, (Object)this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("afterDrawDataPointLabel", (Object)dpha[i7]);
                }
                ++i7;
            }
        }
        if (this.getSeries().getCurveFitting() != null) {
            Location[] larray = new Location[faX.length];
            int i8 = 0;
            while (i8 < larray.length) {
                larray[i8] = goFactory.createLocation(faX[i8], faY[i8]);
                ++i8;
            }
            larray = this.filterNull(larray);
            this.renderFittingCurve(ipr, larray, this.getSeries().getCurveFitting(), false, true);
        }
        this.restoreClipping(ipr);
    }

    private boolean isValidBubbleEntry(BubbleEntry entry) {
        return entry != null && entry.isValid();
    }

    private double computeBestFit(SeriesRenderingHints srh, Bounds plotBounds, boolean isCategoryAxis) {
        double dCoeff = 1.0;
        double dLastCoeff = -1.0;
        boolean isFirstFit = false;
        int i = 0;
        while (i < 50) {
            try {
                if (this.checkAllInbound(srh, plotBounds, dCoeff, isCategoryAxis)) {
                    dLastCoeff = dCoeff;
                    dCoeff *= 2.0;
                    if (i == 0) {
                        isFirstFit = true;
                    }
                    if (!isFirstFit) {
                        return dLastCoeff;
                    }
                } else {
                    if (dLastCoeff > 0.0) {
                        return dLastCoeff;
                    }
                    dCoeff /= 2.0;
                }
            }
            catch (RuntimeException runtimeException) {
            }
            catch (ChartException ex) {
                logger.log((Exception)((Object)ex));
            }
            ++i;
        }
        return 0.0;
    }

    private boolean checkAllInbound(SeriesRenderingHints srh, Bounds plotBounds, double dCoeff, boolean isCategoryAxis) throws ChartException {
        boolean hasEntryChecked = false;
        AutoScale scaleOrth = this.getInternalOrthogonalAxis().getScale();
        AutoScale scaleBase = this.getInternalBaseAxis().getScale();
        int i = 1;
        while (i < this.iSeriesCount) {
            BaseRenderer renderer = this.getRenderer(i);
            if (renderer instanceof Bubble && ((Bubble)renderer).getAxis() == this.getAxis()) {
                DataPointHints[] dpha = renderer.getSeriesRenderingHints().getDataPoints();
                int j = 0;
                while (j < dpha.length) {
                    BubbleEntry be = (BubbleEntry)dpha[j].getOrthogonalValue();
                    if (this.isValidBubbleEntry(be) && this.checkEntryByType(scaleOrth, dpha[j].getOrthogonalValue()) == 0 && this.checkEntryByType(scaleBase, dpha[j].getBaseValue()) == 0) {
                        double faY;
                        double faX;
                        Location lo = dpha[j].getLocation();
                        double unitSize = dpha[j].getSize();
                        if (this.isTransposed()) {
                            faX = srh.getLocationOnOrthogonal(be.getValue());
                            faY = lo.getY() + (isCategoryAxis ? unitSize / 2.0 : 0.0);
                        } else {
                            faX = lo.getX() + (isCategoryAxis ? unitSize / 2.0 : 0.0);
                            faY = srh.getLocationOnOrthogonal(be.getValue());
                        }
                        hasEntryChecked = true;
                        if (!this.checkInbound(plotBounds, faX, faY, Math.abs(be.getSize()) * dCoeff)) {
                            return false;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (!hasEntryChecked) {
            throw new RuntimeException(Messages.getString("exception.invalid.data.point.outbound.bubble"));
        }
        return hasEntryChecked;
    }

    private boolean checkInbound(Bounds plotBounds, double faX, double faY, double size) {
        return faX - size > plotBounds.getLeft() && faX + size < plotBounds.getLeft() + plotBounds.getWidth() && faY - size > plotBounds.getTop() && faY + size < plotBounds.getTop() + plotBounds.getHeight();
    }

    protected int checkEntryInRange(Object entry, Object min, Object max) {
        if (entry instanceof BubbleEntry) {
            int iOutside = 0;
            Object oValue = ((BubbleEntry)entry).getValue();
            if (oValue instanceof Number) {
                double value = ((Number)oValue).doubleValue();
                double dMin = Methods.asDouble((Object)min);
                double dMax = Methods.asDouble((Object)max);
                if (value < dMin) {
                    iOutside = 1;
                } else if (value > dMax) {
                    iOutside = 2;
                }
            } else if (oValue instanceof CDateTime) {
                CDateTime value = (CDateTime)oValue;
                CDateTime cMin = Methods.asDateTime((Object)min);
                CDateTime cMax = Methods.asDateTime((Object)max);
                if (value.before((Object)cMin)) {
                    iOutside = 1;
                } else if (value.after((Object)cMax)) {
                    iOutside = 2;
                }
            } else {
                iOutside = 1;
            }
            return iOutside;
        }
        return 1;
    }

    protected int getPreviousNonNullIndex(int currentIndex, DataPointHints[] dpha) {
        int i = currentIndex - 1;
        while (i >= 0) {
            if (this.isValidBubbleEntry((BubbleEntry)dpha[i].getOrthogonalValue())) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public void set(Chart _cm, PlotComputation _o, Series _se, Axis _ax, SeriesDefinition _sd) {
        super.set(_cm, _o, _se, _ax, _sd);
        if (_o instanceof PlotWith2DAxes) {
            PlotWith2DAxes pwa = (PlotWith2DAxes)_o;
            pwa.addMargin(20);
        }
    }

    protected boolean isShowOutside() {
        return false;
    }

    protected void flushClipping() throws ChartException {
        this.getDeferredCache().flushOptions(4);
    }

    protected final Bounds getPlotBoundsWithMargin() {
        PlotComputation obj = this.getComputations();
        Bounds bo = null;
        if (obj instanceof PlotWith2DAxes) {
            PlotWith2DAxes pwa = (PlotWith2DAxes)obj;
            bo = goFactory.adjusteBounds(pwa.getPlotBoundsWithMargin(), pwa.getPlotInsets());
        }
        return bo;
    }
}

