/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.type;

import java.util.Collection;
import java.util.Vector;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.LeaderLineStyle;
import org.eclipse.birt.chart.model.attribute.LegendItemType;
import org.eclipse.birt.chart.model.attribute.Orientation;
import org.eclipse.birt.chart.model.attribute.Text;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.BaseSampleData;
import org.eclipse.birt.chart.model.data.DataFactory;
import org.eclipse.birt.chart.model.data.OrthogonalSampleData;
import org.eclipse.birt.chart.model.data.SampleData;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.impl.ChartWithoutAxesImpl;
import org.eclipse.birt.chart.model.type.PieSeries;
import org.eclipse.birt.chart.model.type.impl.PieSeriesImpl;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.ChartPreviewPainter;
import org.eclipse.birt.chart.ui.swt.DefaultChartSubTypeImpl;
import org.eclipse.birt.chart.ui.swt.DefaultChartTypeImpl;
import org.eclipse.birt.chart.ui.swt.HelpContentImpl;
import org.eclipse.birt.chart.ui.swt.interfaces.IChartSubType;
import org.eclipse.birt.chart.ui.swt.interfaces.IChartType;
import org.eclipse.birt.chart.ui.swt.interfaces.IHelpContent;
import org.eclipse.birt.chart.ui.swt.interfaces.ISelectDataComponent;
import org.eclipse.birt.chart.ui.swt.interfaces.ISelectDataCustomizeUI;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.swt.wizard.data.DefaultBaseSeriesComponent;
import org.eclipse.birt.chart.ui.util.ChartCacheManager;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.ui.util.UIHelper;
import org.eclipse.emf.common.util.EList;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PieChart
extends DefaultChartTypeImpl {
    public static final String TYPE_LITERAL = "Pie Chart";
    protected static final String STANDARD_SUBTYPE_LITERAL = "Standard";

    public PieChart() {
        this.chartTitle = Messages.getString("PieChart.Txt.DefaultPieChartTitle");
    }

    public String getName() {
        return TYPE_LITERAL;
    }

    public Image getImage() {
        return UIHelper.getImage((String)"icons/obj16/piecharticon.gif");
    }

    public IHelpContent getHelp() {
        return new HelpContentImpl(TYPE_LITERAL, Messages.getString("PieChart.Txt.HelpText"));
    }

    public Collection<IChartSubType> getChartSubtypes(String sDimension, Orientation orientation) {
        Vector<IChartSubType> vSubTypes = new Vector<IChartSubType>();
        if (!orientation.equals((Object)Orientation.VERTICAL_LITERAL)) {
            return vSubTypes;
        }
        vSubTypes.add((IChartSubType)new DefaultChartSubTypeImpl(STANDARD_SUBTYPE_LITERAL, this.getImageForSubtype(sDimension), this.getDescriptionForSubtype(sDimension), this.getDisplayNameForSubtype(sDimension)));
        return vSubTypes;
    }

    public Chart getModel(String sSubType, Orientation orientation, String sDimension, Chart currentChart) {
        ChartWithoutAxes newChart = null;
        if (currentChart != null && (newChart = (ChartWithoutAxes)this.getConvertedChart(currentChart, sSubType, sDimension)) != null) {
            return newChart;
        }
        newChart = ChartWithoutAxesImpl.create();
        newChart.setType(this.getName());
        newChart.setSubType(sSubType);
        newChart.setDimension(this.getDimensionFor(sDimension));
        newChart.setUnits("Points");
        if (newChart.getDimension().equals((Object)ChartDimension.TWO_DIMENSIONAL_WITH_DEPTH_LITERAL)) {
            newChart.setSeriesThickness(15.0);
        }
        SeriesDefinition sdX = SeriesDefinitionImpl.create();
        sdX.getSeriesPalette().shift(0);
        Series categorySeries = SeriesImpl.create();
        sdX.getSeries().add((Object)categorySeries);
        sdX.getQuery().setDefinition("Base Series");
        newChart.getTitle().getLabel().getCaption().setValue(this.getDefaultTitle());
        SeriesDefinition sdY = SeriesDefinitionImpl.create();
        sdY.getSeriesPalette().shift(0);
        Series valueSeries = this.getSeries();
        valueSeries.getLabel().setVisible(true);
        valueSeries.setSeriesIdentifier((Object)"valueSeriesIdentifier");
        ((PieSeries)valueSeries).getTitle().getCaption().setValue("valueSeries");
        sdY.getSeries().add((Object)valueSeries);
        sdX.getSeriesDefinitions().add((Object)sdY);
        newChart.getSeriesDefinitions().add((Object)sdX);
        this.addSampleData((Chart)newChart);
        return newChart;
    }

    private void addSampleData(Chart newChart) {
        SampleData sd = DataFactory.eINSTANCE.createSampleData();
        sd.getBaseSampleData().clear();
        sd.getOrthogonalSampleData().clear();
        BaseSampleData sdBase = DataFactory.eINSTANCE.createBaseSampleData();
        sdBase.setDataSetRepresentation("A, B, C");
        sd.getBaseSampleData().add((Object)sdBase);
        OrthogonalSampleData oSample = DataFactory.eINSTANCE.createOrthogonalSampleData();
        oSample.setDataSetRepresentation("5,4,12");
        oSample.setSeriesDefinitionIndex(0);
        sd.getOrthogonalSampleData().add((Object)oSample);
        newChart.setSampleData(sd);
    }

    private Chart getConvertedChart(Chart currentChart, String sNewSubType, String sNewDimension) {
        Chart helperModel = currentChart.copyInstance();
        ChartCacheManager.getInstance().cacheSeries(ChartUIUtil.getAllOrthogonalSeriesDefinitions((Chart)helperModel));
        IChartType oldType = ChartUIUtil.getChartType((String)currentChart.getType());
        if (currentChart instanceof ChartWithAxes) {
            if (!ChartPreviewPainter.isLivePreviewActive()) {
                helperModel.setSampleData(this.getConvertedSampleData(helperModel.getSampleData(), ((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getType()));
            }
            currentChart = ChartWithoutAxesImpl.create();
            currentChart.setType(this.getName());
            currentChart.setSubType(sNewSubType);
            currentChart.setDimension(this.getDimensionFor(sNewDimension));
            currentChart.setBlock(helperModel.getBlock());
            currentChart.setDescription(helperModel.getDescription());
            currentChart.setGridColumnCount(helperModel.getGridColumnCount());
            if (helperModel.getInteractivity() != null) {
                currentChart.getInteractivity().setEnable(helperModel.getInteractivity().isEnable());
                currentChart.getInteractivity().setLegendBehavior(helperModel.getInteractivity().getLegendBehavior());
            }
            currentChart.setSampleData(helperModel.getSampleData());
            currentChart.setScript(helperModel.getScript());
            if (helperModel.isSetSeriesThickness()) {
                currentChart.setSeriesThickness(helperModel.getSeriesThickness());
            } else {
                currentChart.setSeriesThickness(15.0);
            }
            currentChart.setUnits(helperModel.getUnits());
            if (helperModel.getGridColumnCount() > 0) {
                currentChart.setGridColumnCount(helperModel.getGridColumnCount());
            } else {
                currentChart.setGridColumnCount(0);
            }
            ((ChartWithoutAxes)currentChart).getSeriesDefinitions().add((Object)((SeriesDefinition)((Axis)((ChartWithAxes)helperModel).getAxes().get(0)).getSeriesDefinitions().get(0)));
            Vector<SeriesDefinition> vOSD = new Vector<SeriesDefinition>();
            Axis primaryOrthogonalAxis = ((ChartWithAxes)helperModel).getPrimaryOrthogonalAxis((Axis)((ChartWithAxes)helperModel).getAxes().get(0));
            EList osd = primaryOrthogonalAxis.getSeriesDefinitions();
            int j = 0;
            while (j < osd.size()) {
                SeriesDefinition sd = (SeriesDefinition)osd.get(j);
                Series series = sd.getDesignTimeSeries();
                sd.getSeries().clear();
                sd.getSeries().add((Object)this.getConvertedSeries(series, j));
                vOSD.add(sd);
                ++j;
            }
            ((SeriesDefinition)((ChartWithoutAxes)currentChart).getSeriesDefinitions().get(0)).getSeriesDefinitions().clear();
            ((SeriesDefinition)((ChartWithoutAxes)currentChart).getSeriesDefinitions().get(0)).getSeriesDefinitions().addAll(vOSD);
            currentChart.getLegend().setItemType(LegendItemType.CATEGORIES_LITERAL);
            Text title = currentChart.getTitle().getLabel().getCaption();
            if (title.getValue() == null || title.getValue().trim().length() == 0 || title.getValue().trim().equals(oldType.getDefaultTitle().trim())) {
                title.setValue(this.getDefaultTitle());
            }
        } else if (currentChart instanceof ChartWithoutAxes) {
            if (currentChart.getType().equals(this.getName())) {
                currentChart.setSubType(sNewSubType);
                if (!currentChart.getDimension().equals((Object)this.getDimensionFor(sNewDimension))) {
                    currentChart.setDimension(this.getDimensionFor(sNewDimension));
                }
                if (!currentChart.isSetSeriesThickness()) {
                    currentChart.setSeriesThickness(15.0);
                }
            } else {
                currentChart = ChartWithoutAxesImpl.create();
                currentChart.setType(this.getName());
                currentChart.setSubType(sNewSubType);
                currentChart.setDimension(this.getDimensionFor(sNewDimension));
                currentChart.setBlock(helperModel.getBlock());
                currentChart.setDescription(helperModel.getDescription());
                currentChart.setGridColumnCount(helperModel.getGridColumnCount());
                currentChart.setSampleData(helperModel.getSampleData());
                currentChart.setScript(helperModel.getScript());
                currentChart.setSeriesThickness(helperModel.getSeriesThickness());
                currentChart.setUnits(helperModel.getUnits());
                if (helperModel.getInteractivity() != null) {
                    currentChart.getInteractivity().setEnable(helperModel.getInteractivity().isEnable());
                    currentChart.getInteractivity().setLegendBehavior(helperModel.getInteractivity().getLegendBehavior());
                }
                ((ChartWithoutAxes)currentChart).getSeriesDefinitions().clear();
                ((ChartWithoutAxes)currentChart).getSeriesDefinitions().addAll((Collection)((ChartWithoutAxes)helperModel).getSeriesDefinitions());
                EList seriesdefinitions = ((SeriesDefinition)((ChartWithoutAxes)currentChart).getSeriesDefinitions().get(0)).getSeriesDefinitions();
                int j = 0;
                while (j < seriesdefinitions.size()) {
                    Series series = ((SeriesDefinition)seriesdefinitions.get(j)).getDesignTimeSeries();
                    series = this.getConvertedSeries(series, j);
                    ((SeriesDefinition)seriesdefinitions.get(j)).getSeries().clear();
                    ((SeriesDefinition)seriesdefinitions.get(j)).getSeries().add((Object)series);
                    ++j;
                }
                currentChart.getLegend().setItemType(LegendItemType.CATEGORIES_LITERAL);
                Text title = currentChart.getTitle().getLabel().getCaption();
                if (title.getValue() == null || title.getValue().trim().length() == 0 || title.getValue().trim().equals(oldType.getDefaultTitle().trim())) {
                    title.setValue(this.getDefaultTitle());
                }
            }
        } else {
            return null;
        }
        return currentChart;
    }

    private Series getConvertedSeries(Series series, int seriesIndex) {
        if (series.getClass().getName().equals(SeriesImpl.class.getName())) {
            return series;
        }
        PieSeries pieseries = (PieSeries)ChartCacheManager.getInstance().findSeries(PieSeriesImpl.class.getName(), seriesIndex);
        if (pieseries == null) {
            pieseries = (PieSeries)this.getSeries();
        }
        ChartUIUtil.copyGeneralSeriesAttributes((Series)series, (Series)pieseries);
        pieseries.getLabel().setVisible(true);
        return pieseries;
    }

    private SampleData getConvertedSampleData(SampleData currentSampleData, AxisType axisType) {
        EList bsdList = currentSampleData.getBaseSampleData();
        Vector<BaseSampleData> vNewBaseSampleData = new Vector<BaseSampleData>();
        int i = 0;
        while (i < bsdList.size()) {
            BaseSampleData bsd = (BaseSampleData)bsdList.get(i);
            bsd.setDataSetRepresentation(ChartUIUtil.getConvertedSampleDataRepresentation((AxisType)axisType, (String)bsd.getDataSetRepresentation(), (int)i));
            vNewBaseSampleData.add(bsd);
            ++i;
        }
        currentSampleData.getBaseSampleData().clear();
        currentSampleData.getBaseSampleData().addAll(vNewBaseSampleData);
        EList osdList = currentSampleData.getOrthogonalSampleData();
        Vector<OrthogonalSampleData> vNewOrthogonalSampleData = new Vector<OrthogonalSampleData>();
        int i2 = 0;
        while (i2 < osdList.size()) {
            OrthogonalSampleData osd = (OrthogonalSampleData)osdList.get(i2);
            osd.setDataSetRepresentation(ChartUIUtil.getConvertedSampleDataRepresentation((AxisType)AxisType.LINEAR_LITERAL, (String)osd.getDataSetRepresentation(), (int)i2));
            vNewOrthogonalSampleData.add(osd);
            ++i2;
        }
        currentSampleData.getOrthogonalSampleData().clear();
        currentSampleData.getOrthogonalSampleData().addAll(vNewOrthogonalSampleData);
        return currentSampleData;
    }

    public String[] getSupportedDimensions() {
        return new String[]{TWO_DIMENSION_TYPE, TWO_DIMENSION_WITH_DEPTH_TYPE};
    }

    public String getDefaultDimension() {
        return TWO_DIMENSION_TYPE;
    }

    public boolean supportsTransposition() {
        return false;
    }

    private ChartDimension getDimensionFor(String sDimension) {
        if (sDimension == null || sDimension.equals(TWO_DIMENSION_TYPE)) {
            return ChartDimension.TWO_DIMENSIONAL_LITERAL;
        }
        return ChartDimension.TWO_DIMENSIONAL_WITH_DEPTH_LITERAL;
    }

    public ISelectDataComponent getBaseUI(Chart chart, ISelectDataCustomizeUI selectDataUI, ChartWizardContext context, String sTitle) {
        DefaultBaseSeriesComponent component = new DefaultBaseSeriesComponent((SeriesDefinition)ChartUIUtil.getBaseSeriesDefinitions((Chart)chart).get(0), context, sTitle);
        component.setLabelText(Messages.getString("PieBaseSeriesComponent.Label.CategoryDefinition"));
        return component;
    }

    public String getDisplayName() {
        return Messages.getString("PieChart.Txt.DisplayName");
    }

    public Series getSeries() {
        PieSeries pieseries = (PieSeries)PieSeriesImpl.create();
        pieseries.setExplosion(0);
        pieseries.setLeaderLineLength(10.0);
        pieseries.setLeaderLineStyle(LeaderLineStyle.FIXED_LENGTH_LITERAL);
        return pieseries;
    }

    protected String getDescriptionForSubtype(String sDimension) {
        return Messages.getString("PieChart.Txt.Description");
    }

    protected Image getImageForSubtype(String sDimension) {
        if (sDimension.equals(TWO_DIMENSION_TYPE) || sDimension.equals(ChartDimension.TWO_DIMENSIONAL_LITERAL.getName())) {
            return UIHelper.getImage((String)"icons/wizban/piechartimage.gif");
        }
        if (sDimension.equals(TWO_DIMENSION_WITH_DEPTH_TYPE) || sDimension.equals(ChartDimension.TWO_DIMENSIONAL_WITH_DEPTH_LITERAL.getName())) {
            return UIHelper.getImage((String)"icons/wizban/piechartwithdepthimage.gif");
        }
        return null;
    }

    protected String getDisplayNameForSubtype(String sDimension) {
        return Messages.getString("PieChart.SubType.Standard");
    }
}

