/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard.data;

import java.util.Collection;
import java.util.List;
import org.eclipse.birt.chart.aggregate.IAggregateFunction;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.DataType;
import org.eclipse.birt.chart.model.data.DataPackage;
import org.eclipse.birt.chart.model.data.Query;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.SeriesGrouping;
import org.eclipse.birt.chart.model.data.impl.DataFactoryImpl;
import org.eclipse.birt.chart.model.data.impl.QueryImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesGroupingImpl;
import org.eclipse.birt.chart.model.impl.ChartModelHelper;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.ColorPalette;
import org.eclipse.birt.chart.ui.swt.ColumnBindingInfo;
import org.eclipse.birt.chart.ui.swt.DataDefinitionTextManager;
import org.eclipse.birt.chart.ui.swt.DataTextDropListener;
import org.eclipse.birt.chart.ui.swt.DefaultSelectDataComponent;
import org.eclipse.birt.chart.ui.swt.IQueryExpressionManager;
import org.eclipse.birt.chart.ui.swt.SimpleTextTransfer;
import org.eclipse.birt.chart.ui.swt.composites.BaseGroupSortingDialog;
import org.eclipse.birt.chart.ui.swt.composites.GroupSortingDialog;
import org.eclipse.birt.chart.ui.swt.fieldassist.CComboAssistField;
import org.eclipse.birt.chart.ui.swt.fieldassist.CTextContentAdapter;
import org.eclipse.birt.chart.ui.swt.fieldassist.FieldAssistHelper;
import org.eclipse.birt.chart.ui.swt.fieldassist.IContentChangeListener;
import org.eclipse.birt.chart.ui.swt.fieldassist.TextAssistField;
import org.eclipse.birt.chart.ui.swt.interfaces.IDataServiceProvider;
import org.eclipse.birt.chart.ui.swt.interfaces.IExpressionButton;
import org.eclipse.birt.chart.ui.swt.interfaces.IUIServiceProvider;
import org.eclipse.birt.chart.ui.swt.type.GanttChart;
import org.eclipse.birt.chart.ui.swt.wizard.ChartAdapter;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.swt.wizard.data.AggregateEditorComposite;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.ui.util.UIHelper;
import org.eclipse.birt.chart.util.ChartExpressionUtil;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.data.IColumnBinding;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.ui.frameworks.taskwizard.WizardBase;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class BaseDataDefinitionComponent
extends DefaultSelectDataComponent
implements SelectionListener,
ModifyListener,
FocusListener,
KeyListener,
IQueryExpressionManager {
    protected Composite cmpTop;
    private CCombo cmbDefinition;
    protected Text txtDefinition = null;
    private IExpressionButton btnBuilder = null;
    private Button btnGroup = null;
    protected Query query = null;
    protected SeriesDefinition seriesdefinition = null;
    protected ChartWizardContext context = null;
    private String sTitle = null;
    private String description = "";
    private String tooltipWhenBlank = Messages.getString("BaseDataDefinitionComponent.Tooltip.InputValueExpression");
    protected boolean isQueryModified;
    private final String queryType;
    private int style = 0;
    private AggregateEditorComposite fAggEditorComposite;
    public static final int BUTTON_NONE = 0;
    public static final int BUTTON_GROUP = 1;
    public static final int BUTTON_AGGREGATION = 2;
    protected final ChartExpressionUtil.ExpressionCodec exprCodec = ChartModelHelper.instance().createExpressionCodec();

    public BaseDataDefinitionComponent(String queryType, SeriesDefinition seriesdefinition, Query query, ChartWizardContext context, String sTitle) {
        this(0, queryType, seriesdefinition, query, context, sTitle);
    }

    public BaseDataDefinitionComponent(int style, String queryType, SeriesDefinition seriesdefinition, Query query, ChartWizardContext context, String sTitle) {
        this.query = query;
        this.queryType = queryType;
        this.seriesdefinition = seriesdefinition;
        this.context = context;
        this.sTitle = sTitle == null || sTitle.length() == 0 ? Messages.getString("BaseDataDefinitionComponent.Text.SpecifyDataDefinition") : sTitle;
        this.style = style;
    }

    public Composite createArea(Composite parent) {
        boolean isCubeNoMultiDimensions;
        GridLayout gl;
        GridData gd;
        Composite control;
        boolean hasContentAssist;
        int numColumns = 2;
        if (this.description != null && this.description.length() > 0) {
            ++numColumns;
        }
        if ((this.style & 2) == 2) {
            ++numColumns;
        }
        if ((this.style & 1) == 1) {
            ++numColumns;
        }
        this.cmpTop = new Composite(parent, 0);
        GridLayout glContent = new GridLayout();
        glContent.numColumns = numColumns;
        glContent.marginHeight = 0;
        glContent.marginWidth = 0;
        glContent.horizontalSpacing = 2;
        this.cmpTop.setLayout((Layout)glContent);
        GridData gd2 = new GridData(768);
        this.cmpTop.setLayoutData((Object)gd2);
        Label lblDesc = null;
        if (this.description != null && this.description.length() > 0) {
            lblDesc = new Label(this.cmpTop, 0);
            lblDesc.setText(this.description);
            lblDesc.setToolTipText(this.tooltipWhenBlank);
        }
        if ((this.style & 2) == 2) {
            this.createAggregationItem(this.cmpTop);
        }
        boolean isSharingChart = this.context.getDataServiceProvider().checkState(2048);
        final Object[] predefinedQuery = this.context.getPredefinedQuery(this.queryType);
        IDataServiceProvider provider = this.context.getDataServiceProvider();
        boolean needComboField = predefinedQuery != null && predefinedQuery.length > 0 && (provider.checkState(16) || provider.checkState(2) || provider.checkState(1024));
        boolean bl = hasContentAssist = !isSharingChart && predefinedQuery != null && predefinedQuery.length > 0;
        if (needComboField &= !isSharingChart) {
            String[] items;
            control = new Composite(this.cmpTop, 0);
            gd = new GridData(1808);
            gd.widthHint = 80;
            control.setLayoutData((Object)gd);
            gl = new GridLayout();
            FieldAssistHelper.getInstance().initDecorationMargin(gl);
            control.setLayout((Layout)gl);
            this.cmbDefinition = new CCombo(control, this.context.getDataServiceProvider().checkState(32) ? 2056 : 2048);
            gd = new GridData(768);
            gd.grabExcessHorizontalSpace = true;
            this.cmbDefinition.setLayoutData((Object)gd);
            if (hasContentAssist && (items = this.getContentItems(predefinedQuery)) != null) {
                new CComboAssistField(this.cmbDefinition, null, items);
            }
            if (predefinedQuery.length > 0) {
                this.populateExprComboItems(predefinedQuery);
            } else if (this.getQuery().getDefinition() == null || this.getQuery().getDefinition().equals("")) {
                this.cmbDefinition.setEnabled(false);
            }
            this.cmbDefinition.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    String oldQuery = BaseDataDefinitionComponent.this.query.getDefinition() == null ? "" : BaseDataDefinitionComponent.this.query.getDefinition();
                    String text = BaseDataDefinitionComponent.this.cmbDefinition.getText();
                    if (!BaseDataDefinitionComponent.this.isTableSharedBinding() && text.equals(oldQuery)) {
                        return;
                    }
                    BaseDataDefinitionComponent.this.updateQuery(text);
                    if (!oldQuery.equals(text) && BaseDataDefinitionComponent.this.queryType == "value" && BaseDataDefinitionComponent.this.context.getDataServiceProvider().update("value", (Object)text)) {
                        Event e = new Event();
                        e.data = BaseDataDefinitionComponent.this;
                        e.widget = BaseDataDefinitionComponent.this.cmbDefinition;
                        e.type = 2;
                        BaseDataDefinitionComponent.this.context.getDataSheet().notifyListeners(e);
                    }
                    if (BaseDataDefinitionComponent.this.context.getDataServiceProvider().checkState(32) && "category".equals(BaseDataDefinitionComponent.this.queryType) && BaseDataDefinitionComponent.this.context.getModel() instanceof ChartWithAxes) {
                        ((ChartWithAxes)BaseDataDefinitionComponent.this.context.getModel()).setTransposed(BaseDataDefinitionComponent.this.cmbDefinition.getSelectionIndex() > 0);
                    }
                    if (predefinedQuery.length == 0 && (BaseDataDefinitionComponent.this.getQuery().getDefinition() == null || BaseDataDefinitionComponent.this.getQuery().getDefinition().equals(""))) {
                        BaseDataDefinitionComponent.this.cmbDefinition.setEnabled(false);
                    }
                }
            });
            this.cmbDefinition.addModifyListener((ModifyListener)this);
            this.cmbDefinition.addFocusListener((FocusListener)this);
            this.cmbDefinition.addKeyListener((KeyListener)this);
            this.initComboExprText();
        } else {
            String[] items;
            control = this.cmpTop;
            if (hasContentAssist) {
                control = new Composite(this.cmpTop, 0);
                gd = new GridData(1808);
                gd.widthHint = 80;
                control.setLayoutData((Object)gd);
                gl = new GridLayout();
                FieldAssistHelper.getInstance().initDecorationMargin(gl);
                control.setLayout((Layout)gl);
            }
            this.txtDefinition = new Text(control, 2052);
            GridData gdTXTDefinition = new GridData(768);
            gdTXTDefinition.widthHint = 80;
            gdTXTDefinition.grabExcessHorizontalSpace = true;
            this.txtDefinition.setLayoutData((Object)gdTXTDefinition);
            this.txtDefinition.addModifyListener((ModifyListener)this);
            this.txtDefinition.addFocusListener((FocusListener)this);
            this.txtDefinition.addKeyListener((KeyListener)this);
            if (hasContentAssist && (items = this.getContentItems(predefinedQuery)) != null) {
                TextAssistField taf = new TextAssistField(this.txtDefinition, null, items);
                ((CTextContentAdapter)taf.getContentAdapter()).addContentChangeListener(new IContentChangeListener(){

                    public void contentChanged(Control control, Object newValue, Object oldValue) {
                        BaseDataDefinitionComponent.this.isQueryModified = true;
                        BaseDataDefinitionComponent.this.saveQuery();
                    }
                });
            }
        }
        Control dropControl = this.getInputControl();
        DropTarget target = new DropTarget(dropControl, 1);
        Transfer[] types = new Transfer[]{SimpleTextTransfer.getInstance()};
        target.setTransfer(types);
        target.addDropListener((DropTargetListener)new DataTextDropListener(dropControl));
        DataDefinitionTextManager.getInstance().addDataDefinitionText(dropControl, (IQueryExpressionManager)this);
        try {
            this.btnBuilder = (IExpressionButton)this.context.getUIServiceProvider().invoke(IUIServiceProvider.Command.EXPRESS_BUTTON_CREATE, new Object[]{this.cmpTop, this.getInputControl(), this.context.getExtendedItem(), 1, new Listener(){

                public void handleEvent(Event event) {
                    if (event.data instanceof String[]) {
                        BaseDataDefinitionComponent.this.handleBuilderAction((String[])event.data);
                    }
                }
            }});
            if (this.query != null) {
                this.btnBuilder.setExpression(this.query.getDefinition());
            }
        }
        catch (ChartException e) {
            WizardBase.displayException((Throwable)e);
        }
        if ((this.style & 1) == 1) {
            this.btnGroup = new Button(this.cmpTop, 8);
            GridData gdBTNGroup = new GridData();
            ChartUIUtil.setChartImageButtonSizeByPlatform((GridData)gdBTNGroup);
            this.btnGroup.setLayoutData((Object)gdBTNGroup);
            this.btnGroup.setImage(UIHelper.getImage((String)"icons/obj16/group.gif"));
            this.btnGroup.addSelectionListener((SelectionListener)this);
            this.btnGroup.setToolTipText(Messages.getString("BaseDataDefinitionComponent.Label.EditGroupSorting"));
        }
        this.setColor();
        boolean bl2 = isCubeNoMultiDimensions = (provider.checkState(2) || provider.checkState(256)) && !provider.checkState(64);
        if (this.context.getDataServiceProvider().checkState(32) || this.context.getDataServiceProvider().checkState(16)) {
            if (!(this.txtDefinition == null || this.context.getDataServiceProvider().checkState(256) && !isSharingChart || "optional".equals(this.queryType) && provider.checkState(128) && this.getQuery().getDefinition() != null && this.getQuery().getDefinition().trim().length() != 0)) {
                this.txtDefinition.setEnabled(false);
            }
            this.btnBuilder.setEnabled(false);
            if (this.btnGroup != null) {
                this.btnGroup.setEnabled(false);
            }
        }
        if (this.cmbDefinition != null && "optional".equals(this.queryType) && isCubeNoMultiDimensions) {
            this.cmbDefinition.setEnabled(false);
            this.btnBuilder.setEnabled(false);
        }
        this.setTooltipForInputControl();
        boolean isRequiredField = "category".equals(this.queryType);
        if (lblDesc != null && isRequiredField) {
            FieldAssistHelper.getInstance().addRequiredFieldIndicator(lblDesc);
        }
        return this.cmpTop;
    }

    private void initComboExprText() {
        if (this.isTableSharedBinding()) {
            this.initComboExprTextForSharedBinding();
        } else {
            this.cmbDefinition.setText(this.query.getDefinition());
        }
    }

    private boolean isTableSharedBinding() {
        return this.cmbDefinition != null && !this.cmbDefinition.isDisposed() && this.cmbDefinition.getData() != null && (this.context.getDataServiceProvider().checkState(16) || this.context.getDataServiceProvider().checkState(1024));
    }

    private void initComboExprTextForSharedBinding() {
        this.setUITextForSharedBinding(this.cmbDefinition, this.query.getDefinition());
    }

    private String[] getContentItems(Object[] predefinedQuery) {
        if (predefinedQuery[0] instanceof Object[]) {
            String[] items = new String[predefinedQuery.length];
            int i = 0;
            while (i < items.length) {
                items[i] = (String)((Object[])predefinedQuery[i])[0];
                ++i;
            }
            return items;
        }
        if (predefinedQuery[0] instanceof String) {
            String[] items = new String[predefinedQuery.length];
            int i = 0;
            while (i < items.length) {
                items[i] = (String)predefinedQuery[i];
                ++i;
            }
            return items;
        }
        return null;
    }

    private void populateExprComboItems(Object[] predefinedQuery) {
        if (predefinedQuery[0] instanceof Object[]) {
            String[] items = new String[predefinedQuery.length];
            Object[] data = new Object[predefinedQuery.length];
            int i = 0;
            while (i < items.length) {
                items[i] = (String)((Object[])predefinedQuery[i])[0];
                data[i] = ((Object[])predefinedQuery[i])[1];
                ++i;
            }
            this.cmbDefinition.setItems(items);
            this.cmbDefinition.setData((Object)data);
        } else if (predefinedQuery[0] instanceof String) {
            String[] items = new String[predefinedQuery.length];
            int i = 0;
            while (i < items.length) {
                items[i] = (String)predefinedQuery[i];
                ++i;
            }
            this.cmbDefinition.setItems(items);
        }
    }

    public void selectArea(boolean selected, Object data) {
        if (data instanceof Object[]) {
            Object[] array = (Object[])data;
            this.seriesdefinition = (SeriesDefinition)array[0];
            this.query = (Query)array[1];
            this.setUIText(this.getInputControl(), this.query.getDefinition());
            DataDefinitionTextManager.getInstance().addDataDefinitionText(this.getInputControl(), (IQueryExpressionManager)this);
            if (this.fAggEditorComposite != null) {
                this.fAggEditorComposite.setAggregation(this.query, this.seriesdefinition);
            }
        }
        this.setColor();
    }

    private void setColor() {
        if (this.query != null) {
            Color cColor = ColorPalette.getInstance().getColor(this.getDisplayExpression());
            if (this.getInputControl() != null) {
                ChartUIUtil.setBackgroundColor((Control)this.getInputControl(), (boolean)true, (Color)cColor);
            }
        }
    }

    public void dispose() {
        if (this.getInputControl() != null) {
            DataDefinitionTextManager.getInstance().removeDataDefinitionText(this.getInputControl());
        }
        super.dispose();
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource().equals(this.btnGroup)) {
            this.handleGroupAction();
        }
    }

    protected void handleGroupAction() {
        SeriesDefinition sdBackup = this.seriesdefinition.copyInstance();
        GroupSortingDialog groupDialog = this.createGroupSortingDialog(sdBackup);
        if (groupDialog.open() == 0) {
            if (!sdBackup.eIsSet((EStructuralFeature)DataPackage.eINSTANCE.getSeriesDefinition_Sorting())) {
                this.seriesdefinition.eUnset((EStructuralFeature)DataPackage.eINSTANCE.getSeriesDefinition_Sorting());
            } else {
                this.seriesdefinition.setSorting(sdBackup.getSorting());
            }
            this.seriesdefinition.setSortKey(sdBackup.getSortKey());
            this.seriesdefinition.getSortKey().eAdapters().addAll((Collection)this.seriesdefinition.eAdapters());
            this.seriesdefinition.setGrouping(sdBackup.getGrouping());
            this.seriesdefinition.getGrouping().eAdapters().addAll((Collection)this.seriesdefinition.eAdapters());
            ChartUIUtil.checkGroupType((ChartWizardContext)this.context, (Chart)this.context.getModel());
            ChartUIUtil.checkAggregateType((ChartWizardContext)this.context);
            DataDefinitionTextManager.getInstance().updateTooltip();
        }
    }

    protected void handleBuilderAction(String[] data) {
        if (data.length != 2) {
            return;
        }
        String newExpr = data[1];
        this.updateQuery(newExpr);
    }

    protected GroupSortingDialog createGroupSortingDialog(SeriesDefinition sdBackup) {
        return new BaseGroupSortingDialog(this.cmpTop.getShell(), this.context, sdBackup);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void modifyText(ModifyEvent e) {
        if (e.getSource().equals(this.getInputControl())) {
            this.isQueryModified = true;
            this.setTooltipForInputControl();
        }
    }

    public void setTooltipForInputControl() {
        Control control = this.getInputControl();
        if (control != null && !control.isDisposed()) {
            this.getInputControl().setToolTipText(this.getTooltipForDataText(this.getExpression(control)));
        }
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        if ((e == null || e.widget.equals(this.getInputControl())) && !ChartUIUtil.getText((Control)this.getInputControl()).equals(this.query.getDefinition())) {
            this.saveQuery();
        }
    }

    protected void saveQuery() {
        if (this.isQueryModified) {
            this.setColor();
            this.updateQuery(ChartUIUtil.getText((Control)this.getInputControl()));
            if (!this.getInputControl().isDisposed()) {
                this.getInputControl().getParent().layout();
            }
            Event e = new Event();
            e.text = this.query.getDefinition() == null ? "" : this.query.getDefinition();
            e.data = e.text;
            e.widget = this.getInputControl();
            e.type = 0;
            this.fireEvent(e);
            this.isQueryModified = false;
        }
    }

    private String getTooltipForDataText(String queryText) {
        ColumnBindingInfo cbi;
        int index;
        if (this.isTableSharedBinding() && (index = this.cmbDefinition.getSelectionIndex()) >= 0 && ((cbi = (ColumnBindingInfo)((Object[])this.cmbDefinition.getData())[index]).getColumnType() == 1 || cbi.getColumnType() == 2)) {
            return cbi.getTooltip();
        }
        if (queryText.trim().length() == 0) {
            return this.tooltipWhenBlank;
        }
        if ("value".equals(this.queryType) && this.context.getDataServiceProvider().checkState(1)) {
            boolean baseEnabled;
            SeriesDefinition baseSd = (SeriesDefinition)ChartUIUtil.getBaseSeriesDefinitions((Chart)this.context.getModel()).get(0);
            SeriesGrouping sg = null;
            boolean bl = baseEnabled = baseSd.getGrouping() != null && baseSd.getGrouping().isEnabled();
            if (baseEnabled) {
                sg = baseSd.getGrouping();
                if (this.seriesdefinition.getGrouping() != null && this.seriesdefinition.getGrouping().isEnabled()) {
                    sg = this.seriesdefinition.getGrouping();
                }
            }
            if (this.query.getGrouping() != null && this.query.getGrouping().isEnabled()) {
                sg = this.query.getGrouping();
            }
            if (sg != null) {
                StringBuffer sbuf = new StringBuffer();
                sbuf.append(sg.getAggregateExpression());
                sbuf.append("( ");
                sbuf.append(queryText);
                IAggregateFunction aFunc = null;
                try {
                    aFunc = PluginSettings.instance().getAggregateFunction(sg.getAggregateExpression());
                }
                catch (ChartException chartException) {}
                if (!baseEnabled && aFunc != null && aFunc.getType() == 0) {
                    return queryText;
                }
                int count = aFunc != null ? aFunc.getParametersCount() : sg.getAggregateParameters().size();
                int i = 0;
                while (i < sg.getAggregateParameters().size()) {
                    if (i < count) {
                        sbuf.append(", ");
                        sbuf.append((String)sg.getAggregateParameters().get(i));
                    }
                    ++i;
                }
                sbuf.append(" )");
                return sbuf.toString();
            }
        }
        return queryText;
    }

    public void keyPressed(KeyEvent e) {
        if (e.keyCode == 13 || e.keyCode == 0x1000050) {
            this.saveQuery();
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void setTooltipWhenBlank(String tootipWhenBlank) {
        this.tooltipWhenBlank = tootipWhenBlank;
    }

    private void createAggregationItem(Composite composite) {
        boolean enabled;
        SeriesDefinition baseSD = (SeriesDefinition)ChartUIUtil.getBaseSeriesDefinitions((Chart)this.context.getModel()).get(0);
        boolean bl = enabled = ChartUIUtil.isGroupingSupported((ChartWizardContext)this.context) && (PluginSettings.instance().inEclipseEnv() || baseSD.getGrouping().isEnabled());
        if (this.query.getGrouping() == null) {
            SeriesGrouping aggGrouping = SeriesGroupingImpl.create();
            if (this.seriesdefinition.getGrouping() != null) {
                aggGrouping.setAggregateExpression(this.seriesdefinition.getGrouping().getAggregateExpression());
            }
            this.query.setGrouping(aggGrouping);
        }
        this.fAggEditorComposite = new AggregateEditorComposite(composite, this.seriesdefinition, this.context, enabled, this.query);
    }

    private Control getInputControl() {
        if (this.txtDefinition != null) {
            return this.txtDefinition;
        }
        if (this.cmbDefinition != null) {
            return this.cmbDefinition;
        }
        return null;
    }

    private String getExpression(Control control) {
        return this.getActualExpression(control);
    }

    private boolean setUIText(Control control, String expression) {
        if (control == null || control.isDisposed()) {
            return false;
        }
        if (control instanceof Text) {
            ((Text)control).setText(expression);
        } else if (control instanceof CCombo) {
            if (this.isTableSharedBinding()) {
                this.setUITextForSharedBinding((CCombo)control, expression);
            } else {
                ((CCombo)control).setText(expression);
            }
        }
        return true;
    }

    private void setUITextForSharedBinding(CCombo control, String expression) {
        Object[] data = (Object[])control.getData();
        if (data == null || data.length == 0) {
            control.setText(expression);
        } else {
            String expr = this.getDisplayExpressionForSharedBinding(control, expression);
            control.setText(expr);
        }
    }

    public void updateQuery(String expression) {
        if (this.getInputControl() instanceof CCombo) {
            if (this.query.getDefinition() != null) {
                this.query.getDefinition();
            }
            Object checkResult = this.context.getDataServiceProvider().checkData(this.queryType, (Object)expression);
            if (checkResult != null && checkResult instanceof Boolean && !((Boolean)checkResult).booleanValue()) {
                return;
            }
        }
        if (!this.isTableSharedBinding()) {
            this.setQueryExpression(expression);
            return;
        }
        this.updateQueryForSharedBinding(expression);
        String regex = "\\Qrow[\"\\E.*\\Q\"]\\E";
        if (expression.matches(regex)) {
            DataDefinitionTextManager.getInstance().updateText(this.query);
            final Event e = new Event();
            e.data = this;
            e.widget = this.getInputControl();
            e.type = 2;
            e.detail = 3;
            Display.getCurrent().asyncExec(new Runnable(){

                public void run() {
                    BaseDataDefinitionComponent.this.context.getDataSheet().notifyListeners(e);
                }
            });
        } else {
            this.getInputControl().setBackground(null);
        }
    }

    private void updateQueryForSharedBinding(String expression) {
        Object[] data = (Object[])this.cmbDefinition.getData();
        if (data != null && data.length > 0) {
            String expr = expression;
            if ("category".equals(this.queryType) || "optional".equals(this.queryType)) {
                boolean isGroupExpr = false;
                int i = 0;
                while (i < data.length) {
                    ColumnBindingInfo chi = (ColumnBindingInfo)data[i];
                    int type = chi.getColumnType();
                    if (type == 1) {
                        String groupRegex = ChartUtil.createRegularRowExpression((String)chi.getName(), (boolean)false);
                        String regex = ChartUtil.createRegularRowExpression((String)chi.getName(), (boolean)true);
                        if (expression.matches(regex)) {
                            isGroupExpr = true;
                            expr = expression.replaceAll(groupRegex, chi.getExpression());
                            break;
                        }
                    }
                    ++i;
                }
                this.setQueryExpression(expr);
                if ("category".equals(this.queryType)) {
                    if (isGroupExpr) {
                        this.seriesdefinition.getGrouping().setEnabled(true);
                    } else {
                        this.seriesdefinition.getGrouping().setEnabled(false);
                    }
                }
            } else if ("value".equals(this.queryType)) {
                boolean isAggregationExpr = false;
                ColumnBindingInfo chi = null;
                int i = 0;
                while (i < data.length) {
                    chi = (ColumnBindingInfo)data[i];
                    int type = chi.getColumnType();
                    if (type == 2) {
                        String aggRegex = ChartUtil.createRegularRowExpression((String)chi.getName(), (boolean)false);
                        String regex = ChartUtil.createRegularRowExpression((String)chi.getName(), (boolean)true);
                        if (expression.matches(regex)) {
                            isAggregationExpr = true;
                            expr = expression.replaceAll(aggRegex, chi.getExpression());
                            break;
                        }
                    }
                    ++i;
                }
                this.setQueryExpression(expr);
                if (isAggregationExpr) {
                    this.query.getGrouping().setEnabled(true);
                    this.query.getGrouping().setAggregateExpression(chi.getChartAggExpression());
                } else {
                    this.query.getGrouping().setEnabled(false);
                    this.query.getGrouping().setAggregateExpression(null);
                }
            }
        } else {
            this.setQueryExpression(expression);
        }
    }

    private void setQueryExpression(String expression) {
        if ("value".equals(this.queryType) && !(this.context.getChartType() instanceof GanttChart) && !this.context.getDataServiceProvider().checkState(16) && this.context.getDataServiceProvider().checkState(1) && this.context.getDataServiceProvider().getDataType(expression) == DataType.DATE_TIME_LITERAL) {
            ChartAdapter.beginIgnoreNotifications();
            if (this.query.getGrouping() == null) {
                this.query.setGrouping(DataFactoryImpl.init().createSeriesGrouping());
            }
            SeriesGrouping group = this.query.getGrouping();
            group.setEnabled(true);
            group.setAggregateExpression("First");
            ChartAdapter.endIgnoreNotifications();
        }
        if (this.query != null) {
            this.query.setDefinition(this.btnBuilder.getExpression());
        } else {
            this.query = QueryImpl.create((String)this.btnBuilder.getExpression());
            this.query.eAdapters().addAll((Collection)this.seriesdefinition.eAdapters());
            this.seriesdefinition.setQuery(this.query);
        }
    }

    public Query getQuery() {
        if (this.query == null) {
            this.query = QueryImpl.create((String)this.getExpression(this.getInputControl()));
            this.query.eAdapters().addAll((Collection)this.seriesdefinition.eAdapters());
            this.seriesdefinition.setQuery(this.query);
        }
        return this.query;
    }

    public String getDisplayExpression() {
        if (this.cmbDefinition != null && this.isTableSharedBinding()) {
            return this.getDisplayExpressionForSharedBinding(this.cmbDefinition, this.query.getDefinition());
        }
        return this.btnBuilder.getExpressionString();
    }

    private String getDisplayExpressionForSharedBinding(CCombo combo, String expression) {
        String expr = expression;
        Object[] data = (Object[])combo.getData();
        int i = 0;
        while (data != null && i < data.length) {
            block9: {
                ColumnBindingInfo chi = (ColumnBindingInfo)data[i];
                if (chi.getExpression() != null) {
                    String columnExpr = null;
                    try {
                        List bindings = ExpressionUtil.extractColumnExpressions((String)chi.getExpression());
                        if (bindings.isEmpty()) break block9;
                        columnExpr = ((IColumnBinding)bindings.get(0)).getResultSetColumnName();
                    }
                    catch (BirtException birtException) {
                        break block9;
                    }
                    String columnRegex = ChartUtil.createRegularRowExpression((String)columnExpr, (boolean)false);
                    String regex = ChartUtil.createRegularRowExpression((String)columnExpr, (boolean)true);
                    if (expression != null && expression.matches(regex)) {
                        if (this.queryType == "category") {
                            boolean groupedBinding;
                            boolean sdGrouped = this.seriesdefinition.getGrouping().isEnabled();
                            boolean bl = groupedBinding = chi.getColumnType() == 1;
                            if (sdGrouped && groupedBinding) {
                                expr = expression.replaceAll(columnRegex, ExpressionUtil.createJSRowExpression((String)chi.getName()));
                                break;
                            }
                        } else if (this.queryType == "optional") {
                            expr = expression.replaceAll(columnRegex, ExpressionUtil.createJSRowExpression((String)chi.getName()));
                            break;
                        }
                    }
                }
            }
            ++i;
        }
        return expr == null ? "" : expr;
    }

    public boolean isValidExpression(String expression) {
        if (this.context.getDataServiceProvider().checkState(16) || this.context.getDataServiceProvider().checkState(1024)) {
            if (this.cmbDefinition == null) {
                return false;
            }
            int index = this.cmbDefinition.indexOf(expression);
            return index >= 0;
        }
        return true;
    }

    private String getActualExpression(Control control) {
        if (control instanceof Text) {
            return ((Text)control).getText();
        }
        if (control instanceof CCombo) {
            Object[] data = (Object[])control.getData();
            if (data != null && data.length > 0 && data[0] instanceof ColumnBindingInfo) {
                String txt = ((CCombo)control).getText();
                String[] items = ((CCombo)control).getItems();
                int index = 0;
                while (items != null && items.length > 0 && index < items.length) {
                    if (items[index].equals(txt)) break;
                    ++index;
                }
                if (items != null && index >= 0 && index < items.length) {
                    return ((ColumnBindingInfo)data[index]).getExpression();
                }
            }
            return ((CCombo)control).getText();
        }
        return "";
    }

    public void updateText(String expression) {
        if (this.btnBuilder != null) {
            this.btnBuilder.setExpression(expression);
        }
    }
}

