/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard.format.popup;

import org.eclipse.birt.chart.ui.swt.composites.TriggerDataComposite;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.AbstractPopupSheet;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class InteractivitySheet
extends AbstractPopupSheet {
    private final EList triggers;
    private final EObject cursorContainer;
    private final boolean bEnableURLParameters;
    private final boolean bEnableShowTooltipValue;
    private final int iInteractivityType;
    private int optionalStyle;

    public InteractivitySheet(String title, ChartWizardContext context, EList triggers, EObject cursorContainer, int iInteractivityType, int optionalStyle) {
        this(title, context, triggers, cursorContainer, iInteractivityType, (optionalStyle & 1) == 1, (optionalStyle & 0x10) == 16);
        this.optionalStyle = optionalStyle;
    }

    public InteractivitySheet(String title, ChartWizardContext context, EList triggers, EObject cursorContainer, int iInteractivityType, boolean bEnableURLParameters, boolean bEnableShowTooltipValue) {
        super(title, context, false);
        this.triggers = triggers;
        this.cursorContainer = cursorContainer;
        this.bEnableURLParameters = bEnableURLParameters;
        this.bEnableShowTooltipValue = bEnableShowTooltipValue;
        this.iInteractivityType = iInteractivityType;
        if (bEnableShowTooltipValue) {
            this.optionalStyle |= 0x10;
        }
        if (bEnableURLParameters) {
            this.optionalStyle |= 1;
        }
    }

    protected Composite getComponent(Composite parent) {
        ChartUIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.chart.cshelp.Interactivity_ID");
        final TriggerDataComposite triggerUI = new TriggerDataComposite(parent, 0, this.triggers, this.cursorContainer, this.getContext(), this.iInteractivityType, this.optionalStyle);
        parent.getShell().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                triggerUI.markSaveWhenClosing();
            }
        });
        return triggerUI;
    }
}

