/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.device.image;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.FlatteningPathIterator;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.event.IIOWriteWarningListener;
import javax.imageio.stream.ImageOutputStream;
import org.eclipse.birt.chart.computation.DataPointHints;
import org.eclipse.birt.chart.computation.LegendItemHints;
import org.eclipse.birt.chart.device.IImageMapEmitter;
import org.eclipse.birt.chart.device.ImageWriterFactory;
import org.eclipse.birt.chart.device.extension.i18n.Messages;
import org.eclipse.birt.chart.device.image.MultiActionValuesScriptGenerator;
import org.eclipse.birt.chart.device.swing.ShapedAction;
import org.eclipse.birt.chart.device.swing.SwingRendererImpl;
import org.eclipse.birt.chart.device.util.CSSHelper;
import org.eclipse.birt.chart.device.util.HTMLAttribute;
import org.eclipse.birt.chart.device.util.HTMLTag;
import org.eclipse.birt.chart.device.util.ScriptUtil;
import org.eclipse.birt.chart.event.StructureSource;
import org.eclipse.birt.chart.event.StructureType;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.attribute.ActionType;
import org.eclipse.birt.chart.model.attribute.ActionValue;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.CursorType;
import org.eclipse.birt.chart.model.attribute.MultiURLValues;
import org.eclipse.birt.chart.model.attribute.ScriptValue;
import org.eclipse.birt.chart.model.attribute.TooltipValue;
import org.eclipse.birt.chart.model.attribute.TriggerCondition;
import org.eclipse.birt.chart.model.attribute.URLValue;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.data.Action;
import org.eclipse.birt.chart.model.data.MultipleActions;
import org.eclipse.birt.chart.util.SecurityUtil;
import org.eclipse.birt.core.script.JavascriptEvalUtil;
import org.eclipse.emf.common.util.EList;

public abstract class JavaxImageIOWriter
extends SwingRendererImpl
implements IIOWriteWarningListener,
IImageMapEmitter {
    protected Image _img = null;
    protected Object _oOutputIdentifier = null;
    private Bounds _bo = null;
    private boolean _bImageExternallySpecified = false;
    private boolean _bAltEnabled = false;
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.device.extension/image");
    private static final String NO_OP_JAVASCRIPT = "javascript:void(0);";
    private static final String POLY_SHAPE = "poly";
    private Map<String, Boolean> callbackMethodsRegistry = new HashMap<String, Boolean>(5);
    private volatile boolean hasMultipleMenu = false;
    private volatile boolean hasAddedMenuLib = false;

    protected abstract String getFormat();

    protected abstract int getImageType();

    protected boolean supportsTransparency() {
        return true;
    }

    JavaxImageIOWriter() {
        ImageIO.setUseCache(false);
    }

    protected void updateWriterParameters(ImageWriteParam iwp) {
    }

    public String getImageMap() {
        List<ShapedAction> saList = this.getShapeActions();
        Collections.sort(saList, new Comparator<ShapedAction>(){

            @Override
            public int compare(ShapedAction o1, ShapedAction o2) {
                return o2.getZOrder() - o1.getZOrder();
            }
        });
        if (saList == null || saList.size() == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        ListIterator<ShapedAction> iter = saList.listIterator(saList.size());
        while (iter.hasPrevious()) {
            ShapedAction sa = iter.previous();
            this.userCallback(sa, sb);
            String coords = this.shape2polyCoords(sa.getShape());
            if (coords == null) continue;
            HTMLTag tag = new HTMLTag("area");
            tag.addAttribute(HTMLAttribute.SHAPE, POLY_SHAPE);
            tag.addAttribute(HTMLAttribute.COORDS, coords);
            tag.addAttribute(HTMLAttribute.ALT, this._bAltEnabled ? sa.getSource().getSource().toString() : "");
            this.setCursorAttribute(tag, sa);
            boolean changed = false;
            changed |= this.processOnFocus(sa, tag);
            changed |= this.processOnBlur(sa, tag);
            changed |= this.processOnClick(sa, tag);
            changed |= this.processOnDoubleClick(sa, tag);
            if (!(changed |= this.processOnMouseOver(sa, tag))) continue;
            sb.append(tag);
        }
        return sb.toString();
    }

    private void setCursorAttribute(HTMLTag tag, ShapedAction sa) {
        if (sa.getCursor() == null || sa.getCursor().getType() == CursorType.AUTO) {
            return;
        }
        String value = CSSHelper.getCSSCursorValue(sa.getCursor());
        if (value != null) {
            tag.addAttribute(HTMLAttribute.STYLE, value);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean processCommonEvent(ShapedAction sa, HTMLTag tag, TriggerCondition condition, HTMLAttribute htmlAttr) {
        Action ac = sa.getActionForCondition(condition);
        if (!this.checkSupportedAction(ac)) return false;
        if (ac instanceof MultipleActions) {
            List<Action> validActions = MultiActionValuesScriptGenerator.getValidActions((MultipleActions)ac);
            int size = validActions.size();
            if (size == 0) {
                return false;
            }
            if (size == 1) {
                Action subAction = validActions.get(0);
                if (subAction.getValue() instanceof URLValue) {
                    this.setURLValueAttributes(tag, condition, htmlAttr, (URLValue)subAction.getValue());
                    return true;
                }
                if (!(subAction.getValue() instanceof ScriptValue)) return false;
                this.setAttributesWithScript(sa, tag, condition, htmlAttr);
                return true;
            }
            this.setAttributesWithScript(sa, tag, condition, htmlAttr);
            return true;
        }
        switch (ac.getType().getValue()) {
            case 0: {
                if (ac.getValue() instanceof MultiURLValues) {
                    List<URLValue> validURLValues = MultiActionValuesScriptGenerator.getValidURLValues((MultiURLValues)ac.getValue());
                    int size = validURLValues.size();
                    if (size == 0) {
                        this.setTooltipAttribute(tag, ((MultiURLValues)ac.getValue()).getTooltip());
                        return false;
                    }
                    if (size == 1) {
                        URLValue uv = validURLValues.get(0);
                        this.setURLValueAttributes(tag, condition, htmlAttr, uv);
                        return true;
                    }
                    this.setTooltipAttribute(tag, ((MultiURLValues)ac.getValue()).getTooltip());
                    this.setAttributesWithScript(sa, tag, condition, htmlAttr);
                    return true;
                }
                URLValue uv = (URLValue)ac.getValue();
                this.setURLValueAttributes(tag, condition, htmlAttr, uv);
                return true;
            }
            case 1: {
                return false;
            }
            case 3: {
                this.setAttributesWithScript(sa, tag, condition, htmlAttr);
                return true;
            }
        }
        return false;
    }

    private void setTooltipAttribute(HTMLTag tag, String tooltip) {
        if (tooltip != null && tooltip.trim().length() > 0) {
            tag.addAttribute(HTMLAttribute.TITLE, this.eval2HTML(tooltip));
        }
    }

    private void setAttributesWithScript(ShapedAction sa, HTMLTag tag, TriggerCondition condition, HTMLAttribute htmlAttr) {
        tag.addAttribute(HTMLAttribute.HREF, NO_OP_JAVASCRIPT);
        StringBuffer callbackFunction = new StringBuffer(this.getJSMethodName(condition, sa));
        this.addCallBackScript(sa, callbackFunction);
        tag.addAttribute(htmlAttr, this.eval2JS(callbackFunction.toString(), true));
    }

    private String removeSurroundingQuotes(String sBaseUrl) {
        if (sBaseUrl == null) {
            return null;
        }
        if (sBaseUrl.length() > 0) {
            int iEnd = sBaseUrl.length() - 1;
            if (sBaseUrl.charAt(0) == '\"' && sBaseUrl.charAt(iEnd) == '\"') {
                return sBaseUrl.substring(1, iEnd);
            }
        }
        return sBaseUrl;
    }

    private void setURLValueAttributes(HTMLTag tag, TriggerCondition condition, HTMLAttribute htmlAttr, URLValue uv) {
        String tooltip = uv.getTooltip();
        this.setTooltipAttribute(tag, tooltip);
        if (condition == TriggerCondition.ONCLICK_LITERAL) {
            tag.addAttribute(HTMLAttribute.HREF, this.eval2HTML(this.removeSurroundingQuotes(uv.getBaseUrl())));
            if (uv.getTarget() != null) {
                tag.addAttribute(HTMLAttribute.TARGET, uv.getTarget());
            }
        } else {
            tag.addAttribute(HTMLAttribute.HREF, NO_OP_JAVASCRIPT);
            String value = this.getJsURLRedirect(uv);
            if (htmlAttr.equals(HTMLAttribute.ONFOCUS)) {
                value = "this.blur();" + value;
            }
            tag.addAttribute(htmlAttr, value);
        }
    }

    protected boolean processOnFocus(ShapedAction sa, HTMLTag tag) {
        return this.processCommonEvent(sa, tag, TriggerCondition.ONFOCUS_LITERAL, HTMLAttribute.ONFOCUS);
    }

    protected boolean processOnBlur(ShapedAction sa, HTMLTag tag) {
        return this.processCommonEvent(sa, tag, TriggerCondition.ONBLUR_LITERAL, HTMLAttribute.ONBLUR);
    }

    protected boolean processOnClick(ShapedAction sa, HTMLTag tag) {
        return this.processCommonEvent(sa, tag, TriggerCondition.ONCLICK_LITERAL, HTMLAttribute.ONCLICK);
    }

    protected boolean processOnDoubleClick(ShapedAction sa, HTMLTag tag) {
        return this.processCommonEvent(sa, tag, TriggerCondition.ONDBLCLICK_LITERAL, HTMLAttribute.ONDBLCLICK);
    }

    protected boolean processOnMouseOver(ShapedAction sa, HTMLTag tag) {
        Action ac = sa.getActionForCondition(TriggerCondition.ONMOUSEOVER_LITERAL);
        if (this.checkSupportedAction(ac)) {
            switch (ac.getType().getValue()) {
                case 0: {
                    return false;
                }
                case 1: {
                    TooltipValue tv = (TooltipValue)ac.getValue();
                    if (tv.getText() != null && tv.getText().length() > 0) {
                        tag.addAttribute(HTMLAttribute.TITLE, this.eval2HTML(tv.getText()));
                        return true;
                    }
                    return false;
                }
                case 3: {
                    StringBuffer callbackFunction = new StringBuffer(this.getJSMethodName(TriggerCondition.ONMOUSEOVER_LITERAL, sa));
                    this.addCallBackScript(sa, callbackFunction);
                    tag.addAttribute(HTMLAttribute.ONMOUSEOVER, this.eval2JS(callbackFunction.toString(), true));
                    return true;
                }
            }
        }
        return false;
    }

    protected String getJsURLRedirect(URLValue uv) {
        String sBaseUrl = uv.getBaseUrl() == null ? "" : uv.getBaseUrl();
        if ((sBaseUrl = this.removeSurroundingQuotes(sBaseUrl)).startsWith("javascript:")) {
            return sBaseUrl;
        }
        if (sBaseUrl.startsWith("#")) {
            return "window.location='" + this.eval2HTML(sBaseUrl) + "'";
        }
        return "window.open('" + this.eval2HTML(sBaseUrl) + "','" + (uv.getTarget() == null ? "self" : uv.getTarget()) + "')";
    }

    private String shape2polyCoords(Shape shape) {
        if (shape == null) {
            return null;
        }
        ArrayList<Double> al = new ArrayList<Double>();
        FlatteningPathIterator pitr = new FlatteningPathIterator(shape.getPathIterator(null), 1.0);
        double[] data = new double[6];
        while (!pitr.isDone()) {
            int type = pitr.currentSegment(data);
            switch (type) {
                case 0: {
                    al.add(new Double(data[0]));
                    al.add(new Double(data[1]));
                    break;
                }
                case 1: {
                    al.add(new Double(data[0]));
                    al.add(new Double(data[1]));
                    break;
                }
                case 2: {
                    al.add(new Double(data[0]));
                    al.add(new Double(data[1]));
                    al.add(new Double(data[2]));
                    al.add(new Double(data[3]));
                    break;
                }
                case 3: {
                    al.add(new Double(data[0]));
                    al.add(new Double(data[1]));
                    al.add(new Double(data[2]));
                    al.add(new Double(data[3]));
                    al.add(new Double(data[4]));
                    al.add(new Double(data[5]));
                    break;
                }
            }
            pitr.next();
        }
        if (al.size() == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < al.size()) {
            Double db = (Double)al.get(i);
            if (i > 0) {
                sb.append(",");
            }
            sb.append((int)db.doubleValue());
            ++i;
        }
        return sb.toString();
    }

    private boolean checkSupportedAction(Action action) {
        return action != null && (action.getType() == ActionType.URL_REDIRECT_LITERAL || action.getType() == ActionType.SHOW_TOOLTIP_LITERAL || action.getType() == ActionType.INVOKE_SCRIPT_LITERAL);
    }

    protected boolean isSupportedByJavaxImageIO() {
        Iterator<ImageWriter> it;
        boolean supported = false;
        String s = this.getFormat();
        if (s != null && (it = ImageIO.getImageWritersByFormatName(s)).hasNext()) {
            supported = true;
        }
        if (!supported && (s = this.getMimeType()) != null && (it = ImageIO.getImageWritersByMIMEType(s)).hasNext()) {
            supported = true;
        }
        return supported;
    }

    public void before() throws ChartException {
        super.before();
        boolean bl = this._bImageExternallySpecified = this._img != null;
        if (!this._bImageExternallySpecified) {
            if (this._bo == null) {
                throw new ChartException("org.eclipse.birt.chart.device.extension", 11, "JavaxImageIOWriter.exception.no.bounds", Messages.getResourceBundle(this.getULocale()));
            }
            if ((int)this._bo.getWidth() < 0 || (int)this._bo.getHeight() < 0) {
                throw new ChartException("org.eclipse.birt.chart.device.extension", 18, "JavaxImageIOWriter.exception.invalid.image.size", Messages.getResourceBundle(this.getULocale()));
            }
            if ((int)this._bo.getWidth() == 0 || (int)this._bo.getHeight() == 0) {
                this._bo.setWidth(1.0);
                this._bo.setHeight(1.0);
            }
            this._img = new BufferedImage((int)Math.round(this._bo.getWidth()), (int)Math.round(this._bo.getHeight()), this.getImageType());
        }
        super.setProperty("device.output.context", this._img.getGraphics());
        if (!this.supportsTransparency()) {
            this._g2d.setPaint(Color.WHITE);
            this._g2d.fillRect(0, 0, this._img.getWidth(null), this._img.getHeight(null));
        }
    }

    public void after() throws ChartException {
        super.after();
        if (this._oOutputIdentifier != null) {
            ImageWriter iw = ImageWriterFactory.instance().createByFormatName(this.getFormat());
            if (iw == null) {
                String s = this.getMimeType();
                if (s == null) {
                    throw new ChartException("org.eclipse.birt.chart.device.extension", 11, "JavaxImageIOWriter.exception.no.imagewriter.mimetype.and.format", new Object[]{this.getMimeType(), this.getFormat(), this.getClass().getName()}, Messages.getResourceBundle(this.getULocale()));
                }
                Iterator<ImageWriter> it = ImageIO.getImageWritersByMIMEType(s);
                if (!it.hasNext()) {
                    throw new ChartException("org.eclipse.birt.chart.device.extension", 11, "JavaxImageIOWriter.exception.no.imagewriter.mimetype", new Object[]{this.getMimeType()}, Messages.getResourceBundle(this.getULocale()));
                }
                iw = it.next();
            }
            logger.log(1, String.valueOf(Messages.getString("JavaxImageIOWriter.info.using.imagewriter", this.getULocale())) + this.getFormat() + iw.getClass().getName());
            Object o = this._oOutputIdentifier instanceof String ? new File((String)this._oOutputIdentifier) : this._oOutputIdentifier;
            try {
                try {
                    ImageOutputStream ios = SecurityUtil.newImageOutputStream((Object)o);
                    this.updateWriterParameters(iw.getDefaultWriteParam());
                    iw.setOutput(ios);
                    iw.write((RenderedImage)((Object)this._img));
                    ios.close();
                }
                catch (Exception ex) {
                    throw new ChartException("org.eclipse.birt.chart.device.extension", 11, (Throwable)ex);
                }
            }
            finally {
                iw.dispose();
            }
        }
        if (!this._bImageExternallySpecified) {
            this._img.flush();
            this._img = null;
        }
        this._g2d.dispose();
        this._g2d = null;
    }

    public void setProperty(String sProperty, Object oValue) {
        super.setProperty(sProperty, oValue);
        if (sProperty.equals("device.bounds")) {
            this._bo = (Bounds)oValue;
        } else if (sProperty.equals("cached.image")) {
            this._img = (Image)oValue;
        } else if (sProperty.equals("device.file.identifier")) {
            this._oOutputIdentifier = oValue;
        } else if (sProperty.equals("device.disk.cache")) {
            ImageIO.setUseCache((Boolean)oValue);
        } else if (sProperty.equals("enable.area.alt")) {
            this._bAltEnabled = (Boolean)oValue;
        }
    }

    public void warningOccurred(ImageWriter source, int imageIndex, String warning) {
        logger.log(2, warning);
    }

    public void presentException(Exception cexp) {
        if (this._bo == null) {
            this._bo = BoundsImpl.create((double)0.0, (double)0.0, (double)400.0, (double)300.0);
        }
        String sWrappedException = cexp.getClass().getName();
        while (cexp.getCause() != null) {
            cexp = (Exception)cexp.getCause();
        }
        String sException = cexp.getClass().getName();
        if (sWrappedException.equals(sException)) {
            sWrappedException = null;
        }
        String sMessage = cexp.getMessage();
        StackTraceElement[] stea = cexp.getStackTrace();
        Dimension d = new Dimension((int)this._bo.getWidth(), (int)this._bo.getHeight());
        Font fo = new Font("Monospaced", 1, 14);
        this._g2d.setFont(fo);
        FontMetrics fm = this._g2d.getFontMetrics();
        this._g2d.setColor(Color.WHITE);
        this._g2d.fillRect(20, 20, d.width - 40, d.height - 40);
        this._g2d.setColor(Color.BLACK);
        this._g2d.drawRect(20, 20, d.width - 40, d.height - 40);
        this._g2d.setClip(20, 20, d.width - 40, d.height - 40);
        int x = 25;
        int y = 20 + fm.getHeight();
        this._g2d.drawString(Messages.getString("JavaxImageIOWriter.exception.caption", this.getULocale()), x, y);
        this._g2d.setColor(Color.RED);
        this._g2d.drawString(sException, x += fm.stringWidth(Messages.getString("JavaxImageIOWriter.exception.caption", this.getULocale())) + 5, y);
        x = 25;
        y += fm.getHeight();
        if (sWrappedException != null) {
            this._g2d.setColor(Color.BLACK);
            this._g2d.drawString(Messages.getString("JavaxImageIOWriter.wrapped.caption", this.getULocale()), x, y);
            this._g2d.setColor(Color.RED);
            this._g2d.drawString(sWrappedException, x += fm.stringWidth(Messages.getString("JavaxImageIOWriter.wrapped.caption", this.getULocale())) + 5, y);
            x = 25;
            y += fm.getHeight();
        }
        this._g2d.setColor(Color.BLACK);
        this._g2d.drawString(Messages.getString("JavaxImageIOWriter.message.caption", this.getULocale()), x, y += 10);
        this._g2d.setColor(Color.BLUE);
        this._g2d.drawString(sMessage, x += fm.stringWidth(Messages.getString("JavaxImageIOWriter.message.caption", this.getULocale())) + 5, y);
        x = 25;
        y += fm.getHeight();
        this._g2d.setColor(Color.BLACK);
        this._g2d.drawString(Messages.getString("JavaxImageIOWriter.trace.caption", this.getULocale()), x, y += 10);
        x = 40;
        y += fm.getHeight();
        this._g2d.setColor(Color.GREEN.darker());
        int i = 0;
        while (i < stea.length) {
            this._g2d.drawString(Messages.getString("JavaxImageIOWriter.trace.detail", new Object[]{stea[i].getClassName(), stea[i].getMethodName(), String.valueOf(stea[i].getLineNumber())}, this.getULocale()), x, y);
            x = 40;
            y += fm.getHeight();
            ++i;
        }
    }

    protected String eval2HTML(String expr) {
        if (expr == null) {
            return "";
        }
        StringBuffer result = null;
        char[] s2char = expr.toCharArray();
        int i = 0;
        int max = s2char.length;
        int delta = 0;
        while (i < max) {
            char c = s2char[i];
            String replacement = null;
            if (!(c == '\t' || c == '\n' || c == '\r' || c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd')) {
                replacement = "";
            }
            if (c == '&') {
                replacement = "&amp;";
            } else if (c == '\"') {
                replacement = "&#34;";
            } else if (c == '\r') {
                replacement = "&#13;";
            } else if (c == '<') {
                replacement = "&lt;";
            } else if (c >= '\u0080') {
                replacement = "&#x" + Integer.toHexString(c) + ';';
            }
            if (replacement != null) {
                if (result == null) {
                    result = new StringBuffer(expr);
                }
                result.replace(i + delta, i + delta + 1, replacement);
                delta += replacement.length() - 1;
            }
            ++i;
        }
        if (result == null) {
            return expr;
        }
        return result.toString();
    }

    protected String eval2JS(String expr, boolean bCallback) {
        if (expr == null) {
            return "";
        }
        if (bCallback) {
            return expr;
        }
        return JavascriptEvalUtil.transformToJsConstants((String)expr);
    }

    private void userCallback(ShapedAction sa, StringBuffer sb) {
        this.addCallbackMethod(sa, sb, TriggerCondition.ONCLICK_LITERAL);
        this.addCallbackMethod(sa, sb, TriggerCondition.ONDBLCLICK_LITERAL);
        this.addCallbackMethod(sa, sb, TriggerCondition.ONMOUSEOVER_LITERAL);
        this.addCallbackMethod(sa, sb, TriggerCondition.ONFOCUS_LITERAL);
        this.addCallbackMethod(sa, sb, TriggerCondition.ONBLUR_LITERAL);
        if (this.hasMultipleMenu && !this.hasAddedMenuLib) {
            sb.insert(0, "<Script>" + MultiActionValuesScriptGenerator.getBirtChartMenuLib() + "</Script>");
            this.hasAddedMenuLib = true;
        }
    }

    private void addCallbackMethod(ShapedAction sa, StringBuffer sb, TriggerCondition condition) {
        String functionName = this.getJSMethodName(condition, sa);
        String key = String.valueOf(condition.getLiteral()) + functionName;
        if (!this.callbackMethodsRegistry.containsKey(key)) {
            this.addScriptCallBack(sa, sb, sa.getActionForCondition(condition), functionName);
            this.callbackMethodsRegistry.put(key, Boolean.TRUE);
        }
    }

    private void addScriptCallBack(ShapedAction sa, StringBuffer sb, Action ac, String functionName) {
        if (ac != null) {
            if (ac instanceof MultipleActions) {
                if (((MultipleActions)ac).getActions().size() > 1) {
                    sb.append(this.wrapJSMethod(functionName, this.generateJSContent(ac)));
                }
            } else if (ac.getType().getValue() == 3) {
                sb.append(this.wrapJSMethod(functionName, this.generateJSContent(ac)));
            } else if (ac.getType().getValue() == 0 && ac.getValue() instanceof MultiURLValues && ((MultiURLValues)ac.getValue()).getURLValues().size() > 1) {
                sb.append(this.wrapJSMethod(functionName, this.generateJSContent(ac)));
            }
        }
    }

    private String generateUniqueJSKey(Action ac) {
        if (ac == null) {
            return "";
        }
        if (ac instanceof MultipleActions) {
            EList subActions = ((MultipleActions)ac).getActions();
            if (subActions.size() <= 1) {
                return this.generateJSContent((Action)subActions.get(0));
            }
            return String.valueOf(MultiActionValuesScriptGenerator.getJSKey((MultipleActions)ac)) + this.hashCode();
        }
        if (ac.getValue() instanceof MultiURLValues) {
            MultiURLValues values = (MultiURLValues)ac.getValue();
            if (values.getURLValues().size() <= 1) {
                return this.generateJSContent(ac);
            }
            return String.valueOf(MultiActionValuesScriptGenerator.getJSKey((ActionValue)values)) + this.hashCode();
        }
        return this.generateJSContent(ac);
    }

    /*
     * Enabled aggressive block sorting
     */
    private String generateJSContent(Action ac) {
        if (ac != null) {
            if (ac instanceof MultipleActions) {
                List<Action> validActions = MultiActionValuesScriptGenerator.getValidActions((MultipleActions)ac);
                if (validActions.size() == 0) {
                    return "";
                }
                if (validActions.size() != 1) {
                    this.hasMultipleMenu = true;
                    return MultiActionValuesScriptGenerator.getJSContent((MultipleActions)ac);
                }
                ActionValue av = validActions.get(0).getValue();
                if (av instanceof URLValue) {
                    return this.getJsURLRedirect((URLValue)av);
                }
                if (av instanceof ScriptValue) {
                    return ((ScriptValue)av).getScript();
                }
            } else if (ac.getType().getValue() == 3) {
                ScriptValue sv = (ScriptValue)ac.getValue();
                return sv.getScript();
            }
            if (ac.getType().getValue() == 0) {
                ActionValue value = ac.getValue();
                if (value instanceof URLValue) {
                    URLValue uv = (URLValue)ac.getValue();
                    return this.getJsURLRedirect(uv);
                }
                if (value instanceof MultiURLValues) {
                    List<URLValue> validURLValues = MultiActionValuesScriptGenerator.getValidURLValues((MultiURLValues)value);
                    if (validURLValues.size() == 0) {
                        return "";
                    }
                    if (validURLValues.size() == 1) {
                        return this.getJsURLRedirect(validURLValues.get(0));
                    }
                    this.hasMultipleMenu = true;
                    return MultiActionValuesScriptGenerator.getJSContent(value);
                }
            }
        }
        return "";
    }

    private String wrapJSMethod(String functionName, String functionContent) {
        return "<Script>function " + functionName + "(evt," + "categoryData" + ", " + "valueData" + ", " + "valueSeriesName" + ", " + "legendItemText" + ", " + "legendItemValue" + ", " + "axisLabel" + "){" + this.eval2JS(functionContent, true) + "};</Script>";
    }

    private String getJSMethodName(TriggerCondition tc, ShapedAction sa) {
        int hashCode = this.generateUniqueJSKey(sa.getActionForCondition(tc)).hashCode();
        if (hashCode != Integer.MIN_VALUE) {
            return "userCallBack" + Math.abs(hashCode);
        }
        return "userCallBack2147483647";
    }

    private void addCallBackScript(ShapedAction sa, StringBuffer callbackFunction) {
        StructureSource source = sa.getSource();
        DataPointHints dph = StructureType.SERIES_DATA_POINT.equals(source.getType()) ? (DataPointHints)source.getSource() : null;
        LegendItemHints lerh = StructureType.LEGEND_ENTRY.equals(source.getType()) ? (LegendItemHints)source.getSource() : null;
        String axisLabel = StructureType.AXIS_LABEL.equals(source.getType()) ? (String)source.getSource() : null;
        callbackFunction.append("(event");
        ScriptUtil.script(callbackFunction, dph, lerh, axisLabel);
        callbackFunction.append(");");
    }
}

