/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.computation.withaxes;

import java.util.EnumSet;
import java.util.Map;
import org.eclipse.birt.chart.computation.LabelLimiter;
import org.eclipse.birt.chart.computation.LegendItemRenderingHints;
import org.eclipse.birt.chart.computation.withaxes.AllAxes;
import org.eclipse.birt.chart.computation.withaxes.AutoScale;
import org.eclipse.birt.chart.computation.withaxes.IAxisAdjuster;
import org.eclipse.birt.chart.computation.withaxes.IntersectionValue;
import org.eclipse.birt.chart.computation.withaxes.OneAxis;
import org.eclipse.birt.chart.computation.withaxes.PlotWithAxes;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.render.AxesRenderer;
import org.eclipse.birt.chart.render.IAxesDecorator;
import org.eclipse.birt.chart.util.ChartUtil;

public class HorizontalAxisAdjuster
implements IAxisAdjuster {
    private OneAxis fVerticalAxis;
    private OneAxis fHorizontalAxis;
    private PlotWithAxes fPlotWithAxes;
    private Bounds fPlotBounds;
    private double fAxisY;
    private double fAxisBottom;
    private double fAxisTop;
    private int iXLabelLocation;
    private int iYLabelLocation;
    private int iXTitleLocation;
    private Label laYAxisLabels;
    private double dXAxisLabelsThickness;
    private double[] dDecorationThickness = new double[]{0.0, 0.0};
    private double dXAxisTitleThickness = 0.0;
    private boolean bTicksAbove;
    private boolean bTicksBelow;
    private double dAppliedXAxisPlotSpacing;
    private double dHTotal;

    public HorizontalAxisAdjuster(OneAxis horizontalAxis, OneAxis verticalAxis, PlotWithAxes plotWithAxes, Bounds boPlot) {
        this.fVerticalAxis = verticalAxis;
        this.fHorizontalAxis = horizontalAxis;
        this.fPlotWithAxes = plotWithAxes;
        this.fPlotBounds = boPlot;
    }

    public double getAxisY() {
        return this.fAxisY;
    }

    public double getAxisTopEdge() {
        return this.fAxisTop;
    }

    public double getAxisBottomEdge() {
        return this.fAxisBottom;
    }

    public void adjust() throws ChartException {
        this.init();
        boolean bForwardScale = this.fHorizontalAxis.getScale().getDirection() == 1;
        IntersectionValue iv = this.fHorizontalAxis.getIntersectionValue();
        if (bForwardScale && iv.iType == 2 || !bForwardScale && iv.iType == 1) {
            this.computeYLocationWithMinOrigin();
        } else if (bForwardScale && iv.iType == 1 || !bForwardScale && iv.iType == 2) {
            this.computeYLocationWithMaxOrigin();
        } else {
            this.computeYLocatoinWithValueOrigin();
        }
    }

    private void init() throws ChartException {
        double dFixedLabelThickness;
        IDisplayServer ids = this.fPlotWithAxes.getDisplayServer();
        RunTimeContext rtc = this.fPlotWithAxes.getRunTimeContext();
        AllAxes aax = this.fPlotWithAxes.aax;
        OneAxis axPH = this.fHorizontalAxis;
        OneAxis axPV = this.fVerticalAxis;
        AutoScale scX = axPH.getScale();
        AutoScale scY = axPV.getScale();
        this.iXLabelLocation = axPH.getLabelPosition();
        this.iYLabelLocation = axPV.getLabelPosition();
        this.iXTitleLocation = axPH.getTitlePosition();
        Label laXAxisTitle = axPH.getTitle();
        Label laXAxisLabels = axPH.getLabel();
        this.laYAxisLabels = axPV.getLabel();
        int iXTickStyle = axPH.getCombinedTickStyle();
        IntersectionValue iv = axPH.getIntersectionValue();
        this.dXAxisLabelsThickness = scX.computeAxisLabelThickness(ids, axPH.getLabel(), 0);
        double dStart = scX.getStart();
        double dEnd = scX.getEnd();
        scX.computeTicks(ids, laXAxisLabels, this.iXLabelLocation, 0, dStart, dEnd, true, aax);
        if (!scX.isStepFixed()) {
            Object[] oaMinMax = scX.getMinMax();
            while (!scX.checkFit(ids, laXAxisLabels, this.iXLabelLocation)) {
                if (!scX.zoomOut()) break;
                scX.updateAxisMinMax(oaMinMax[0], oaMinMax[1]);
                int tickCount = scX.computeTicks(ids, laXAxisLabels, this.iXLabelLocation, 0, dStart, dEnd, true, aax);
                if (scX.getUnit() != null && PlotWithAxes.asInteger(scX.getUnit()) == 1 && tickCount <= 3 || this.fPlotWithAxes.isSharedScale()) break;
            }
        }
        Series[] sea = this.fPlotWithAxes.getModel().getSeries(2);
        Map<Series, LegendItemRenderingHints> seriesRenderingHints = rtc.getSeriesRenderers();
        int i = 0;
        while (i < sea.length) {
            IAxesDecorator iad;
            LegendItemRenderingHints lirh = seriesRenderingHints.get(sea[i]);
            if (lirh != null && lirh.getRenderer() instanceof AxesRenderer && (iad = ((AxesRenderer)lirh.getRenderer()).getAxesDecorator(axPH)) != null) {
                double[] thickness = iad.computeDecorationThickness(ids, axPH);
                if (thickness[0] > this.dDecorationThickness[0]) {
                    this.dDecorationThickness[0] = thickness[0];
                }
                if (thickness[1] > this.dDecorationThickness[1]) {
                    this.dDecorationThickness[1] = thickness[1];
                }
            }
            ++i;
        }
        if (laXAxisTitle.isVisible()) {
            String sPreviousValue = laXAxisTitle.getCaption().getValue();
            laXAxisTitle.getCaption().setValue(rtc.externalizedMessage(sPreviousValue));
            double maxWidth = Math.abs(scX.getEnd() - scX.getStart());
            double maxHeight = 0.3 * this.fPlotBounds.getHeight();
            LabelLimiter lblLimit = new LabelLimiter(maxWidth, maxHeight, 0.0);
            lblLimit.computeWrapping(ids, laXAxisTitle);
            lblLimit = lblLimit.limitLabelSize(this.fPlotWithAxes.getChartComputation(), ids, laXAxisTitle, EnumSet.of(LabelLimiter.Option.FIX_WIDTH));
            this.fPlotWithAxes.putLabelLimiter(axPH.getModelAxis().getTitle(), lblLimit);
            this.dXAxisTitleThickness = lblLimit.getMaxHeight();
            laXAxisTitle.getCaption().setValue(sPreviousValue);
        }
        this.dHTotal = Math.abs(scY.getStart() - scY.getEnd());
        if (axPH.getModelAxis().isSetLabelSpan() && (dFixedLabelThickness = axPH.getModelAxis().getLabelSpan() * this.fPlotWithAxes.getPointToPixel()) < this.dHTotal - 2.0 * this.fPlotWithAxes.getTickSize()) {
            if (this.dXAxisTitleThickness + this.dXAxisLabelsThickness > dFixedLabelThickness) {
                axPH.setShowLabels(false);
            }
            if (this.dXAxisTitleThickness > dFixedLabelThickness) {
                laXAxisTitle.setVisible(false);
                this.dXAxisLabelsThickness = 0.0;
            }
            this.dXAxisLabelsThickness = dFixedLabelThickness;
        }
        this.bTicksAbove = (iXTickStyle & 1) == 1;
        this.bTicksBelow = (iXTickStyle & 2) == 2;
        this.dAppliedXAxisPlotSpacing = iv.iType == 1 || iv.iType == 2 ? this.fPlotWithAxes.getHorizontalSpacingInPixels() : 0.0;
    }

    private void computeYLocationWithMinOrigin() throws ChartException, IllegalArgumentException {
        double dY;
        IntersectionValue iv = this.fHorizontalAxis.getIntersectionValue();
        double dY1 = dY = PlotWithAxes.getLocation(this.fVerticalAxis.getScale(), iv);
        double dY2 = dY;
        this.dHTotal -= this.dAppliedXAxisPlotSpacing;
        dY1 = dY -= this.dAppliedXAxisPlotSpacing;
        dY2 = dY;
        double dTickSize = this.fPlotWithAxes.getTickSize();
        if (this.bTicksAbove && dTickSize <= this.dHTotal) {
            dY1 -= dTickSize;
            this.dHTotal -= dTickSize;
        } else {
            dTickSize = 0.0;
        }
        double dH1 = 0.0;
        double dH2 = 0.0;
        if (this.iXLabelLocation == 4) {
            dH1 = Math.max(this.dXAxisLabelsThickness, this.dDecorationThickness[0]);
            dH2 = Math.max(this.bTicksBelow ? this.fPlotWithAxes.getTickSize() : 0.0, this.dAppliedXAxisPlotSpacing);
        } else if (this.iXLabelLocation == 8) {
            dH1 = this.dDecorationThickness[0];
            dH2 += Math.max((this.bTicksBelow ? this.fPlotWithAxes.getTickSize() : 0.0) + this.dXAxisLabelsThickness, this.dAppliedXAxisPlotSpacing);
        }
        if (dH1 + dH2 <= this.dHTotal) {
            dY1 -= dH1;
            dY2 += dH2;
            this.dHTotal -= dH1 + dH2;
        } else {
            this.fHorizontalAxis.setShowLabels(false);
        }
        if (this.iXTitleLocation == 4) {
            dY1 -= this.dXAxisTitleThickness;
        } else if (this.iXTitleLocation == 8) {
            dY2 += this.dXAxisTitleThickness;
        }
        double dBlockY = this.fPlotBounds.getTop();
        if (dY1 < dBlockY) {
            double dDelta = dBlockY - dY1;
            dY1 = dBlockY;
            dY += dDelta;
            dY2 += dDelta;
        }
        this.fAxisY = dY;
        this.fAxisTop = dY1;
        this.fAxisBottom = dY2;
    }

    private void computeYLocationWithMaxOrigin() throws ChartException, IllegalArgumentException {
        double dXLabelHeight;
        double dY;
        IntersectionValue iv = this.fHorizontalAxis.getIntersectionValue();
        double dY1 = dY = PlotWithAxes.getLocation(this.fVerticalAxis.getScale(), iv);
        double dY2 = dY;
        this.dHTotal -= this.dAppliedXAxisPlotSpacing;
        dY1 = dY += this.dAppliedXAxisPlotSpacing;
        dY2 = dY;
        double dTickSize = this.fPlotWithAxes.getTickSize();
        if (this.bTicksBelow && dTickSize < this.dHTotal) {
            dY2 += dTickSize;
            this.dHTotal -= dTickSize;
        } else {
            dTickSize = 0.0;
        }
        if (this.iXLabelLocation == 4) {
            dXLabelHeight = Math.max((this.bTicksAbove ? dTickSize : 0.0) + this.dXAxisLabelsThickness, this.dAppliedXAxisPlotSpacing);
            if (dXLabelHeight + this.dDecorationThickness[1] < this.dHTotal) {
                dY1 -= dXLabelHeight;
                dY2 += this.dDecorationThickness[1];
                this.dHTotal -= dXLabelHeight + this.dDecorationThickness[1];
            } else {
                dXLabelHeight = 0.0;
                this.fHorizontalAxis.setShowLabels(false);
            }
        } else if (this.iXLabelLocation == 8) {
            double dHt1;
            dXLabelHeight = Math.max(this.dXAxisLabelsThickness, this.dDecorationThickness[1]);
            if (dXLabelHeight + (dHt1 = Math.max(this.bTicksAbove ? dTickSize : 0.0, this.dAppliedXAxisPlotSpacing)) <= this.dHTotal) {
                dY2 += dXLabelHeight;
                dY1 -= dHt1;
                this.dHTotal -= dXLabelHeight + dHt1;
            } else {
                dXLabelHeight = 0.0;
                this.fHorizontalAxis.setShowLabels(false);
            }
        }
        if (this.iXTitleLocation == 4) {
            dY1 -= this.dXAxisTitleThickness;
        } else if (this.iXTitleLocation == 8) {
            dY2 += this.dXAxisTitleThickness;
        }
        double dBlockY = this.fPlotBounds.getTop();
        double dBlockHeight = this.fPlotBounds.getHeight();
        if (dY2 > dBlockY + dBlockHeight) {
            double dDelta = dY2 - (dBlockY + dBlockHeight);
            dY2 = dBlockY + dBlockHeight;
            dY -= dDelta;
            dY1 -= dDelta;
        }
        this.fAxisY = dY;
        this.fAxisTop = dY1;
        this.fAxisBottom = dY2;
    }

    private void computeYLocatoinWithValueOrigin() throws ChartException, IllegalArgumentException {
        double dY;
        IntersectionValue iv = this.fHorizontalAxis.getIntersectionValue();
        double dY1 = dY = PlotWithAxes.getLocation(this.fVerticalAxis.getScale(), iv);
        double dY2 = dY;
        double dDeltaY1 = 0.0;
        double dDeltaY2 = 0.0;
        double dBlockY = this.fPlotBounds.getTop();
        double dBlockHeight = this.fPlotBounds.getHeight();
        AutoScale scY = this.fVerticalAxis.getScale();
        boolean bForwardScale = this.fHorizontalAxis.getScale().getDirection() == 1;
        IDisplayServer ids = this.fPlotWithAxes.getDisplayServer();
        if (this.iXLabelLocation == 4) {
            double dH2;
            double dH1 = (this.bTicksAbove ? this.fPlotWithAxes.getTickSize() : 0.0) + Math.max(this.dXAxisLabelsThickness, this.dDecorationThickness[0]);
            double d = dH2 = this.bTicksBelow ? this.fPlotWithAxes.getTickSize() : 0.0;
            if (dH1 + dH2 <= this.dHTotal) {
                dY1 -= dH1;
                dY2 += dH2;
                this.dHTotal -= dH1 + dH2;
            } else {
                this.fHorizontalAxis.setShowLabels(false);
            }
            if (this.iXTitleLocation == 4) {
                dY1 -= this.dXAxisTitleThickness;
            } else if (this.iXTitleLocation == 8) {
                dY2 += this.dXAxisTitleThickness;
            }
            dDeltaY1 = dY - dY1;
            dDeltaY2 = dY2 - dY;
            if (dY1 < dBlockY) {
                Object[] oaMinMax = scY.getMinMax();
                boolean bForceBreak = false;
                do {
                    double dStart;
                    double dEnd;
                    double dAMin_RI;
                    double dAMin_AMax;
                    scY.setEndPoints(scY.getStart() + scY.getStartShift(), scY.getEnd() - scY.getEndShift());
                    scY.resetShifts();
                    double[] da = scY.getEndPoints();
                    double dT_RI = dBlockY - dY1;
                    if (bForwardScale) {
                        dAMin_AMax = da[1] - da[0];
                        dAMin_RI = da[1] - dY;
                        dEnd = da[1];
                        dStart = dT_RI / dAMin_RI * dAMin_AMax + da[0];
                        if (dStart < dBlockY) {
                            dStart = dBlockY;
                            bForceBreak = true;
                        }
                    } else {
                        dAMin_AMax = da[0] - da[1];
                        dAMin_RI = da[0] - dY;
                        dStart = da[0];
                        dEnd = dT_RI / dAMin_RI * dAMin_AMax + da[1];
                        if (dEnd < dBlockY) {
                            dEnd = dBlockY;
                            bForceBreak = true;
                        }
                    }
                    scY.setEndPoints(dStart, dEnd);
                    scY.computeTicks(ids, this.laYAxisLabels, this.iYLabelLocation, 1, dStart, dEnd, true, this.fPlotWithAxes.getAxes());
                    if (!scY.isStepFixed()) {
                        while (!scY.checkFit(ids, this.laYAxisLabels, this.iYLabelLocation)) {
                            if (!scY.zoomOut()) {
                                bForceBreak = true;
                                break;
                            }
                            scY.updateAxisMinMax(oaMinMax[0], oaMinMax[1]);
                            int tickCount = scY.computeTicks(ids, this.laYAxisLabels, this.iYLabelLocation, 1, dStart, dEnd, true, this.fPlotWithAxes.getAxes());
                            if ((scY.getUnit() == null || PlotWithAxes.asInteger(scY.getUnit()) != 1 || tickCount > 3) && !this.fPlotWithAxes.isSharedScale()) continue;
                            bForceBreak = true;
                            break;
                        }
                    }
                    dY = PlotWithAxes.getLocation(scY, iv);
                    dY1 = dY - dDeltaY1;
                    dY2 = dY + dDeltaY2;
                } while (Math.abs(dY1 - dBlockY) > 1.0 && !bForceBreak);
            }
        } else if (this.iXLabelLocation == 8) {
            double dH2;
            double dH1 = this.bTicksAbove ? this.fPlotWithAxes.getTickSize() : 0.0;
            if (dH1 + (dH2 = (this.bTicksBelow ? this.fPlotWithAxes.getTickSize() : 0.0) + Math.max(this.dXAxisLabelsThickness, this.dDecorationThickness[1])) <= this.dHTotal) {
                dY1 -= dH1;
                dY2 += dH2;
                this.dHTotal -= dH1 + dH2;
            }
            if (this.iXTitleLocation == 4) {
                dY1 -= this.dXAxisTitleThickness;
            } else if (this.iXTitleLocation == 8) {
                dY2 += this.dXAxisTitleThickness;
            }
            dDeltaY1 = dY - dY1;
            dDeltaY2 = dY2 - dY;
            if (dY2 > dBlockY + dBlockHeight) {
                Object[] oaMinMax = scY.getMinMax();
                boolean bForceBreak = false;
                do {
                    double dStart;
                    double dEnd;
                    double dX2_AMax;
                    double dAMin_AMax;
                    scY.setEndPoints(scY.getStart() + scY.getStartShift(), scY.getEnd() - scY.getEndShift());
                    scY.resetShifts();
                    double[] da = scY.getEndPoints();
                    double dX2_X1 = dY2 - (dBlockY + dBlockHeight);
                    if (bForwardScale) {
                        dAMin_AMax = da[1] - da[0];
                        dX2_AMax = dY - da[0];
                        dEnd = da[1] - dX2_X1 / dX2_AMax * dAMin_AMax;
                        dStart = da[0];
                        if (dEnd > dBlockY + dBlockHeight) {
                            dEnd = dBlockY + dBlockHeight;
                            bForceBreak = true;
                        }
                    } else {
                        dAMin_AMax = da[0] - da[1];
                        dX2_AMax = dY - da[1];
                        dStart = da[0] - dX2_X1 / dX2_AMax * dAMin_AMax;
                        dEnd = da[1];
                        if (dStart > dBlockY + dBlockHeight) {
                            dStart = dBlockY + dBlockHeight;
                            bForceBreak = true;
                        }
                    }
                    if (ChartUtil.mathEqual(Math.abs(dEnd - dStart), 0.0)) {
                        bForceBreak = true;
                    }
                    scY.setEndPoints(dStart, dEnd);
                    scY.computeTicks(ids, this.laYAxisLabels, this.iYLabelLocation, 1, dStart, dEnd, true, this.fPlotWithAxes.getAxes());
                    if (!scY.isStepFixed()) {
                        while (!scY.checkFit(ids, this.laYAxisLabels, this.iYLabelLocation)) {
                            if (!scY.zoomOut()) {
                                bForceBreak = true;
                                break;
                            }
                            scY.updateAxisMinMax(oaMinMax[0], oaMinMax[1]);
                            int tickCount = scY.computeTicks(ids, this.laYAxisLabels, this.iYLabelLocation, 1, dStart, dEnd, true, this.fPlotWithAxes.getAxes());
                            if ((scY.getUnit() == null || PlotWithAxes.asInteger(scY.getUnit()) != 1 || tickCount > 3) && !this.fPlotWithAxes.isSharedScale()) continue;
                            bForceBreak = true;
                            break;
                        }
                    }
                    dY = PlotWithAxes.getLocation(scY, iv);
                    dY2 = dY + dDeltaY2;
                    dY1 = dY - dDeltaY1;
                } while (Math.abs(dY2 - (dBlockY + dBlockHeight)) > 1.0 && !bForceBreak);
            }
        }
        this.fAxisY = dY;
        this.fAxisTop = dY1;
        this.fAxisBottom = dY2;
    }

    public OneAxis getHorizontalAxis() {
        return this.fHorizontalAxis;
    }

    public double getAxisLabelThickness() {
        return this.dXAxisLabelsThickness;
    }

    public double getAxisTitleThickness() {
        return this.dXAxisTitleThickness;
    }
}

