/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.plugin;

import org.eclipse.birt.chart.computation.ChartComputationFactory;
import org.eclipse.birt.chart.computation.GObjectFactory;
import org.eclipse.birt.chart.computation.IChartComputationFactory;
import org.eclipse.birt.chart.device.IImageWriterFactory;
import org.eclipse.birt.chart.device.IScriptMenuHelper;
import org.eclipse.birt.chart.device.ImageWriterFactory;
import org.eclipse.birt.chart.device.ScriptMenuHelper;
import org.eclipse.birt.chart.internal.log.JavaUtilLoggerImpl;
import org.eclipse.birt.chart.model.IChartModelHelper;
import org.eclipse.birt.chart.model.impl.ChartModelHelper;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.BundleContext;

public class ChartEnginePlugin
extends Plugin {
    public static final String ID = "org.eclipse.birt.chart.engine";

    public void start(BundleContext context) throws Exception {
        super.start(context);
        JavaUtilLoggerImpl.setStateDir(this.getStateLocation().toOSString());
        ChartEnginePlugin.initChartComputation(this);
        ChartEnginePlugin.initImageWriterFactory(this);
        ChartEnginePlugin.initChartModelHelper(this);
        ChartEnginePlugin.initChartScriptMenuHelper(this);
    }

    private static void initChartScriptMenuHelper(ChartEnginePlugin plugin) {
        IScriptMenuHelper factory = ChartUtil.getAdapter((Object)plugin, IScriptMenuHelper.class);
        if (factory != null) {
            ScriptMenuHelper.initInstance(factory);
        }
    }

    private static void initChartComputation(ChartEnginePlugin plugin) {
        IChartComputationFactory factory = ChartUtil.getAdapter((Object)plugin, IChartComputationFactory.class);
        if (factory != null) {
            ChartComputationFactory.initInstance(factory);
            GObjectFactory.initInstance(factory.createGObjectFactory());
        }
    }

    private static void initImageWriterFactory(ChartEnginePlugin plugin) {
        IImageWriterFactory factory = ChartUtil.getAdapter((Object)plugin, IImageWriterFactory.class);
        if (factory != null) {
            ImageWriterFactory.initInstance(factory);
        }
    }

    private static void initChartModelHelper(ChartEnginePlugin plugin) {
        IChartModelHelper factory = ChartUtil.getAdapter((Object)plugin, IChartModelHelper.class);
        if (factory != null) {
            ChartModelHelper.initInstance(factory);
        }
    }
}

