/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.composites;

import java.net.URI;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.attribute.Cursor;
import org.eclipse.birt.chart.model.attribute.Image;
import org.eclipse.birt.chart.model.attribute.impl.ImageImpl;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.composites.IconCanvas;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.ui.util.UIHelper;
import org.eclipse.birt.core.ui.frameworks.taskwizard.WizardBase;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CursorImageDialog
extends TrayDialog
implements SelectionListener {
    private Composite inputArea;
    private IconCanvas previewCanvas;
    private Text txtUriEditor;
    private Button btnUriBuilder;
    private Cursor cursor;
    private Label title;
    private ChartWizardContext context;

    public CursorImageDialog(Shell parentShell, ChartWizardContext context, Cursor cursor) {
        super(parentShell);
        this.context = context;
        this.cursor = cursor;
    }

    protected Control createContents(Composite parent) {
        Control ct = super.createContents(parent);
        this.initDialog();
        return ct;
    }

    protected Control createDialogArea(Composite parent) {
        Composite topCompostie = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(topCompostie, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.createInputArea(composite);
        this.createPreviewArea(composite);
        new Label(topCompostie, 258).setLayoutData((Object)new GridData(768));
        return topCompostie;
    }

    private void createInputArea(Composite parent) {
        this.inputArea = new Composite(parent, 0);
        GridData gd = new GridData(768);
        this.inputArea.setLayoutData((Object)gd);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        this.inputArea.setLayout((Layout)gl);
        this.title = new Label(this.inputArea, 0);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.title.setLayoutData((Object)gd);
        this.txtUriEditor = new Text(this.inputArea, 2052);
        this.txtUriEditor.setLayoutData((Object)new GridData(768));
        this.txtUriEditor.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CursorImageDialog.this.updateButtons();
            }
        });
        this.txtUriEditor.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                CursorImageDialog.this.preview(CursorImageDialog.this.txtUriEditor.getText());
            }
        });
        this.btnUriBuilder = new Button(this.inputArea, 8);
        gd = new GridData();
        ChartUIUtil.setChartImageButtonSizeByPlatform((GridData)gd);
        this.btnUriBuilder.setLayoutData((Object)gd);
        this.btnUriBuilder.setImage(UIHelper.getImage((String)"icons/obj16/expressionbuilder.gif"));
        this.btnUriBuilder.addSelectionListener((SelectionListener)this);
    }

    private void createPreviewArea(Composite composite) {
        Composite previewArea = new Composite(composite, 2048);
        GridData gd = new GridData(1808);
        gd.widthHint = 250;
        gd.heightHint = 200;
        previewArea.setLayoutData((Object)gd);
        previewArea.setLayout((Layout)new FillLayout());
        this.previewCanvas = new IconCanvas(previewArea);
    }

    protected void okPressed() {
        if (this.cursor.getImage().size() > 0) {
            this.cursor.getImage().clear();
        }
        this.cursor.getImage().add(0, (Object)ImageImpl.create((String)this.txtUriEditor.getText()));
        super.okPressed();
    }

    protected boolean initDialog() {
        this.getShell().setText(Messages.getString("ImageDialog.label.SelectImage"));
        this.title.setText(Messages.getString("ImageDialog.label.EnterURL"));
        this.getButton(0).setEnabled(false);
        this.initURIEditor();
        return true;
    }

    private void initURIEditor() {
        String uri = "";
        if (this.cursor.getImage().size() > 0) {
            uri = ((Image)this.cursor.getImage().get(0)).getURL();
        }
        this.txtUriEditor.setText(uri);
        this.txtUriEditor.setFocus();
        this.updateButtons();
        this.preview(this.txtUriEditor.getText());
    }

    private void updateButtons() {
        this.getButton(0).setEnabled(true);
    }

    public String removeQuote(String string) {
        if (string != null && string.length() >= 2 && string.startsWith("\"") && string.endsWith("\"")) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    private void preview(String uri) {
        try {
            this.previewCanvas.loadImage(new URI(uri).toURL());
        }
        catch (Exception exception) {}
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        Object source = e.getSource();
        if (source == this.btnUriBuilder) {
            try {
                String sExpr = this.context.getUIServiceProvider().invoke(1, this.txtUriEditor.getText(), this.context.getExtendedItem(), this.title.getText());
                this.txtUriEditor.setText(sExpr == null ? "" : sExpr);
            }
            catch (ChartException e1) {
                WizardBase.displayException((Throwable)e1);
            }
        }
    }
}

