/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.composites;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.data.DataPackage;
import org.eclipse.birt.chart.model.data.Query;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.SeriesGrouping;
import org.eclipse.birt.chart.model.data.impl.SeriesGroupingImpl;
import org.eclipse.birt.chart.ui.swt.composites.GroupSortingDialog;
import org.eclipse.birt.chart.ui.swt.composites.SeriesGroupingComposite;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;

public class YOptionalGroupSortingDialog
extends GroupSortingDialog {
    public YOptionalGroupSortingDialog(Shell shell, ChartWizardContext wizardContext, SeriesDefinition sd, boolean disableAggregation, boolean hasExprBuilder) {
        super(shell, wizardContext, sd, disableAggregation, hasExprBuilder);
    }

    public void handleEvent(Event event) {
        super.handleEvent(event);
        if (event.widget == this.cmbSorting) {
            this.populateSortKeyList();
        } else if (event.widget == this.cmbSortExpr) {
            this.getSeriesDefinitionForProcessing().getSortKey().setDefinition(this.cmbSortExpr.getText());
        }
    }

    protected void populateLists() {
        super.populateLists();
        this.populateSortKeyList();
    }

    private void populateSortKeyList() {
        this.initSortKey();
        LinkedHashSet<String> exprList = new LinkedHashSet<String>();
        String sortExpr = null;
        if (!this.isYGroupingEnabled() || this.cmbSorting.getText().equals(UNSORTED_OPTION)) {
            this.getSeriesDefinitionForProcessing().eUnset((EStructuralFeature)DataPackage.eINSTANCE.getSeriesDefinition_Sorting());
            exprList.add("");
        } else {
            exprList.addAll(this.getYGroupingExpressions());
            exprList.addAll(this.getValueSeriesExpressions());
            sortExpr = this.getSeriesDefinitionForProcessing().getSortKey().getDefinition();
            this.setSortKeySelectionState(true);
        }
        if (sortExpr != null && !"".equals(sortExpr)) {
            exprList.add(sortExpr);
        }
        this.cmbSortExpr.removeAll();
        Iterator iter = exprList.iterator();
        while (iter.hasNext()) {
            this.cmbSortExpr.add((String)iter.next());
        }
        if (sortExpr != null && !"".equals(sortExpr)) {
            this.cmbSortExpr.setText(sortExpr);
        } else {
            this.cmbSortExpr.select(0);
        }
        this.setSortKeyInModel();
    }

    public void createSortArea(Composite parent) {
        super.createSortArea(parent);
        if (!this.isYGroupingEnabled()) {
            this.lblSorting.setEnabled(false);
            this.cmbSorting.setEnabled(false);
            this.lblSortExpr.setEnabled(false);
            this.cmbSortExpr.setEnabled(false);
        }
    }

    protected SeriesGroupingComposite createSeriesGroupingComposite(Composite parent) {
        SeriesGrouping grouping = this.getSeriesDefinitionForProcessing().getQuery().getGrouping();
        if (grouping == null) {
            grouping = SeriesGroupingImpl.create();
            this.getSeriesDefinitionForProcessing().getQuery().setGrouping(grouping);
        }
        YSeriesGroupingComposite sgc = new YSeriesGroupingComposite(parent, 0, grouping, this.fEnableAggregation, this.wizardContext, null);
        sgc.setGroupingButtionEnabled(false);
        return sgc;
    }

    protected Set getYGroupingExpressions() {
        LinkedHashSet<String> exprList = new LinkedHashSet<String>();
        Chart chart = this.wizardContext.getModel();
        if (chart instanceof ChartWithAxes) {
            Axis axPrimaryBase = ((ChartWithAxes)chart).getPrimaryBaseAxes()[0];
            Axis[] axaOrthogonal = ((ChartWithAxes)chart).getOrthogonalAxes(axPrimaryBase, true);
            int j = 0;
            while (j < axaOrthogonal.length) {
                EList lstOrthogonalSDs = axaOrthogonal[j].getSeriesDefinitions();
                int k = 0;
                while (k < lstOrthogonalSDs.size()) {
                    SeriesDefinition orthoSD = (SeriesDefinition)lstOrthogonalSDs.get(k);
                    if (orthoSD.getQuery() != null && orthoSD.getQuery().getDefinition() != null) {
                        exprList.add(orthoSD.getQuery().getDefinition());
                    }
                    ++k;
                }
                ++j;
            }
        } else {
            EList lstSDs = ((ChartWithoutAxes)chart).getSeriesDefinitions();
            int i = 0;
            while (i < lstSDs.size()) {
                SeriesDefinition sd = (SeriesDefinition)lstSDs.get(i);
                EList orthSDs = sd.getSeriesDefinitions();
                for (SeriesDefinition orthSD : orthSDs) {
                    if (orthSD.getQuery() == null || orthSD.getQuery().getDefinition() == null) continue;
                    exprList.add(orthSD.getQuery().getDefinition());
                }
                ++i;
            }
        }
        return exprList;
    }

    class YSeriesGroupingComposite
    extends SeriesGroupingComposite {
        public YSeriesGroupingComposite(Composite parent, int style, SeriesGrouping grouping, boolean aggEnabled, ChartWizardContext context, String title) {
            super(parent, style, grouping, aggEnabled, context, title);
        }

        protected void setGroupingButtonSelection() {
            Query query = YOptionalGroupSortingDialog.this.getSeriesDefinitionForProcessing().getQuery();
            if (query != null && query.getDefinition() != null && !"".equals(query.getDefinition())) {
                this.btnEnabled.setSelection(true);
            } else {
                this.btnEnabled.setSelection(false);
            }
        }
    }
}

