/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard.format.popup.chart;

import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.Anchor;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.Insets;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.Stretch;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.composites.FillChooserComposite;
import org.eclipse.birt.chart.ui.swt.composites.InsetsComposite;
import org.eclipse.birt.chart.ui.swt.composites.IntegerSpinControl;
import org.eclipse.birt.chart.ui.swt.composites.LineAttributesComposite;
import org.eclipse.birt.chart.ui.swt.composites.LocalizedNumberEditorComposite;
import org.eclipse.birt.chart.ui.swt.fieldassist.TextNumberEditorAssistField;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.AbstractPopupSheet;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.util.LiteralHelper;
import org.eclipse.birt.chart.util.NameSet;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class PlotClientAreaSheet
extends AbstractPopupSheet
implements Listener,
ModifyListener,
SelectionListener {
    static final int AUTO = -1;
    private transient Composite cmpContent;
    private transient Combo cmbAnchor;
    private transient Combo cmbStretch;
    private transient LineAttributesComposite outlineIncluding;
    private transient LineAttributesComposite outlineWithin;
    private transient InsetsComposite icIncluding;
    private transient InsetsComposite icWithin;
    private transient IntegerSpinControl iscVSpacing;
    private transient IntegerSpinControl iscHSpacing;
    private transient LocalizedNumberEditorComposite txtHeight;
    private transient LocalizedNumberEditorComposite txtWidth;
    private transient FillChooserComposite fccShadow;
    private Button btnHeight;
    private Button btnWidth;

    public PlotClientAreaSheet(String title, ChartWizardContext context) {
        super(title, context, true);
    }

    protected Composite getComponent(Composite parent) {
        ChartUIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.chart.cshelp.AreaFormat_ID");
        this.cmpContent = new Composite(parent, 0);
        this.cmpContent.setLayout((Layout)new GridLayout());
        Group grpAreaIncluding = new Group(this.cmpContent, 0);
        grpAreaIncluding.setLayout((Layout)new GridLayout(2, true));
        GridData gd = new GridData(768);
        grpAreaIncluding.setLayoutData((Object)gd);
        grpAreaIncluding.setText(this.getChart() instanceof ChartWithAxes ? Messages.getString("ChartPlotSheetImpl.Label.AreaIncludingAxes") : Messages.getString("ChartPlotSheetImpl.Label.PlotArea"));
        Composite leftComp = new Composite((Composite)grpAreaIncluding, 0);
        GridData gdL = new GridData(768);
        leftComp.setLayout((Layout)new GridLayout(3, false));
        leftComp.setLayoutData((Object)gdL);
        Composite rightComp = new Composite((Composite)grpAreaIncluding, 0);
        GridData gdR = new GridData(768);
        rightComp.setLayout((Layout)new GridLayout(1, false));
        rightComp.setLayoutData((Object)gdR);
        Label lblAnchor = new Label(leftComp, 0);
        GridData gdLBLAnchor = new GridData();
        lblAnchor.setLayoutData((Object)gdLBLAnchor);
        lblAnchor.setText(Messages.getString("MoreOptionsChartPlotSheet.Label.Anchor"));
        this.cmbAnchor = new Combo(leftComp, 12);
        GridData gdCBAnchor = new GridData(768);
        gdCBAnchor.horizontalSpan = 2;
        this.cmbAnchor.setLayoutData((Object)gdCBAnchor);
        this.cmbAnchor.addSelectionListener((SelectionListener)this);
        Label lblStretch = new Label(leftComp, 0);
        GridData gd2 = new GridData();
        lblStretch.setLayoutData((Object)gd2);
        lblStretch.setText(Messages.getString("MoreOptionsChartPlotSheet.Label.Stretch"));
        this.cmbStretch = new Combo(leftComp, 12);
        gd2 = new GridData(768);
        gd2.horizontalSpan = 2;
        this.cmbStretch.setLayoutData((Object)gd2);
        this.cmbStretch.addSelectionListener((SelectionListener)this);
        Label lblVerticalSpacing = new Label(leftComp, 0);
        lblVerticalSpacing.setLayoutData((Object)new GridData());
        lblVerticalSpacing.setText(Messages.getString("BlockAttributeComposite.Lbl.VerticalSpacing"));
        this.iscVSpacing = new IntegerSpinControl(leftComp, 0, this.getBlockForProcessing().getVerticalSpacing());
        GridData gd3 = new GridData(768);
        gd3.horizontalSpan = 2;
        this.iscVSpacing.setLayoutData(gd3);
        this.iscVSpacing.addListener(this);
        Label lblHorizontalSpacing = new Label(leftComp, 0);
        lblHorizontalSpacing.setLayoutData((Object)new GridData());
        lblHorizontalSpacing.setText(Messages.getString("BlockAttributeComposite.Lbl.HorizontalSpacing"));
        this.iscHSpacing = new IntegerSpinControl(leftComp, 0, this.getBlockForProcessing().getHorizontalSpacing());
        gd3 = new GridData(768);
        gd3.horizontalSpan = 2;
        this.iscHSpacing.setLayoutData(gd3);
        this.iscHSpacing.addListener(this);
        new Label(leftComp, 0).setText(Messages.getString("PlotClientAreaSheet.Label.HeightHint"));
        this.txtHeight = new LocalizedNumberEditorComposite(leftComp, 2048);
        new TextNumberEditorAssistField(this.txtHeight.getTextControl(), null);
        this.txtHeight.setLayoutData(new GridData(768));
        this.txtHeight.addModifyListener(this);
        this.btnHeight = new Button(leftComp, 32);
        this.btnHeight.setText(Messages.getString("PlotClientAreaSheet.Btn.Auto"));
        gd3 = new GridData();
        this.btnHeight.setLayoutData((Object)gd3);
        this.btnHeight.addSelectionListener((SelectionListener)this);
        new Label(leftComp, 0).setText(Messages.getString("PlotClientAreaSheet.Label.WidthHint"));
        this.txtWidth = new LocalizedNumberEditorComposite(leftComp, 2048);
        new TextNumberEditorAssistField(this.txtWidth.getTextControl(), null);
        this.txtWidth.setLayoutData(new GridData(768));
        this.txtWidth.addModifyListener(this);
        this.btnWidth = new Button(leftComp, 32);
        this.btnWidth.setText(Messages.getString("PlotClientAreaSheet.Btn.Auto2"));
        gd3 = new GridData();
        this.btnWidth.setLayoutData((Object)gd3);
        this.btnWidth.addSelectionListener((SelectionListener)this);
        this.updateHeightWidthHint();
        Group grpOutline = new Group(rightComp, 0);
        GridData gdGRPOutline = new GridData(768);
        gdGRPOutline.widthHint = 150;
        grpOutline.setLayoutData((Object)gdGRPOutline);
        grpOutline.setLayout((Layout)new FillLayout());
        grpOutline.setText(Messages.getString("MoreOptionsChartPlotSheet.Label.Outline"));
        this.outlineIncluding = new LineAttributesComposite((Composite)grpOutline, 0, this.getContext(), this.getBlockForProcessing().getOutline(), true, true, false);
        this.outlineIncluding.addListener(this);
        this.icIncluding = new InsetsComposite(rightComp, 0, this.getBlockForProcessing().getInsets(), this.getChart().getUnits(), this.getContext().getUIServiceProvider());
        GridData gdInsets = new GridData(768);
        this.icIncluding.setLayoutData(gdInsets);
        Group grpAreaWithin = new Group(this.cmpContent, 0);
        grpAreaWithin.setLayout((Layout)new GridLayout(4, false));
        gd3 = new GridData(768);
        grpAreaWithin.setLayoutData((Object)gd3);
        grpAreaWithin.setText(this.getChart() instanceof ChartWithAxes ? Messages.getString("ChartPlotSheetImpl.Label.AreaWithinAxes") : Messages.getString("ChartPlotSheetImpl.Label.ClientArea"));
        this.createClientArea(grpAreaWithin);
        this.populateLists();
        return this.cmpContent;
    }

    private void updateHeightWidthHint() {
        double hint;
        if (this.getBlockForProcessing().isSetHeightHint()) {
            hint = this.getBlockForProcessing().getHeightHint();
            if (hint == -1.0) {
                this.btnHeight.setSelection(true);
                this.txtHeight.unsetValue();
                this.txtHeight.setEnabled(false);
            } else {
                this.btnHeight.setSelection(false);
                this.txtHeight.setValue(hint);
            }
        } else {
            this.btnHeight.setSelection(true);
            this.txtHeight.unsetValue();
            this.txtHeight.setEnabled(false);
        }
        if (this.getBlockForProcessing().isSetWidthHint()) {
            hint = this.getBlockForProcessing().getWidthHint();
            if (hint == -1.0) {
                this.btnWidth.setSelection(true);
                this.txtWidth.unsetValue();
                this.txtWidth.setEnabled(false);
            } else {
                this.btnWidth.setSelection(false);
                this.txtWidth.setValue(hint);
            }
        } else {
            this.btnWidth.setSelection(true);
            this.txtWidth.unsetValue();
            this.txtWidth.setEnabled(false);
        }
    }

    private void createClientArea(Group grpAreaWithin) {
        boolean isNot3D = !ChartUIUtil.is3DType((Chart)this.getChart());
        Label lblShadow = new Label((Composite)grpAreaWithin, 0);
        GridData gdLBLShadow = new GridData();
        lblShadow.setLayoutData((Object)gdLBLShadow);
        lblShadow.setText(Messages.getString("ClientAreaAttributeComposite.Lbl.Shadow"));
        lblShadow.setEnabled(isNot3D);
        this.fccShadow = new FillChooserComposite((Composite)grpAreaWithin, 0, this.getContext(), (Fill)this.getBlockForProcessing().getClientArea().getShadowColor(), false, false);
        GridData gdFCCShadow = new GridData(768);
        this.fccShadow.setLayoutData(gdFCCShadow);
        this.fccShadow.addListener(this);
        this.fccShadow.setEnabled(isNot3D);
        Group grpOutline = new Group((Composite)grpAreaWithin, 0);
        GridData gdGRPOutline = new GridData(768);
        gdGRPOutline.horizontalSpan = 2;
        gdGRPOutline.verticalSpan = 2;
        grpOutline.setLayoutData((Object)gdGRPOutline);
        grpOutline.setLayout((Layout)new FillLayout());
        grpOutline.setText(Messages.getString("MoreOptionsChartPlotSheet.Label.Outline"));
        this.outlineWithin = new LineAttributesComposite((Composite)grpOutline, 0, this.getContext(), this.getBlockForProcessing().getClientArea().getOutline(), true, true, false);
        this.outlineWithin.addListener(this);
        this.outlineWithin.setAttributesEnabled(ChartUIUtil.is3DWallFloorSet((Chart)this.getChart()));
        this.icWithin = new InsetsComposite((Composite)grpAreaWithin, 0, this.getBlockForProcessing().getClientArea().getInsets(), this.getChart().getUnits(), this.getContext().getUIServiceProvider());
        GridData gdInsets = new GridData(768);
        gdInsets.horizontalSpan = 2;
        this.icWithin.setLayoutData(gdInsets);
        this.icWithin.setEnabled(isNot3D);
    }

    private void populateLists() {
        NameSet ns = LiteralHelper.anchorSet;
        this.cmbAnchor.setItems(ns.getDisplayNames());
        this.cmbAnchor.select(ns.getSafeNameIndex(this.getBlockForProcessing().getAnchor().getName()));
        ns = LiteralHelper.stretchSet;
        this.cmbStretch.setItems(ns.getDisplayNames());
        this.cmbStretch.select(ns.getSafeNameIndex(this.getBlockForProcessing().getStretch().getName()));
    }

    public void modifyText(ModifyEvent e) {
        if (e.widget.equals((Object)this.txtHeight)) {
            if (this.txtHeight.isSetValue()) {
                this.getBlockForProcessing().setHeightHint(this.txtHeight.getValue());
            } else {
                this.getBlockForProcessing().unsetHeightHint();
            }
        } else if (e.widget.equals((Object)this.txtWidth)) {
            if (this.txtWidth.isSetValue()) {
                this.getBlockForProcessing().setWidthHint(this.txtWidth.getValue());
            } else {
                this.getBlockForProcessing().unsetWidthHint();
            }
        }
    }

    public void handleEvent(Event event) {
        if (event.widget.equals((Object)this.outlineIncluding)) {
            switch (event.type) {
                case 1: {
                    this.getBlockForProcessing().getOutline().setStyle((LineStyle)event.data);
                    break;
                }
                case 2: {
                    this.getBlockForProcessing().getOutline().setThickness(((Integer)event.data).intValue());
                    break;
                }
                case 3: {
                    this.getBlockForProcessing().getOutline().setColor((ColorDefinition)event.data);
                    break;
                }
                case 4: {
                    this.getBlockForProcessing().getOutline().setVisible(((Boolean)event.data).booleanValue());
                }
            }
        } else if (event.widget.equals((Object)this.outlineWithin)) {
            switch (event.type) {
                case 1: {
                    this.getBlockForProcessing().getClientArea().getOutline().setStyle((LineStyle)event.data);
                    break;
                }
                case 2: {
                    this.getBlockForProcessing().getClientArea().getOutline().setThickness(((Integer)event.data).intValue());
                    break;
                }
                case 3: {
                    this.getBlockForProcessing().getClientArea().getOutline().setColor((ColorDefinition)event.data);
                    break;
                }
                case 4: {
                    this.getBlockForProcessing().getClientArea().getOutline().setVisible(((Boolean)event.data).booleanValue());
                }
            }
        } else if (event.widget.equals((Object)this.fccShadow)) {
            this.getBlockForProcessing().getClientArea().setShadowColor((ColorDefinition)event.data);
        } else if (event.widget.equals((Object)this.iscHSpacing)) {
            this.getBlockForProcessing().setHorizontalSpacing(((Integer)event.data).intValue());
        } else if (event.widget.equals((Object)this.iscVSpacing)) {
            this.getBlockForProcessing().setVerticalSpacing(((Integer)event.data).intValue());
        } else if (event.widget.equals((Object)this.icIncluding)) {
            this.getBlockForProcessing().setInsets((Insets)event.data);
        } else if (event.widget.equals((Object)this.icWithin)) {
            this.getBlockForProcessing().getClientArea().setInsets((Insets)event.data);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        Object oSource = e.getSource();
        if (oSource.equals(this.cmbAnchor)) {
            this.getBlockForProcessing().setAnchor(Anchor.getByName((String)LiteralHelper.anchorSet.getNameByDisplayName(this.cmbAnchor.getText())));
        } else if (oSource.equals(this.cmbStretch)) {
            this.getBlockForProcessing().setStretch(Stretch.getByName((String)LiteralHelper.stretchSet.getNameByDisplayName(this.cmbStretch.getText())));
        } else if (oSource == this.btnHeight) {
            if (this.btnHeight.getSelection()) {
                this.getBlockForProcessing().setHeightHint(-1.0);
                this.txtHeight.setEnabled(false);
            } else {
                this.txtHeight.setEnabled(true);
                if (this.txtHeight.isSetValue()) {
                    this.getBlockForProcessing().setHeightHint(this.txtHeight.getValue());
                } else {
                    this.getBlockForProcessing().unsetHeightHint();
                }
            }
        } else if (oSource == this.btnWidth) {
            if (this.btnWidth.getSelection()) {
                this.getBlockForProcessing().setWidthHint(-1.0);
                this.txtWidth.setEnabled(false);
            } else {
                this.txtWidth.setEnabled(true);
                if (this.txtWidth.isSetValue()) {
                    this.getBlockForProcessing().setWidthHint(this.txtWidth.getValue());
                } else {
                    this.getBlockForProcessing().unsetWidthHint();
                }
            }
        }
    }

    public String getTitleText() {
        return Messages.getString("AttributeSheetImpl.Title.SheetTitle");
    }

    private Plot getBlockForProcessing() {
        return this.getChart().getPlot();
    }
}

