/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.compound;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.birt.core.archive.compound.ArchiveEntry;
import org.eclipse.birt.core.archive.compound.ArchiveEntryV1;
import org.eclipse.birt.core.archive.compound.IArchiveFile;

class ArchiveFileV1
implements IArchiveFile {
    String archiveName;
    RandomAccessFile rf;
    private HashMap lookupMap = new HashMap();

    ArchiveFileV1(String archiveName, RandomAccessFile rf) throws IOException {
        this.archiveName = archiveName;
        this.rf = rf;
        try {
            if (this.rf == null) {
                this.rf = new RandomAccessFile(archiveName, "r");
            }
            this.readFileTable();
        }
        catch (IOException ex) {
            this.close();
            throw ex;
        }
    }

    ArchiveFileV1(String archiveName) throws IOException {
        this(archiveName, null);
    }

    protected void readFileTable() throws IOException {
        this.rf.seek(0L);
        long streamSectionPos = this.rf.readLong();
        long entryNumber = this.rf.readLong();
        long i = 0L;
        while (i < entryNumber) {
            String name = this.rf.readUTF();
            long start = this.rf.readLong() + streamSectionPos;
            long length = this.rf.readLong();
            this.lookupMap.put(name, new ArchiveEntryV1(this, name, start, length));
            ++i;
        }
    }

    public String getName() {
        return this.archiveName;
    }

    public String getDependId() {
        return null;
    }

    public String getSystemId() {
        return null;
    }

    public void close() throws IOException {
        if (this.rf != null) {
            this.rf.close();
            this.rf = null;
        }
    }

    public void setCacheSize(int cacheSize) {
    }

    public int getUsedCache() {
        return 0;
    }

    public synchronized ArchiveEntry createEntry(String name) throws IOException {
        throw new IOException("read only archive");
    }

    public boolean exists(String name) {
        return this.lookupMap.containsKey(name);
    }

    public void flush() throws IOException {
        throw new IOException("read only archive");
    }

    public ArchiveEntry getEntry(String name) {
        return (ArchiveEntryV1)this.lookupMap.get(name);
    }

    public List listEntries(String namePattern) {
        ArrayList<String> list = new ArrayList<String>();
        for (String name : this.lookupMap.keySet()) {
            if (namePattern != null && !name.startsWith(namePattern)) continue;
            list.add(name);
        }
        return list;
    }

    public synchronized void refresh() throws IOException {
    }

    public synchronized boolean removeEntry(String name) throws IOException {
        throw new IOException("read only archive");
    }

    public Object lockEntry(ArchiveEntry entry) throws IOException {
        return entry;
    }

    public void unlockEntry(Object locker) throws IOException {
        if (!(locker instanceof ArchiveEntryV1)) {
            throw new IOException("Invalide lock type:" + locker);
        }
    }

    synchronized int read(long pos, byte[] b, int off, int len) throws IOException {
        this.rf.seek(pos);
        return this.rf.read(b, off, len);
    }

    synchronized void write(long pos, byte[] b, int off, int len) throws IOException {
        throw new IOException("read only archive");
    }

    public synchronized void save() throws IOException {
        throw new IOException("read only archive");
    }
}

