/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.compound;

import java.io.IOException;
import java.util.List;
import org.eclipse.birt.core.archive.compound.ArchiveEntry;
import org.eclipse.birt.core.archive.compound.ArchiveFile;
import org.eclipse.birt.core.archive.compound.ArchiveFileV2;
import org.eclipse.birt.core.archive.compound.IArchiveFile;

public class ArchiveView
implements IArchiveFile {
    private boolean sharedArchive = false;
    private IArchiveFile view = null;
    private IArchiveFile archive = null;

    public ArchiveView(IArchiveFile view, IArchiveFile archive, boolean sharedArchive) {
        this.view = view;
        this.archive = archive;
        this.sharedArchive = sharedArchive;
    }

    public ArchiveView(String viewName, String archiveName, String viewMode) throws IOException {
        this.view = new ArchiveFileV2(viewName, viewMode);
        this.archive = new ArchiveFile(archiveName, "r");
        this.sharedArchive = false;
    }

    public ArchiveView(String viewName, IArchiveFile archive, String viewMode) throws IOException {
        this.view = new ArchiveFileV2(viewName, viewMode);
        this.archive = archive;
        this.sharedArchive = true;
    }

    public void close() throws IOException {
        try {
            if (!this.sharedArchive) {
                this.archive.close();
            }
        }
        finally {
            this.view.close();
        }
    }

    public synchronized boolean exists(String name) {
        return this.view.exists(name) || this.archive.exists(name);
    }

    public synchronized ArchiveEntry getEntry(String name) throws IOException {
        ArchiveEntry result = this.view.getEntry(name);
        if (result != null) {
            return result;
        }
        result = this.archive.getEntry(name);
        if (result != null) {
            return new ViewEntry(this, name, result);
        }
        return null;
    }

    public synchronized List listEntries(String namePattern) {
        List viewList = this.view.listEntries(namePattern);
        List archiveList = this.archive.listEntries(namePattern);
        for (String entryName : archiveList) {
            if (viewList.contains(entryName)) continue;
            viewList.add(entryName);
        }
        return viewList;
    }

    public Object lockEntry(ArchiveEntry entry) throws IOException {
        return entry;
    }

    public void refresh() throws IOException {
        this.view.refresh();
    }

    public String getSystemId() {
        return this.view.getSystemId();
    }

    public String getDependId() {
        return this.archive.getSystemId();
    }

    public ArchiveEntry createEntry(String name) throws IOException {
        return this.view.createEntry(name);
    }

    public void flush() throws IOException {
        this.view.flush();
    }

    public void save() throws IOException {
        this.view.save();
    }

    public String getName() {
        return this.view.getName();
    }

    public int getUsedCache() {
        return this.view.getUsedCache();
    }

    public boolean removeEntry(String name) throws IOException {
        return this.view.removeEntry(name);
    }

    public void setCacheSize(int cacheSize) {
        this.view.setCacheSize(cacheSize);
    }

    public void unlockEntry(Object locker) throws IOException {
        this.view.unlockEntry(locker);
    }

    public IArchiveFile getArchive() {
        return this.archive;
    }

    public IArchiveFile getView() {
        return this.view;
    }

    class ViewEntry
    extends ArchiveEntry {
        IArchiveFile view;
        boolean writable = false;
        ArchiveEntry entry;
        String name;

        ViewEntry(IArchiveFile view, String name, ArchiveEntry entry) {
            this.view = view;
            this.name = name;
            this.entry = entry;
        }

        public long getLength() throws IOException {
            return this.entry.getLength();
        }

        public void setLength(long length) throws IOException {
            this.ensureWritable();
            this.entry.setLength(length);
        }

        public void flush() throws IOException {
            this.ensureWritable();
            this.entry.flush();
        }

        public void refresh() throws IOException {
            this.entry.refresh();
        }

        public int read(long pos, byte[] b, int off, int len) throws IOException {
            return this.entry.read(pos, b, off, len);
        }

        public void write(long pos, byte[] b, int off, int len) throws IOException {
            this.ensureWritable();
            this.entry.write(pos, b, off, len);
        }

        void ensureWritable() throws IOException {
            if (!this.writable) {
                ArchiveEntry viewEntry = this.view.createEntry(this.name);
                this.copyEntry(this.entry, viewEntry);
                this.entry = viewEntry;
                this.writable = true;
            }
        }

        private void copyEntry(ArchiveEntry src, ArchiveEntry tgt) throws IOException {
            byte[] b = new byte[4096];
            long length = src.getLength();
            long pos = 0L;
            while (pos < length) {
                int size = src.read(pos, b, 0, 4096);
                tgt.write(pos, b, 0, size);
                pos += (long)size;
            }
        }
    }
}

