/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.device.util;

import com.ibm.icu.util.Calendar;
import org.eclipse.birt.chart.computation.DataPointHints;
import org.eclipse.birt.chart.computation.LegendItemHints;
import org.eclipse.birt.chart.model.data.DateTimeDataElement;
import org.eclipse.birt.chart.model.data.NumberDataElement;

public class ScriptUtil {
    public static void script(StringBuffer str, DataPointHints dph, LegendItemHints lerh, String axisLabel) {
        if (dph != null) {
            str.append(",");
            str.append(ScriptUtil.addDataValueToScript(dph.getBaseValue()));
            str.append(",");
            str.append(ScriptUtil.addDataValueToScript(dph.getOrthogonalValue()));
            str.append(",");
            str.append(ScriptUtil.addDataValueToScript(dph.getSeriesValue()));
        } else {
            str.append(",null,null,null");
        }
        if (lerh != null) {
            str.append(",");
            str.append(ScriptUtil.addDataValueToScript(lerh.getItemText()));
            str.append(",");
            str.append(ScriptUtil.addDataValueToScript(lerh.getValueText()));
        } else {
            str.append(",null,null");
        }
        if (axisLabel != null) {
            str.append(",");
            str.append(ScriptUtil.addDataValueToScript(axisLabel));
        } else {
            str.append(",null");
        }
    }

    private static String addDataValueToScript(Object oValue) {
        if (oValue instanceof String) {
            return "'" + (String)oValue + "'";
        }
        if (oValue instanceof Double) {
            return ((Double)oValue).toString();
        }
        if (oValue instanceof NumberDataElement) {
            return ((NumberDataElement)oValue).toString();
        }
        if (oValue instanceof Calendar) {
            return "'" + ((Calendar)oValue).getTime().toString() + "'";
        }
        if (oValue instanceof DateTimeDataElement) {
            return "'" + ((DateTimeDataElement)oValue).getValueAsCalendar().toString() + "'";
        }
        if (oValue == null) {
            return "''";
        }
        return "'" + oValue.toString() + "'";
    }
}

