/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.ui.editor;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttribute;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaOperation;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaRepositoryConnector;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaRepositoryResponse;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaTaskDataHandler;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaVersion;
import org.eclipse.mylyn.internal.bugzilla.core.RepositoryConfiguration;
import org.eclipse.mylyn.internal.bugzilla.ui.editor.BugzillaCcAttributeEditor;
import org.eclipse.mylyn.internal.bugzilla.ui.editor.BugzillaKeywordAttributeEditor;
import org.eclipse.mylyn.internal.bugzilla.ui.editor.BugzillaPeoplePart;
import org.eclipse.mylyn.internal.bugzilla.ui.editor.BugzillaPlanningEditorPart;
import org.eclipse.mylyn.internal.bugzilla.ui.editor.BugzillaResponseDetailDialog;
import org.eclipse.mylyn.internal.bugzilla.ui.editor.BugzillaVotesEditor;
import org.eclipse.mylyn.internal.bugzilla.ui.editor.FlagAttributeEditor;
import org.eclipse.mylyn.internal.bugzilla.ui.editor.Messages;
import org.eclipse.mylyn.internal.provisional.commons.ui.WorkbenchUtil;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorActionPart;
import org.eclipse.mylyn.tasks.core.RepositoryResponse;
import org.eclipse.mylyn.tasks.core.RepositoryStatus;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMetaData;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.eclipse.mylyn.tasks.core.data.TaskDataModelEvent;
import org.eclipse.mylyn.tasks.core.data.TaskDataModelListener;
import org.eclipse.mylyn.tasks.core.sync.SubmitJobEvent;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPage;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPart;
import org.eclipse.mylyn.tasks.ui.editors.AttributeEditorFactory;
import org.eclipse.mylyn.tasks.ui.editors.LayoutHint;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorInput;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorPartDescriptor;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.services.IServiceLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BugzillaTaskEditorPage
extends AbstractTaskEditorPage {
    public static final String ID_PART_BUGZILLA_PLANNING = "org.eclipse.mylyn.bugzilla.ui.editors.part.planning";
    public static final String ID_PART_BUGZILLA_FLAGS = "org.eclipse.mylyn.bugzilla.ui.editors.part.flags";
    private final Map<TaskAttribute, AbstractAttributeEditor> attributeEditorMap = new HashMap<TaskAttribute, AbstractAttributeEditor>();
    private TaskDataModelListener productListener;

    public BugzillaTaskEditorPage(TaskEditor editor) {
        this(editor, "bugzilla");
    }

    public BugzillaTaskEditorPage(TaskEditor editor, String connectorKind) {
        super(editor, connectorKind);
        this.setNeedsPrivateSection(true);
        this.setNeedsSubmitButton(true);
    }

    protected Set<TaskEditorPartDescriptor> createPartDescriptors() {
        Set descriptors = super.createPartDescriptors();
        for (TaskEditorPartDescriptor taskEditorPartDescriptor : descriptors) {
            if (!taskEditorPartDescriptor.getId().equals("org.eclipse.mylyn.tasks.ui.editors.parts.people")) continue;
            descriptors.remove(taskEditorPartDescriptor);
            break;
        }
        try {
            TaskAttribute attrEstimatedTime;
            TaskData data = TasksUi.getTaskDataManager().getTaskData(this.getTask());
            if (data != null && (attrEstimatedTime = data.getRoot().getMappedAttribute(BugzillaAttribute.ESTIMATED_TIME.getKey())) != null) {
                descriptors.add(new TaskEditorPartDescriptor(ID_PART_BUGZILLA_PLANNING){

                    public AbstractTaskEditorPart createPart() {
                        return new BugzillaPlanningEditorPart();
                    }
                }.setPath("org.eclipse.mylyn.tasks.ui.editors.parts.attributes/planning"));
            }
        }
        catch (CoreException coreException) {}
        descriptors.add(new TaskEditorPartDescriptor("org.eclipse.mylyn.tasks.ui.editors.parts.people"){

            public AbstractTaskEditorPart createPart() {
                return new BugzillaPeoplePart();
            }
        }.setPath("people"));
        return descriptors;
    }

    protected AttributeEditorFactory createAttributeEditorFactory() {
        AttributeEditorFactory factory = new AttributeEditorFactory(this.getModel(), this.getTaskRepository(), (IServiceLocator)this.getEditorSite()){

            public AbstractAttributeEditor createEditor(String type, TaskAttribute taskAttribute) {
                Object editor;
                if ("bugzilla.editor.keywords".equals(type)) {
                    editor = new BugzillaKeywordAttributeEditor(BugzillaTaskEditorPage.this.getModel(), taskAttribute);
                } else if ("bugzilla.editor.removecc".equals(type)) {
                    editor = new BugzillaCcAttributeEditor(BugzillaTaskEditorPage.this.getModel(), taskAttribute);
                } else if ("bugzilla.editor.votes".equals(type)) {
                    editor = new BugzillaVotesEditor(BugzillaTaskEditorPage.this.getModel(), taskAttribute);
                } else if ("bugzilla.editor.flag".equals(type)) {
                    editor = new FlagAttributeEditor(BugzillaTaskEditorPage.this.getModel(), taskAttribute);
                } else {
                    editor = super.createEditor(type, taskAttribute);
                    if ("boolean".equals(type)) {
                        editor.setDecorationEnabled(false);
                    }
                }
                if (editor != null && taskAttribute.getId().startsWith("cf_")) {
                    editor.setLayoutHint(new LayoutHint(editor.getLayoutHint()){

                        public int getPriority() {
                            return super.getPriority() * 10;
                        }
                    });
                }
                TaskAttributeMetaData properties = taskAttribute.getMetaData();
                if (editor != null && "bugzilla.editor.flag".equals(properties.getType())) {
                    editor.setLayoutHint(new LayoutHint(editor.getLayoutHint()){

                        public int getPriority() {
                            return super.getPriority() * 5;
                        }
                    });
                }
                BugzillaTaskEditorPage.this.addToAttributeEditorMap(taskAttribute, (AbstractAttributeEditor)editor);
                return editor;
            }
        };
        return factory;
    }

    public void doSubmit() {
        String tokenString;
        TaskAttribute attrToken;
        String dupValue;
        TaskAttribute inputAttribute;
        TaskAttribute originalOperation;
        String inputAttributeId;
        TaskAttribute summaryAttribute = this.getModel().getTaskData().getRoot().getMappedAttribute("task.common.summary");
        if (summaryAttribute != null && summaryAttribute.getValue().length() == 0) {
            this.getTaskEditor().setMessage(Messages.BugzillaTaskEditorPage_Please_enter_a_short_summary_before_submitting, 3);
            AbstractTaskEditorPart part = this.getPart("org.eclipse.mylyn.tasks.ui.editors.parts.summary");
            if (part != null) {
                part.setFocus();
            }
            return;
        }
        TaskAttribute componentAttribute = this.getModel().getTaskData().getRoot().getMappedAttribute(BugzillaAttribute.COMPONENT.getKey());
        if (componentAttribute != null && componentAttribute.getValue().length() == 0) {
            this.getTaskEditor().setMessage(Messages.BugzillaTaskEditorPage_Please_select_a_component_before_submitting, 3);
            AbstractTaskEditorPart part = this.getPart("org.eclipse.mylyn.tasks.ui.editors.parts.attributes");
            if (part != null) {
                part.setFocus();
            }
            return;
        }
        TaskAttribute descriptionAttribute = this.getModel().getTaskData().getRoot().getMappedAttribute("task.common.description");
        if (descriptionAttribute != null && descriptionAttribute.getValue().length() == 0 && this.getModel().getTaskData().isNew()) {
            this.getTaskEditor().setMessage(Messages.BugzillaTaskEditorPage_Please_enter_a_description_before_submitting, 3);
            AbstractTaskEditorPart descriptionPart = this.getPart("org.eclipse.mylyn.tasks.ui.editors.parts.descriptions");
            if (descriptionPart != null) {
                descriptionPart.setFocus();
            }
            return;
        }
        TaskAttribute attributeOperation = this.getModel().getTaskData().getRoot().getMappedAttribute("task.common.operation");
        if (attributeOperation != null && "duplicate".equals(attributeOperation.getValue()) && (inputAttributeId = (originalOperation = this.getModel().getTaskData().getRoot().getAttribute("task.common.operation-" + attributeOperation.getValue())).getMetaData().getValue("task.meta.associated.attribute")) != null && !inputAttributeId.equals("") && (inputAttribute = attributeOperation.getTaskData().getRoot().getAttribute(inputAttributeId)) != null && ((dupValue = inputAttribute.getValue()) == null || dupValue.equals(""))) {
            this.getTaskEditor().setMessage(Messages.BugzillaTaskEditorPage_Please_enter_a_bugid_for_duplicate_of_before_submitting, 3);
            AbstractTaskEditorPart part = this.getPart("org.eclipse.mylyn.tasks.ui.editors.parts.actions");
            if (part != null) {
                part.setFocus();
            }
            return;
        }
        if (this.getModel().getTaskData().isNew()) {
            TaskAttribute componentSelectedAttribute;
            TaskAttribute productAttribute = this.getModel().getTaskData().getRoot().getMappedAttribute("task.common.product");
            if (productAttribute != null && productAttribute.getValue().length() > 0) {
                this.getModel().getTaskRepository().setProperty("last.selection.product", productAttribute.getValue());
            }
            if ((componentSelectedAttribute = this.getModel().getTaskData().getRoot().getMappedAttribute("task.common.component")) != null && componentSelectedAttribute.getValue().length() > 0) {
                this.getModel().getTaskRepository().setProperty("last.selection.component", componentSelectedAttribute.getValue());
            }
        }
        if ((attrToken = this.getModel().getTaskData().getRoot().getAttribute(BugzillaAttribute.TOKEN.getKey())) != null && (tokenString = this.getModel().getTask().getAttribute(BugzillaAttribute.TOKEN.getKey())) != null) {
            attrToken.setValue(tokenString);
        }
        this.getTaskEditor().setMessage("", 0);
        super.doSubmit();
    }

    protected void createParts() {
        this.attributeEditorMap.clear();
        super.createParts();
    }

    protected TaskDataModel createModel(TaskEditorInput input) throws CoreException {
        TaskDataModel model = super.createModel(input);
        this.productListener = new ProductSelectionListener();
        model.addModelListener(this.productListener);
        return model;
    }

    private void addToAttributeEditorMap(TaskAttribute attribute, AbstractAttributeEditor editor) {
        if (this.attributeEditorMap.containsKey(attribute)) {
            this.attributeEditorMap.remove(attribute);
        }
        this.attributeEditorMap.put(attribute, editor);
    }

    private AbstractAttributeEditor getEditorForAttribute(TaskAttribute attribute) {
        return this.attributeEditorMap.get(attribute);
    }

    private void refresh(TaskAttribute attributeComponent) {
        AbstractAttributeEditor editor = this.getEditorForAttribute(attributeComponent);
        if (editor != null) {
            try {
                editor.refresh();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        }
    }

    protected void handleTaskSubmitted(SubmitJobEvent event) {
        if (event.getJob().getResponse() != null && event.getJob().getResponse() instanceof BugzillaRepositoryResponse) {
            RepositoryResponse response = event.getJob().getResponse();
            if (response instanceof BugzillaRepositoryResponse) {
                final BugzillaRepositoryResponse bugzillaResponse = (BugzillaRepositoryResponse)response;
                if (bugzillaResponse.getResponseData().size() > 0) {
                    this.getTaskEditor().setMessage(Messages.BugzillaTaskEditorPage_Changes_Submitted_Message, 1, (IHyperlinkListener)new HyperlinkAdapter(){

                        public void linkActivated(HyperlinkEvent event) {
                            BugzillaResponseDetailDialog dialog = new BugzillaResponseDetailDialog(WorkbenchUtil.getShell(), bugzillaResponse);
                            dialog.open();
                        }
                    });
                } else {
                    this.getTaskEditor().setMessage(Messages.BugzillaTaskEditorPage_Changes_Submitted_Message, 1);
                }
            }
        } else {
            super.handleTaskSubmitted(event);
        }
    }

    private class ProductSelectionListener
    extends TaskDataModelListener {
        private ProductSelectionListener() {
        }

        public void attributeChanged(TaskDataModelEvent event) {
            TaskAttribute taskAttribute = event.getTaskAttribute();
            if (taskAttribute != null && taskAttribute.getId().equals(BugzillaAttribute.PRODUCT.getKey())) {
                TaskAttribute attributeConfirmeProductChange;
                TaskAttribute attributeDefaultAssignee;
                TaskAttribute attributeVersion;
                TaskAttribute attributeTargetMilestone;
                RepositoryConfiguration repositoryConfiguration = null;
                try {
                    BugzillaRepositoryConnector connector = (BugzillaRepositoryConnector)TasksUi.getRepositoryConnector((String)BugzillaTaskEditorPage.this.getModel().getTaskRepository().getConnectorKind());
                    repositoryConfiguration = connector.getRepositoryConfiguration(BugzillaTaskEditorPage.this.getModel().getTaskRepository(), false, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    StatusHandler.log((IStatus)new RepositoryStatus(BugzillaTaskEditorPage.this.getTaskRepository(), 4, "org.eclipse.mylyn.bugzilla.ui", 0, "Failed to obtain repository configuration", (Throwable)e));
                    BugzillaTaskEditorPage.this.getTaskEditor().setMessage("Problem occured when updating attributes", 3);
                    return;
                }
                TaskAttribute attributeComponent = taskAttribute.getTaskData().getRoot().getMappedAttribute(BugzillaAttribute.COMPONENT.getKey());
                if (attributeComponent != null) {
                    List optionValues = repositoryConfiguration.getComponents(taskAttribute.getValue());
                    Collections.sort(optionValues);
                    attributeComponent.clearOptions();
                    for (String option : optionValues) {
                        attributeComponent.putOption(option, option);
                    }
                    if (optionValues.size() == 1) {
                        attributeComponent.setValue((String)optionValues.get(0));
                    } else {
                        attributeComponent.setValue("");
                    }
                    BugzillaTaskEditorPage.this.refresh(attributeComponent);
                }
                if ((attributeTargetMilestone = taskAttribute.getTaskData().getRoot().getMappedAttribute(BugzillaAttribute.TARGET_MILESTONE.getKey())) != null) {
                    List optionValues = repositoryConfiguration.getTargetMilestones(taskAttribute.getValue());
                    Collections.sort(optionValues);
                    attributeTargetMilestone.clearOptions();
                    for (String option : optionValues) {
                        attributeTargetMilestone.putOption(option, option);
                    }
                    if (optionValues.size() == 1) {
                        attributeTargetMilestone.setValue((String)optionValues.get(0));
                    } else {
                        attributeTargetMilestone.setValue("---");
                    }
                    BugzillaTaskEditorPage.this.refresh(attributeTargetMilestone);
                }
                if ((attributeVersion = taskAttribute.getTaskData().getRoot().getMappedAttribute(BugzillaAttribute.VERSION.getKey())) != null) {
                    List optionValues = repositoryConfiguration.getVersions(taskAttribute.getValue());
                    Collections.sort(optionValues);
                    attributeVersion.clearOptions();
                    for (String option : optionValues) {
                        attributeVersion.putOption(option, option);
                    }
                    if (optionValues.size() == 1) {
                        attributeVersion.setValue((String)optionValues.get(0));
                    } else {
                        attributeVersion.setValue("unspecified");
                    }
                    BugzillaTaskEditorPage.this.refresh(attributeVersion);
                }
                if ((attributeDefaultAssignee = taskAttribute.getTaskData().getRoot().getMappedAttribute(BugzillaAttribute.SET_DEFAULT_ASSIGNEE.getKey())) != null) {
                    attributeDefaultAssignee.setValue("1");
                    BugzillaTaskEditorPage.this.refresh(attributeDefaultAssignee);
                }
                if (taskAttribute.getTaskData().isNew()) {
                    BugzillaVersion bugzillaVersion = repositoryConfiguration.getInstallVersion();
                    if (bugzillaVersion == null) {
                        bugzillaVersion = BugzillaVersion.MIN_VERSION;
                    }
                    if (bugzillaVersion.compareMajorMinorOnly(BugzillaVersion.BUGZILLA_4_0) >= 0) {
                        AbstractTaskEditorPart part = BugzillaTaskEditorPage.this.getPart("org.eclipse.mylyn.tasks.ui.editors.parts.actions");
                        Boolean unconfirmedAllowed = repositoryConfiguration.getUnconfirmedAllowed(taskAttribute.getValue());
                        TaskAttribute unconfirmedAttribute = taskAttribute.getTaskData().getRoot().getAttribute("task.common.operation-" + BugzillaOperation.unconfirmed.toString());
                        if (unconfirmedAttribute != null && unconfirmedAllowed != null) {
                            unconfirmedAttribute.getMetaData().setReadOnly(unconfirmedAllowed == false);
                        }
                        if (part != null) {
                            TaskEditorActionPart actionPart = (TaskEditorActionPart)part;
                            actionPart.refreshOperations();
                        }
                    }
                }
                if ((attributeConfirmeProductChange = taskAttribute.getTaskData().getRoot().getMappedAttribute(BugzillaAttribute.CONFIRM_PRODUCT_CHANGE.getKey())) == null) {
                    attributeConfirmeProductChange = BugzillaTaskDataHandler.createAttribute((TaskAttribute)taskAttribute.getTaskData().getRoot(), (BugzillaAttribute)BugzillaAttribute.CONFIRM_PRODUCT_CHANGE);
                }
                if (attributeConfirmeProductChange != null) {
                    attributeConfirmeProductChange.setValue("1");
                }
            }
        }
    }
}

