/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.provisional.commons.ui.TableSorter;
import org.eclipse.mylyn.internal.provisional.commons.ui.TableViewerSupport;
import org.eclipse.mylyn.internal.tasks.core.TaskAttachment;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.commands.OpenTaskAttachmentHandler;
import org.eclipse.mylyn.internal.tasks.ui.editors.AttachmentTableLabelProvider;
import org.eclipse.mylyn.internal.tasks.ui.editors.EditorUtil;
import org.eclipse.mylyn.internal.tasks.ui.editors.Messages;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiMenus;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskKeyComparator;
import org.eclipse.mylyn.internal.tasks.ui.wizards.TaskAttachmentWizard;
import org.eclipse.mylyn.tasks.core.ITaskAttachment;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPart;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.osgi.framework.Bundle;

public class TaskEditorAttachmentPart
extends AbstractTaskEditorPart {
    private static final String ID_POPUP_MENU = "org.eclipse.mylyn.tasks.ui.editor.menu.attachments";
    private final String[] attachmentsColumns = new String[]{Messages.TaskEditorAttachmentPart_Name, Messages.TaskEditorAttachmentPart_Description, Messages.TaskEditorAttachmentPart_Size, Messages.TaskEditorAttachmentPart_Creator, Messages.TaskEditorAttachmentPart_Created, Messages.TaskEditorAttachmentPart_ID};
    private final int[] attachmentsColumnWidths;
    private List<TaskAttribute> attachments;
    private boolean hasIncoming;
    private MenuManager menuManager;
    private Composite attachmentsComposite;

    public TaskEditorAttachmentPart() {
        int[] nArray = new int[6];
        nArray[0] = 130;
        nArray[1] = 150;
        nArray[2] = 70;
        nArray[3] = 100;
        nArray[4] = 100;
        this.attachmentsColumnWidths = nArray;
        this.setPartName(Messages.TaskEditorAttachmentPart_Attachments);
    }

    private void createAttachmentTable(FormToolkit toolkit, Composite attachmentsComposite) {
        Table attachmentsTable = toolkit.createTable(attachmentsComposite, 65538);
        attachmentsTable.setLinesVisible(true);
        attachmentsTable.setHeaderVisible(true);
        attachmentsTable.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).hint(500, -1).applyTo((Control)attachmentsTable);
        attachmentsTable.setData("FormWidgetFactory.drawBorder", (Object)"treeBorder");
        int i = 0;
        while (i < this.attachmentsColumns.length) {
            TableColumn column = new TableColumn(attachmentsTable, 16384, i);
            column.setText(this.attachmentsColumns[i]);
            column.setWidth(this.attachmentsColumnWidths[i]);
            column.setMoveable(true);
            if (i == 4) {
                attachmentsTable.setSortColumn(column);
                attachmentsTable.setSortDirection(1024);
            }
            ++i;
        }
        attachmentsTable.getColumn(2).setAlignment(131072);
        TableViewer attachmentsViewer = new TableViewer(attachmentsTable);
        attachmentsViewer.setUseHashlookup(true);
        attachmentsViewer.setColumnProperties(this.attachmentsColumns);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)attachmentsViewer, (int)2);
        attachmentsViewer.setSorter((ViewerSorter)new AttachmentTableSorter());
        ArrayList<TaskAttachment> attachmentList = new ArrayList<TaskAttachment>(this.attachments.size());
        for (TaskAttribute attribute : this.attachments) {
            TaskAttachment taskAttachment = new TaskAttachment(this.getModel().getTaskRepository(), this.getModel().getTask(), attribute);
            this.getTaskData().getAttributeMapper().updateTaskAttachment((ITaskAttachment)taskAttachment, attribute);
            attachmentList.add(taskAttachment);
        }
        attachmentsViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        attachmentsViewer.setLabelProvider((IBaseLabelProvider)new AttachmentTableLabelProvider(this.getModel(), this.getTaskEditorPage().getAttributeEditorToolkit()));
        attachmentsViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                TaskEditorAttachmentPart.this.openAttachments(event);
            }
        });
        attachmentsViewer.addSelectionChangedListener((ISelectionChangedListener)this.getTaskEditorPage());
        attachmentsViewer.setInput((Object)attachmentList.toArray());
        this.menuManager = new MenuManager();
        this.menuManager.setRemoveAllWhenShown(true);
        this.menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                TasksUiMenus.fillTaskAttachmentMenu(manager);
            }
        });
        this.getTaskEditorPage().getEditorSite().registerContextMenu(ID_POPUP_MENU, this.menuManager, (ISelectionProvider)attachmentsViewer, true);
        Menu menu = this.menuManager.createContextMenu((Control)attachmentsTable);
        attachmentsTable.setMenu(menu);
        new TableViewerSupport(attachmentsViewer, this.getStateFile());
    }

    private File getStateFile() {
        IPath stateLocation = Platform.getStateLocation((Bundle)TasksUiPlugin.getDefault().getBundle());
        return stateLocation.append("TaskEditorAttachmentPart.xml").toFile();
    }

    private void createButtons(Composite attachmentsComposite, FormToolkit toolkit) {
        Composite attachmentControlsComposite = toolkit.createComposite(attachmentsComposite);
        attachmentControlsComposite.setLayout((Layout)new GridLayout(2, false));
        attachmentControlsComposite.setLayoutData((Object)new GridData(1));
        Button attachFileButton = toolkit.createButton(attachmentControlsComposite, Messages.TaskEditorAttachmentPart_Attach_, 8);
        attachFileButton.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.FILE_PLAIN));
        attachFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditorUtil.openNewAttachmentWizard(TaskEditorAttachmentPart.this.getTaskEditorPage(), TaskAttachmentWizard.Mode.DEFAULT, null);
            }
        });
        this.getTaskEditorPage().registerDefaultDropListener((Control)attachFileButton);
        Button attachScreenshotButton = toolkit.createButton(attachmentControlsComposite, Messages.TaskEditorAttachmentPart_Attach__Screenshot, 8);
        attachScreenshotButton.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.IMAGE_CAPTURE));
        attachScreenshotButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditorUtil.openNewAttachmentWizard(TaskEditorAttachmentPart.this.getTaskEditorPage(), TaskAttachmentWizard.Mode.SCREENSHOT, null);
            }
        });
        this.getTaskEditorPage().registerDefaultDropListener((Control)attachScreenshotButton);
    }

    public void createControl(Composite parent, final FormToolkit toolkit) {
        this.initialize();
        final Section section = this.createSection(parent, toolkit, this.hasIncoming);
        section.setText(String.valueOf(this.getPartName()) + " (" + this.attachments.size() + ")");
        if (this.hasIncoming) {
            this.expandSection(toolkit, section);
        } else {
            section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

                public void expansionStateChanged(ExpansionEvent event) {
                    if (TaskEditorAttachmentPart.this.attachmentsComposite == null) {
                        TaskEditorAttachmentPart.this.expandSection(toolkit, section);
                        TaskEditorAttachmentPart.this.getTaskEditorPage().reflow();
                    }
                }
            });
        }
        this.setSection(toolkit, section);
    }

    private void expandSection(FormToolkit toolkit, Section section) {
        this.attachmentsComposite = toolkit.createComposite((Composite)section);
        this.attachmentsComposite.setLayout((Layout)EditorUtil.createSectionClientLayout());
        this.attachmentsComposite.setLayoutData((Object)new GridData(1808));
        this.getTaskEditorPage().registerDefaultDropListener((Control)section);
        if (this.attachments.size() > 0) {
            this.createAttachmentTable(toolkit, this.attachmentsComposite);
        } else {
            Label label = toolkit.createLabel(this.attachmentsComposite, Messages.TaskEditorAttachmentPart_No_attachments);
            this.getTaskEditorPage().registerDefaultDropListener((Control)label);
        }
        this.createButtons(this.attachmentsComposite, toolkit);
        toolkit.paintBordersFor(this.attachmentsComposite);
        section.setClient((Control)this.attachmentsComposite);
    }

    public void dispose() {
        if (this.menuManager != null) {
            this.menuManager.dispose();
        }
        super.dispose();
    }

    private void initialize() {
        this.attachments = this.getTaskData().getAttributeMapper().getAttributesByType(this.getTaskData(), "attachment");
        for (TaskAttribute attachmentAttribute : this.attachments) {
            if (!this.getModel().hasIncomingChanges(attachmentAttribute)) continue;
            this.hasIncoming = true;
            break;
        }
    }

    protected void fillToolBar(ToolBarManager toolBarManager) {
        Action attachFileAction = new Action(){

            public void run() {
                EditorUtil.openNewAttachmentWizard(TaskEditorAttachmentPart.this.getTaskEditorPage(), TaskAttachmentWizard.Mode.DEFAULT, null);
            }
        };
        attachFileAction.setToolTipText(Messages.TaskEditorAttachmentPart_Attach_);
        attachFileAction.setImageDescriptor(CommonImages.FILE_PLAIN_SMALL);
        toolBarManager.add((IAction)attachFileAction);
    }

    protected void openAttachments(OpenEvent event) {
        ArrayList<ITaskAttachment> attachments = new ArrayList<ITaskAttachment>();
        StructuredSelection selection = (StructuredSelection)event.getSelection();
        List items = selection.toList();
        for (Object item : items) {
            if (!(item instanceof ITaskAttachment)) continue;
            attachments.add((ITaskAttachment)item);
        }
        if (attachments.isEmpty()) {
            return;
        }
        IWorkbenchPage page = this.getTaskEditorPage().getSite().getWorkbenchWindow().getActivePage();
        try {
            OpenTaskAttachmentHandler.openAttachments(page, attachments);
        }
        catch (OperationCanceledException operationCanceledException) {}
    }

    private class AttachmentTableSorter
    extends TableSorter {
        TaskKeyComparator keyComparator = new TaskKeyComparator();

        private AttachmentTableSorter() {
        }

        public int compare(TableViewer viewer, Object e1, Object e2, int columnIndex) {
            ITaskAttachment attachment1 = (ITaskAttachment)e1;
            ITaskAttachment attachment2 = (ITaskAttachment)e2;
            switch (columnIndex) {
                case 0: {
                    return this.compare((Comparable)((Object)attachment1.getFileName()), attachment2.getFileName());
                }
                case 1: {
                    String description1 = attachment1.getDescription();
                    String description2 = attachment2.getDescription();
                    return this.compare((Comparable)((Object)description1), description2);
                }
                case 2: {
                    return this.compare(Long.valueOf(attachment1.getLength()), attachment2.getLength());
                }
                case 3: {
                    return this.compare((Comparable)((Object)attachment1.getAuthor().toString()), attachment2.getAuthor().toString());
                }
                case 4: {
                    return this.compare(attachment1.getCreationDate(), attachment2.getCreationDate());
                }
                case 5: {
                    String key1 = AttachmentTableLabelProvider.getAttachmentId(attachment1);
                    String key2 = AttachmentTableLabelProvider.getAttachmentId(attachment2);
                    return this.keyComparator.compare2(key1, key2);
                }
            }
            return super.compare((ColumnViewer)viewer, e1, e2, columnIndex);
        }
    }
}

