/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.notifications;

import java.util.Collections;
import java.util.Date;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.mylyn.internal.provisional.commons.ui.ServiceMessageControl;
import org.eclipse.mylyn.internal.tasks.core.notifications.IServiceMessageListener;
import org.eclipse.mylyn.internal.tasks.core.notifications.ServiceMessage;
import org.eclipse.mylyn.internal.tasks.core.notifications.ServiceMessageEvent;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.actions.AddRepositoryAction;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.internal.tasks.ui.wizards.Messages;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.osgi.framework.Version;

public class TaskListServiceMessageControl
extends ServiceMessageControl
implements IServiceMessageListener {
    private ServiceMessage currentMessage;

    public TaskListServiceMessageControl(Composite parent) {
        super(parent);
    }

    static ExecutionEvent createExecutionEvent(Command command, IHandlerService handlerService) {
        return new ExecutionEvent(command, Collections.emptyMap(), null, (Object)TasksUiInternal.createDiscoveryWizardEvaluationContext(handlerService));
    }

    protected void closeMessage() {
        if (this.currentMessage != null) {
            TasksUiPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.mylyn.tasks.ui.servicemessage.id", this.currentMessage.getId());
        }
        this.close();
    }

    public void handleEvent(ServiceMessageEvent event) {
        switch (event.getEventKind()) {
            case MESSAGE_UPDATE: {
                IPreferenceStore preferenceStore = TasksUiPlugin.getDefault().getPreferenceStore();
                preferenceStore.setValue("org.eclipse.mylyn.tasks.ui.servicemessage.checktime", new Date().getTime());
                String lastMessageId = preferenceStore.getString("org.eclipse.mylyn.tasks.ui.servicemessage.id");
                for (final ServiceMessage message : event.getMessages()) {
                    if (!message.isValid() || message.getId().equals("-1") || lastMessageId.equals(message.getId()) || !this.isForCurrentVersion(message)) continue;
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            TaskListServiceMessageControl.this.setMessage(message);
                        }
                    });
                }
                break;
            }
            case STOP: {
                this.close();
            }
        }
    }

    private boolean isForCurrentVersion(ServiceMessage message) {
        if (message.getVersion() == null) {
            return true;
        }
        try {
            VersionRange version = new VersionRange(message.getVersion());
            String versionString = (String)TasksUiPlugin.getDefault().getBundle().getHeaders().get("Bundle-Version");
            return version.isIncluded(new Version(versionString));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public void setMessage(ServiceMessage message) {
        if (message != null) {
            this.ensureControl();
            if (message.getETag() != null && message.getLastModified() != null) {
                IPreferenceStore preferenceStore = TasksUiPlugin.getDefault().getPreferenceStore();
                preferenceStore.setValue("org.eclipse.mylyn.tasks.ui.servicemessage.etag", message.getETag());
                preferenceStore.setValue("org.eclipse.mylyn.tasks.ui.servicemessage.lastmodified", message.getLastModified());
            }
            this.currentMessage = message;
            this.setTitle(message.getTitle());
            this.setDescription(message.getDescription());
            this.setTitleImage(Dialog.getImage((String)message.getImage()));
        }
    }

    public SelectionListener getLinkListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.text != null) {
                    if (e.text.toLowerCase().equals("connect")) {
                        TaskListServiceMessageControl.this.closeMessage();
                        new AddRepositoryAction().run();
                    } else if (e.text.toLowerCase().equals("discovery")) {
                        TaskListServiceMessageControl.this.closeMessage();
                        Command discoveryWizardCommand = TasksUiInternal.getConfiguredDiscoveryWizardCommand();
                        if (discoveryWizardCommand != null && discoveryWizardCommand.isEnabled()) {
                            IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
                            try {
                                handlerService.executeCommand(discoveryWizardCommand.getId(), null);
                            }
                            catch (Exception e1) {
                                Status status = new Status(4, "org.eclipse.mylyn.tasks.ui", NLS.bind((String)Messages.SelectRepositoryConnectorPage_discoveryProblemMessage, (Object[])new Object[]{e1.getMessage()}), (Throwable)e1);
                                TasksUiInternal.logAndDisplayStatus(Messages.SelectRepositoryConnectorPage_discoveryProblemTitle, (IStatus)status);
                            }
                        }
                    }
                }
            }
        };
    }
}

