/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.ui.editors;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonTextSupport;
import org.eclipse.mylyn.internal.tasks.ui.PersonProposalLabelProvider;
import org.eclipse.mylyn.internal.tasks.ui.PersonProposalProvider;
import org.eclipse.mylyn.internal.tasks.ui.editors.EditorUtil;
import org.eclipse.mylyn.internal.tasks.ui.editors.Messages;
import org.eclipse.mylyn.internal.tasks.ui.editors.PersonAttributeEditor;
import org.eclipse.mylyn.internal.tasks.ui.editors.RepositoryTextViewerConfiguration;
import org.eclipse.mylyn.internal.tasks.ui.editors.RichTextAttributeEditor;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskDataModelEvent;
import org.eclipse.mylyn.tasks.core.data.TaskDataModelListener;
import org.eclipse.mylyn.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.mylyn.tasks.ui.editors.AbstractRenderingEngine;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.fieldassist.ContentAssistCommandAdapter;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.themes.IThemeManager;

public class AttributeEditorToolkit {
    private final Color colorIncoming;
    private Menu menu;
    private AbstractRenderingEngine renderingEngine;
    private final CommonTextSupport textSupport;
    @Deprecated
    public IHandlerActivation contentAssistHandlerActivation;

    AttributeEditorToolkit(CommonTextSupport textSupport) {
        this.textSupport = textSupport;
        IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();
        this.colorIncoming = themeManager.getCurrentTheme().getColorRegistry().get("org.eclipse.mylyn.tasks.ui.colors.incoming.background");
    }

    public void adapt(AbstractAttributeEditor editor) {
        if (editor.getControl() instanceof Text || editor.getControl() instanceof CCombo || editor instanceof PersonAttributeEditor) {
            Control control;
            Object object = control = editor instanceof PersonAttributeEditor ? ((PersonAttributeEditor)editor).getText() : editor.getControl();
            if (control == null) {
                control = editor.getControl();
            }
            if (!editor.isReadOnly() && this.hasContentAssist(editor.getTaskAttribute())) {
                IContentProposalProvider contentProposalProvider = this.createContentProposalProvider(editor.getTaskAttribute());
                ILabelProvider labelPropsalProvider = this.createLabelProposalProvider(editor.getTaskAttribute());
                if (contentProposalProvider != null && labelPropsalProvider != null) {
                    ContentAssistCommandAdapter adapter = new ContentAssistCommandAdapter(control, this.getContentAdapter(control), contentProposalProvider, "org.eclipse.ui.edit.text.contentAssist.proposals", new char[0], true);
                    adapter.setLabelProvider(labelPropsalProvider);
                    adapter.setProposalAcceptanceStyle(2);
                }
            }
        } else if (editor instanceof RichTextAttributeEditor) {
            RichTextAttributeEditor richTextEditor = (RichTextAttributeEditor)editor;
            boolean spellCheck = this.hasSpellChecking(editor.getTaskAttribute());
            SourceViewer viewer = richTextEditor.getViewer();
            this.textSupport.install((TextViewer)viewer, spellCheck);
            if (!editor.isReadOnly() && richTextEditor.getMode() == RepositoryTextViewerConfiguration.Mode.TASK_RELATION) {
                this.installContentAssistControlDecoration(viewer.getControl());
            }
            this.installMenu(viewer.getControl());
        } else {
            TextViewer viewer = CommonTextSupport.getTextViewer((Widget)editor.getControl());
            if (viewer != null) {
                this.textSupport.install(viewer, false);
                this.installMenu(viewer.getControl());
            }
        }
        EditorUtil.setMarker((Widget)editor.getControl(), editor.getTaskAttribute().getId());
        editor.decorate(this.getColorIncoming());
    }

    private IControlContentAdapter getContentAdapter(Control control) {
        if (control instanceof Combo) {
            return new ComboContentAdapter();
        }
        if (control instanceof Text) {
            return new TextContentAdapter();
        }
        return null;
    }

    private void installMenu(final Control control) {
        if (this.menu != null) {
            control.setMenu(this.menu);
            control.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    control.setMenu(null);
                }
            });
        }
    }

    private ControlDecoration installContentAssistControlDecoration(Control control) {
        ControlDecoration controlDecoration = new ControlDecoration(control, 16512);
        controlDecoration.setShowOnlyOnFocus(true);
        FieldDecoration contentProposalImage = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL");
        controlDecoration.setImage(contentProposalImage.getImage());
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getService(IBindingService.class);
        controlDecoration.setDescriptionText(NLS.bind((String)Messages.AttributeEditorToolkit_Content_Assist_Available__X_, (Object)bindingService.getBestActiveBindingFormattedFor("org.eclipse.ui.edit.text.contentAssist.proposals")));
        return controlDecoration;
    }

    private IContentProposalProvider createContentProposalProvider(TaskAttribute attribute) {
        return new PersonProposalProvider(null, attribute.getTaskData());
    }

    private ILabelProvider createLabelProposalProvider(TaskAttribute attribute) {
        return new PersonProposalLabelProvider();
    }

    void dispose() {
    }

    public Color getColorIncoming() {
        return this.colorIncoming;
    }

    Menu getMenu() {
        return this.menu;
    }

    public AbstractRenderingEngine getRenderingEngine(TaskAttribute attribute) {
        return this.renderingEngine;
    }

    private boolean hasContentAssist(TaskAttribute taskAttribute) {
        String type = taskAttribute.getMetaData().getType();
        if ("person".equals(type)) {
            return true;
        }
        return "taskDepenedency".equals(type);
    }

    boolean hasSpellChecking(TaskAttribute taskAttribute) {
        String type = taskAttribute.getMetaData().getType();
        return "longRichText".equals(type) || "shortRichText".equals(type);
    }

    void setMenu(Menu menu) {
        this.menu = menu;
    }

    public void setRenderingEngine(AbstractRenderingEngine renderingEngine) {
        this.renderingEngine = renderingEngine;
    }

    public static void createValidator(final AbstractAttributeEditor attributeEditor, Control control, final IInputValidator validator) {
        Assert.isNotNull((Object)validator);
        Assert.isNotNull((Object)control);
        Assert.isNotNull((Object)attributeEditor);
        final ControlDecoration decoration = new ControlDecoration(control, 17408);
        decoration.setMarginWidth(2);
        FieldDecoration errorDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
        decoration.setImage(errorDecoration.getImage());
        decoration.hide();
        final TaskDataModelListener validationListener = new TaskDataModelListener(){

            public void attributeChanged(TaskDataModelEvent event) {
                if (event.getTaskAttribute().equals((Object)attributeEditor.getTaskAttribute())) {
                    String validationMessage = validator.isValid(attributeEditor.getTaskAttribute().getValue());
                    if (validationMessage == null) {
                        decoration.hide();
                    } else {
                        decoration.setDescriptionText(validationMessage);
                        decoration.show();
                    }
                }
            }
        };
        attributeEditor.getModel().addModelListener(validationListener);
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                decoration.dispose();
                attributeEditor.getModel().removeModelListener(validationListener);
            }
        });
        validationListener.attributeChanged(new TaskDataModelEvent(attributeEditor.getModel(), TaskDataModelEvent.EventKind.CHANGED, attributeEditor.getTaskAttribute()));
    }
}

