/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.ui.wizards;

import org.eclipse.core.expressions.Expression;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonTextSupport;
import org.eclipse.mylyn.internal.tasks.core.data.FileTaskAttachmentSource;
import org.eclipse.mylyn.internal.tasks.ui.editors.RichTextEditor;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorExtensions;
import org.eclipse.mylyn.internal.tasks.ui.wizards.Messages;
import org.eclipse.mylyn.tasks.core.data.TaskAttachmentMapper;
import org.eclipse.mylyn.tasks.core.data.TaskAttachmentModel;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorExtension;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ActiveShellExpression;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerService;

public class TaskAttachmentPage
extends WizardPage {
    private Button attachContextButton;
    private RichTextEditor commentEditor;
    private Text descriptionText;
    private Combo contentTypeList;
    private Text fileNameText;
    private Button isPatchButton;
    private final TaskAttachmentModel model;
    private boolean needsDescription;
    private final TaskAttachmentMapper taskAttachment;
    private boolean first = true;
    private IContextService contextService;
    private IContextActivation commentContext;
    private CommonTextSupport textSupport;
    private boolean needsReplaceExisting;
    private Button replaceExistingButton;

    public TaskAttachmentPage(TaskAttachmentModel model) {
        super("AttachmentDetails");
        this.model = model;
        this.taskAttachment = TaskAttachmentMapper.createFrom((TaskAttribute)model.getAttribute());
        this.setTitle(Messages.TaskAttachmentPage_Attachment_Details);
        this.setNeedsDescription(true);
    }

    public void createControl(Composite parent) {
        String contextId;
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite.setLayout((Layout)gridLayout);
        this.setControl((Control)composite);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)new GridLayout(3, false));
        new Label(composite, 0).setText(Messages.TaskAttachmentPage_File);
        this.fileNameText = new Text(composite, 2048);
        this.fileNameText.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        if (this.needsReplaceExisting) {
            new Label(composite, 0);
            this.replaceExistingButton = new Button(composite, 32);
            this.replaceExistingButton.setLayoutData((Object)new GridData(-1, -1, false, false, 2, 1));
            this.replaceExistingButton.setText(Messages.TaskAttachmentPage_Replace_existing_attachment_Label);
            this.replaceExistingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TaskAttachmentPage.this.taskAttachment.setReplaceExisting(Boolean.valueOf(TaskAttachmentPage.this.replaceExistingButton.getSelection()));
                    TaskAttachmentPage.this.validate();
                }
            });
        }
        if (this.needsDescription) {
            new Label(composite, 0).setText(Messages.TaskAttachmentPage_Description);
            this.descriptionText = new Text(composite, 2048);
            this.descriptionText.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
            this.descriptionText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    TaskAttachmentPage.this.taskAttachment.setDescription(TaskAttachmentPage.this.descriptionText.getText().trim());
                    TaskAttachmentPage.this.validate();
                }
            });
        }
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(16384, 4, false, false));
        label.setText(Messages.TaskAttachmentPage_Comment);
        AbstractTaskEditorExtension extension = TaskEditorExtensions.getTaskEditorExtension(this.model.getTaskRepository());
        if (extension != null && (contextId = extension.getEditorContextId()) != null) {
            this.contextService = (IContextService)PlatformUI.getWorkbench().getService(IContextService.class);
            if (this.contextService != null) {
                this.commentContext = this.contextService.activateContext(contextId, (Expression)new ActiveShellExpression(this.getShell()));
            }
        }
        this.commentEditor = new RichTextEditor(this.getModel().getTaskRepository(), 2624, this.contextService, extension, this.getModel().getTask()){

            protected void valueChanged(String value) {
                TaskAttachmentPage.this.apply();
            }
        };
        this.commentEditor.createControl(composite, null);
        this.commentEditor.getControl().setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        if (handlerService != null) {
            this.textSupport = new CommonTextSupport(handlerService);
            this.textSupport.install((TextViewer)this.commentEditor.getViewer(), true);
        }
        new Label(composite, 0).setText(Messages.TaskAttachmentPage_Content_Type);
        this.contentTypeList = new Combo(composite, 2060);
        this.contentTypeList.setLayoutData((Object)new GridData(-1, -1, false, false, 2, 1));
        String[] contentTypes = FileTaskAttachmentSource.getContentTypes();
        int selection = 0;
        int i = 0;
        while (i < contentTypes.length) {
            String next = contentTypes[i];
            this.contentTypeList.add(next);
            if (next.equalsIgnoreCase(this.model.getContentType())) {
                selection = i;
            }
            ++i;
        }
        this.contentTypeList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                TaskAttachmentPage.this.taskAttachment.setContentType(TaskAttachmentPage.this.contentTypeList.getItem(TaskAttachmentPage.this.contentTypeList.getSelectionIndex()));
                TaskAttachmentPage.this.validate();
            }
        });
        this.contentTypeList.select(selection);
        this.taskAttachment.setContentType(this.contentTypeList.getItem(selection));
        new Label(composite, 0);
        this.isPatchButton = new Button(composite, 32);
        this.isPatchButton.setLayoutData((Object)new GridData(-1, -1, false, false, 2, 1));
        this.isPatchButton.setText(Messages.TaskAttachmentPage_Patch);
        new Label(composite, 0);
        this.attachContextButton = new Button(composite, 32);
        this.attachContextButton.setLayoutData((Object)new GridData(-1, -1, false, false, 2, 1));
        this.attachContextButton.setText(Messages.TaskAttachmentPage_ATTACHE_CONTEXT);
        this.attachContextButton.setImage(CommonImages.getImage((ImageDescriptor)TasksUiImages.CONTEXT_ATTACH));
        this.attachContextButton.setEnabled(ContextCore.getContextManager().hasContext(this.model.getTask().getHandleIdentifier()));
        this.fileNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TaskAttachmentPage.this.taskAttachment.setFileName(TaskAttachmentPage.this.fileNameText.getText());
                TaskAttachmentPage.this.setContentTypeFromFilename(TaskAttachmentPage.this.fileNameText.getText());
                TaskAttachmentPage.this.validate();
            }
        });
        this.isPatchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private int lastSelected;

            public void widgetSelected(SelectionEvent e) {
                TaskAttachmentPage.this.taskAttachment.setPatch(Boolean.valueOf(TaskAttachmentPage.this.isPatchButton.getSelection()));
                if (TaskAttachmentPage.this.isPatchButton.getSelection()) {
                    this.lastSelected = TaskAttachmentPage.this.contentTypeList.getSelectionIndex();
                    TaskAttachmentPage.this.contentTypeList.select(0);
                    TaskAttachmentPage.this.contentTypeList.setEnabled(false);
                    if (TaskAttachmentPage.this.attachContextButton.isEnabled()) {
                        TaskAttachmentPage.this.attachContextButton.setSelection(true);
                    }
                } else {
                    TaskAttachmentPage.this.contentTypeList.setEnabled(true);
                    TaskAttachmentPage.this.contentTypeList.select(this.lastSelected);
                }
                TaskAttachmentPage.this.validate();
            }
        });
        this.attachContextButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TaskAttachmentPage.this.validate();
            }
        });
        this.validate();
        this.setErrorMessage(null);
        if (this.descriptionText != null) {
            this.descriptionText.setFocus();
        } else {
            this.commentEditor.getControl().setFocus();
        }
        Dialog.applyDialogFont((Control)composite);
    }

    private void validate() {
        this.apply();
        if (this.fileNameText != null && "".equals(this.fileNameText.getText().trim())) {
            this.setMessage(Messages.TaskAttachmentPage_Enter_a_file_name);
            this.setPageComplete(false);
        } else if (this.descriptionText != null && "".equals(this.descriptionText.getText().trim())) {
            this.setMessage(Messages.TaskAttachmentPage_Enter_a_description);
            this.setPageComplete(false);
        } else {
            this.setMessage(Messages.TaskAttachmentPage_Verify_the_content_type_of_the_attachment);
            this.setPageComplete(true);
        }
    }

    public TaskAttachmentModel getModel() {
        return this.model;
    }

    private void apply() {
        this.taskAttachment.applyTo(this.model.getAttribute());
        this.model.setComment(this.commentEditor.getText());
        this.model.setAttachContext(this.attachContextButton.getSelection());
        this.model.setContentType(this.taskAttachment.getContentType());
    }

    private void setContentType(String contentType) {
        String[] typeList = this.contentTypeList.getItems();
        int i = 0;
        while (i < typeList.length) {
            if (typeList[i].equals(contentType)) {
                this.contentTypeList.select(i);
                this.taskAttachment.setContentType(contentType);
                this.validate();
                break;
            }
            ++i;
        }
    }

    private void setContentTypeFromFilename(String fileName) {
        this.setContentType(FileTaskAttachmentSource.getContentTypeFromFilename((String)fileName));
    }

    private void setFilePath(String path) {
        this.fileNameText.setText(path);
        this.taskAttachment.setFileName(path);
        if (path.endsWith(".patch")) {
            this.isPatchButton.setSelection(true);
            this.taskAttachment.setPatch(Boolean.valueOf(true));
            if (this.attachContextButton.isEnabled()) {
                this.attachContextButton.setSelection(true);
            }
        }
        this.validate();
    }

    public void setNeedsDescription(boolean supportsDescription) {
        this.needsDescription = supportsDescription;
    }

    @Deprecated
    public boolean supportsDescription() {
        return this.needsDescription();
    }

    public boolean needsDescription() {
        return this.needsDescription;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.fileNameText.setText(this.taskAttachment.getFileName() == null ? "" : this.taskAttachment.getFileName());
            if (this.fileNameText.getText().length() == 0) {
                this.setFilePath(this.getModel().getSource().getName());
                this.setContentType(this.getModel().getSource().getContentType());
            }
        }
        super.setVisible(visible);
        if (this.first) {
            if (this.descriptionText != null) {
                this.descriptionText.setFocus();
            } else {
                this.commentEditor.getControl().setFocus();
            }
            this.first = false;
        }
    }

    public void dispose() {
        super.dispose();
        if (this.contextService != null && this.commentContext != null) {
            this.contextService.deactivateContext(this.commentContext);
            this.commentContext = null;
        }
        if (this.textSupport != null) {
            this.textSupport.dispose();
        }
    }

    public void setNeedsReplaceExisting(boolean needsReplaceExisting) {
        this.needsReplaceExisting = needsReplaceExisting;
    }

    public boolean needsReplaceExisting() {
        return this.needsReplaceExisting;
    }
}

