/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.fix.CleanUpPostSaveListener;
import org.eclipse.jdt.internal.corext.fix.CleanUpPreferenceUtil;
import org.eclipse.jdt.internal.corext.fix.CleanUpRefactoring;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.dialogs.OptionalMessageDialog;
import org.eclipse.jdt.internal.ui.fix.IMultiLineCleanUp;
import org.eclipse.jdt.internal.ui.fix.MapCleanUpOptions;
import org.eclipse.jdt.internal.ui.javaeditor.saveparticipant.IPostSaveListener;
import org.eclipse.jdt.internal.ui.preferences.BulletListBlock;
import org.eclipse.jdt.ui.SharedASTProvider;
import org.eclipse.jdt.ui.cleanup.CleanUpContext;
import org.eclipse.jdt.ui.cleanup.CleanUpRequirements;
import org.eclipse.jdt.ui.cleanup.ICleanUp;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.IUndoManager;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.PerformChangeOperation;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.ui.refactoring.RefactoringUI;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.UndoEdit;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class CleanUpPostSaveListener
implements IPostSaveListener {
    public static final String POSTSAVELISTENER_ID = "org.eclipse.jdt.ui.postsavelistener.cleanup";
    private static final String WARNING_VALUE = "warning";
    private static final String ERROR_VALUE = "error";
    private static final String CHANGED_REGION_POSITION_CATEGORY = "changed_region_position_category";
    private static boolean FIRST_CALL = false;
    private static boolean FIRST_CALL_DONE = false;

    public boolean needsChangedRegions(ICompilationUnit unit) throws CoreException {
        ICleanUp[] cleanUps = CleanUpPostSaveListener.getCleanUps(unit.getJavaProject().getProject());
        return this.requiresChangedRegions(cleanUps);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saved(ICompilationUnit unit, IRegion[] changedRegions, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(this.getName(), -1);
        try {
            if (!ActionUtil.isOnBuildPath((IJavaElement)unit)) {
                return;
            }
            ICleanUp[] cleanUps = CleanUpPostSaveListener.getCleanUps(unit.getJavaProject().getProject());
            long oldFileValue = unit.getResource().getModificationStamp();
            long oldDocValue = this.getDocumentStamp((IFile)unit.getResource(), (IProgressMonitor)new SubProgressMonitor(monitor, 2));
            CompositeChange result = new CompositeChange(FixMessages.CleanUpPostSaveListener_SaveAction_ChangeName);
            LinkedList<UndoEdit> undoEdits = new LinkedList<UndoEdit>();
            if (FIRST_CALL && !FIRST_CALL_DONE) {
                FIRST_CALL = false;
                FIRST_CALL_DONE = true;
            } else {
                FIRST_CALL = true;
            }
            HashSet slowCleanUps = FIRST_CALL_DONE ? new HashSet() : null;
            IUndoManager manager = RefactoringCore.getUndoManager();
            boolean success = false;
            try {
                manager.aboutToPerformChange((Change)result);
                do {
                    RefactoringStatus preCondition = new RefactoringStatus();
                    int i = 0;
                    while (i < cleanUps.length) {
                        RefactoringStatus conditions = cleanUps[i].checkPreConditions(unit.getJavaProject(), new ICompilationUnit[]{unit}, (IProgressMonitor)new SubProgressMonitor(monitor, 5));
                        preCondition.merge(conditions);
                        ++i;
                    }
                    if (this.showStatus(preCondition) != 0) {
                        return;
                    }
                    HashMap options = new HashMap();
                    int i2 = 0;
                    while (i2 < cleanUps.length) {
                        Map map = cleanUps[i2].getRequirements().getCompilerOptions();
                        if (map != null) {
                            options.putAll(map);
                        }
                        ++i2;
                    }
                    CompilationUnit ast = null;
                    if (this.requiresAST(cleanUps)) {
                        ast = this.createAst(unit, options, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                    }
                    CleanUpContext context = changedRegions == null ? new CleanUpContext(unit, ast) : new IMultiLineCleanUp.MultiLineCleanUpContext(unit, ast, changedRegions);
                    ArrayList undoneCleanUps = new ArrayList();
                    CleanUpRefactoring.CleanUpChange change = CleanUpRefactoring.calculateChange(context, cleanUps, undoneCleanUps, slowCleanUps);
                    RefactoringStatus postCondition = new RefactoringStatus();
                    int i3 = 0;
                    while (i3 < cleanUps.length) {
                        RefactoringStatus conditions = cleanUps[i3].checkPostConditions((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        postCondition.merge(conditions);
                        ++i3;
                    }
                    if (this.showStatus(postCondition) != 0) {
                        return;
                    }
                    cleanUps = undoneCleanUps.toArray(new ICleanUp[undoneCleanUps.size()]);
                    if (change == null) continue;
                    result.add((Change)change);
                    change.setSaveMode(4);
                    change.initializeValidationData((IProgressMonitor)new NullProgressMonitor());
                    PerformChangeOperation performChangeOperation = RefactoringUI.createUIAwareChangeOperation((Change)change);
                    performChangeOperation.setSchedulingRule(unit.getSchedulingRule());
                    if (changedRegions != null && changedRegions.length > 0 && this.requiresChangedRegions(cleanUps)) {
                        changedRegions = this.performWithChangedRegionUpdate(performChangeOperation, changedRegions, unit, (IProgressMonitor)new SubProgressMonitor(monitor, 5));
                    } else {
                        performChangeOperation.run((IProgressMonitor)new SubProgressMonitor(monitor, 5));
                    }
                    performChangeOperation.getUndoChange();
                    undoEdits.addFirst(change.getUndoEdit());
                } while (cleanUps.length > 0);
                success = true;
            }
            finally {
                manager.changePerformed((Change)result, success);
            }
            if (undoEdits.size() > 0) {
                UndoEdit[] undoEditArray = undoEdits.toArray(new UndoEdit[undoEdits.size()]);
                CleanUpSaveUndo undo = new CleanUpSaveUndo(result.getName(), (IFile)unit.getResource(), undoEditArray, oldDocValue, oldFileValue);
                undo.initializeValidationData((IProgressMonitor)new NullProgressMonitor());
                manager.addUndo(result.getName(), (Change)undo);
            }
            if (slowCleanUps == null) return;
            if (slowCleanUps.size() <= 0) return;
            this.showSlowCleanUpsWarning(slowCleanUps);
            return;
        }
        finally {
            monitor.done();
        }
    }

    private static ICleanUp[] getCleanUps(IProject project) throws CoreException {
        ICleanUp[] cleanUps;
        Map settings = CleanUpPreferenceUtil.loadSaveParticipantOptions((IScopeContext)new ProjectScope(project));
        if (settings == null) {
            IEclipsePreferences contextNode = InstanceScope.INSTANCE.getNode("org.eclipse.jdt.ui");
            String id = contextNode.get("cleanup.on_save_profile_id", null);
            if (id == null) {
                id = DefaultScope.INSTANCE.getNode("org.eclipse.jdt.ui").get("cleanup.on_save_profile_id", "org.eclipse.jdt.ui.default.save_participant_clean_up_profile");
            }
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.ui", Messages.format(FixMessages.CleanUpPostSaveListener_unknown_profile_error_message, id)));
        }
        if ("true".equals(settings.get("cleanup.on_save_use_additional_actions"))) {
            cleanUps = CleanUpPostSaveListener.getCleanUps(settings, null);
        } else {
            HashMap filteredSettins = new HashMap();
            filteredSettins.put("cleanup.format_source_code", settings.get("cleanup.format_source_code"));
            filteredSettins.put("cleanup.format_source_code_changes_only", settings.get("cleanup.format_source_code_changes_only"));
            filteredSettins.put("cleanup.organize_imports", settings.get("cleanup.organize_imports"));
            HashSet<String> ids = new HashSet<String>(2);
            ids.add("org.eclipse.jdt.ui.cleanup.format");
            ids.add("org.eclipse.jdt.ui.cleanup.imports");
            cleanUps = CleanUpPostSaveListener.getCleanUps(filteredSettins, ids);
        }
        return cleanUps;
    }

    private static ICleanUp[] getCleanUps(Map settings, Set ids) {
        ICleanUp[] result = JavaPlugin.getDefault().getCleanUpRegistry().createCleanUps(ids);
        int i = 0;
        while (i < result.length) {
            result[i].setOptions(new MapCleanUpOptions(settings));
            ++i;
        }
        return result;
    }

    private int showStatus(RefactoringStatus status) {
        if (!status.hasError()) {
            return 0;
        }
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        Dialog dialog = RefactoringUI.createRefactoringStatusDialog((RefactoringStatus)status, (Shell)shell, (String)"", (boolean)false);
        return dialog.open();
    }

    private long getDocumentStamp(IFile file, IProgressMonitor monitor) throws CoreException {
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        IPath path = file.getFullPath();
        monitor.beginTask("", 2);
        ITextFileBuffer buffer = null;
        try {
            manager.connect(path, LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            buffer = manager.getTextFileBuffer(path, LocationKind.IFILE);
            IDocument document = buffer.getDocument();
            if (document instanceof IDocumentExtension4) {
                long l = ((IDocumentExtension4)document).getModificationStamp();
                return l;
            }
            long l = file.getModificationStamp();
            return l;
        }
        finally {
            if (buffer != null) {
                manager.disconnect(path, LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            monitor.done();
        }
    }

    private IRegion[] performWithChangedRegionUpdate(PerformChangeOperation performChangeOperation, IRegion[] changedRegions, ICompilationUnit unit, IProgressMonitor monitor) throws CoreException {
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        IPath path = unit.getResource().getFullPath();
        monitor.beginTask("", 7);
        ITextFileBuffer buffer = null;
        try {
            IRegion[] iRegionArray;
            manager.connect(path, LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            buffer = manager.getTextFileBuffer(path, LocationKind.IFILE);
            IDocument document = buffer.getDocument();
            document.addPositionCategory(CHANGED_REGION_POSITION_CATEGORY);
            DefaultPositionUpdater updater = new DefaultPositionUpdater(CHANGED_REGION_POSITION_CATEGORY);
            try {
                document.addPositionUpdater((IPositionUpdater)updater);
                Position[] positions = new Position[changedRegions.length];
                int i = 0;
                while (i < changedRegions.length) {
                    try {
                        Position position = new Position(changedRegions[i].getOffset(), changedRegions[i].getLength());
                        document.addPosition(CHANGED_REGION_POSITION_CATEGORY, position);
                        positions[i] = position;
                    }
                    catch (BadLocationException e) {
                        throw CleanUpPostSaveListener.wrapBadLocationException(e);
                    }
                    catch (BadPositionCategoryException e) {
                        throw this.wrapBadPositionCategoryException(e);
                    }
                    ++i;
                }
                performChangeOperation.run((IProgressMonitor)new SubProgressMonitor(monitor, 5));
                ArrayList<Region> result = new ArrayList<Region>();
                int i2 = 0;
                while (i2 < positions.length) {
                    Position position = positions[i2];
                    if (!position.isDeleted()) {
                        result.add(new Region(position.getOffset(), position.getLength()));
                    }
                    ++i2;
                }
                iRegionArray = result.toArray(new IRegion[result.size()]);
            }
            catch (Throwable throwable) {
                document.removePositionUpdater((IPositionUpdater)updater);
                try {
                    document.removePositionCategory(CHANGED_REGION_POSITION_CATEGORY);
                }
                catch (BadPositionCategoryException e) {
                    throw this.wrapBadPositionCategoryException(e);
                }
                throw throwable;
            }
            document.removePositionUpdater((IPositionUpdater)updater);
            try {
                document.removePositionCategory(CHANGED_REGION_POSITION_CATEGORY);
            }
            catch (BadPositionCategoryException e) {
                throw this.wrapBadPositionCategoryException(e);
            }
            return iRegionArray;
        }
        finally {
            if (buffer != null) {
                manager.disconnect(path, LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            monitor.done();
        }
    }

    private boolean requiresAST(ICleanUp[] cleanUps) {
        int i = 0;
        while (i < cleanUps.length) {
            if (cleanUps[i].getRequirements().requiresAST()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean requiresChangedRegions(ICleanUp[] cleanUps) {
        int i = 0;
        while (i < cleanUps.length) {
            CleanUpRequirements requirements = cleanUps[i].getRequirements();
            if (requirements.requiresChangedRegions()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private CompilationUnit createAst(ICompilationUnit unit, Map cleanUpOptions, IProgressMonitor monitor) {
        CompilationUnit ast;
        IJavaProject project = unit.getJavaProject();
        if (this.compatibleOptions(project, cleanUpOptions) && (ast = SharedASTProvider.getAST((ITypeRoot)unit, SharedASTProvider.WAIT_NO, monitor)) != null) {
            return ast;
        }
        ASTParser parser = CleanUpRefactoring.createCleanUpASTParser();
        parser.setSource(unit);
        Map compilerOptions = RefactoringASTParser.getCompilerOptions((IJavaElement)unit.getJavaProject());
        compilerOptions.putAll(cleanUpOptions);
        parser.setCompilerOptions(compilerOptions);
        return (CompilationUnit)parser.createAST(monitor);
    }

    private boolean compatibleOptions(IJavaProject project, Map cleanUpOptions) {
        if (cleanUpOptions.size() == 0) {
            return true;
        }
        Map projectOptions = project.getOptions(true);
        Iterator iterator = cleanUpOptions.keySet().iterator();
        while (iterator.hasNext()) {
            String cleanUpOption;
            String key = (String)iterator.next();
            String projectOption = (String)projectOptions.get(key);
            if (this.strongerEquals(projectOption, cleanUpOption = (String)cleanUpOptions.get(key))) continue;
            return false;
        }
        return true;
    }

    private boolean strongerEquals(String projectOption, String cleanUpOption) {
        if (projectOption == null) {
            return false;
        }
        if (ERROR_VALUE.equals(cleanUpOption)) {
            return ERROR_VALUE.equals(projectOption);
        }
        if (WARNING_VALUE.equals(cleanUpOption)) {
            return ERROR_VALUE.equals(projectOption) || WARNING_VALUE.equals(projectOption);
        }
        return false;
    }

    public String getName() {
        return FixMessages.CleanUpPostSaveListener_name;
    }

    public String getId() {
        return POSTSAVELISTENER_ID;
    }

    private static CoreException wrapBadLocationException(BadLocationException e) {
        String message = e.getMessage();
        if (message == null) {
            message = "BadLocationException";
        }
        return new CoreException((IStatus)new Status(4, "org.eclipse.jdt.ui", 10001, message, (Throwable)e));
    }

    private CoreException wrapBadPositionCategoryException(BadPositionCategoryException e) {
        String message = e.getMessage();
        if (message == null) {
            message = "BadPositionCategoryException";
        }
        return new CoreException((IStatus)new Status(4, "org.eclipse.jdt.ui", 0, message, (Throwable)e));
    }

    private void showSlowCleanUpsWarning(HashSet slowCleanUps) {
        final StringBuffer cleanUpNames = new StringBuffer();
        Iterator iterator = slowCleanUps.iterator();
        while (iterator.hasNext()) {
            ICleanUp cleanUp = (ICleanUp)iterator.next();
            String[] descriptions = cleanUp.getStepDescriptions();
            if (descriptions == null) continue;
            int i = 0;
            while (i < descriptions.length) {
                if (cleanUpNames.length() > 0) {
                    cleanUpNames.append('\n');
                }
                cleanUpNames.append(descriptions[i]);
                ++i;
            }
        }
        if (Display.getCurrent() != null) {
            this.showSlowCleanUpDialog(cleanUpNames);
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    CleanUpPostSaveListener.this.showSlowCleanUpDialog(cleanUpNames);
                }
            });
        }
    }

    private void showSlowCleanUpDialog(StringBuffer cleanUpNames) {
        if (OptionalMessageDialog.isDialogEnabled("SaveActions.slowWarningDialog")) {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            new SlowCleanUpWarningDialog(shell, FixMessages.CleanUpPostSaveListener_SlowCleanUpDialog_title, cleanUpNames.toString()).open();
        }
    }

    private static class CleanUpSaveUndo
    extends TextFileChange {
        private final IFile fFile;
        private final UndoEdit[] fUndos;
        private final long fDocumentStamp;
        private final long fFileStamp;

        public CleanUpSaveUndo(String name, IFile file, UndoEdit[] undos, long documentStamp, long fileStamp) {
            super(name, file);
            Assert.isNotNull((Object)undos);
            this.fDocumentStamp = documentStamp;
            this.fFileStamp = fileStamp;
            this.fFile = file;
            this.fUndos = undos;
        }

        public final boolean needsSaving() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Change perform(IProgressMonitor pm) throws CoreException {
            if (this.isValid(pm).hasFatalError()) {
                return new NullChange();
            }
            if (pm == null) {
                pm = new NullProgressMonitor();
            }
            ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
            pm.beginTask("", 2);
            ITextFileBuffer buffer = null;
            try {
                manager.connect(this.fFile.getFullPath(), LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                buffer = manager.getTextFileBuffer(this.fFile.getFullPath(), LocationKind.IFILE);
                IDocument document = buffer.getDocument();
                long oldFileValue = this.fFile.getModificationStamp();
                LinkedList undoEditCollector = new LinkedList();
                long[] oldDocValue = new long[1];
                boolean[] setContentStampSuccess = new boolean[1];
                if (!buffer.isSynchronizationContextRequested()) {
                    this.performEdit(document, oldFileValue, undoEditCollector, oldDocValue, setContentStampSuccess);
                } else {
                    UIRunnable runnable;
                    ITextFileBufferManager fileBufferManager = FileBuffers.getTextFileBufferManager();
                    class UIRunnable
                    implements Runnable {
                        public boolean fDone;
                        public Exception fException;
                        final /* synthetic */ CleanUpSaveUndo this$1;
                        private final /* synthetic */ IDocument val$document;
                        private final /* synthetic */ long val$oldFileValue;
                        private final /* synthetic */ LinkedList val$undoEditCollector;
                        private final /* synthetic */ long[] val$oldDocValue;
                        private final /* synthetic */ boolean[] val$setContentStampSuccess;

                        UIRunnable(CleanUpSaveUndo cleanUpSaveUndo, IDocument iDocument, long l, LinkedList linkedList, long[] lArray, boolean[] blArray) {
                            this.this$1 = cleanUpSaveUndo;
                            this.val$document = iDocument;
                            this.val$oldFileValue = l;
                            this.val$undoEditCollector = linkedList;
                            this.val$oldDocValue = lArray;
                            this.val$setContentStampSuccess = blArray;
                        }

                        /*
                         * Exception decompiling
                         */
                        public void run() {
                            /*
                             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                             * 
                             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK]], but top level block is 7[CATCHBLOCK]
                             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                             *     at org.benf.cfr.reader.entities.Method.dump(Method.java:598)
                             *     at org.benf.cfr.reader.entities.classfilehelpers.AbstractClassFileDumper.dumpMethods(AbstractClassFileDumper.java:211)
                             *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:70)
                             *     at org.benf.cfr.reader.entities.ClassFile.dumpAsInlineClass(ClassFile.java:1171)
                             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredDefinition.dump(StructuredDefinition.java:47)
                             *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                             *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredIf.dump(StructuredIf.java:65)
                             *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                             *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredTry.dump(StructuredTry.java:79)
                             *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                             *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.dump(AttributeCode.java:135)
                             *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                             *     at org.benf.cfr.reader.entities.Method.dump(Method.java:627)
                             *     at org.benf.cfr.reader.entities.classfilehelpers.AbstractClassFileDumper.dumpMethods(AbstractClassFileDumper.java:211)
                             *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:70)
                             *     at org.benf.cfr.reader.entities.ClassFile.dumpNamedInnerClasses(ClassFile.java:1161)
                             *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:71)
                             *     at org.benf.cfr.reader.entities.ClassFile.dump(ClassFile.java:1167)
                             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:952)
                             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                             *     at org.benf.cfr.reader.Main.main(Main.java:54)
                             */
                            throw new IllegalStateException("Decompilation failed");
                        }
                    }
                    UIRunnable uIRunnable = runnable = new UIRunnable(this, document, oldFileValue, undoEditCollector, oldDocValue, setContentStampSuccess);
                    synchronized (uIRunnable) {
                        fileBufferManager.execute((Runnable)runnable);
                        while (!runnable.fDone) {
                            try {
                                runnable.wait(500L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                    if (runnable.fException != null) {
                        if (runnable.fException instanceof BadLocationException) {
                            throw (BadLocationException)((Object)runnable.fException);
                        }
                        if (runnable.fException instanceof MalformedTreeException) {
                            throw (MalformedTreeException)runnable.fException;
                        }
                        if (runnable.fException instanceof CoreException) {
                            throw (CoreException)((Object)runnable.fException);
                        }
                    }
                }
                buffer.commit(pm, false);
                if (!setContentStampSuccess[0]) {
                    this.fFile.revertModificationStamp(this.fFileStamp);
                }
                CleanUpSaveUndo cleanUpSaveUndo = new CleanUpSaveUndo(this.getName(), this.fFile, undoEditCollector.toArray(new UndoEdit[undoEditCollector.size()]), oldDocValue[0], oldFileValue);
                return cleanUpSaveUndo;
            }
            catch (BadLocationException e) {
                throw CleanUpPostSaveListener.wrapBadLocationException(e);
            }
            finally {
                if (buffer != null) {
                    manager.disconnect(this.fFile.getFullPath(), LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                }
            }
        }

        private void performEdit(IDocument document, long oldFileValue, LinkedList editCollector, long[] oldDocValue, boolean[] setContentStampSuccess) throws MalformedTreeException, BadLocationException, CoreException {
            oldDocValue[0] = document instanceof IDocumentExtension4 ? ((IDocumentExtension4)document).getModificationStamp() : oldFileValue;
            int index = 0;
            while (index < this.fUndos.length) {
                UndoEdit edit = this.fUndos[index];
                UndoEdit redo = edit.apply(document, 1);
                editCollector.addFirst(redo);
                ++index;
            }
            if (document instanceof IDocumentExtension4 && this.fDocumentStamp != -1L) {
                try {
                    ((IDocumentExtension4)document).replace(0, 0, "", this.fDocumentStamp);
                    setContentStampSuccess[0] = true;
                }
                catch (BadLocationException e) {
                    throw CleanUpPostSaveListener.wrapBadLocationException(e);
                }
            }
        }

        static /* synthetic */ void access$0(CleanUpSaveUndo cleanUpSaveUndo, IDocument iDocument, long l, LinkedList linkedList, long[] lArray, boolean[] blArray) throws MalformedTreeException, BadLocationException, CoreException {
            cleanUpSaveUndo.performEdit(iDocument, l, linkedList, lArray, blArray);
        }
    }

    private static final class SlowCleanUpWarningDialog
    extends OptionalMessageDialog {
        private static final String ID = "SaveActions.slowWarningDialog";
        private final String fCleanUpNames;

        protected SlowCleanUpWarningDialog(Shell parent, String title, String cleanUpNames) {
            super(ID, parent, title, null, null, 4, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
            this.fCleanUpNames = cleanUpNames;
        }

        protected Control createMessageArea(Composite parent) {
            this.initializeDialogUnits((Control)parent);
            Composite messageComposite = new Composite(parent, 0);
            messageComposite.setFont(parent.getFont());
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
            layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
            messageComposite.setLayout((Layout)layout);
            messageComposite.setLayoutData((Object)new GridData(4, 4, true, true));
            Label explain = new Label(messageComposite, 64);
            explain.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            explain.setText(FixMessages.CleanUpPostSaveListener_SlowCleanUpWarningDialog_explain);
            BulletListBlock cleanUpListBlock = new BulletListBlock(messageComposite, 0);
            GridData gridData = new GridData(4, 4, true, true);
            cleanUpListBlock.setLayoutData(gridData);
            cleanUpListBlock.setText(this.fCleanUpNames);
            TextLayout textLayout = new TextLayout((Device)messageComposite.getDisplay());
            textLayout.setText(this.fCleanUpNames);
            int lineCount = textLayout.getLineCount();
            if (lineCount < 5) {
                gridData.heightHint = textLayout.getLineBounds((int)0).height * 6;
            }
            textLayout.dispose();
            Link link = new Link(messageComposite, 0);
            link.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            link.setText(FixMessages.CleanUpPostSaveListener_SlowCleanUpDialog_link);
            link.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ SlowCleanUpWarningDialog this$1;
                {
                    this.this$1 = slowCleanUpWarningDialog;
                }

                public void widgetSelected(SelectionEvent e) {
                    PreferencesUtil.createPreferenceDialogOn((Shell)this.this$1.getShell(), (String)"org.eclipse.jdt.ui.preferences.SaveParticipantPreferencePage", null, null).open();
                }
            });
            return messageComposite;
        }
    }
}

