/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.PackageSelectionDialog;
import org.eclipse.jdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jdt.internal.ui.preferences.TypeFilterInputDialog;
import org.eclipse.jdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.CheckedListDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class TypeFilterPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String TYPE_FILTER_PREF_PAGE_ID = "org.eclipse.jdt.ui.preferences.TypeFilterPreferencePage";
    private static final String PREF_FILTER_ENABLED = "org.eclipse.jdt.ui.typefilter.enabled";
    private static final String PREF_FILTER_DISABLED = "org.eclipse.jdt.ui.typefilter.disabled";
    private static final int IDX_ADD = 0;
    private static final int IDX_ADD_PACKAGE = 1;
    private static final int IDX_EDIT = 2;
    private static final int IDX_REMOVE = 3;
    private static final int IDX_SELECT = 5;
    private static final int IDX_DESELECT = 6;
    private CheckedListDialogField fFilterListField;
    private SelectionButtonDialogField fHideForbiddenField;
    private SelectionButtonDialogField fHideDiscouragedField;

    private static String[] unpackOrderList(String str) {
        StringTokenizer tok = new StringTokenizer(str, ";");
        int nTokens = tok.countTokens();
        String[] res = new String[nTokens];
        int i = 0;
        while (i < nTokens) {
            res[i] = tok.nextToken();
            ++i;
        }
        return res;
    }

    private static String packOrderList(List orderList) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < orderList.size()) {
            buf.append((String)orderList.get(i));
            buf.append(';');
            ++i;
        }
        return buf.toString();
    }

    public TypeFilterPreferencePage() {
        this.setPreferenceStore(JavaPlugin.getDefault().getPreferenceStore());
        this.setDescription(PreferencesMessages.TypeFilterPreferencePage_description);
        String[] stringArray = new String[7];
        stringArray[0] = PreferencesMessages.TypeFilterPreferencePage_add_button;
        stringArray[1] = PreferencesMessages.TypeFilterPreferencePage_addpackage_button;
        stringArray[2] = PreferencesMessages.TypeFilterPreferencePage_edit_button;
        stringArray[3] = PreferencesMessages.TypeFilterPreferencePage_remove_button;
        stringArray[5] = PreferencesMessages.TypeFilterPreferencePage_selectall_button;
        stringArray[6] = PreferencesMessages.TypeFilterPreferencePage_deselectall_button;
        String[] buttonLabels = stringArray;
        TypeFilterAdapter adapter = new TypeFilterAdapter();
        this.fFilterListField = new CheckedListDialogField(adapter, buttonLabels, (ILabelProvider)new LabelProvider());
        this.fFilterListField.setDialogFieldListener(adapter);
        this.fFilterListField.setLabelText(PreferencesMessages.TypeFilterPreferencePage_list_label);
        this.fFilterListField.setCheckAllButtonIndex(5);
        this.fFilterListField.setUncheckAllButtonIndex(6);
        this.fFilterListField.setRemoveButtonIndex(3);
        this.fFilterListField.enableButton(2, false);
        this.fHideForbiddenField = new SelectionButtonDialogField(32);
        this.fHideForbiddenField.setLabelText(PreferencesMessages.TypeFilterPreferencePage_hideForbidden_label);
        this.fHideDiscouragedField = new SelectionButtonDialogField(32);
        this.fHideDiscouragedField.setLabelText(PreferencesMessages.TypeFilterPreferencePage_hideDiscouraged_label);
        this.initialize(false);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.jdt.ui.type_filter_preference_page_context");
    }

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        this.fFilterListField.doFillIntoGrid(composite, 3);
        LayoutUtil.setHorizontalSpan((Control)this.fFilterListField.getLabelControl(null), 2);
        LayoutUtil.setWidthHint((Control)this.fFilterListField.getLabelControl(null), this.convertWidthInCharsToPixels(40));
        LayoutUtil.setHorizontalGrabbing(this.fFilterListField.getListControl(null));
        this.fFilterListField.getTableViewer().setComparator(new ViewerComparator());
        Label spacer = new Label(composite, 16384);
        GridData gd = new GridData(-1, this.convertHeightInCharsToPixels(1) / 2);
        gd.horizontalSpan = 2;
        spacer.setLayoutData((Object)gd);
        String label = PreferencesMessages.TypeFilterPreferencePage_restricted_link;
        HashMap<String, String> targetInfo = new HashMap<String, String>(2);
        targetInfo.put("select_option_key", "org.eclipse.jdt.core.compiler.problem.forbiddenReference");
        targetInfo.put("select_option_qualifier", "org.eclipse.jdt.core");
        this.createPreferencePageLink(composite, label, targetInfo);
        this.fHideForbiddenField.doFillIntoGrid(composite, 2);
        this.fHideDiscouragedField.doFillIntoGrid(composite, 2);
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void createPreferencePageLink(Composite composite, String label, final Map targetInfo) {
        final Link link = new Link(composite, 0);
        link.setText(label);
        link.setLayoutData((Object)new GridData(1, 1, true, false, 2, 1));
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)link.getShell(), (String)e.text, null, (Object)targetInfo);
            }
        });
    }

    private void initialize(boolean fromDefault) {
        IPreferenceStore store = this.getPreferenceStore();
        String enabled = fromDefault ? store.getDefaultString(PREF_FILTER_ENABLED) : store.getString(PREF_FILTER_ENABLED);
        String disabled = fromDefault ? store.getDefaultString(PREF_FILTER_DISABLED) : store.getString(PREF_FILTER_DISABLED);
        ArrayList<String> res = new ArrayList<String>();
        String[] enabledEntries = TypeFilterPreferencePage.unpackOrderList(enabled);
        int i = 0;
        while (i < enabledEntries.length) {
            res.add(enabledEntries[i]);
            ++i;
        }
        String[] disabledEntries = TypeFilterPreferencePage.unpackOrderList(disabled);
        int i2 = 0;
        while (i2 < disabledEntries.length) {
            res.add(disabledEntries[i2]);
            ++i2;
        }
        this.fFilterListField.setElements(res);
        this.fFilterListField.setCheckedElements(Arrays.asList(enabledEntries));
        boolean hideForbidden = this.getJDTCoreOption("org.eclipse.jdt.core.codeComplete.forbiddenReferenceCheck", fromDefault);
        this.fHideForbiddenField.setSelection(hideForbidden);
        boolean hideDiscouraged = this.getJDTCoreOption("org.eclipse.jdt.core.codeComplete.discouragedReferenceCheck", fromDefault);
        this.fHideDiscouragedField.setSelection(hideDiscouraged);
    }

    private boolean getJDTCoreOption(String option, boolean fromDefault) {
        String value = fromDefault ? JavaCore.getDefaultOptions().get(option) : JavaCore.getOption((String)option);
        return "enabled".equals(value);
    }

    private void doButtonPressed(int index) {
        if (index == 0) {
            List existing = this.fFilterListField.getElements();
            TypeFilterInputDialog dialog = new TypeFilterInputDialog(this.getShell(), existing);
            if (dialog.open() == 0) {
                Object res = dialog.getResult();
                this.fFilterListField.addElement(res);
                this.fFilterListField.setChecked(res, true);
            }
        } else if (index == 1) {
            String[] res = this.choosePackage();
            if (res != null) {
                this.fFilterListField.addElements(Arrays.asList(res));
                int i = 0;
                while (i < res.length) {
                    this.fFilterListField.setChecked(res[i], true);
                    ++i;
                }
            }
        } else if (index == 2) {
            List selected = this.fFilterListField.getSelectedElements();
            if (selected.isEmpty()) {
                return;
            }
            String editedEntry = (String)selected.get(0);
            List existing = this.fFilterListField.getElements();
            existing.remove(editedEntry);
            TypeFilterInputDialog dialog = new TypeFilterInputDialog(this.getShell(), existing);
            dialog.setInitialString(editedEntry);
            if (dialog.open() == 0) {
                this.fFilterListField.replaceElement(editedEntry, dialog.getResult());
            }
        }
    }

    private String[] choosePackage() {
        IJavaSearchScope scope = SearchEngine.createWorkspaceScope();
        BusyIndicatorRunnableContext context = new BusyIndicatorRunnableContext();
        int flags = 7;
        PackageSelectionDialog dialog = new PackageSelectionDialog(this.getShell(), context, flags, scope);
        dialog.setTitle(PreferencesMessages.TypeFilterPreferencePage_choosepackage_label);
        dialog.setMessage(PreferencesMessages.TypeFilterPreferencePage_choosepackage_description);
        dialog.setMultipleSelection(true);
        if (dialog.open() == 0) {
            Object[] fragments = dialog.getResult();
            String[] res = new String[fragments.length];
            int i = 0;
            while (i < res.length) {
                res[i] = String.valueOf(((IPackageFragment)fragments[i]).getElementName()) + ".*";
                ++i;
            }
            return res;
        }
        return null;
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        this.initialize(true);
        super.performDefaults();
    }

    public boolean performOk() {
        IPreferenceStore prefs = JavaPlugin.getDefault().getPreferenceStore();
        List checked = this.fFilterListField.getCheckedElements();
        List unchecked = this.fFilterListField.getElements();
        unchecked.removeAll(checked);
        prefs.setValue(PREF_FILTER_ENABLED, TypeFilterPreferencePage.packOrderList(checked));
        prefs.setValue(PREF_FILTER_DISABLED, TypeFilterPreferencePage.packOrderList(unchecked));
        JavaPlugin.flushInstanceScope();
        Hashtable coreOptions = JavaCore.getOptions();
        String hideForbidden = this.fHideForbiddenField.isSelected() ? "enabled" : "disabled";
        coreOptions.put("org.eclipse.jdt.core.codeComplete.forbiddenReferenceCheck", hideForbidden);
        String hideDiscouraged = this.fHideDiscouragedField.isSelected() ? "enabled" : "disabled";
        coreOptions.put("org.eclipse.jdt.core.codeComplete.discouragedReferenceCheck", hideDiscouraged);
        JavaCore.setOptions((Hashtable)coreOptions);
        return true;
    }

    private class TypeFilterAdapter
    implements IListAdapter,
    IDialogFieldListener {
        private TypeFilterAdapter() {
        }

        private boolean canEdit(ListDialogField field) {
            return field.getSelectedElements().size() == 1;
        }

        public void customButtonPressed(ListDialogField field, int index) {
            TypeFilterPreferencePage.this.doButtonPressed(index);
        }

        public void selectionChanged(ListDialogField field) {
            TypeFilterPreferencePage.this.fFilterListField.enableButton(2, this.canEdit(field));
        }

        public void dialogFieldChanged(DialogField field) {
        }

        public void doubleClicked(ListDialogField field) {
            if (this.canEdit(field)) {
                TypeFilterPreferencePage.this.doButtonPressed(2);
            }
        }
    }
}

