/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.typehierarchy;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IRegion;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeHierarchyChangedListener;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.typehierarchy.HistoryAction;
import org.eclipse.jdt.internal.ui.typehierarchy.ITypeHierarchyLifeCycleListener;
import org.eclipse.jdt.internal.ui.typehierarchy.TypeHierarchyMessages;
import org.eclipse.jdt.internal.ui.typehierarchy.TypeHierarchyViewPart;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public class TypeHierarchyLifeCycle
implements ITypeHierarchyChangedListener,
IElementChangedListener {
    private boolean fHierarchyRefreshNeeded;
    private ITypeHierarchy fHierarchy = null;
    private IJavaElement[] fInputElements = null;
    private boolean fIsSuperTypesOnly;
    private List fChangeListeners;
    private TypeHierarchyViewPart fTypeHierarchyViewPart;
    private Job fRefreshHierarchyJob;
    private boolean fRefreshJobCanceledExplicitly = true;
    static /* synthetic */ Class class$0;

    public TypeHierarchyLifeCycle(TypeHierarchyViewPart part) {
        this(false);
        this.fTypeHierarchyViewPart = part;
        this.fRefreshHierarchyJob = null;
    }

    public TypeHierarchyLifeCycle(boolean isSuperTypesOnly) {
        this.fIsSuperTypesOnly = isSuperTypesOnly;
        this.fChangeListeners = new ArrayList(2);
    }

    public ITypeHierarchy getHierarchy() {
        return this.fHierarchy;
    }

    public IJavaElement[] getInputElements() {
        return this.fInputElements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeHierarchy() {
        if (this.fHierarchy != null) {
            this.fHierarchy.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
            JavaCore.removeElementChangedListener((IElementChangedListener)this);
            this.fHierarchy = null;
            this.fInputElements = null;
        }
        TypeHierarchyLifeCycle typeHierarchyLifeCycle = this;
        synchronized (typeHierarchyLifeCycle) {
            if (this.fRefreshHierarchyJob != null) {
                this.fRefreshHierarchyJob.cancel();
                this.fRefreshHierarchyJob = null;
            }
        }
    }

    public void removeChangedListener(ITypeHierarchyLifeCycleListener listener) {
        this.fChangeListeners.remove(listener);
    }

    public void addChangedListener(ITypeHierarchyLifeCycleListener listener) {
        if (!this.fChangeListeners.contains(listener)) {
            this.fChangeListeners.add(listener);
        }
    }

    private void fireChange(IType[] changedTypes) {
        int i = this.fChangeListeners.size() - 1;
        while (i >= 0) {
            ITypeHierarchyLifeCycleListener curr = (ITypeHierarchyLifeCycleListener)this.fChangeListeners.get(i);
            curr.typeHierarchyChanged(this, changedTypes);
            --i;
        }
    }

    public void ensureRefreshedTypeHierarchy(IJavaElement element, IRunnableContext context) throws InvocationTargetException, InterruptedException {
        this.ensureRefreshedTypeHierarchy(new IJavaElement[]{element}, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureRefreshedTypeHierarchy(final IJavaElement[] elements, IRunnableContext context) throws InvocationTargetException, InterruptedException {
        boolean hierachyCreationNeeded;
        TypeHierarchyLifeCycle typeHierarchyLifeCycle = this;
        synchronized (typeHierarchyLifeCycle) {
            block21: {
                if (this.fRefreshHierarchyJob != null) {
                    this.fRefreshHierarchyJob.cancel();
                    this.fRefreshJobCanceledExplicitly = false;
                    try {
                        try {
                            this.fRefreshHierarchyJob.join();
                        }
                        catch (InterruptedException interruptedException) {
                            this.fRefreshHierarchyJob = null;
                            this.fRefreshJobCanceledExplicitly = true;
                            break block21;
                        }
                    }
                    catch (Throwable throwable) {
                        this.fRefreshHierarchyJob = null;
                        this.fRefreshJobCanceledExplicitly = true;
                        throw throwable;
                    }
                    this.fRefreshHierarchyJob = null;
                    this.fRefreshJobCanceledExplicitly = true;
                }
            }
        }
        if (elements == null || elements.length == 0) {
            this.freeHierarchy();
            return;
        }
        int i = 0;
        while (i < elements.length) {
            if (elements[i] == null || !elements[i].exists()) {
                this.freeHierarchy();
                return;
            }
            ++i;
        }
        boolean bl = hierachyCreationNeeded = this.fHierarchy == null || !elements.equals(this.fInputElements);
        if (hierachyCreationNeeded || this.fHierarchyRefreshNeeded) {
            if (this.fTypeHierarchyViewPart == null) {
                IRunnableWithProgress op = new IRunnableWithProgress(){

                    public void run(IProgressMonitor pm) throws InvocationTargetException, InterruptedException {
                        try {
                            TypeHierarchyLifeCycle.this.doHierarchyRefresh(elements, pm);
                        }
                        catch (JavaModelException e) {
                            throw new InvocationTargetException(e);
                        }
                        catch (OperationCanceledException operationCanceledException) {
                            throw new InterruptedException();
                        }
                    }
                };
                this.fHierarchyRefreshNeeded = true;
                context.run(true, true, op);
                this.fHierarchyRefreshNeeded = false;
            } else {
                final String label = Messages.format(TypeHierarchyMessages.TypeHierarchyLifeCycle_computeInput, HistoryAction.getElementLabel(elements));
                TypeHierarchyLifeCycle typeHierarchyLifeCycle2 = this;
                synchronized (typeHierarchyLifeCycle2) {
                    this.fRefreshHierarchyJob = new Job(label){

                        public IStatus run(IProgressMonitor pm) {
                            pm.beginTask(label, 30);
                            try {
                                try {
                                    TypeHierarchyLifeCycle.this.doHierarchyRefreshBackground(elements, pm);
                                }
                                catch (OperationCanceledException operationCanceledException) {
                                    if (TypeHierarchyLifeCycle.this.fRefreshJobCanceledExplicitly) {
                                        TypeHierarchyLifeCycle.this.fTypeHierarchyViewPart.showEmptyViewer();
                                    }
                                    IStatus iStatus = Status.CANCEL_STATUS;
                                    TypeHierarchyLifeCycle.this.fHierarchyRefreshNeeded = true;
                                    pm.done();
                                    return iStatus;
                                }
                                catch (JavaModelException e) {
                                    IStatus iStatus = e.getStatus();
                                    TypeHierarchyLifeCycle.this.fHierarchyRefreshNeeded = true;
                                    pm.done();
                                    return iStatus;
                                }
                            }
                            finally {
                                TypeHierarchyLifeCycle.this.fHierarchyRefreshNeeded = true;
                                pm.done();
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    this.fRefreshHierarchyJob.setUser(true);
                    IWorkbenchPartSite iWorkbenchPartSite = this.fTypeHierarchyViewPart.getSite();
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.ui.progress.IWorkbenchSiteProgressService");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    IWorkbenchSiteProgressService progressService = (IWorkbenchSiteProgressService)iWorkbenchPartSite.getAdapter((Class)clazz);
                    progressService.schedule(this.fRefreshHierarchyJob, 0L);
                }
            }
        }
    }

    public boolean isRefreshJobRunning() {
        return this.fRefreshHierarchyJob != null;
    }

    protected void doHierarchyRefreshBackground(IJavaElement[] elements, final IProgressMonitor pm) throws JavaModelException {
        this.doHierarchyRefresh(elements, pm);
        if (!pm.isCanceled()) {
            Display.getDefault().asyncExec(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    TypeHierarchyLifeCycle typeHierarchyLifeCycle = TypeHierarchyLifeCycle.this;
                    synchronized (typeHierarchyLifeCycle) {
                        if (TypeHierarchyLifeCycle.this.fRefreshHierarchyJob == null) {
                            return;
                        }
                        TypeHierarchyLifeCycle.this.fRefreshHierarchyJob = null;
                    }
                    if (pm.isCanceled()) {
                        return;
                    }
                    TypeHierarchyLifeCycle.this.fTypeHierarchyViewPart.setViewersInput();
                    TypeHierarchyLifeCycle.this.fTypeHierarchyViewPart.updateViewers();
                }
            });
        }
    }

    private ITypeHierarchy createTypeHierarchy(IJavaElement[] elements, IProgressMonitor pm) throws JavaModelException {
        if (elements.length == 1 && elements[0].getElementType() == 7) {
            IType type = (IType)elements[0];
            if (this.fIsSuperTypesOnly) {
                return type.newSupertypeHierarchy(pm);
            }
            return type.newTypeHierarchy(pm);
        }
        IRegion region = JavaCore.newRegion();
        int i = 0;
        while (i < elements.length) {
            if (elements[i].getElementType() == 2) {
                IPackageFragmentRoot[] roots = ((IJavaProject)elements[i]).getPackageFragmentRoots();
                int j = 0;
                while (j < roots.length) {
                    if (!roots[j].isExternal()) {
                        region.add((IJavaElement)roots[j]);
                    }
                    ++j;
                }
            } else {
                region.add(elements[i]);
            }
            ++i;
        }
        return JavaCore.newTypeHierarchy((IRegion)region, null, (IProgressMonitor)pm);
    }

    public void doHierarchyRefresh(IJavaElement[] elements, IProgressMonitor pm) throws JavaModelException {
        boolean hierachyCreationNeeded;
        boolean bl = hierachyCreationNeeded = this.fHierarchy == null || !elements.equals(this.fInputElements);
        if (this.fHierarchy != null) {
            this.fHierarchy.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
            JavaCore.removeElementChangedListener((IElementChangedListener)this);
        }
        if (hierachyCreationNeeded) {
            this.fHierarchy = this.createTypeHierarchy(elements, pm);
            if (pm != null && pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.fInputElements = elements;
        } else {
            this.fHierarchy.refresh(pm);
            if (pm != null && pm.isCanceled()) {
                throw new OperationCanceledException();
            }
        }
        this.fHierarchy.addTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
        JavaCore.addElementChangedListener((IElementChangedListener)this);
        this.fHierarchyRefreshNeeded = false;
    }

    public void typeHierarchyChanged(ITypeHierarchy typeHierarchy) {
        this.fHierarchyRefreshNeeded = true;
        this.fireChange(null);
    }

    public void elementChanged(ElementChangedEvent event) {
        if (this.fChangeListeners.isEmpty()) {
            return;
        }
        if (this.fHierarchyRefreshNeeded) {
            return;
        }
        ArrayList changedTypes = new ArrayList();
        this.processDelta(event.getDelta(), changedTypes);
        if (changedTypes.size() > 0) {
            this.fireChange(changedTypes.toArray(new IType[changedTypes.size()]));
        }
    }

    private void processDelta(IJavaElementDelta delta, ArrayList changedTypes) {
        IJavaElement element = delta.getElement();
        switch (element.getElementType()) {
            case 7: {
                this.processTypeDelta((IType)element, changedTypes);
                this.processChildrenDelta(delta, changedTypes);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.processChildrenDelta(delta, changedTypes);
                break;
            }
            case 5: {
                ICompilationUnit cu = (ICompilationUnit)element;
                if (!JavaModelUtil.isPrimary(cu)) {
                    return;
                }
                if (delta.getKind() == 4 && this.isPossibleStructuralChange(delta.getFlags())) {
                    try {
                        if (!cu.exists()) break;
                        IType[] types = cu.getAllTypes();
                        int i = 0;
                        while (i < types.length) {
                            this.processTypeDelta(types[i], changedTypes);
                            ++i;
                        }
                    }
                    catch (JavaModelException e) {
                        JavaPlugin.log(e);
                    }
                    break;
                }
                this.processChildrenDelta(delta, changedTypes);
                break;
            }
            case 6: {
                if (delta.getKind() == 4) {
                    IType type = ((IClassFile)element).getType();
                    this.processTypeDelta(type, changedTypes);
                    break;
                }
                this.processChildrenDelta(delta, changedTypes);
            }
        }
    }

    private boolean isPossibleStructuralChange(int flags) {
        return (flags & 0x4001) == 1;
    }

    private void processTypeDelta(IType type, ArrayList changedTypes) {
        if (this.getHierarchy().contains(type)) {
            changedTypes.add(type);
        }
    }

    private void processChildrenDelta(IJavaElementDelta delta, ArrayList changedTypes) {
        IJavaElementDelta[] children = delta.getAffectedChildren();
        int i = 0;
        while (i < children.length) {
            this.processDelta(children[i], changedTypes);
            ++i;
        }
    }
}

