/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.cubebuilder.dialog;

import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.dialogs.helper.IDialogHelper;
import org.eclipse.birt.report.designer.internal.ui.dialogs.helper.IDialogHelperProvider;
import org.eclipse.birt.report.designer.internal.ui.expressions.IExpressionConverter;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.ExpressionButtonUtil;
import org.eclipse.birt.report.designer.internal.ui.util.ExpressionUtility;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.util.WidgetUtil;
import org.eclipse.birt.report.designer.ui.cubebuilder.dialog.LevelDynamicAttributeDialog;
import org.eclipse.birt.report.designer.ui.cubebuilder.dialog.LevelStaticAttributeDialog;
import org.eclipse.birt.report.designer.ui.cubebuilder.nls.Messages;
import org.eclipse.birt.report.designer.ui.cubebuilder.provider.CubeExpressionProvider;
import org.eclipse.birt.report.designer.ui.cubebuilder.provider.LinkToCubeExpressionProvider;
import org.eclipse.birt.report.designer.ui.cubebuilder.util.OlapUtil;
import org.eclipse.birt.report.designer.ui.dialogs.IExpressionProvider;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.designer.ui.views.ElementAdapterManager;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.ActionHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.FormatValueHandle;
import org.eclipse.birt.report.model.api.LevelAttributeHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.RuleHandle;
import org.eclipse.birt.report.model.api.SimpleValueHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.FormatValue;
import org.eclipse.birt.report.model.api.elements.structures.LevelAttribute;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.olap.TabularHierarchyHandle;
import org.eclipse.birt.report.model.api.olap.TabularLevelHandle;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class LevelPropertyDialog
extends TitleAreaDialog {
    private Composite dynamicArea;
    private DataSetHandle dataset;
    private boolean isNew;
    private static final String dummyChoice = "dummy";
    private IStructuredContentProvider contentProvider = new IStructuredContentProvider(){

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object input) {
            if (input instanceof List) {
                List list = (List)input;
                return list.toArray();
            }
            return new Object[0];
        }
    };
    private IStructuredContentProvider defaultValueContentProvider = new IStructuredContentProvider(){

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object input) {
            if (input instanceof TabularLevelHandle) {
                ArrayList<String> list = new ArrayList<String>();
                if (((TabularLevelHandle)input).getDefaultValue() != null) {
                    list.add(((TabularLevelHandle)input).getDefaultValue());
                } else {
                    list.add(LevelPropertyDialog.dummyChoice);
                }
                return list.toArray();
            }
            return new Object[0];
        }
    };
    private ITableLabelProvider staticLabelProvider = new ITableLabelProvider(){

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 1) {
                if (element == LevelPropertyDialog.dummyChoice) {
                    return Messages.getString("LevelPropertyDialog.MSG.Static.CreateNew");
                }
                if (element instanceof RuleHandle) {
                    return ((RuleHandle)element).getDisplayExpression();
                }
                return "";
            }
            if (columnIndex == 2) {
                if (element == LevelPropertyDialog.dummyChoice) {
                    return "";
                }
                if (element instanceof RuleHandle) {
                    return ((RuleHandle)element).getRuleExpression();
                }
                return "";
            }
            return "";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    };
    private ITableLabelProvider defaultValueLabelProvider = new ITableLabelProvider(){

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 1) {
                if (element == LevelPropertyDialog.dummyChoice) {
                    return Messages.getString("LevelPropertyDialog.MSG.DefaultValue");
                }
                if (element instanceof String) {
                    return (String)element;
                }
                return "";
            }
            if (columnIndex == 2) {
                return Messages.getString("LevelPropertyDialog.MSG.Tooltip");
            }
            return "";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    };
    private ITableLabelProvider dynamicLabelProvider = new ITableLabelProvider(){

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 1) {
                if (element == LevelPropertyDialog.dummyChoice) {
                    return Messages.getString("LevelPropertyDialog.MSG.Dynamic.CreateNew");
                }
                if (element instanceof LevelAttributeHandle) {
                    return ((LevelAttributeHandle)element).getName();
                }
            }
            return "";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    };
    private ICellModifier defaultValueCellModifier = new ICellModifier(){

        public boolean canModify(Object element, String property) {
            return property.equals(LevelPropertyDialog.Prop_DefaultValue);
        }

        public Object getValue(Object element, String property) {
            if (property.equals(LevelPropertyDialog.Prop_DefaultValue) && element != LevelPropertyDialog.dummyChoice && element instanceof String) {
                return (String)element;
            }
            return "";
        }

        public void modify(Object element, String property, Object value) {
            if (property.equals(LevelPropertyDialog.Prop_DefaultValue)) {
                try {
                    if (!value.toString().trim().equals("") && !value.equals(LevelPropertyDialog.dummyChoice)) {
                        LevelPropertyDialog.this.input.setDefaultValue(value.toString());
                    } else {
                        LevelPropertyDialog.this.input.setDefaultValue(null);
                    }
                }
                catch (SemanticException e) {
                    ExceptionUtil.handle((Throwable)e);
                }
            }
            LevelPropertyDialog.this.refreshStaticViewer();
        }
    };
    private int dynamicSelectIndex;
    String[] attributeItems = new String[0];
    private String[] dynamicMemeberItems;
    private TabularLevelHandle input;
    private TableViewer dynamicViewer;
    private Text nameText;
    private TableViewer staticViewer;
    private Composite staticArea;
    private Button dynamicButton;
    private Button staticButton;
    protected int staticSelectIndex;
    private static final String Prop_Name = "Name";
    private static final String prop_Expression = "Expression";
    private static final String prop_Attribute = "Attribute";
    private static final String Prop_DefaultValue = "DefaultValue";
    private static final String prop_Tooltip = "Tooltip";
    private Table dynamicTable;
    private Combo staticDataTypeCombo;
    private Text staticNameText;
    private Combo fieldCombo;
    private Combo dynamicDataTypeCombo;
    private Combo displayKeyCombo;
    private TableViewer defaultValueViewer;
    private Table defaultValueTable;
    private TableColumn[] defaultValueColumns;
    private TableColumn[] staticColumns;
    private IDialogHelper dynamicLevelHelper;
    private IDialogHelper dynamicMemberHelper;
    private IDialogHelper staticLevelHelper;
    private IDialogHelper staticMemberHelper;
    private IDialogHelper dynamicFormatHelper;
    private IDialogHelper staticFormatHelper;
    private IDialogHelper dynamicAlignmentHelper;
    private IDialogHelper staticAlignmentHelper;
    private Table staticTable;
    private Button staticEditButton;
    private Button staticRemoveButton;
    private Button dynamicEditButton;
    private Button dynamicRemoveButton;

    private IChoice[] getAvailableDataTypeChoices() {
        IChoice[] dataTypes = DEUtil.getMetaDataDictionary().getElement("Level").getProperty("dataType").getAllowedChoices().getChoices();
        ArrayList<IChoice> choiceList = new ArrayList<IChoice>();
        int i = 0;
        while (i < dataTypes.length) {
            choiceList.add(dataTypes[i]);
            ++i;
        }
        return choiceList.toArray(new IChoice[0]);
    }

    public String[] getDataTypeNames() {
        IChoice[] choices = this.getAvailableDataTypeChoices();
        if (choices == null) {
            return new String[0];
        }
        String[] names = new String[choices.length];
        int i = 0;
        while (i < choices.length) {
            names[i] = choices[i].getName();
            ++i;
        }
        return names;
    }

    public String getDataTypeDisplayName(String name) {
        return ChoiceSetFactory.getDisplayNameFromChoiceSet((String)name, (IChoiceSet)DEUtil.getMetaDataDictionary().getElement("Level").getProperty("dataType").getAllowedChoices());
    }

    private String[] getDataTypeDisplayNames() {
        IChoice[] choices = this.getAvailableDataTypeChoices();
        if (choices == null) {
            return new String[0];
        }
        String[] displayNames = new String[choices.length];
        int i = 0;
        while (i < choices.length) {
            displayNames[i] = choices[i].getDisplayName();
            ++i;
        }
        return displayNames;
    }

    public LevelPropertyDialog(boolean isNew) {
        super(UIUtil.getDefaultShell());
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.isNew = isNew;
    }

    protected Control createDialogArea(Composite parent) {
        UIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.cshelp.LevelPropertyDialog_ID");
        this.getShell().setText(Messages.getString("LevelPropertyDialog.Shell.Title"));
        if (this.isNew) {
            this.setTitle(Messages.getString("LevelPropertyDialog.Title.Add"));
        } else {
            this.setTitle(Messages.getString("LevelPropertyDialog.Title.Edit"));
        }
        this.setMessage(Messages.getString("LevelPropertyDialog.Message"));
        Composite area = (Composite)super.createDialogArea(parent);
        Composite contents = new Composite(area, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 20;
        contents.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.widthHint = this.convertWidthInCharsToPixels(80);
        data.heightHint = 400;
        contents.setLayoutData((Object)data);
        this.createChoiceArea(contents);
        this.dynamicArea = this.createDynamicArea(contents);
        this.staticArea = this.createStaticArea(contents);
        WidgetUtil.createGridPlaceholder((Composite)contents, (int)1, (boolean)true);
        this.initLevelDialog();
        parent.layout();
        return contents;
    }

    private void initLevelDialog() {
        if (this.input != null) {
            if (this.input.getLevelType() == null) {
                try {
                    this.input.setLevelType("dynamic");
                }
                catch (SemanticException e) {
                    ExceptionUtil.handle((Throwable)e);
                }
            }
            this.refreshDynamicViewer();
            this.dataset = OlapUtil.getHierarchyDataset((TabularHierarchyHandle)this.input.getContainer());
            if (this.dataset != null) {
                this.attributeItems = OlapUtil.getDataFieldNames(this.dataset);
            }
            this.resetEditorItems();
            if (this.input.getName() != null) {
                this.nameText.setText(this.input.getName());
            }
            this.dynamicDataTypeCombo.setItems(this.getDataTypeDisplayNames());
            this.dynamicDataTypeCombo.setText(this.getDataTypeDisplayName(this.input.getDataType()));
            this.fieldCombo.setItems(OlapUtil.getDataFieldDisplayNames(this.dataset));
            if (this.input.getColumnName() != null) {
                try {
                    this.fieldCombo.setText(OlapUtil.getDataFieldDisplayName(OlapUtil.getDataField(this.dataset, this.input.getColumnName())));
                }
                catch (Exception exception) {
                    this.fieldCombo.select(0);
                }
            } else {
                this.fieldCombo.select(0);
            }
            this.displayKeyCombo.setItems(OlapUtil.getDataFieldNames(this.dataset));
            this.displayKeyCombo.add(Messages.getString("LevelPropertyDialog.None"), 0);
            ExpressionButtonUtil.initExpressionButtonControl((Control)this.displayKeyCombo, (Object)this.input, (String)"displayColumnName");
            if (this.displayKeyCombo.getText().trim().length() == 0 && this.displayKeyCombo.getItemCount() > 0) {
                this.displayKeyCombo.select(0);
            }
            this.staticDataTypeCombo.setItems(this.getDataTypeDisplayNames());
            this.staticNameText.setText(this.input.getName());
            this.staticDataTypeCombo.setText(this.getDataTypeDisplayName(this.input.getDataType()));
            this.refreshStaticViewer();
            if (this.input.getLevelType().equals("dynamic")) {
                this.dynamicButton.setSelection(true);
                this.updateButtonStatus(this.dynamicButton);
                this.updateFormatHelper(this.dynamicFormatHelper, this.dynamicDataTypeCombo);
            } else {
                this.staticButton.setSelection(true);
                this.updateButtonStatus(this.staticButton);
                this.updateFormatHelper(this.staticFormatHelper, this.staticDataTypeCombo);
            }
        }
    }

    private void refreshDynamicViewer() {
        Iterator attrIter = this.input.attributesIterator();
        LinkedList attrList = new LinkedList();
        while (attrIter.hasNext()) {
            attrList.add(attrIter.next());
        }
        this.dynamicViewer.setInput(attrList);
    }

    private void refreshStaticViewer() {
        Iterator valuesIter = this.input.staticValuesIterator();
        LinkedList valuesList = new LinkedList();
        while (valuesIter.hasNext()) {
            valuesList.add(valuesIter.next());
        }
        this.staticViewer.setInput(valuesList);
        this.defaultValueViewer.setInput((Object)this.input);
        this.checkStaticViewerButtonStatus();
    }

    protected void okPressed() {
        IDialogHelper formatHelper = null;
        if (this.dynamicButton.getSelection()) {
            try {
                this.input.setLevelType("dynamic");
                if (this.nameText.getText() != null && !this.nameText.getText().trim().equals("")) {
                    this.input.setName(this.nameText.getText());
                }
                if (this.fieldCombo.getText() != null) {
                    this.input.setColumnName(OlapUtil.getDataFieldNames(this.dataset)[this.fieldCombo.getSelectionIndex()]);
                }
                if (this.displayKeyCombo.getText().trim().length() > 0 && !this.displayKeyCombo.getText().equals(Messages.getString("LevelPropertyDialog.None"))) {
                    ExpressionButtonUtil.saveExpressionButtonControl((Control)this.displayKeyCombo, (Object)this.input, (String)"displayColumnName");
                } else {
                    this.input.setDisplayColumnName(null);
                }
                if (this.dynamicDataTypeCombo.getText() != null) {
                    this.input.setDataType(this.getDataTypeNames()[this.dynamicDataTypeCombo.getSelectionIndex()]);
                }
                this.input.getPropertyHandle("staticValues").clearValue();
            }
            catch (SemanticException e) {
                ExceptionUtil.handle((Throwable)e);
                return;
            }
            if (this.dynamicLevelHelper != null) {
                try {
                    this.dynamicLevelHelper.validate();
                    this.input.setExpressionProperty("ACLExpression", (Expression)this.dynamicLevelHelper.getProperty("Security Expression Property"));
                }
                catch (SemanticException e) {
                    ExceptionUtil.handle((Throwable)e);
                }
            }
            if (this.dynamicMemberHelper != null) {
                try {
                    this.dynamicMemberHelper.validate();
                    this.input.setExpressionProperty("memberACLExpression", (Expression)this.dynamicMemberHelper.getProperty("Security Expression Property"));
                }
                catch (SemanticException e) {
                    ExceptionUtil.handle((Throwable)e);
                }
            }
            if (this.dynamicAlignmentHelper != null) {
                try {
                    this.input.setAlignment((String)this.dynamicAlignmentHelper.getProperty("Alignment Value"));
                }
                catch (SemanticException e) {
                    ExceptionUtil.handle((Throwable)e);
                }
            }
            formatHelper = this.dynamicFormatHelper;
        } else if (this.staticButton.getSelection()) {
            ActionHandle handle;
            try {
                this.input.setLevelType("mirrored");
                if (this.staticNameText.getText() != null && !this.staticNameText.getText().trim().equals("")) {
                    this.input.setName(this.staticNameText.getText());
                }
                this.input.setColumnName(null);
                this.input.setDisplayColumnName(null);
                if (this.staticDataTypeCombo.getText() != null) {
                    this.input.setDataType(this.getDataTypeNames()[this.staticDataTypeCombo.getSelectionIndex()]);
                }
                this.input.getPropertyHandle("attributes").clearValue();
            }
            catch (SemanticException e) {
                ExceptionUtil.handle((Throwable)e);
                return;
            }
            if (this.staticLevelHelper != null) {
                try {
                    this.staticLevelHelper.validate();
                    this.input.setExpressionProperty("ACLExpression", (Expression)this.staticLevelHelper.getProperty("Security Expression Property"));
                }
                catch (SemanticException e) {
                    ExceptionUtil.handle((Throwable)e);
                }
            }
            if (this.staticMemberHelper != null) {
                try {
                    this.staticMemberHelper.validate();
                    this.input.setExpressionProperty("memberACLExpression", (Expression)this.staticMemberHelper.getProperty("Security Expression Property"));
                }
                catch (SemanticException e) {
                    ExceptionUtil.handle((Throwable)e);
                }
            }
            if (this.staticAlignmentHelper != null) {
                try {
                    this.input.setAlignment((String)this.staticAlignmentHelper.getProperty("Alignment Value"));
                }
                catch (SemanticException e) {
                    ExceptionUtil.handle((Throwable)e);
                }
            }
            if ((handle = this.getActionHandle()) != null) {
                try {
                    handle.setToolTip(null);
                    handle.setExpressionProperty("uri", null);
                    handle.setTargetBookmark(null);
                    handle.setTargetBookmarkType(null);
                    handle.setTargetWindow(null);
                    handle.setTargetFileType(null);
                    handle.setReportName(null);
                    handle.setFormatType(null);
                    handle.getMember("paramBindings").setValue(null);
                    this.input.setProperty("action", null);
                }
                catch (SemanticException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            }
            formatHelper = this.staticFormatHelper;
        }
        if (formatHelper != null && formatHelper.getProperty("Format Value Result") instanceof Object[]) {
            Object[] formatValue = (Object[])formatHelper.getProperty("Format Value Result");
            Object value = this.input.getProperty("format");
            try {
                if (value == null) {
                    FormatValue formatValueToSet = new FormatValue();
                    formatValueToSet.setCategory((String)formatValue[0]);
                    formatValueToSet.setPattern((String)formatValue[1]);
                    formatValueToSet.setLocale((ULocale)formatValue[2]);
                    this.input.setProperty("format", (Object)formatValueToSet);
                } else {
                    PropertyHandle propHandle = this.input.getPropertyHandle("format");
                    FormatValue formatValueToSet = (FormatValue)value;
                    FormatValueHandle formatHandle = (FormatValueHandle)formatValueToSet.getHandle((SimpleValueHandle)propHandle);
                    formatHandle.setCategory((String)formatValue[0]);
                    formatHandle.setPattern((String)formatValue[1]);
                    formatHandle.setLocale((ULocale)formatValue[2]);
                }
            }
            catch (SemanticException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        super.okPressed();
    }

    private ActionHandle getActionHandle() {
        return DEUtil.getActionHandle((ReportElementHandle)this.input);
    }

    protected Composite createDynamicArea(Composite parent) {
        Composite contents = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        contents.setLayout((Layout)layout);
        GridData data = new GridData(768);
        contents.setLayoutData((Object)data);
        Group groupGroup = new Group(contents, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        groupGroup.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        groupGroup.setLayoutData((Object)gd);
        Label nameLabel = new Label((Composite)groupGroup, 0);
        nameLabel.setText(Messages.getString("LevelPropertyDialog.Name"));
        this.nameText = new Text((Composite)groupGroup, 2048);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.nameText.setLayoutData((Object)gd);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LevelPropertyDialog.this.checkOkButtonStatus();
            }
        });
        Label fieldLabel = new Label((Composite)groupGroup, 0);
        fieldLabel.setText(Messages.getString("LevelPropertyDialog.KeyField"));
        this.fieldCombo = new Combo((Composite)groupGroup, 2056);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fieldCombo.setLayoutData((Object)gd);
        this.fieldCombo.setVisibleItemCount(30);
        this.fieldCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Iterator attrIter = LevelPropertyDialog.this.input.attributesIterator();
                while (attrIter.hasNext()) {
                    LevelAttributeHandle handle = (LevelAttributeHandle)attrIter.next();
                    if (handle == null || LevelPropertyDialog.this.fieldCombo == null || LevelPropertyDialog.this.fieldCombo.getText() == null || !LevelPropertyDialog.this.fieldCombo.getText().equals(handle.getName())) continue;
                    try {
                        handle.drop();
                    }
                    catch (PropertyValueException e1) {
                        ExceptionHandler.handle((Throwable)e1);
                    }
                }
                LevelPropertyDialog.this.refreshDynamicViewer();
                LevelPropertyDialog.this.checkOkButtonStatus();
            }
        });
        Label displayKeyLabel = new Label((Composite)groupGroup, 0);
        displayKeyLabel.setText(Messages.getString("LevelPropertyDialog.DisplayField"));
        this.displayKeyCombo = new Combo((Composite)groupGroup, 2048);
        gd = new GridData(768);
        this.displayKeyCombo.setLayoutData((Object)gd);
        this.displayKeyCombo.setVisibleItemCount(30);
        this.displayKeyCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String value;
                IExpressionConverter converter;
                if (LevelPropertyDialog.this.displayKeyCombo.getSelectionIndex() > 0 && (converter = ExpressionButtonUtil.getCurrentExpressionConverter((Control)LevelPropertyDialog.this.displayKeyCombo)) != null && (value = ExpressionUtility.getResultSetColumnExpression((String)LevelPropertyDialog.this.displayKeyCombo.getText(), (IExpressionConverter)converter)) != null) {
                    LevelPropertyDialog.this.displayKeyCombo.setText(value);
                }
            }
        });
        ExpressionButtonUtil.createExpressionButton((Composite)groupGroup, (Control)this.displayKeyCombo, (IExpressionProvider)new CubeExpressionProvider((DesignElementHandle)this.input), (Object)this.input);
        new Label((Composite)groupGroup, 0).setText(Messages.getString("LevelPropertyDialog.DataType"));
        this.dynamicDataTypeCombo = new Combo((Composite)groupGroup, 2056);
        this.dynamicDataTypeCombo.setLayoutData((Object)new GridData(768));
        this.dynamicDataTypeCombo.setVisibleItemCount(30);
        this.dynamicDataTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LevelPropertyDialog.this.updateFormatHelper(LevelPropertyDialog.this.dynamicFormatHelper, LevelPropertyDialog.this.dynamicDataTypeCombo);
                LevelPropertyDialog.this.checkOkButtonStatus();
            }
        });
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.dynamicDataTypeCombo.setLayoutData((Object)gd);
        this.dynamicLevelHelper = this.createLevelSecurityPart((Composite)groupGroup);
        this.dynamicMemberHelper = this.createMemberSecurityPart((Composite)groupGroup);
        this.createHyperLinkPart((Composite)groupGroup);
        this.dynamicFormatHelper = this.createFormatPart((Composite)groupGroup);
        this.dynamicAlignmentHelper = this.createAlignmentPart((Composite)groupGroup);
        this.dynamicTable = new Table(contents, 68356);
        gd = new GridData(1808);
        gd.heightHint = 150;
        gd.verticalSpan = 3;
        this.dynamicTable.setLayoutData((Object)gd);
        this.dynamicTable.setLinesVisible(true);
        this.dynamicTable.setHeaderVisible(true);
        this.dynamicTable.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    LevelPropertyDialog.this.deleteDynamicAttribute();
                }
            }
        });
        this.dynamicTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                LevelPropertyDialog.this.handleDynamicTableEditEvent();
            }
        });
        this.dynamicViewer = new TableViewer(this.dynamicTable);
        String[] columns = new String[]{" ", Messages.getString("LevelPropertyDialog.Label.Attribute")};
        TableColumn column = new TableColumn(this.dynamicTable, 16384);
        column.setText(columns[0]);
        column.setWidth(15);
        TableColumn column1 = new TableColumn(this.dynamicTable, 16384);
        column1.setResizable(columns[1] != null);
        if (columns[1] != null) {
            column1.setText(columns[1]);
        }
        column1.setWidth(230);
        this.dynamicViewer.setColumnProperties(new String[]{"", prop_Attribute});
        this.dynamicViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.dynamicViewer.setLabelProvider((IBaseLabelProvider)this.dynamicLabelProvider);
        Button dynamicAddButton = new Button(contents, 8);
        dynamicAddButton.setText(Messages.getString("LevelPropertyDialog.DynamicTable.Button.Add"));
        gd = new GridData(1040);
        gd.verticalAlignment = 0x1000008;
        gd.horizontalAlignment = 4;
        dynamicAddButton.setLayoutData((Object)gd);
        dynamicAddButton.setEnabled(true);
        dynamicAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LevelPropertyDialog.this.resetEditorItems();
                LevelDynamicAttributeDialog dialog = new LevelDynamicAttributeDialog(Messages.getString("LevelPropertyDialog.DynamicAttributeDialog.Title.New"));
                dialog.setInput(LevelPropertyDialog.this.dynamicMemeberItems);
                if (dialog.open() == 0) {
                    LevelAttribute attribute = StructureFactory.createLevelAttribute();
                    attribute.setName((String)dialog.getResult());
                    if (LevelPropertyDialog.this.dataset != null) {
                        ResultSetColumnHandle dataField = OlapUtil.getDataField(LevelPropertyDialog.this.dataset, attribute.getName());
                        attribute.setDataType(dataField.getDataType());
                    }
                    try {
                        LevelPropertyDialog.this.input.getPropertyHandle("attributes").addItem((IStructure)attribute);
                    }
                    catch (SemanticException e1) {
                        ExceptionUtil.handle((Throwable)e1);
                    }
                    LevelPropertyDialog.this.refreshDynamicViewer();
                }
                if (LevelPropertyDialog.this.dynamicTable.getItemCount() > 0) {
                    LevelPropertyDialog.this.dynamicSelectIndex = LevelPropertyDialog.this.dynamicTable.getItemCount() - 1;
                    LevelPropertyDialog.this.dynamicTable.select(LevelPropertyDialog.this.dynamicSelectIndex);
                    LevelPropertyDialog.this.checkDynamicViewerButtonStatus();
                }
            }
        });
        this.dynamicEditButton = new Button(contents, 8);
        this.dynamicEditButton.setText(Messages.getString("LevelPropertyDialog.DynamicTable.Button.Edit"));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        this.dynamicEditButton.setLayoutData((Object)gd);
        this.dynamicEditButton.setEnabled(false);
        this.dynamicEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LevelPropertyDialog.this.handleDynamicTableEditEvent();
            }
        });
        this.dynamicRemoveButton = new Button(contents, 8);
        this.dynamicRemoveButton.setText(Messages.getString("LevelPropertyDialog.DynamicTable.Button.Remove"));
        gd = new GridData(1040);
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        this.dynamicRemoveButton.setLayoutData((Object)gd);
        this.dynamicRemoveButton.setEnabled(false);
        this.dynamicRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LevelPropertyDialog.this.deleteDynamicAttribute();
            }
        });
        this.dynamicTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LevelPropertyDialog.this.checkDynamicViewerButtonStatus();
            }
        });
        return contents;
    }

    private IDialogHelper createLevelSecurityPart(Composite parent) {
        Object[] helperProviders = ElementAdapterManager.getAdapters((Object)this.input, IDialogHelperProvider.class);
        if (helperProviders != null) {
            int i = 0;
            while (i < helperProviders.length) {
                IDialogHelper levelHelper;
                IDialogHelperProvider helperProvider = (IDialogHelperProvider)helperProviders[i];
                if (helperProvider != null && (levelHelper = helperProvider.createHelper((Object)this, "Security Helper")) != null) {
                    levelHelper.setProperty("Security Label", (Object)Messages.getString("LevelPropertyDialog.Access.Control.List.Expression"));
                    levelHelper.setProperty("Security Expression Context", (Object)this.input);
                    levelHelper.setProperty("Security Expression Provider", (Object)new CubeExpressionProvider((DesignElementHandle)this.input));
                    levelHelper.setProperty("Security Expression Property", (Object)this.input.getACLExpression());
                    levelHelper.createContent(parent);
                    levelHelper.addListener(24, new Listener(){

                        public void handleEvent(Event event) {
                            levelHelper.update(false);
                        }
                    });
                    levelHelper.update(true);
                    return levelHelper;
                }
                ++i;
            }
        }
        return null;
    }

    private IDialogHelper createMemberSecurityPart(Composite parent) {
        Object[] helperProviders = ElementAdapterManager.getAdapters((Object)this.input, IDialogHelperProvider.class);
        if (helperProviders != null) {
            int i = 0;
            while (i < helperProviders.length) {
                IDialogHelper memberHelper;
                IDialogHelperProvider helperProvider = (IDialogHelperProvider)helperProviders[i];
                if (helperProvider != null && (memberHelper = helperProvider.createHelper((Object)this, "Security Helper")) != null) {
                    memberHelper.setProperty("Security Label", (Object)Messages.getString("LevelPropertyDialog.Member.Access.Control.List.Expression"));
                    memberHelper.setProperty("Security Expression Context", (Object)this.input);
                    memberHelper.setProperty("Security Expression Provider", (Object)new CubeExpressionProvider((DesignElementHandle)this.input));
                    memberHelper.setProperty("Security Expression Property", (Object)this.input.getMemberACLExpression());
                    memberHelper.createContent(parent);
                    memberHelper.addListener(24, new Listener(){

                        public void handleEvent(Event event) {
                            memberHelper.update(false);
                        }
                    });
                    memberHelper.update(true);
                    return memberHelper;
                }
                ++i;
            }
        }
        return null;
    }

    private IDialogHelper createHyperLinkPart(Composite parent) {
        Object[] helperProviders = ElementAdapterManager.getAdapters((Object)this.input, IDialogHelperProvider.class);
        if (helperProviders != null) {
            int i = 0;
            while (i < helperProviders.length) {
                IDialogHelper hyperLinkHelper;
                IDialogHelperProvider helperProvider = (IDialogHelperProvider)helperProviders[i];
                if (helperProvider != null && (hyperLinkHelper = helperProvider.createHelper((Object)this, "HyperLink Helper")) != null) {
                    hyperLinkHelper.setProperty("HyperLink Label", (Object)Messages.getString("LevelPropertyDialog.Label.LinkTo"));
                    hyperLinkHelper.setProperty("HyperLink Button Text", (Object)Messages.getString("LevelPropertyDialog.Button.Text.Edit"));
                    hyperLinkHelper.setProperty("HyperLink Report Item Handle", (Object)this.input);
                    hyperLinkHelper.setProperty("HyperLink Report Item Expression Provider", (Object)new LinkToCubeExpressionProvider((DesignElementHandle)this.input));
                    hyperLinkHelper.createContent(parent);
                    hyperLinkHelper.addListener(24, new Listener(){

                        public void handleEvent(Event event) {
                            hyperLinkHelper.update(false);
                        }
                    });
                    hyperLinkHelper.update(true);
                    return hyperLinkHelper;
                }
                ++i;
            }
        }
        return null;
    }

    private IDialogHelper createFormatPart(Composite parent) {
        Object[] helperProviders = ElementAdapterManager.getAdapters((Object)this.input, IDialogHelperProvider.class);
        if (helperProviders != null) {
            int i = 0;
            while (i < helperProviders.length) {
                IDialogHelper formatHelper;
                IDialogHelperProvider helperProvider = (IDialogHelperProvider)helperProviders[i];
                if (helperProvider != null && (formatHelper = helperProvider.createHelper((Object)this, "Format Helper")) != null) {
                    formatHelper.setProperty("Format Label", (Object)Messages.getString("LevelPropertyDialog.Label.Format"));
                    formatHelper.setProperty("Format Button Text", (Object)Messages.getString("LevelPropertyDialog.Button.Format.Edit"));
                    PropertyHandle propHandle = this.input.getPropertyHandle("format");
                    if (this.input.getProperty("format") != null) {
                        Object value = this.input.getProperty("format");
                        FormatValue formatValueToSet = (FormatValue)value;
                        FormatValueHandle formatHandle = (FormatValueHandle)formatValueToSet.getHandle((SimpleValueHandle)propHandle);
                        formatHelper.setProperty("Format Value", (Object)formatHandle);
                    }
                    formatHelper.createContent(parent);
                    formatHelper.update(true);
                    return formatHelper;
                }
                ++i;
            }
        }
        return null;
    }

    private IDialogHelper createAlignmentPart(Composite parent) {
        Object[] helperProviders = ElementAdapterManager.getAdapters((Object)this.input, IDialogHelperProvider.class);
        if (helperProviders != null) {
            int i = 0;
            while (i < helperProviders.length) {
                IDialogHelper alignmentHelper;
                IDialogHelperProvider helperProvider = (IDialogHelperProvider)helperProviders[i];
                if (helperProvider != null && (alignmentHelper = helperProvider.createHelper((Object)this, "Alignment Helper")) != null) {
                    alignmentHelper.setProperty("Alignment Label", (Object)Messages.getString("LevelPropertyDialog.Label.Alignment"));
                    if (this.input.getAlignment() != null) {
                        alignmentHelper.setProperty("Alignment Value", (Object)this.input.getAlignment());
                    } else if (this.isNew && this.input.getDataType() != null) {
                        if (this.isNumber(this.input.getDataType())) {
                            alignmentHelper.setProperty("Alignment Value", (Object)"right");
                        } else {
                            alignmentHelper.setProperty("Alignment Value", (Object)"left");
                        }
                    }
                    alignmentHelper.createContent(parent);
                    alignmentHelper.update(true);
                    return alignmentHelper;
                }
                ++i;
            }
        }
        return null;
    }

    private boolean isNumber(String dataType) {
        return "decimal".equals(dataType) || "float".equals(dataType) || "integer".equals(dataType);
    }

    private void resetEditorItems() {
        this.resetEditorItems(null);
    }

    private void resetEditorItems(String name) {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(Arrays.asList(this.attributeItems));
        Iterator attrIter = this.input.attributesIterator();
        while (attrIter.hasNext()) {
            LevelAttributeHandle handle = (LevelAttributeHandle)attrIter.next();
            list.remove(handle.getName());
        }
        list.remove(this.fieldCombo.getText());
        if (name != null && !list.contains(name)) {
            list.add(0, name);
        }
        String[] temps = new String[list.size()];
        list.toArray(temps);
        this.dynamicMemeberItems = temps;
    }

    protected void handleDynamicDelEvent() {
        Object element;
        if (this.dynamicViewer.getSelection() != null && this.dynamicViewer.getSelection() instanceof StructuredSelection && (element = ((StructuredSelection)this.dynamicViewer.getSelection()).getFirstElement()) instanceof LevelAttributeHandle) {
            try {
                ((LevelAttributeHandle)element).drop();
            }
            catch (PropertyValueException e) {
                ExceptionUtil.handle((Throwable)e);
            }
        }
    }

    protected void handleStaticDelEvent() {
        Object element;
        if (this.staticViewer.getSelection() != null && this.staticViewer.getSelection() instanceof StructuredSelection && (element = ((StructuredSelection)this.staticViewer.getSelection()).getFirstElement()) instanceof RuleHandle) {
            try {
                ((RuleHandle)element).drop();
            }
            catch (PropertyValueException e) {
                ExceptionUtil.handle((Throwable)e);
            }
        }
    }

    private void createChoiceArea(Composite parent) {
        Composite contents = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        contents.setLayout((Layout)layout);
        GridData data = new GridData(768);
        contents.setLayoutData((Object)data);
        this.dynamicButton = new Button(contents, 16);
        this.dynamicButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    LevelPropertyDialog.this.input.setLevelType("dynamic");
                }
                catch (SemanticException e1) {
                    ExceptionUtil.handle((Throwable)e1);
                }
                LevelPropertyDialog.this.updateButtonStatus(LevelPropertyDialog.this.dynamicButton);
            }
        });
        this.staticButton = new Button(contents, 16);
        this.staticButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    LevelPropertyDialog.this.input.setLevelType("mirrored");
                }
                catch (SemanticException e1) {
                    ExceptionUtil.handle((Throwable)e1);
                }
                LevelPropertyDialog.this.updateButtonStatus(LevelPropertyDialog.this.staticButton);
            }
        });
        this.dynamicButton.setText(Messages.getString("LevelPropertyDialog.Button.Dynamic"));
        this.staticButton.setText(Messages.getString("LevelPropertyDialog.Button.Static"));
    }

    protected void updateButtonStatus(Button button) {
        if (button == this.dynamicButton) {
            this.staticButton.setSelection(false);
            this.dynamicButton.setSelection(true);
            LevelPropertyDialog.setExcludeGridData((Control)this.staticArea, true);
            LevelPropertyDialog.setExcludeGridData((Control)this.dynamicArea, false);
            this.updateFormatHelper(this.dynamicFormatHelper, this.dynamicDataTypeCombo);
            try {
                this.input.setLevelType("dynamic");
            }
            catch (SemanticException e) {
                ExceptionUtil.handle((Throwable)e);
            }
        } else if (button == this.staticButton) {
            this.dynamicButton.setSelection(false);
            this.staticButton.setSelection(true);
            LevelPropertyDialog.setExcludeGridData((Control)this.dynamicArea, true);
            LevelPropertyDialog.setExcludeGridData((Control)this.staticArea, false);
            this.updateFormatHelper(this.staticFormatHelper, this.staticDataTypeCombo);
            try {
                this.input.setLevelType("mirrored");
            }
            catch (SemanticException e) {
                ExceptionUtil.handle((Throwable)e);
            }
        }
        this.getShell().layout();
        this.checkOkButtonStatus();
    }

    private void updateFormatHelper(IDialogHelper helper, Combo combo) {
        if (helper != null) {
            if (combo.getSelectionIndex() > -1) {
                helper.setProperty("Format Value Type", (Object)this.getDataTypeNames()[combo.getSelectionIndex()]);
            }
            helper.update(true);
        }
    }

    protected Composite createStaticArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        Group properties = new Group(container, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        properties.setLayout((Layout)layout);
        properties.setLayoutData((Object)new GridData(768));
        new Label((Composite)properties, 0).setText(Messages.getString("LevelPropertyDialog.Name"));
        this.staticNameText = new Text((Composite)properties, 2048);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.staticNameText.setLayoutData((Object)gd);
        this.staticNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LevelPropertyDialog.this.checkOkButtonStatus();
            }
        });
        new Label((Composite)properties, 0).setText(Messages.getString("LevelPropertyDialog.DataType"));
        this.staticDataTypeCombo = new Combo((Composite)properties, 2056);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.staticDataTypeCombo.setLayoutData((Object)gd);
        this.staticDataTypeCombo.setVisibleItemCount(30);
        this.staticDataTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LevelPropertyDialog.this.updateFormatHelper(LevelPropertyDialog.this.staticFormatHelper, LevelPropertyDialog.this.staticDataTypeCombo);
                LevelPropertyDialog.this.checkOkButtonStatus();
            }
        });
        this.staticLevelHelper = this.createLevelSecurityPart((Composite)properties);
        this.staticMemberHelper = this.createMemberSecurityPart((Composite)properties);
        this.staticFormatHelper = this.createFormatPart((Composite)properties);
        this.staticAlignmentHelper = this.createAlignmentPart((Composite)properties);
        Group contents = new Group(container, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        contents.setLayout((Layout)layout);
        contents.setLayoutData((Object)new GridData(768));
        this.staticTable = new Table((Composite)contents, 68356);
        gd = new GridData(1808);
        gd.heightHint = 150;
        gd.verticalSpan = 3;
        this.staticTable.setLayoutData((Object)gd);
        this.staticTable.setLinesVisible(true);
        this.staticTable.setHeaderVisible(true);
        this.staticTable.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    LevelPropertyDialog.this.deleteStaticAttribute();
                }
            }
        });
        this.staticTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                LevelPropertyDialog.this.handleStaticTableEditEvent();
            }
        });
        this.staticViewer = new TableViewer(this.staticTable);
        String[] columns = new String[]{"", Messages.getString("LevelPropertyDialog.Label.Name"), Messages.getString("LevelPropertyDialog.Label.Expression")};
        int[] widths = new int[]{15, 180, 180};
        this.staticColumns = new TableColumn[3];
        int i = 0;
        while (i < columns.length) {
            this.staticColumns[i] = new TableColumn(this.staticTable, 16384);
            this.staticColumns[i].setResizable(columns[i] != null);
            if (columns[i] != null) {
                this.staticColumns[i].setText(columns[i]);
            }
            this.staticColumns[i].setWidth(widths[i]);
            this.staticColumns[i].addControlListener(new ControlListener(){

                public void controlMoved(ControlEvent e) {
                }

                public void controlResized(ControlEvent e) {
                    LevelPropertyDialog.this.defaultValueColumns[0].setWidth(LevelPropertyDialog.this.staticColumns[0].getWidth());
                    LevelPropertyDialog.this.defaultValueColumns[1].setWidth(LevelPropertyDialog.this.staticColumns[1].getWidth());
                    LevelPropertyDialog.this.defaultValueColumns[2].setWidth(LevelPropertyDialog.this.staticColumns[2].getWidth());
                }
            });
            ++i;
        }
        this.staticViewer.setColumnProperties(new String[]{"", Prop_Name, prop_Expression});
        this.staticViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.staticViewer.setLabelProvider((IBaseLabelProvider)this.staticLabelProvider);
        Button staticAddButton = new Button((Composite)contents, 8);
        staticAddButton.setText(Messages.getString("LevelPropertyDialog.StaticTable.Button.Add"));
        gd = new GridData(1040);
        gd.verticalAlignment = 0x1000008;
        gd.horizontalAlignment = 4;
        staticAddButton.setLayoutData((Object)gd);
        staticAddButton.setEnabled(true);
        staticAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LevelStaticAttributeDialog dialog = new LevelStaticAttributeDialog(Messages.getString("LevelPropertyDialog.StaticAttributeDialog.Title.New"));
                dialog.setInput(LevelPropertyDialog.this.input);
                if (dialog.open() == 0) {
                    LevelPropertyDialog.this.refreshStaticViewer();
                }
                if (LevelPropertyDialog.this.staticTable.getItemCount() > 0) {
                    LevelPropertyDialog.this.staticSelectIndex = LevelPropertyDialog.this.staticTable.getItemCount() - 1;
                    LevelPropertyDialog.this.staticTable.select(LevelPropertyDialog.this.staticSelectIndex);
                    LevelPropertyDialog.this.checkStaticViewerButtonStatus();
                }
            }
        });
        this.staticEditButton = new Button((Composite)contents, 8);
        this.staticEditButton.setText(Messages.getString("LevelPropertyDialog.StaticTable.Button.Edit"));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        this.staticEditButton.setLayoutData((Object)gd);
        this.staticEditButton.setEnabled(false);
        this.staticEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LevelPropertyDialog.this.handleStaticTableEditEvent();
            }
        });
        this.staticRemoveButton = new Button((Composite)contents, 8);
        this.staticRemoveButton.setText(Messages.getString("LevelPropertyDialog.StaticTable.Button.Remove"));
        gd = new GridData(1040);
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        this.staticRemoveButton.setLayoutData((Object)gd);
        this.staticRemoveButton.setEnabled(false);
        this.staticRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LevelPropertyDialog.this.deleteStaticAttribute();
            }
        });
        this.staticTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LevelPropertyDialog.this.checkStaticViewerButtonStatus();
            }
        });
        this.defaultValueTable = new Table((Composite)contents, 68356);
        this.defaultValueTable.setHeaderVisible(false);
        this.defaultValueTable.setLinesVisible(true);
        gd = new GridData(768);
        gd.heightHint = this.defaultValueTable.getItemHeight();
        this.defaultValueTable.setLayoutData((Object)gd);
        this.defaultValueViewer = new TableViewer(this.defaultValueTable);
        this.defaultValueColumns = new TableColumn[3];
        int i2 = 0;
        while (i2 < columns.length) {
            this.defaultValueColumns[i2] = new TableColumn(this.defaultValueTable, 16384);
            this.defaultValueColumns[i2].setResizable(columns[i2] != null);
            this.defaultValueColumns[i2].setWidth(widths[i2]);
            ++i2;
        }
        this.defaultValueViewer.setColumnProperties(new String[]{"", Prop_DefaultValue, prop_Tooltip});
        CellEditor[] cellEditorArray = new CellEditor[3];
        cellEditorArray[1] = new TextCellEditor((Composite)this.defaultValueTable);
        CellEditor[] cellEditors = cellEditorArray;
        this.defaultValueViewer.setCellEditors(cellEditors);
        this.defaultValueViewer.setContentProvider((IContentProvider)this.defaultValueContentProvider);
        this.defaultValueViewer.setLabelProvider((IBaseLabelProvider)this.defaultValueLabelProvider);
        this.defaultValueViewer.setCellModifier(this.defaultValueCellModifier);
        return container;
    }

    protected void checkStaticViewerButtonStatus() {
        if (this.staticTable != null && !this.staticTable.isDisposed()) {
            if (this.staticTable.getSelectionCount() > 0) {
                this.setButtonEnabled(this.staticEditButton, true);
                this.setButtonEnabled(this.staticRemoveButton, true);
            } else {
                this.setButtonEnabled(this.staticEditButton, false);
                this.setButtonEnabled(this.staticRemoveButton, false);
            }
        } else {
            this.setButtonEnabled(this.staticEditButton, false);
            this.setButtonEnabled(this.staticRemoveButton, false);
        }
    }

    protected void checkDynamicViewerButtonStatus() {
        if (this.dynamicTable != null && !this.dynamicTable.isDisposed()) {
            if (this.dynamicTable.getSelectionCount() > 0) {
                this.setButtonEnabled(this.dynamicEditButton, true);
                this.setButtonEnabled(this.dynamicRemoveButton, true);
            } else {
                this.setButtonEnabled(this.dynamicEditButton, false);
                this.setButtonEnabled(this.dynamicRemoveButton, false);
            }
        } else {
            this.setButtonEnabled(this.dynamicEditButton, false);
            this.setButtonEnabled(this.dynamicRemoveButton, false);
        }
    }

    private void setButtonEnabled(Button button, boolean enabled) {
        if (button != null && !button.isDisposed()) {
            button.setEnabled(enabled);
        }
    }

    public void setInput(TabularLevelHandle level) {
        this.input = level;
    }

    public static void setExcludeGridData(Control control, boolean exclude) {
        Object obj = control.getLayoutData();
        if (obj == null) {
            control.setLayoutData((Object)new GridData());
        } else if (!(obj instanceof GridData)) {
            return;
        }
        GridData data = (GridData)control.getLayoutData();
        data.heightHint = exclude ? 0 : -1;
        control.setLayoutData((Object)data);
        control.getParent().layout();
        control.setVisible(!exclude);
    }

    protected void checkOkButtonStatus() {
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(false);
        }
        this.setMessage(null);
        if (this.dynamicButton.getSelection()) {
            if (this.nameText.getText() == null || this.nameText.getText().trim().equals("")) {
                this.setErrorMessage(Messages.getString("LevelPropertyDialog.Message.BlankName"));
            } else if (!UIUtil.validateDimensionName((String)this.nameText.getText())) {
                this.setErrorMessage(Messages.getString("LevelPropertyDialog.Message.NumericName"));
            } else if (this.fieldCombo.getSelectionIndex() == -1) {
                this.setErrorMessage(Messages.getString("LevelPropertyDialog.Message.BlankKeyField"));
            } else if (this.dynamicDataTypeCombo.getSelectionIndex() == -1) {
                this.setErrorMessage(Messages.getString("LevelPropertyDialog.Message.BlankDataType"));
            } else {
                if (this.getButton(0) != null) {
                    this.getButton(0).setEnabled(true);
                }
                this.setErrorMessage(null);
                this.setMessage(Messages.getString("LevelPropertyDialog.Message"));
            }
        } else if (this.staticNameText.getText() == null || this.staticNameText.getText().trim().equals("")) {
            this.setErrorMessage(Messages.getString("LevelPropertyDialog.Message.BlankName"));
        } else if (!UIUtil.validateDimensionName((String)this.staticNameText.getText())) {
            this.setErrorMessage(Messages.getString("LevelPropertyDialog.Message.NumericName"));
        } else if (this.staticDataTypeCombo.getSelectionIndex() == -1) {
            this.setErrorMessage(Messages.getString("LevelPropertyDialog.Message.BlankDataType"));
        } else {
            if (this.getButton(0) != null) {
                this.getButton(0).setEnabled(true);
            }
            this.setErrorMessage(null);
            this.setMessage(Messages.getString("LevelPropertyDialog.Message"));
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.checkOkButtonStatus();
        if (this.input != null && this.input.getLevelType() != null) {
            if (this.input.getLevelType().equals("dynamic")) {
                this.dynamicButton.setSelection(true);
                this.staticButton.setSelection(false);
            } else {
                this.dynamicButton.setSelection(false);
                this.staticButton.setSelection(true);
            }
        }
    }

    protected Point getInitialSize() {
        Point shellSize = super.getInitialSize();
        return new Point(Math.max(this.convertHorizontalDLUsToPixels(400), shellSize.x), Math.max(this.convertVerticalDLUsToPixels(350), shellSize.y));
    }

    private void deleteStaticAttribute() {
        if (this.staticTable.getSelectionCount() > 0) {
            this.staticSelectIndex = this.staticTable.getSelectionIndex();
            try {
                this.handleStaticDelEvent();
            }
            catch (Exception e1) {
                ExceptionUtil.handle((Throwable)e1);
            }
            this.refreshStaticViewer();
            int itemCount = this.staticTable.getItemCount();
            if (this.staticSelectIndex >= itemCount) {
                this.staticSelectIndex = itemCount - 1;
            }
            if (this.staticSelectIndex >= 0) {
                this.staticTable.select(this.staticSelectIndex);
            }
            this.checkStaticViewerButtonStatus();
        }
    }

    private void deleteDynamicAttribute() {
        if (this.dynamicTable.getSelectionCount() > 0) {
            this.dynamicSelectIndex = this.dynamicTable.getSelectionIndex();
            try {
                this.handleDynamicDelEvent();
            }
            catch (Exception e1) {
                ExceptionUtil.handle((Throwable)e1);
            }
            this.refreshDynamicViewer();
            int itemCount = this.dynamicTable.getItemCount();
            if (this.dynamicSelectIndex >= itemCount) {
                this.dynamicSelectIndex = itemCount - 1;
            }
            if (this.dynamicSelectIndex >= 0) {
                this.dynamicTable.select(this.dynamicSelectIndex);
            }
            this.checkDynamicViewerButtonStatus();
        }
    }

    private void handleStaticTableEditEvent() {
        if (((StructuredSelection)this.staticViewer.getSelection()).getFirstElement() instanceof RuleHandle) {
            this.staticSelectIndex = this.staticTable.getSelectionIndex();
            LevelStaticAttributeDialog dialog = new LevelStaticAttributeDialog(Messages.getString("LevelPropertyDialog.StaticAttributeDialog.Title.Edit"));
            dialog.setInput(this.input, (RuleHandle)((StructuredSelection)this.staticViewer.getSelection()).getFirstElement());
            if (dialog.open() == 0) {
                this.refreshStaticViewer();
            }
            this.staticTable.select(this.staticSelectIndex);
            this.checkStaticViewerButtonStatus();
        }
    }

    private void handleDynamicTableEditEvent() {
        if (((StructuredSelection)this.dynamicViewer.getSelection()).getFirstElement() instanceof LevelAttributeHandle) {
            LevelAttributeHandle handle = (LevelAttributeHandle)((StructuredSelection)this.dynamicViewer.getSelection()).getFirstElement();
            this.resetEditorItems(handle.getName());
            this.dynamicSelectIndex = this.dynamicTable.getSelectionIndex();
            LevelDynamicAttributeDialog dialog = new LevelDynamicAttributeDialog(Messages.getString("LevelPropertyDialog.DynamicAttributeDialog.Title.Edit"));
            dialog.setInput(this.dynamicMemeberItems, handle.getName());
            if (dialog.open() == 0) {
                try {
                    handle.setName((String)dialog.getResult());
                    if (this.dataset != null) {
                        ResultSetColumnHandle dataField = OlapUtil.getDataField(this.dataset, handle.getName());
                        handle.setDataType(dataField.getDataType());
                    }
                }
                catch (SemanticException e) {
                    ExceptionUtil.handle((Throwable)e);
                }
                this.refreshDynamicViewer();
            }
            this.dynamicTable.select(this.dynamicSelectIndex);
            this.checkDynamicViewerButtonStatus();
        }
    }
}

