/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.pde.api.tools.internal.model.ApiBaseline;
import org.eclipse.pde.api.tools.internal.model.ApiModelCache;
import org.eclipse.pde.api.tools.internal.model.ApiModelFactory;
import org.eclipse.pde.api.tools.internal.model.StubApiComponent;
import org.eclipse.pde.api.tools.internal.model.WorkspaceBaseline;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.IApiBaselineManager;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.DependencyManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class ApiBaselineManager
implements IApiBaselineManager,
ISaveParticipant {
    private static boolean DEBUG = Util.DEBUG;
    private static final String DEFAULT_BASELINE = "default_api_profile";
    public static final String WORKSPACE_API_BASELINE_ID = "workspace";
    private static final String BASELINE_FILE_EXTENSION = ".profile";
    private HashMap baselinecache = null;
    private HashMap handlecache = null;
    private HashSet hasinfos = null;
    private String defaultbaseline = null;
    private IApiBaseline workspacebaseline = null;
    private IPath savelocation = null;
    private boolean fNeedsSaving = false;
    private static ApiBaselineManager fInstance = null;

    public static void setDebug(boolean debugValue) {
        DEBUG = debugValue || Util.DEBUG;
    }

    private ApiBaselineManager(boolean framework) {
        if (framework) {
            ApiPlugin.getDefault().addSaveParticipant(this);
            this.savelocation = ApiPlugin.getDefault().getStateLocation().append(".api_profiles").addTrailingSeparator();
        }
    }

    public static synchronized ApiBaselineManager getManager() {
        if (fInstance == null) {
            fInstance = new ApiBaselineManager(ApiPlugin.isRunningInFramework());
        }
        return fInstance;
    }

    public synchronized IApiBaseline getApiBaseline(String name) {
        this.initializeStateCache();
        return (ApiBaseline)this.baselinecache.get(name);
    }

    public synchronized IApiBaseline[] getApiBaselines() {
        this.initializeStateCache();
        return this.baselinecache.values().toArray(new IApiBaseline[this.baselinecache.size()]);
    }

    public synchronized void addApiBaseline(IApiBaseline newbaseline) {
        if (newbaseline != null) {
            this.initializeStateCache();
            this.baselinecache.put(newbaseline.getName(), newbaseline);
            if (((ApiBaseline)newbaseline).peekInfos()) {
                this.hasinfos.add(newbaseline.getName());
            }
            this.fNeedsSaving = true;
        }
    }

    public synchronized boolean removeApiBaseline(String name) {
        if (name != null) {
            this.initializeStateCache();
            IApiBaseline baseline = (IApiBaseline)this.baselinecache.remove(name);
            if (baseline != null) {
                baseline.dispose();
                boolean success = true;
                if (this.savelocation == null) {
                    return success;
                }
                File file = this.savelocation.append(String.valueOf(name) + BASELINE_FILE_EXTENSION).toFile();
                if (file.exists()) {
                    success &= file.delete();
                }
                this.fNeedsSaving = true;
                ApiModelCache.getCache().removeElementInfo(baseline);
                return success;
            }
        }
        return false;
    }

    public void loadBaselineInfos(IApiBaseline baseline) throws CoreException {
        File file;
        this.initializeStateCache();
        if (this.hasinfos.contains(baseline.getName())) {
            return;
        }
        String filename = (String)this.handlecache.get(baseline.getName());
        if (filename != null && (file = new File(filename)).exists()) {
            block16: {
                FileInputStream inputStream = null;
                try {
                    try {
                        inputStream = new FileInputStream(file);
                        this.restoreBaseline(baseline, inputStream);
                    }
                    catch (IOException e) {
                        ApiPlugin.log(e);
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block16;
                    }
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            this.hasinfos.add(baseline.getName());
        }
    }

    private synchronized void initializeStateCache() {
        long time = System.currentTimeMillis();
        if (this.baselinecache == null) {
            String def;
            IApiBaseline baseline;
            this.handlecache = new HashMap(8);
            this.hasinfos = new HashSet(8);
            this.baselinecache = new HashMap(8);
            if (!ApiPlugin.isRunningInFramework()) {
                return;
            }
            File[] baselines = this.savelocation.toFile().listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.getName().endsWith(ApiBaselineManager.BASELINE_FILE_EXTENSION);
                }
            });
            if (baselines != null) {
                ApiBaseline newbaseline = null;
                int i = 0;
                while (i < baselines.length) {
                    File baseline2 = baselines[i];
                    if (baseline2.exists()) {
                        newbaseline = new ApiBaseline(new Path(baseline2.getName()).removeFileExtension().toString());
                        this.handlecache.put(newbaseline.getName(), baseline2.getAbsolutePath());
                        this.baselinecache.put(newbaseline.getName(), newbaseline);
                    }
                    ++i;
                }
            }
            String string = this.defaultbaseline = (baseline = (IApiBaseline)this.baselinecache.get(def = this.getDefaultProfilePref())) != null ? def : null;
            if (DEBUG) {
                System.out.println("Time to initialize state cache: " + (System.currentTimeMillis() - time) + "ms");
            }
        }
    }

    private String getDefaultProfilePref() {
        IPreferencesService service = Platform.getPreferencesService();
        return service.getString("org.eclipse.pde.api.tools", DEFAULT_BASELINE, null, new IScopeContext[]{new InstanceScope()});
    }

    private void persistStateCache() throws CoreException, IOException {
        if (this.savelocation == null) {
            return;
        }
        IEclipsePreferences node = new InstanceScope().getNode("org.eclipse.pde.api.tools");
        if (this.defaultbaseline != null) {
            node.put(DEFAULT_BASELINE, this.defaultbaseline);
        } else {
            node.remove(DEFAULT_BASELINE);
        }
        if (this.baselinecache != null && this.hasinfos != null) {
            File dir = new File(this.savelocation.toOSString());
            if (!dir.exists()) {
                dir.mkdirs();
            }
            String id = null;
            File file = null;
            FileOutputStream fout = null;
            IApiBaseline baseline = null;
            Iterator iter = this.baselinecache.keySet().iterator();
            while (iter.hasNext()) {
                id = (String)iter.next();
                baseline = (IApiBaseline)this.baselinecache.get(id);
                if (!this.hasinfos.contains(baseline.getName())) continue;
                file = this.savelocation.append(String.valueOf(id) + BASELINE_FILE_EXTENSION).toFile();
                if (!file.exists()) {
                    file.createNewFile();
                }
                try {
                    fout = new FileOutputStream(file);
                    this.writeBaselineDescription(baseline, fout);
                    this.handlecache.put(baseline.getName(), file.getAbsolutePath());
                    fout.flush();
                }
                finally {
                    fout.close();
                }
            }
        }
    }

    private void writeBaselineDescription(IApiBaseline baseline, OutputStream stream) throws CoreException {
        String xml = this.getProfileXML(baseline);
        try {
            stream.write(xml.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            ApiBaselineManager.abort("Error writing pofile descrition", e);
        }
        catch (IOException e) {
            ApiBaselineManager.abort("Error writing pofile descrition", e);
        }
    }

    private String getProfileXML(IApiBaseline baseline) throws CoreException {
        Document document = Util.newDocument();
        Element root = document.createElement("apiprofile");
        document.appendChild(root);
        root.setAttribute("name", baseline.getName());
        root.setAttribute("version", "2");
        String location = baseline.getLocation();
        if (location != null) {
            root.setAttribute("location", location);
        }
        Element celement = null;
        IApiComponent[] components = baseline.getApiComponents();
        int i = 0;
        int max = components.length;
        while (i < max) {
            IApiComponent comp = components[i];
            if (!comp.isSystemComponent()) {
                celement = document.createElement("apicomponent");
                celement.setAttribute("id", comp.getSymbolicName());
                celement.setAttribute("version", comp.getVersion());
                celement.setAttribute("location", new Path(comp.getLocation()).toPortableString());
                root.appendChild(celement);
            }
            ++i;
        }
        return Util.serializeDocument(document);
    }

    private static void abort(String message, Throwable e) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.api.tools", message, e));
    }

    private void restoreBaseline(IApiBaseline baseline, InputStream stream) throws CoreException {
        long start;
        block28: {
            start = System.currentTimeMillis();
            DocumentBuilder parser = null;
            try {
                parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                parser.setErrorHandler(new DefaultHandler());
            }
            catch (ParserConfigurationException e) {
                ApiBaselineManager.abort("Error restoring API baseline", e);
            }
            catch (FactoryConfigurationError e) {
                ApiBaselineManager.abort("Error restoring API baseline", e);
            }
            try {
                Document document = parser.parse(stream);
                Element root = document.getDocumentElement();
                if (root.getNodeName().equals("apiprofile")) {
                    String location;
                    String baselineLocation = root.getAttribute("location");
                    if (baselineLocation != null && !baselineLocation.equals("")) {
                        baseline.setLocation(Path.fromPortableString((String)baselineLocation).toOSString());
                    }
                    NodeList children = root.getElementsByTagName("apicomponent");
                    ArrayList<IApiComponent> components = new ArrayList<IApiComponent>();
                    int j = 0;
                    while (j < children.getLength()) {
                        IApiComponent component;
                        Element componentNode = (Element)children.item(j);
                        if (componentNode.getParentNode().equals(root) && (component = ApiModelFactory.newApiComponent(baseline, Path.fromPortableString((String)(location = componentNode.getAttribute("location"))).toOSString())) != null) {
                            components.add(component);
                        }
                        ++j;
                    }
                    children = root.getElementsByTagName("pool");
                    IApiComponent component = null;
                    int j2 = 0;
                    while (j2 < children.getLength()) {
                        location = ((Element)children.item(j2)).getAttribute("location");
                        IPath poolPath = Path.fromPortableString((String)location);
                        NodeList componentNodes = root.getElementsByTagName("apicomponent");
                        int i = 0;
                        while (i < componentNodes.getLength()) {
                            Element compElement = (Element)componentNodes.item(i);
                            String id = compElement.getAttribute("id");
                            String ver = compElement.getAttribute("version");
                            StringBuffer name = new StringBuffer();
                            name.append(id);
                            name.append('_');
                            name.append(ver);
                            File file = poolPath.append(name.toString()).toFile();
                            if (!file.exists()) {
                                name.append(".jar");
                                file = poolPath.append(name.toString()).toFile();
                            }
                            if ((component = ApiModelFactory.newApiComponent(baseline, file.getAbsolutePath())) != null) {
                                components.add(component);
                            }
                            ++i;
                        }
                        ++j2;
                    }
                    baseline.addApiComponents(components.toArray(new IApiComponent[components.size()]));
                }
            }
            catch (IOException e) {
                ApiBaselineManager.abort("Error restoring API baseline", e);
                try {
                    stream.close();
                }
                catch (IOException io) {
                    ApiPlugin.log(io);
                }
                break block28;
            }
            catch (SAXException e) {
                try {
                    ApiBaselineManager.abort("Error restoring API baseline", e);
                    break block28;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        stream.close();
                    }
                    catch (IOException io) {
                        ApiPlugin.log(io);
                    }
                }
            }
            try {
                stream.close();
            }
            catch (IOException io) {
                ApiPlugin.log(io);
            }
        }
        if (baseline == null) {
            ApiBaselineManager.abort("Invalid baseline description", null);
        }
        if (DEBUG) {
            System.out.println("Time to restore a persisted baseline : " + (System.currentTimeMillis() - start) + "ms");
        }
    }

    public void saving(ISaveContext context) throws CoreException {
        if (!this.fNeedsSaving) {
            return;
        }
        try {
            this.persistStateCache();
            this.cleanStateCache();
            this.fNeedsSaving = false;
        }
        catch (IOException e) {
            ApiPlugin.log(e);
        }
    }

    private void cleanStateCache() {
        if (this.baselinecache != null) {
            IApiBaseline baseline = null;
            Iterator iter = this.baselinecache.keySet().iterator();
            while (iter.hasNext()) {
                baseline = (IApiBaseline)this.baselinecache.get(iter.next());
                if (baseline.getName().equals(this.defaultbaseline)) continue;
                baseline.dispose();
                this.hasinfos.remove(baseline.getName());
            }
        }
    }

    public boolean isExistingProfileName(String name) {
        if (this.baselinecache == null) {
            return false;
        }
        return this.baselinecache.keySet().contains(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        try {
            if (this.baselinecache != null) {
                Iterator iterator = this.baselinecache.values().iterator();
                while (iterator.hasNext()) {
                    IApiBaseline baseline = (IApiBaseline)iterator.next();
                    baseline.dispose();
                }
                this.baselinecache.clear();
            }
            ApiBaselineManager apiBaselineManager = this;
            synchronized (apiBaselineManager) {
                if (this.workspacebaseline != null) {
                    this.workspacebaseline.dispose();
                }
            }
            if (this.handlecache != null) {
                this.handlecache.clear();
            }
            if (this.hasinfos != null) {
                this.hasinfos.clear();
            }
            StubApiComponent.disposeAllCaches();
        }
        finally {
            if (ApiPlugin.isRunningInFramework()) {
                ApiPlugin.getDefault().removeSaveParticipant(this);
            }
        }
    }

    public void doneSaving(ISaveContext context) {
    }

    public void prepareToSave(ISaveContext context) throws CoreException {
    }

    public void rollback(ISaveContext context) {
    }

    public synchronized IApiBaseline getDefaultApiBaseline() {
        this.initializeStateCache();
        return (IApiBaseline)this.baselinecache.get(this.defaultbaseline);
    }

    public void setDefaultApiBaseline(String name) {
        this.fNeedsSaving = true;
        this.defaultbaseline = name;
    }

    public synchronized IApiBaseline getWorkspaceBaseline() {
        if (ApiPlugin.isRunningInFramework()) {
            if (this.workspacebaseline == null) {
                try {
                    this.workspacebaseline = this.createWorkspaceBaseline();
                }
                catch (CoreException e) {
                    ApiPlugin.log(e);
                }
            }
            return this.workspacebaseline;
        }
        return null;
    }

    synchronized void disposeWorkspaceBaseline() {
        if (this.workspacebaseline != null) {
            if (DEBUG) {
                System.out.println("disposing workspace baseline");
            }
            this.workspacebaseline.dispose();
            StubApiComponent.disposeAllCaches();
            this.workspacebaseline = null;
        }
    }

    private IApiBaseline createWorkspaceBaseline() throws CoreException {
        long time = System.currentTimeMillis();
        WorkspaceBaseline baseline = null;
        try {
            baseline = new WorkspaceBaseline();
            Set ids = DependencyManager.getSelfandDependencies((IPluginModelBase[])PluginRegistry.getWorkspaceModels(), null);
            ArrayList<IApiComponent> componentsList = new ArrayList<IApiComponent>(ids.size());
            IApiComponent apiComponent = null;
            IPluginModelBase model = null;
            Iterator iter = ids.iterator();
            while (iter.hasNext()) {
                model = PluginRegistry.findModel((String)((String)iter.next()));
                if (model == null) continue;
                try {
                    apiComponent = ApiModelFactory.newApiComponent((IApiBaseline)baseline, model);
                    if (apiComponent == null) continue;
                    componentsList.add(apiComponent);
                }
                catch (CoreException e) {
                    ApiPlugin.log(e);
                }
            }
            baseline.addApiComponents(componentsList.toArray(new IApiComponent[componentsList.size()]));
        }
        finally {
            if (DEBUG) {
                System.out.println("Time to create a workspace baseline : " + (System.currentTimeMillis() - time) + "ms");
            }
        }
        return baseline;
    }

    public synchronized IApiComponent getWorkspaceComponent(String symbolicName) {
        IApiBaseline baseline = this.getWorkspaceBaseline();
        if (baseline != null) {
            return baseline.getApiComponent(symbolicName);
        }
        return null;
    }
}

