/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.pde.api.tools.internal.ApiBaselineManager;
import org.eclipse.pde.api.tools.internal.ApiDescriptionManager;
import org.eclipse.pde.api.tools.internal.model.ApiBaseline;
import org.eclipse.pde.api.tools.internal.util.Util;

public class WorkspaceDeltaProcessor
implements IElementChangedListener,
IResourceChangeListener {
    private static boolean DEBUG = Util.DEBUG;
    ApiBaselineManager bmanager = ApiBaselineManager.getManager();
    ApiDescriptionManager dmanager = ApiDescriptionManager.getManager();

    public static void setDebug(boolean debugValue) {
        DEBUG = debugValue || Util.DEBUG;
    }

    public void elementChanged(ElementChangedEvent event) {
        this.processJavaElementDeltas(event.getDelta().getAffectedChildren(), null);
    }

    /*
     * Unable to fully structure code
     */
    void processJavaElementDeltas(IJavaElementDelta[] deltas, IJavaProject project) {
        i = 0;
        while (i < deltas.length) {
            block41: {
                delta = deltas[i];
                block0 : switch (delta.getElement().getElementType()) {
                    case 2: {
                        proj = (IJavaProject)delta.getElement();
                        flags = delta.getFlags();
                        block6 : switch (delta.getKind()) {
                            case 4: {
                                if (!Util.isApiProject(proj)) {
                                    if (!WorkspaceDeltaProcessor.DEBUG) break;
                                    System.out.println("--> skipped processing CHANGED delta for project: " + proj.getElementName());
                                    break;
                                }
                                if ((flags & 512) != 0) {
                                    if (WorkspaceDeltaProcessor.DEBUG) {
                                        System.out.println("--> processing OPEN project: [" + proj.getElementName() + "]");
                                    }
                                    this.bmanager.disposeWorkspaceBaseline();
                                    break;
                                }
                                if ((flags & 0x200000) != 0 || (flags & 131072) != 0) {
                                    if (WorkspaceDeltaProcessor.DEBUG) {
                                        System.out.println("--> processing CLASSPATH CHANGE project: [" + proj.getElementName() + "]");
                                    }
                                    this.bmanager.disposeWorkspaceBaseline();
                                    this.dmanager.projectClasspathChanged(proj);
                                    this.dmanager.flushElementCache(delta.getElement());
                                    break;
                                }
                                if ((flags & 8) != 0) {
                                    if (WorkspaceDeltaProcessor.DEBUG) {
                                        System.out.println("--> processing CHILDREN delta of project: [" + proj.getElementName() + "]");
                                    }
                                    this.processJavaElementDeltas(delta.getAffectedChildren(), proj);
                                    break;
                                }
                                if ((flags & 1) == 0) break;
                                if (proj != null) {
                                    if (WorkspaceDeltaProcessor.DEBUG) {
                                        System.out.println("--> processing child CONTENT of project: [" + proj.getElementName() + "]");
                                    }
                                    if ((resourcedeltas = delta.getResourceDeltas()) == null) break;
                                    rdelta = null;
                                    j = 0;
                                    while (j < resourcedeltas.length) {
                                        rdelta = resourcedeltas[j].findMember((IPath)new Path("MANIFEST.MF"));
                                        if (rdelta != null && rdelta.getKind() == 4 && (rdelta.getFlags() & 256) > 0) {
                                            if (WorkspaceDeltaProcessor.DEBUG) {
                                                System.out.println("--> processing manifest delta");
                                            }
                                            this.bmanager.disposeWorkspaceBaseline();
                                            break block6;
                                        }
                                        ++j;
                                    }
                                    break block0;
                                }
                                if (!WorkspaceDeltaProcessor.DEBUG) break;
                                System.out.println("--> ignoring child CONTENT project context is null");
                                break;
                            }
                            case 1: {
                                if (!Util.isApiProject(proj)) {
                                    if (!WorkspaceDeltaProcessor.DEBUG) break;
                                    System.out.println("--> skipped processing ADDED delta for project: " + proj.getElementName());
                                    break;
                                }
                                if ((flags & 16) == 0) break;
                                if (WorkspaceDeltaProcessor.DEBUG) {
                                    System.out.println("--> processing PROJECT RENAME from: [" + delta.getMovedFromElement().getJavaProject().getElementName() + "] to: [" + proj.getElementName() + "]");
                                }
                                this.bmanager.disposeWorkspaceBaseline();
                            }
                        }
                        break;
                    }
                    case 3: {
                        root = (IPackageFragmentRoot)delta.getElement();
                        flags = delta.getFlags();
                        if ((flags & 32960) != 0) {
                            if (WorkspaceDeltaProcessor.DEBUG) {
                                System.out.println("processed CLASSPATH CHANGED for package fragment root: [" + root.getElementName() + "]");
                            }
                            this.dmanager.projectClasspathChanged(project);
                        }
                        if ((flags & 8) == 0) break;
                        if (WorkspaceDeltaProcessor.DEBUG) {
                            System.out.println("processed CHILDREN for package fragment root: [" + root.getElementName() + "]");
                        }
                        this.processJavaElementDeltas(delta.getAffectedChildren(), project);
                        break;
                    }
                    case 4: {
                        fragment = (IPackageFragment)delta.getElement();
                        if (delta.getKind() == 2) {
                            if (WorkspaceDeltaProcessor.DEBUG) {
                                System.out.println("processed REMOVED delta for package fragment: [" + fragment.getElementName() + "]");
                            }
                            ((ApiBaseline)this.bmanager.getWorkspaceBaseline()).clearPackage(fragment.getElementName());
                        }
                        if (((flags = delta.getFlags()) & 8) == 0) break;
                        if (WorkspaceDeltaProcessor.DEBUG) {
                            System.out.println("processed CHILDREN delta for package fragment: [" + fragment.getElementName() + "]");
                        }
                        this.processJavaElementDeltas(delta.getAffectedChildren(), project);
                        break;
                    }
                    case 5: {
                        flags = delta.getFlags();
                        switch (delta.getKind()) {
                            case 4: {
                                if ((flags & 278529) != 0 && project != null) {
                                    if (WorkspaceDeltaProcessor.DEBUG) {
                                        System.out.println("processed CONTENT / FINE_GRAINED / PRIMARY_RESOURCE delta for: [" + delta.getElement().getElementName() + "]");
                                    }
                                    this.dmanager.projectChanged(project);
                                    this.dmanager.flushElementCache(delta.getElement());
                                    break block0;
                                }
                                break block41;
                            }
                            case 1: 
                            case 2: {
                                if (project != null) {
                                    if (WorkspaceDeltaProcessor.DEBUG) {
                                        if (delta.getKind() == 1) {
                                            System.out.println("processed ADDED delta for: [" + delta.getElement().getElementName() + "]");
                                        } else {
                                            System.out.println("processed REMOVED delta for: [" + delta.getElement().getElementName() + "]");
                                        }
                                    }
                                    this.dmanager.projectChanged(project);
                                    this.dmanager.flushElementCache(delta.getElement());
                                } else {
                                    ** GOTO lbl104
                                }
                            }
                        }
                    }
                }
            }
            ++i;
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResource resource = event.getResource();
        block0 : switch (event.getType()) {
            case 8: {
                IResourceDelta delta;
                if (DEBUG) {
                    if (resource == null) {
                        System.out.println("processed PRE_BUILD delta for workspace.");
                    } else {
                        System.out.println("processed PRE_BUILD delta for project: [" + resource.getName() + "]");
                    }
                }
                if ((delta = event.getDelta()) == null) break;
                IResourceDelta[] children = delta.getAffectedChildren(4);
                int i = 0;
                while (i < children.length) {
                    resource = children[i].getResource();
                    if (children[i].getResource().getType() == 4 && Util.isApiProject((IProject)resource) && (children[i].getFlags() & 0x80000) != 0) {
                        IJavaProject jp = (IJavaProject)JavaCore.create((IResource)resource);
                        this.dmanager.clean(jp, true, true);
                        this.bmanager.disposeWorkspaceBaseline();
                        break block0;
                    }
                    ++i;
                }
                break;
            }
            case 2: 
            case 4: {
                if (resource.getType() != 4 || !Util.isApiProject((IProject)resource)) break;
                if (DEBUG) {
                    if (event.getType() == 2) {
                        System.out.println("processed PRE_CLOSE delta for project: [" + resource.getName() + "]");
                    } else if (DEBUG) {
                        System.out.println("processed PRE_DELETE delta for project: [" + resource.getName() + "]");
                    }
                }
                this.bmanager.disposeWorkspaceBaseline();
                IJavaProject project = (IJavaProject)JavaCore.create((IResource)resource);
                this.dmanager.clean(project, false, true);
                this.dmanager.flushElementCache((IJavaElement)project);
            }
        }
    }
}

