/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.api.tools.internal.ApiDescriptionManager;
import org.eclipse.pde.api.tools.internal.ApiFilterStore;
import org.eclipse.pde.api.tools.internal.CoreMessages;
import org.eclipse.pde.api.tools.internal.model.ArchiveApiTypeContainer;
import org.eclipse.pde.api.tools.internal.model.BundleComponent;
import org.eclipse.pde.api.tools.internal.model.CompositeApiTypeContainer;
import org.eclipse.pde.api.tools.internal.model.DirectoryApiTypeContainer;
import org.eclipse.pde.api.tools.internal.model.ProjectTypeContainer;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.IApiDescription;
import org.eclipse.pde.api.tools.internal.provisional.IApiFilterStore;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeContainer;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.osgi.framework.BundleException;

public class ProjectComponent
extends BundleComponent {
    private static boolean DEBUG = Util.DEBUG;
    private IJavaProject fProject = null;
    private IPluginModelBase fModel = null;
    private Map fPathToOutputContainers = null;
    private Map fOutputLocationToContainer = null;

    public static void setDebug(boolean debugValue) {
        DEBUG = debugValue || Util.DEBUG;
    }

    public ProjectComponent(IApiBaseline baseline, String location, IPluginModelBase model, long bundleid) throws CoreException {
        super(baseline, location, bundleid);
        Path path = new Path(location);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(path.lastSegment());
        this.fProject = JavaCore.create((IProject)project);
        this.fModel = model;
        this.setName(this.fModel.getResourceString(super.getName()));
    }

    protected boolean isBinary() {
        return false;
    }

    protected BundleDescription getBundleDescription(Dictionary manifest, String location, long id) throws BundleException {
        try {
            return this.getModel().getBundleDescription();
        }
        catch (CoreException ce) {
            throw new BundleException(ce.getMessage());
        }
    }

    IPluginModelBase getModel() throws CoreException {
        if (this.fModel == null) {
            this.fModel = PluginRegistry.findModel((IProject)this.fProject.getProject());
            if (this.fModel == null) {
                this.abort(NLS.bind((String)CoreMessages.ProjectComponent_could_not_locate_model, (Object)this.fProject.getElementName()), null);
            }
        }
        return this.fModel;
    }

    protected boolean isApiEnabled() {
        return Util.isApiProject(this.fProject);
    }

    public void dispose() {
        try {
            try {
                if (this.hasApiFilterStore()) {
                    this.getFilterStore().dispose();
                }
                this.fModel = null;
                if (this.fOutputLocationToContainer != null) {
                    this.fOutputLocationToContainer.clear();
                    this.fOutputLocationToContainer = null;
                }
                if (this.fPathToOutputContainers != null) {
                    this.fPathToOutputContainers.clear();
                    this.fPathToOutputContainers = null;
                }
            }
            catch (CoreException ce) {
                ApiPlugin.log(ce);
                super.dispose();
            }
        }
        finally {
            super.dispose();
        }
    }

    protected IApiDescription createLocalApiDescription() throws CoreException {
        long time = System.currentTimeMillis();
        if (Util.isApiProject(this.getJavaProject())) {
            this.setHasApiDescription(true);
        }
        IApiDescription apiDesc = ApiDescriptionManager.getManager().getApiDescription(this, this.getBundleDescription());
        if (DEBUG) {
            System.out.println("Time to create api description for: [" + this.fProject.getElementName() + "] " + (System.currentTimeMillis() - time) + "ms");
        }
        return apiDesc;
    }

    protected IApiFilterStore createApiFilterStore() throws CoreException {
        long time = System.currentTimeMillis();
        ApiFilterStore store = new ApiFilterStore(this.getJavaProject());
        if (DEBUG) {
            System.out.println("Time to create api filter store for: [" + this.fProject.getElementName() + "] " + (System.currentTimeMillis() - time) + "ms");
        }
        return store;
    }

    protected synchronized List createApiTypeContainers() throws CoreException {
        block11: {
            block12: {
                IBuild build;
                block13: {
                    IBuildModel buildModel;
                    this.fPathToOutputContainers = new HashMap(4);
                    this.fOutputLocationToContainer = new HashMap(4);
                    if (!this.fProject.exists() || !this.fProject.getProject().isOpen()) break block11;
                    IPluginModelBase model = PluginRegistry.findModel((IProject)this.fProject.getProject());
                    if (model == null || (buildModel = PluginRegistry.createBuildModel((IPluginModelBase)model)) == null) break block12;
                    build = buildModel.getBuild();
                    IBuildEntry entry = build.getEntry("custom");
                    if (entry == null) break block13;
                    String[] tokens = entry.getTokens();
                    if (tokens.length != 1 || !tokens[0].equals("true")) break block12;
                    IClasspathEntry[] classpathEntries = this.fProject.getRawClasspath();
                    ArrayList<IApiTypeContainer> containers = new ArrayList<IApiTypeContainer>();
                    int i = 0;
                    while (i < classpathEntries.length) {
                        IClasspathEntry classpathEntry = classpathEntries[i];
                        switch (classpathEntry.getEntryKind()) {
                            case 3: {
                                String containerPath = classpathEntry.getPath().removeFirstSegments(1).toString();
                                IApiTypeContainer container = this.getApiTypeContainer(containerPath, this);
                                if (container == null || containers.contains(container)) break;
                                containers.add(container);
                                break;
                            }
                            case 4: {
                                classpathEntry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)classpathEntry);
                            }
                            case 1: {
                                IPath path = classpathEntry.getPath();
                                if (!Util.isArchive(path.lastSegment())) break;
                                IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
                                if (resource != null) {
                                    containers.add(new ArchiveApiTypeContainer(this, resource.getLocation().toOSString()));
                                    break;
                                }
                                containers.add(new ArchiveApiTypeContainer(this, path.toOSString()));
                            }
                        }
                        ++i;
                    }
                    if (containers.isEmpty()) break block12;
                    IApiTypeContainer cfc = null;
                    cfc = containers.size() == 1 ? (IApiTypeContainer)containers.get(0) : new CompositeApiTypeContainer(this, containers);
                    this.fPathToOutputContainers.put(".", cfc);
                    break block12;
                }
                IBuildEntry[] entries = build.getBuildEntries();
                int length = entries.length;
                int i = 0;
                while (i < length) {
                    IBuildEntry buildEntry = entries[i];
                    String name = buildEntry.getName();
                    if (name.startsWith("source.")) {
                        this.retrieveContainers(name, "source.", buildEntry);
                    } else if (name.startsWith("extra.")) {
                        this.retrieveContainers(name, "extra.", buildEntry);
                    }
                    ++i;
                }
            }
            return super.createApiTypeContainers();
        }
        return Collections.EMPTY_LIST;
    }

    private void retrieveContainers(String name, String prefix, IBuildEntry buildEntry) throws CoreException {
        String jar = name.substring(prefix.length());
        String[] tokens = buildEntry.getTokens();
        if (tokens.length == 1) {
            IApiTypeContainer container = this.getApiTypeContainer(tokens[0], this);
            if (container != null) {
                IApiTypeContainer existingContainer = (IApiTypeContainer)this.fPathToOutputContainers.get(jar);
                if (existingContainer != null) {
                    ArrayList<IApiTypeContainer> allContainers = new ArrayList<IApiTypeContainer>();
                    allContainers.add(existingContainer);
                    allContainers.add(container);
                    CompositeApiTypeContainer apiTypeContainer = new CompositeApiTypeContainer(this, allContainers);
                    this.fPathToOutputContainers.put(jar, apiTypeContainer);
                } else {
                    this.fPathToOutputContainers.put(jar, container);
                }
            }
        } else {
            ArrayList<IApiTypeContainer> containers = new ArrayList<IApiTypeContainer>();
            int j = 0;
            while (j < tokens.length) {
                String currentToken = tokens[j];
                IApiTypeContainer container = this.getApiTypeContainer(currentToken, this);
                if (container != null && !containers.contains(container)) {
                    containers.add(container);
                }
                ++j;
            }
            if (!containers.isEmpty()) {
                IApiTypeContainer existingContainer = (IApiTypeContainer)this.fPathToOutputContainers.get(jar);
                if (existingContainer != null) {
                    containers.add(existingContainer);
                }
                IApiTypeContainer cfc = null;
                cfc = containers.size() == 1 ? (IApiTypeContainer)containers.get(0) : new CompositeApiTypeContainer(this, containers);
                this.fPathToOutputContainers.put(jar, cfc);
            }
        }
    }

    protected IApiTypeContainer createApiTypeContainer(String path) throws IOException, CoreException {
        IApiTypeContainer container;
        if (this.fPathToOutputContainers == null) {
            this.baselineDisposed(this.getBaseline());
        }
        if ((container = (IApiTypeContainer)this.fPathToOutputContainers.get(path)) == null) {
            container = this.findApiTypeContainer(path);
        }
        return container;
    }

    private IApiTypeContainer findApiTypeContainer(String location) {
        IResource res = this.fProject.getProject().findMember((IPath)new Path(location));
        if (res != null) {
            if (res.getType() == 1) {
                return new ArchiveApiTypeContainer(this, res.getLocation().toOSString());
            }
            return new DirectoryApiTypeContainer(this, res.getLocation().toOSString());
        }
        return null;
    }

    private IApiTypeContainer getApiTypeContainer(String location, IApiComponent component) throws CoreException {
        IPackageFragmentRoot root;
        IResource res;
        if (this.fOutputLocationToContainer == null) {
            this.baselineDisposed(this.getBaseline());
        }
        if ((res = this.fProject.getProject().findMember((IPath)new Path(location))) != null && (root = this.fProject.getPackageFragmentRoot(res)).exists()) {
            if (root.getKind() == 2) {
                if (res.getType() == 2) {
                    IPath location2 = res.getLocation();
                    IApiTypeContainer cfc = (IApiTypeContainer)this.fOutputLocationToContainer.get(location2);
                    if (cfc == null) {
                        cfc = new ProjectTypeContainer(component, (IContainer)res);
                        this.fOutputLocationToContainer.put(location2, cfc);
                    }
                    return cfc;
                }
            } else {
                IApiTypeContainer cfc;
                IClasspathEntry entry = root.getRawClasspathEntry();
                IPath outputLocation = entry.getOutputLocation();
                if (outputLocation == null) {
                    outputLocation = this.fProject.getOutputLocation();
                }
                if ((cfc = (IApiTypeContainer)this.fOutputLocationToContainer.get(outputLocation)) == null) {
                    IPath projectFullPath = this.fProject.getProject().getFullPath();
                    Object container = null;
                    container = projectFullPath.equals((Object)outputLocation) ? this.fProject.getProject() : this.fProject.getProject().getWorkspace().getRoot().getFolder(outputLocation);
                    cfc = new ProjectTypeContainer(component, (IContainer)container);
                    this.fOutputLocationToContainer.put(outputLocation, cfc);
                }
                return cfc;
            }
        }
        return null;
    }

    public IJavaProject getJavaProject() {
        return this.fProject;
    }

    public IApiTypeContainer getTypeContainer(IPackageFragmentRoot root) throws CoreException {
        if (root.getKind() == 1) {
            this.getApiTypeContainers();
            IResource resource = root.getResource();
            if (resource != null) {
                String location = resource.getProjectRelativePath().toString();
                return this.getApiTypeContainer(location, this);
            }
        }
        return null;
    }
}

