/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.birt.chart.factory.IActionEvaluator;
import org.eclipse.birt.chart.factory.IExternalizer;
import org.eclipse.birt.chart.factory.IResourceFinder;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.style.IStyleProcessor;
import org.eclipse.birt.chart.ui.integrate.ChartUIFactoryBase;
import org.eclipse.birt.chart.ui.swt.interfaces.IChartDataSheet;
import org.eclipse.birt.chart.ui.swt.interfaces.IChartType;
import org.eclipse.birt.chart.ui.swt.interfaces.IChartUIFactory;
import org.eclipse.birt.chart.ui.swt.interfaces.IChartWizardContext;
import org.eclipse.birt.chart.ui.swt.interfaces.IDataServiceProvider;
import org.eclipse.birt.chart.ui.swt.interfaces.IUIServiceProvider;
import org.eclipse.birt.chart.ui.swt.wizard.ChartUIExtensionsImpl;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizard;

public class ChartWizardContext
implements IChartWizardContext {
    private Chart chartModel = null;
    private IChartType chartType = null;
    private Object extendedItem = null;
    private String sDefaultOutputFormat;
    private String sOutputFormat = this.sDefaultOutputFormat = "SVG";
    private final IUIServiceProvider uiProvider;
    private final IDataServiceProvider dataProvider;
    private final IChartDataSheet dataSheet;
    private IStyleProcessor processor;
    private boolean isMoreAxesSupported;
    private boolean isRtL;
    private boolean isTextRtL;
    private boolean isInheritColumnsOnly;
    private Map<String, Boolean> mSheetEnabled;
    private Map<String, Object[]> mQueries;
    private IResourceFinder resourceFinder = null;
    private IExternalizer externalizer = null;
    private Boolean isShowingDataPreview = null;
    private IActionEvaluator actionEvaluator;
    private Thread livePreviewThread = null;
    private IChartUIFactory uiFactory = new ChartUIFactoryBase();

    public ChartWizardContext(Chart chartModel, IUIServiceProvider uiProvider, IDataServiceProvider dataProvider, IChartDataSheet dataSheet) {
        this.chartModel = chartModel;
        this.uiProvider = uiProvider;
        this.dataProvider = dataProvider;
        this.dataSheet = dataSheet;
        this.dataSheet.setContext(this);
    }

    public void setLivePreviewThread(Thread thread) {
        this.livePreviewThread = thread;
    }

    public Thread getLivePreviewThread() {
        return this.livePreviewThread;
    }

    public String getWizardID() {
        return this.getExtendedItem() == null ? ChartWizard.class.getName() : this.getExtendedItem().toString();
    }

    public Chart getModel() {
        return this.chartModel;
    }

    public void setModel(Chart model) {
        this.chartModel = model;
    }

    public Object getExtendedItem() {
        return this.extendedItem;
    }

    public void setExtendedItem(Object extendedItem) {
        this.extendedItem = extendedItem;
    }

    public String getOutputFormat() {
        return this.sOutputFormat;
    }

    public void setOutputFormat(String format) {
        this.sOutputFormat = format;
    }

    public String getDefaultOutputFormat() {
        return this.sDefaultOutputFormat;
    }

    public void setDefaultOutputFormat(String sOutputFormat) {
        this.sDefaultOutputFormat = sOutputFormat;
    }

    public IUIServiceProvider getUIServiceProvider() {
        return this.uiProvider;
    }

    public IDataServiceProvider getDataServiceProvider() {
        return this.dataProvider;
    }

    public void setChartType(IChartType chartType) {
        this.chartType = chartType;
    }

    public IChartType getChartType() {
        if (this.chartType == null) {
            LinkedHashMap<String, IChartType> htTypes = new LinkedHashMap<String, IChartType>();
            Collection<IChartType> cTypes = ChartUIExtensionsImpl.instance().getUIChartTypeExtensions(this.getClass().getSimpleName());
            for (IChartType type : cTypes) {
                htTypes.put(type.getName(), type);
            }
            this.chartType = (IChartType)htTypes.get(this.chartModel.getType());
        }
        return this.chartType;
    }

    public void setProcessor(IStyleProcessor processor) {
        this.processor = processor;
    }

    public IStyleProcessor getProcessor() {
        return this.processor;
    }

    public void setMoreAxesSupported(boolean isMoreAxesSupported) {
        this.isMoreAxesSupported = isMoreAxesSupported;
    }

    public boolean isMoreAxesSupported() {
        return this.isMoreAxesSupported;
    }

    public boolean isRtL() {
        return this.isRtL;
    }

    public void setRtL(boolean isRtL) {
        this.isRtL = isRtL;
    }

    public boolean isTextRtL() {
        return this.isTextRtL;
    }

    public void setTextRtL(boolean isRtL) {
        this.isTextRtL = isRtL;
    }

    public void setEnabled(String id, boolean bEnabled) {
        if (this.mSheetEnabled == null) {
            this.mSheetEnabled = new HashMap<String, Boolean>();
        }
        this.mSheetEnabled.put(id, bEnabled);
    }

    public boolean isEnabled(String id) {
        if (this.mSheetEnabled != null && this.mSheetEnabled.containsKey(id)) {
            return this.mSheetEnabled.get(id);
        }
        return true;
    }

    public void addPredefinedQuery(String queryType, Object[] expressions) {
        if (this.mQueries == null) {
            this.mQueries = new HashMap<String, Object[]>();
        }
        this.mQueries.put(queryType, expressions);
    }

    public Object[] getPredefinedQuery(String queryType) {
        if (this.mQueries != null && this.mQueries.containsKey(queryType)) {
            return this.mQueries.get(queryType);
        }
        return null;
    }

    public IChartDataSheet getDataSheet() {
        return this.dataSheet;
    }

    public IResourceFinder getResourceFinder() {
        return this.resourceFinder;
    }

    public void setResourceFinder(IResourceFinder resourceFinder) {
        this.resourceFinder = resourceFinder;
    }

    public IExternalizer getExternalizer() {
        return this.externalizer;
    }

    public void setExternalizer(IExternalizer externalizer) {
        this.externalizer = externalizer;
    }

    public void setInheritColumnsOnly(boolean isInheritColumnsOnly) {
        this.isInheritColumnsOnly = isInheritColumnsOnly;
    }

    public boolean isInheritColumnsOnly() {
        return this.isInheritColumnsOnly;
    }

    public boolean isShowingDataPreview() {
        if (this.isShowingDataPreview == null) {
            return true;
        }
        return this.isShowingDataPreview;
    }

    public void setShowingDataPreview(Boolean isShowingDataPreview) {
        this.isShowingDataPreview = isShowingDataPreview;
    }

    public boolean isSetShowingDataPreview() {
        return this.isShowingDataPreview != null;
    }

    public void setActionEvaluator(IActionEvaluator birtActionEvaluator) {
        this.actionEvaluator = birtActionEvaluator;
    }

    public IActionEvaluator getActionEvaluator() {
        return this.actionEvaluator;
    }

    public IChartUIFactory getUIFactory() {
        return this.uiFactory;
    }

    public void setUIFactory(IChartUIFactory factory) {
        this.uiFactory = factory;
    }
}

