/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.framework.jar;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import org.eclipse.birt.core.framework.IBundle;
import org.eclipse.birt.core.framework.jar.Contributor;
import org.eclipse.birt.core.framework.jar.Extension;
import org.eclipse.birt.core.framework.jar.ExtensionPoint;
import org.eclipse.birt.core.framework.jar.ServicePlatform;
import org.eclipse.core.runtime.IContributor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bundle
implements IBundle {
    protected ServicePlatform platform;
    protected URL root;
    protected Contributor contributor;
    protected String version;
    protected Extension[] extensions;
    protected ExtensionPoint[] extensionPoints;
    static final Extension[] EMPTY_EXTENSIONS = new Extension[0];
    static final ExtensionPoint[] EMPTY_EXTENSION_POINTS = new ExtensionPoint[0];

    Bundle(ServicePlatform platform, URL root, String name) {
        this.platform = platform;
        this.root = root;
        this.contributor = new Contributor(name);
    }

    public String getSymbolicName() {
        return this.contributor.getName();
    }

    public IContributor getContributor() {
        return this.contributor;
    }

    public String getVersion() {
        return this.version;
    }

    public URL getEntry(String path) {
        try {
            return new URL(this.root, path);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public Enumeration<URL> getEntryPaths(String path) {
        ArrayList urls = new ArrayList();
        return Collections.enumeration(urls);
    }

    Extension[] getExtensions() {
        if (this.extensions == null) {
            return EMPTY_EXTENSIONS;
        }
        return this.extensions;
    }

    ExtensionPoint[] getExtensionPoints() {
        if (this.extensionPoints == null) {
            return EMPTY_EXTENSION_POINTS;
        }
        return this.extensionPoints;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.contributor.getName());
        sb.append("@");
        sb.append(this.root.toString());
        return sb.toString();
    }

    @Override
    public Class loadClass(String name) throws ClassNotFoundException {
        return this.getClass().getClassLoader().loadClass(name);
    }
}

