/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.framework.osgi;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.framework.FrameworkException;
import org.eclipse.birt.core.framework.IPlatformContext;
import org.eclipse.birt.core.framework.PlatformConfig;
import org.eclipse.birt.core.framework.PlatformFileContext;
import org.eclipse.birt.core.framework.PlatformLauncher;
import org.eclipse.birt.core.framework.URLClassLoader;
import org.eclipse.birt.core.framework.osgi.OSGIPolicy;

public class OSGILauncher
extends PlatformLauncher {
    private static Logger logger = Logger.getLogger(OSGILauncher.class.getName());
    private static final String ECLIPSE_STARTER = "org.eclipse.core.runtime.adaptor.EclipseStarter";
    private static String PluginId = "org.eclipse.birt.core";
    private PlatformConfig platformConfig;
    private File platformDirectory;
    private URL osgiFramework;
    private ChildFirstURLClassLoader frameworkClassLoader;
    private ClassLoader frameworkContextClassLoader;
    private HashMap properties;
    private Object bundleContext;
    private static final String PROP_OSGI_INSTALL_AREA = "osgi.install.area";
    private static final String PROP_OSGI_INSTANCE_AREA = "osgi.instance.area";
    private static final String PROP_OSGI_CONFIGURATION_AREA = "osgi.configuration.area";
    private static final String PROP_ECLIPSE_IGNOREAPP = "eclipse.ignoreApp";
    private static final String PROP_OSGI_NOSHUTDOWN = "osgi.noShutdown";
    private static final String PROP_OSGI_CLEAN = "osgi.clean";
    private static final String PROP_ECLIPSE_SECURITY = "eclipse.security";
    private static final String CONFIG_FILE = "config.ini";
    private static final String CONFIG_FOLDER = "configuration";
    private static final String INSTANCE_FOLDER = "workspace";

    public void startup(final PlatformConfig config) throws FrameworkException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    OSGILauncher.this.doStartup(config);
                    return null;
                }
            });
        }
        catch (Exception ex) {
            if (ex instanceof FrameworkException) {
                throw (FrameworkException)ex;
            }
            throw new FrameworkException(ex.getMessage(), ex);
        }
    }

    private void doStartup(PlatformConfig config) throws FrameworkException {
        if (this.frameworkClassLoader != null) {
            logger.log(Level.WARNING, "Framework is already started");
            return;
        }
        this.platformConfig = config;
        IPlatformContext context = config.getPlatformContext();
        if (context == null) {
            throw new FrameworkException("PlatformContext is not setted - {0}", new Object[]{"PlatformConfig"});
        }
        String root = context.getPlatform();
        this.platformDirectory = new File(root);
        if (!this.platformDirectory.exists() || !this.platformDirectory.isDirectory()) {
            throw new FrameworkException("Framework {0} doesn't exist or is not a directory", new Object[]{root});
        }
        String path = new File(this.platformDirectory, "plugins").toString();
        if ((path = this.searchFor("org.eclipse.osgi", path)) == null) {
            throw new FrameworkException("Could not find the Framework - {0}", new Object[]{"org.eclipse.osgi"});
        }
        try {
            this.osgiFramework = new File(path).toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {}
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            try {
                ClassLoader loader = this.getClass().getClassLoader();
                this.frameworkClassLoader = new ChildFirstURLClassLoader(new URL[]{this.osgiFramework}, loader);
                try {
                    loader.loadClass("org.mozilla.javascript.Context");
                    loader.loadClass("org.mozilla.javascript.Scriptable");
                    loader.loadClass("org.mozilla.javascript.ScriptableObject");
                }
                catch (Exception exception) {}
                Class<?> clazz = this.frameworkClassLoader.loadClass(ECLIPSE_STARTER);
                this.setupOSGiProperties();
                this.setupSecurityPolicy();
                Method initPropertiesMethod = clazz.getMethod("setInitialProperties", Map.class);
                if (initPropertiesMethod != null) {
                    System.setProperty("osgi.framework.useSystemProperties", "false");
                    this.properties.put("osgi.framework.useSystemProperties", "false");
                    initPropertiesMethod.invoke(null, this.properties);
                } else {
                    for (Map.Entry entry : this.properties.entrySet()) {
                        String key = (String)entry.getKey();
                        String value = (String)entry.getValue();
                        System.setProperty(key, value);
                    }
                    System.setProperty("osgi.framework.useSystemProperties", "true");
                }
                Method runMethod = clazz.getMethod("startup", String[].class, Runnable.class);
                Object[] objectArray = new Object[2];
                objectArray[0] = new String[0];
                this.bundleContext = runMethod.invoke(null, objectArray);
                this.frameworkContextClassLoader = Thread.currentThread().getContextClassLoader();
            }
            catch (FrameworkException be) {
                throw be;
            }
            catch (Exception e) {
                throw new FrameworkException("Can not start up OSGI - {0}", new Object[]{e.getMessage()}, (Throwable)e);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    private void setupOSGiProperties() {
        String instanceArea;
        this.properties = new HashMap();
        Properties systemProperties = System.getProperties();
        if (systemProperties != null) {
            for (Map.Entry<Object, Object> entry : systemProperties.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if (value != null && !(value instanceof String)) continue;
                if (!(key.startsWith("osgi.") || key.startsWith("eclipse.") || key.startsWith("org.osgi."))) {
                    this.properties.put(key, value);
                    continue;
                }
                this.properties.put(key, null);
            }
        }
        File configFolder = new File(this.platformDirectory, CONFIG_FOLDER);
        try {
            HashMap configProps = this.loadConfiguration(configFolder.toURL());
            this.properties.putAll(configProps);
        }
        catch (Exception exception) {}
        Map osgiConfig = this.platformConfig.getOSGiConfig();
        if (osgiConfig != null) {
            for (Map.Entry entry : osgiConfig.entrySet()) {
                Object key = entry.getKey();
                Object value = entry.getValue();
                if (!(key instanceof String) || value != null && !(value instanceof String)) continue;
                this.properties.put(key, value);
            }
        }
        this.properties.put(PROP_OSGI_INSTALL_AREA, this.platformDirectory.getAbsolutePath());
        this.properties.put("osgi.framework", this.osgiFramework.toExternalForm());
        String configArea = this.getProperty(this.properties, PROP_OSGI_CONFIGURATION_AREA);
        if (configArea == null) {
            File configDirectory = new File(this.platformDirectory, CONFIG_FOLDER);
            this.properties.put(PROP_OSGI_CONFIGURATION_AREA, configDirectory.getAbsolutePath());
        }
        if ((instanceArea = this.getProperty(this.properties, PROP_OSGI_INSTANCE_AREA)) == null) {
            File workspaceDirectory = new File(this.platformDirectory, INSTANCE_FOLDER);
            if (!workspaceDirectory.exists()) {
                workspaceDirectory.mkdirs();
            }
            this.properties.put(PROP_OSGI_INSTANCE_AREA, workspaceDirectory.getAbsolutePath());
        }
        this.properties.put(PROP_ECLIPSE_IGNOREAPP, "true");
        this.properties.put(PROP_OSGI_NOSHUTDOWN, "true");
        String clean = this.getProperty(this.properties, PROP_OSGI_CLEAN);
        if (clean == null) {
            this.properties.put(PROP_OSGI_CLEAN, "true");
        }
    }

    private HashMap loadConfiguration(URL url) {
        HashMap<Object, Object> result = null;
        if (url == null) {
            return result;
        }
        try {
            url = new URL(url, CONFIG_FILE);
        }
        catch (MalformedURLException malformedURLException) {
            return result;
        }
        Properties tempProp = new Properties();
        try {
            result = new HashMap<Object, Object>();
            InputStream is = null;
            try {
                is = url.openStream();
                tempProp.load(is);
            }
            catch (Throwable throwable) {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (IOException iOException) {}
        for (Map.Entry<Object, Object> entry : tempProp.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            result.put(key, value);
        }
        return result;
    }

    private String getProperty(Map properties, String name) {
        Object value = properties.get(name);
        if (value instanceof String) {
            String strValue = (String)value;
            if ((strValue = strValue.trim()).length() > 0) {
                return strValue;
            }
        }
        return null;
    }

    public ClassLoader getFrameworkContextClassLoader() {
        return this.frameworkContextClassLoader;
    }

    public void shutdown() {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                OSGILauncher.this.doShutdown();
                return null;
            }
        });
    }

    private void doShutdown() {
        if (this.platformDirectory == null) {
            logger.log(Level.WARNING, "Shutdown unnecessary. (not deployed)");
            return;
        }
        if (this.frameworkClassLoader == null) {
            logger.log(Level.WARNING, "Framework is already shutdown");
            return;
        }
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            try {
                Class<?> clazz = this.frameworkClassLoader.loadClass(ECLIPSE_STARTER);
                Method method = clazz.getDeclaredMethod("shutdown", null);
                Thread.currentThread().setContextClassLoader(this.frameworkContextClassLoader);
                method.invoke(clazz, null);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Error while stopping Framework", e);
                this.frameworkClassLoader.close();
                this.frameworkClassLoader = null;
                this.frameworkContextClassLoader = null;
                Thread.currentThread().setContextClassLoader(original);
                return;
            }
        }
        finally {
            this.frameworkClassLoader.close();
            this.frameworkClassLoader = null;
            this.frameworkContextClassLoader = null;
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    protected String searchFor(final String target, String start) {
        FileFilter filter = new FileFilter(){

            public boolean accept(File candidate) {
                return candidate.getName().equals(target) || candidate.getName().startsWith(String.valueOf(target) + "_");
            }
        };
        File[] candidates = new File(start).listFiles(filter);
        if (candidates == null) {
            return null;
        }
        String[] arrays = new String[candidates.length];
        int i = 0;
        while (i < arrays.length) {
            arrays[i] = candidates[i].getName();
            ++i;
        }
        int result = this.findMax(arrays);
        if (result == -1) {
            return null;
        }
        return String.valueOf(candidates[result].getAbsolutePath().replace(File.separatorChar, '/')) + (candidates[result].isDirectory() ? "/" : "");
    }

    protected int findMax(String[] candidates) {
        int result = -1;
        Object[] maxVersion = null;
        int i = 0;
        while (i < candidates.length) {
            String name = candidates[i];
            String version = "";
            int index = name.indexOf(95);
            if (index != -1) {
                version = name.substring(index + 1);
            }
            Object[] currentVersion = this.getVersionElements(version);
            if (maxVersion == null) {
                result = i;
                maxVersion = currentVersion;
            } else if (this.compareVersion(maxVersion, currentVersion) < 0) {
                result = i;
                maxVersion = currentVersion;
            }
            ++i;
        }
        return result;
    }

    private int compareVersion(Object[] left, Object[] right) {
        int result = ((Integer)left[0]).compareTo((Integer)right[0]);
        if (result != 0) {
            return result;
        }
        result = ((Integer)left[1]).compareTo((Integer)right[1]);
        if (result != 0) {
            return result;
        }
        result = ((Integer)left[2]).compareTo((Integer)right[2]);
        if (result != 0) {
            return result;
        }
        return ((String)left[3]).compareTo((String)right[3]);
    }

    private Object[] getVersionElements(String version) {
        if (version.endsWith(".jar")) {
            version = version.substring(0, version.length() - 4);
        }
        Object[] result = new Object[]{0, 0, 0, ""};
        StringTokenizer t = new StringTokenizer(version, ".");
        int i = 0;
        while (t.hasMoreTokens() && i < 4) {
            String token = t.nextToken();
            if (i < 3) {
                try {
                    result[i++] = new Integer(token);
                    continue;
                }
                catch (Exception exception) {
                    break;
                }
            }
            result[i++] = token;
        }
        return result;
    }

    Object getBundle(String symbolicName) {
        if (this.bundleContext == null) {
            return null;
        }
        try {
            Method methodLoadBundle = this.bundleContext.getClass().getMethod("getBundles", new Class[0]);
            Object objects = methodLoadBundle.invoke(this.bundleContext, new Object[0]);
            if (objects instanceof Object[]) {
                Object[] bundles = (Object[])objects;
                int i = 0;
                while (i < bundles.length) {
                    Object bundle = bundles[i];
                    Method methodGetSymbolicName = bundle.getClass().getMethod("getSymbolicName", new Class[0]);
                    Object name = methodGetSymbolicName.invoke(bundle, new Object[0]);
                    if (symbolicName.equals(name)) {
                        return bundle;
                    }
                    ++i;
                }
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, ex.getMessage());
        }
        return null;
    }

    protected void setupSecurityPolicy() throws FrameworkException {
        String eclipseSecurity = (String)this.properties.get(PROP_ECLIPSE_SECURITY);
        if (eclipseSecurity != null) {
            ProtectionDomain domain = OSGILauncher.class.getProtectionDomain();
            CodeSource source = null;
            if (domain != null) {
                source = OSGILauncher.class.getProtectionDomain().getCodeSource();
            }
            if (domain == null || source == null) {
                throw new FrameworkException("Can not automatically set the security manager. Please use a policy file.");
            }
            URL[] rootURLs = new URL[]{source.getLocation(), this.osgiFramework};
            OSGIPolicy eclipsePolicy = new OSGIPolicy(Policy.getPolicy(), rootURLs);
            Policy.setPolicy(eclipsePolicy);
        }
    }

    public static boolean isValidPlatform(PlatformFileContext context) {
        File plugin;
        String root = context.getPlatform();
        return root != null && (plugin = new File(new File(root), "plugins")).exists() && plugin.isDirectory();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ChildFirstURLClassLoader
    extends URLClassLoader {
        public ChildFirstURLClassLoader(URL[] urls) {
            super(urls);
        }

        public ChildFirstURLClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        @Override
        public URL getResource(String name) {
            ClassLoader parent;
            URL resource = this.findResource(name);
            if (resource == null && (parent = this.getParent()) != null) {
                resource = parent.getResource(name);
            }
            return resource;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Class<?> clazz = null;
            Class<ChildFirstURLClassLoader> clazz2 = ChildFirstURLClassLoader.class;
            synchronized (ChildFirstURLClassLoader.class) {
                clazz = this.findLoadedClass(name);
                if (clazz == null) {
                    try {
                        clazz = this.findClass(name);
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
                if (clazz == null) {
                    ClassLoader parent = this.getParent();
                    clazz = parent != null ? parent.loadClass(name) : ChildFirstURLClassLoader.getSystemClassLoader().loadClass(name);
                }
                if (resolve) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
        }
    }
}

