/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl.locale;

import com.ibm.icu.impl.Utility;
import com.ibm.icu.impl.locale.AsciiUtil;
import com.ibm.icu.impl.locale.BaseLocale;
import com.ibm.icu.impl.locale.LanguageTag;
import com.ibm.icu.impl.locale.LocaleExtensions;
import com.ibm.icu.impl.locale.LocaleSyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public final class InternalLocaleBuilder {
    public static final char PRIVATEUSEKEY = 'x';
    private String _language = "";
    private String _script = "";
    private String _region = "";
    private String _variant = "";
    private FieldHandler _handler = FieldHandler.DEFAULT;
    private HashMap _extMap;
    private HashMap _kwdMap;
    private static final char LDMLSINGLETON = 'u';
    private static final String LANGTAGSEP = "-";
    private static final String LOCALESEP = "_";
    private static final int DEFAULTMAPCAPACITY = 4;

    public InternalLocaleBuilder() {
    }

    public InternalLocaleBuilder(FieldHandler handler) {
        this._handler = handler;
    }

    public InternalLocaleBuilder setLanguage(String language) throws LocaleSyntaxException {
        String newval = "";
        if (language.length() > 0 && (newval = this._handler.process(0, language)) == null) {
            throw new LocaleSyntaxException("Ill-formed language: " + language);
        }
        this._language = newval;
        return this;
    }

    public InternalLocaleBuilder setScript(String script) throws LocaleSyntaxException {
        String newval = "";
        if (script.length() > 0 && (newval = this._handler.process(1, script)) == null) {
            throw new LocaleSyntaxException("Ill-formed script: " + script);
        }
        this._script = newval;
        return this;
    }

    public InternalLocaleBuilder setRegion(String region) throws LocaleSyntaxException {
        String newval = "";
        if (region.length() > 0 && (newval = this._handler.process(2, region)) == null) {
            throw new LocaleSyntaxException("Ill-formed region: " + region);
        }
        this._region = newval;
        return this;
    }

    public InternalLocaleBuilder setVariant(String variant) throws LocaleSyntaxException {
        String newval = "";
        if (variant.length() > 0 && (newval = this._handler.process(3, variant)) == null) {
            throw new LocaleSyntaxException("Ill-formed variant: " + variant);
        }
        this._variant = newval;
        return this;
    }

    public InternalLocaleBuilder setLDMLExtensionValue(String key, String type) throws LocaleSyntaxException {
        if (key.length() == 0) {
            throw new LocaleSyntaxException("Empty LDML extension key");
        }
        String kwdkey = this._handler.process(4, key);
        if (kwdkey == null) {
            throw new LocaleSyntaxException("Ill-formed LDML extension key: " + key);
        }
        if (type.length() == 0) {
            if (this._kwdMap != null) {
                this._kwdMap.remove(kwdkey);
            }
        } else {
            String kwdtype = this._handler.process(5, type);
            if (kwdtype == null) {
                throw new LocaleSyntaxException("Ill-formed LDML extension value: " + type);
            }
            if (this._kwdMap == null) {
                this._kwdMap = new HashMap(4);
            }
            this._kwdMap.put(kwdkey, kwdtype);
        }
        return this;
    }

    public InternalLocaleBuilder setExtension(char singleton, String value) throws LocaleSyntaxException {
        if (!LocaleExtensions.isValidExtensionKey(singleton)) {
            throw new LocaleSyntaxException("Ill-formed extension key: " + singleton);
        }
        if ((singleton = AsciiUtil.toLower(singleton)) == 'u') {
            String[] kwdtags;
            if (this._kwdMap != null) {
                this._kwdMap.clear();
            }
            if ((kwdtags = Utility.split(Utility.replaceAll(value, LOCALESEP, LANGTAGSEP), '-')).length % 2 != 0) {
                throw new LocaleSyntaxException("Ill-formed LDML extension key/value pairs: " + value);
            }
            int idx = 0;
            while (idx < kwdtags.length) {
                String kwdkey = this._handler.process(4, kwdtags[idx++]);
                String kwdtype = this._handler.process(5, kwdtags[idx++]);
                if (kwdkey == null || kwdkey.length() == 0 || kwdtype == null || kwdtype.length() == 0) {
                    throw new LocaleSyntaxException("Ill-formed LDML extension key/value pairs: " + value);
                }
                if (this._kwdMap == null) {
                    this._kwdMap = new HashMap(kwdtags.length / 2);
                }
                this._kwdMap.put(kwdkey, kwdtype);
            }
        } else if (value.length() == 0) {
            if (this._extMap != null) {
                this._extMap.remove(new Character(singleton));
            }
        } else {
            int ftype = singleton == 'x' ? 7 : 6;
            String extval = this._handler.process(ftype, value);
            if (extval == null) {
                throw new LocaleSyntaxException("Ill-formed LDML extension value: " + value);
            }
            if (this._extMap == null) {
                this._extMap = new HashMap(4);
            }
            this._extMap.put(new Character(singleton), extval);
        }
        return this;
    }

    public InternalLocaleBuilder clear() {
        this._language = "";
        this._script = "";
        this._region = "";
        this._variant = "";
        this.removeLocaleExtensions();
        return this;
    }

    public InternalLocaleBuilder removeLocaleExtensions() {
        if (this._extMap != null) {
            this._extMap.clear();
        }
        if (this._kwdMap != null) {
            this._kwdMap.clear();
        }
        return this;
    }

    public BaseLocale getBaseLocale() {
        return BaseLocale.getInstance(this._language, this._script, this._region, this._variant);
    }

    public LocaleExtensions getLocaleExtensions() {
        Object key;
        Iterator itr;
        TreeMap<Character, String> extMap = null;
        TreeMap<String, String> kwdMap = null;
        if (this._kwdMap != null && this._kwdMap.size() > 0) {
            Set kwds = this._kwdMap.entrySet();
            itr = kwds.iterator();
            while (itr.hasNext()) {
                Map.Entry kwd = itr.next();
                key = (String)kwd.getKey();
                String type = (String)kwd.getValue();
                if (kwdMap == null) {
                    kwdMap = new TreeMap<String, String>();
                }
                kwdMap.put(((String)key).intern(), type.intern());
            }
        }
        if (this._extMap != null) {
            Set exts = this._extMap.entrySet();
            itr = exts.iterator();
            while (itr.hasNext()) {
                Map.Entry ext = itr.next();
                key = (Character)ext.getKey();
                String value = (String)ext.getValue();
                if (extMap == null) {
                    extMap = new TreeMap();
                }
                extMap.put((Character)key, value.intern());
            }
        }
        if (kwdMap != null) {
            StringBuffer buf = new StringBuffer();
            LocaleExtensions.keywordsToString(kwdMap, buf);
            if (extMap == null) {
                extMap = new TreeMap<Character, String>();
            }
            extMap.put(new Character('u'), buf.toString().intern());
        }
        return LocaleExtensions.getInstance(extMap, kwdMap);
    }

    public static class FieldHandler {
        public static FieldHandler DEFAULT = new FieldHandler();

        protected FieldHandler() {
        }

        public String process(int type, String value) {
            if ((value = this.map(type, value)).length() > 0 && !this.validate(type, value)) {
                return null;
            }
            return value;
        }

        protected String map(int type, String value) {
            switch (type) {
                case 0: {
                    value = AsciiUtil.toLowerString(value);
                    break;
                }
                case 1: {
                    if (value.length() <= 0) break;
                    StringBuffer buf = new StringBuffer();
                    buf.append(AsciiUtil.toUpper(value.charAt(0)));
                    int i = 1;
                    while (i < value.length()) {
                        buf.append(AsciiUtil.toLower(value.charAt(i)));
                        ++i;
                    }
                    value = buf.toString();
                    break;
                }
                case 2: {
                    value = AsciiUtil.toUpperString(value);
                    break;
                }
                case 3: {
                    value = Utility.replaceAll(value, InternalLocaleBuilder.LANGTAGSEP, InternalLocaleBuilder.LOCALESEP);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    value = Utility.replaceAll(AsciiUtil.toLowerString(value), InternalLocaleBuilder.LOCALESEP, InternalLocaleBuilder.LANGTAGSEP);
                }
            }
            return value;
        }

        protected boolean validate(int type, String value) {
            boolean isValid = false;
            block0 : switch (type) {
                case 0: {
                    isValid = LanguageTag.isLanguageSubtag(value);
                    break;
                }
                case 1: {
                    isValid = LanguageTag.isScriptSubtag(value);
                    break;
                }
                case 2: {
                    isValid = LanguageTag.isRegionSubtag(value);
                    break;
                }
                case 3: {
                    String[] subtags = Utility.split(value, '_');
                    int i = 0;
                    while (i < subtags.length) {
                        String subtag = subtags[i];
                        isValid = LanguageTag.isVariantSubtag(subtag);
                        if (!isValid) break block0;
                        ++i;
                    }
                    break;
                }
                case 4: {
                    isValid = LocaleExtensions.isValidLDMLKey(value);
                    break;
                }
                case 5: {
                    isValid = LocaleExtensions.isValidLDMLType(value);
                    break;
                }
                case 6: {
                    String[] subtags = Utility.split(value, '-');
                    int i = 0;
                    while (i < subtags.length) {
                        String subtag = subtags[i];
                        isValid = LanguageTag.isExtensionSubtag(subtag);
                        if (!isValid) break block0;
                        ++i;
                    }
                    break;
                }
                case 7: {
                    String[] subtags = Utility.split(value, '-');
                    int i = 0;
                    while (i < subtags.length) {
                        String subtag = subtags[i];
                        isValid = LanguageTag.isPrivateuseValueSubtag(subtag);
                        if (!isValid) break block0;
                        ++i;
                    }
                    break;
                }
            }
            return isValid;
        }
    }

    private static class FieldType {
        public static final int LANGUAGE = 0;
        public static final int SCRIPT = 1;
        public static final int REGION = 2;
        public static final int VARIANT = 3;
        public static final int LDMLKEY = 4;
        public static final int LDMLTYPE = 5;
        public static final int EXTENSION = 6;
        public static final int PRIVATEUSE = 7;

        private FieldType() {
        }
    }
}

