/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.core;

import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaClient;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaClientFactory;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaRepositoryConnector;
import org.eclipse.mylyn.internal.bugzilla.core.RepositoryConfiguration;
import org.eclipse.mylyn.internal.tasks.core.IRepositoryChangeListener;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryChangeEvent;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryDelta;
import org.eclipse.mylyn.tasks.core.IRepositoryListener;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.sync.TaskJob;

public class BugzillaClientManager
implements IRepositoryListener,
IRepositoryChangeListener {
    private final Map<String, BugzillaClient> clientByUrl = new HashMap<String, BugzillaClient>();
    private final BugzillaRepositoryConnector connector;
    private JobChangeAdapter repositoryConfigurationUpdateJobChangeAdapter;

    public BugzillaClientManager(BugzillaRepositoryConnector connector) {
        this.connector = connector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BugzillaClient getClient(TaskRepository taskRepository, IProgressMonitor monitor) throws CoreException {
        BugzillaClient client;
        Map<String, BugzillaClient> map = this.clientByUrl;
        synchronized (map) {
            client = this.clientByUrl.get(taskRepository.getRepositoryUrl());
            if (client == null) {
                String language = taskRepository.getProperty("bugzilla.languageSetting");
                if (language == null || language.equals("")) {
                    language = "en (default)";
                }
                try {
                    client = this.createClient(taskRepository);
                }
                catch (MalformedURLException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.bugzilla", "Malformed Repository Url", (Throwable)e));
                }
                this.clientByUrl.put(taskRepository.getRepositoryUrl(), client);
            }
            RepositoryConfiguration config = this.connector.getRepositoryConfiguration(taskRepository.getUrl());
            client.setRepositoryConfiguration(config);
        }
        return client;
    }

    protected BugzillaClient createClient(TaskRepository taskRepository) throws MalformedURLException {
        return BugzillaClientFactory.createClient(taskRepository, this.connector);
    }

    public void repositoryAdded(TaskRepository repository) {
        this.removeClient(repository);
    }

    public void repositoryRemoved(TaskRepository repository) {
        this.removeClient(repository);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeClient(TaskRepository repository) {
        Map<String, BugzillaClient> map = this.clientByUrl;
        synchronized (map) {
            this.clientByUrl.remove(repository.getRepositoryUrl());
        }
    }

    public void repositorySettingsChanged(TaskRepository repository) {
        this.removeClient(repository);
    }

    public void repositoryUrlChanged(TaskRepository repository, String oldUrl) {
    }

    public void repositoryChanged(TaskRepositoryChangeEvent event) {
        Object key;
        TaskRepositoryDelta.Type type = event.getDelta().getType();
        if (type == TaskRepositoryDelta.Type.PROPERTY && ("bugzilla.xmlrpc.status.transition".equals(key = event.getDelta().getKey()) || "bugzilla.desciptorFile".equals(key))) {
            final TaskRepository repository = event.getRepository();
            TaskJob updateJob = new TaskJob("Refreshing repository configuration"){
                private IStatus error;

                protected IStatus run(IProgressMonitor monitor) {
                    monitor = SubMonitor.convert((IProgressMonitor)monitor);
                    monitor.beginTask("Receiving_configuration", -1);
                    try {
                        try {
                            BugzillaClientManager.this.connector.updateRepositoryConfiguration(repository, null, monitor);
                        }
                        catch (CoreException e) {
                            this.error = e.getStatus();
                        }
                    }
                    finally {
                        monitor.done();
                    }
                    return Status.OK_STATUS;
                }

                public boolean belongsTo(Object family) {
                    return family == repository;
                }

                public IStatus getStatus() {
                    return this.error;
                }
            };
            updateJob.setPriority(10);
            updateJob.addJobChangeListener((IJobChangeListener)this.repositoryConfigurationUpdateJobChangeAdapter);
            updateJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void done(IJobChangeEvent event) {
                    TaskRepository taskRepository = repository;
                    synchronized (taskRepository) {
                        repository.setUpdating(false);
                    }
                }
            });
            updateJob.schedule();
        }
    }

    public void setRepositoryConfigurationUpdateJobChangeAdapter(JobChangeAdapter repositoryConfigurationUpdateJobChangeAdapter) {
        this.repositoryConfigurationUpdateJobChangeAdapter = repositoryConfigurationUpdateJobChangeAdapter;
    }
}

