/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.views;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.ICommandLink;
import org.eclipse.help.IContext;
import org.eclipse.help.IContext2;
import org.eclipse.help.IContext3;
import org.eclipse.help.IContextProvider;
import org.eclipse.help.IHelpResource;
import org.eclipse.help.ITopic;
import org.eclipse.help.UAContentFilter;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.base.HelpEvaluationContext;
import org.eclipse.help.internal.context.Context;
import org.eclipse.help.internal.toc.Toc;
import org.eclipse.help.ui.internal.DefaultHelpUI;
import org.eclipse.help.ui.internal.ExecuteCommandAction;
import org.eclipse.help.ui.internal.HelpUIPlugin;
import org.eclipse.help.ui.internal.HelpUIResources;
import org.eclipse.help.ui.internal.Messages;
import org.eclipse.help.ui.internal.util.EscapeUtils;
import org.eclipse.help.ui.internal.views.ContextHelpProviderInput;
import org.eclipse.help.ui.internal.views.ContextHelpSorter;
import org.eclipse.help.ui.internal.views.IHelpPart;
import org.eclipse.help.ui.internal.views.RelatedTopicsPart;
import org.eclipse.help.ui.internal.views.ReusableHelpPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.dialogs.IPageChangeProvider;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.window.Window;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class ContextHelpPart
extends SectionPart
implements IHelpPart {
    private ReusableHelpPart parent;
    private static final String HELP_KEY = "org.eclipse.ui.help";
    private static final String MORE_HREF = "__more__";
    private FormText text;
    private Control lastControl;
    private IContextProvider lastProvider;
    private IContext lastContext;
    private IWorkbenchPart lastPart;
    private String defaultText = "";
    private String id;
    private Font codeFont;
    private String savedDescription;
    private long lastUpdate = 0L;
    private String[] searchTerms;

    public ContextHelpPart(Composite parent, FormToolkit toolkit) {
        super(parent, toolkit, ContextHelpPart.getSectionStyle());
        Section section = this.getSection();
        section.marginWidth = 5;
        section.setText(Messages.ContextHelpPart_about);
        Composite container = toolkit.createComposite((Composite)section);
        section.setClient((Control)container);
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                if (e.getState()) {
                    ContextHelpPart.this.updateText(ContextHelpPart.this.savedDescription);
                }
            }
        });
        TableWrapLayout layout = new TableWrapLayout();
        layout.bottomMargin = 0;
        layout.topMargin = 0;
        layout.rightMargin = 0;
        layout.leftMargin = 0;
        layout.verticalSpacing = 10;
        container.setLayout((Layout)layout);
        this.text = toolkit.createFormText(container, false);
        this.text.setWhitespaceNormalized(false);
        this.text.setLayoutData((Object)new TableWrapData(256));
        this.text.setColor("org.eclipse.ui.forms.TITLE", toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.codeFont = ContextHelpPart.createCodeFont(parent.getDisplay(), parent.getFont(), JFaceResources.getTextFont());
        this.text.setFont("code", this.codeFont);
        String key = "obj16/topic_small.gif";
        this.text.setImage(key, HelpUIResources.getImage(key));
        key = "obj16/command_small.gif";
        this.text.setImage(key, HelpUIResources.getImage(key));
        String searchKey = "etool16/helpsearch_co.gif";
        this.text.setImage(searchKey, HelpUIResources.getImage(searchKey));
        this.text.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent e) {
                String href = (String)e.getHref();
                if (href.startsWith(ContextHelpPart.MORE_HREF)) {
                    ContextHelpPart.this.doMore(href.substring(ContextHelpPart.MORE_HREF.length()));
                } else {
                    ContextHelpPart.this.doOpenLink(e.getHref());
                }
            }

            public void linkEntered(HyperlinkEvent e) {
                ContextHelpPart.this.parent.handleLinkEntered(e);
            }

            public void linkExited(HyperlinkEvent e) {
                ContextHelpPart.this.parent.handleLinkExited(e);
            }
        });
        this.text.setText(this.defaultText, false, false);
        this.text.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID == -1) {
                    String currentName = e.result;
                    e.result = String.valueOf(Messages.ReusableHelpPart_contextHelpPage_name) + ' ' + ContextHelpPart.this.getSection().getText() + ' ' + currentName;
                }
            }
        });
    }

    private static int getSectionStyle() {
        int style = 320;
        if (RelatedTopicsPart.isUseDynamicHelp()) {
            style |= 2;
        }
        return style;
    }

    private static Font createCodeFont(Display display, Font regularFont, Font textFont) {
        FontData[] rfontData = regularFont.getFontData();
        FontData[] tfontData = textFont.getFontData();
        int height = 0;
        int i = 0;
        while (i < rfontData.length) {
            FontData data = rfontData[i];
            height = Math.max(height, data.getHeight());
            ++i;
        }
        i = 0;
        while (i < tfontData.length) {
            tfontData[i].setHeight(height);
            ++i;
        }
        return new Font((Device)display, tfontData);
    }

    public void dispose() {
        if (this.codeFont != null) {
            this.codeFont.dispose();
        }
        this.codeFont = null;
        super.dispose();
    }

    public Control getControl() {
        return this.getSection();
    }

    public void init(ReusableHelpPart parent, String id, IMemento memento) {
        this.parent = parent;
        this.id = id;
        parent.hookFormText(this.text);
    }

    public String getId() {
        return this.id;
    }

    public void setVisible(boolean visible) {
        this.getSection().setVisible(visible);
    }

    public String getDefaultText() {
        return this.defaultText;
    }

    public void setDefaultText(String defaultText) {
        this.defaultText = defaultText;
        if (this.text != null) {
            this.text.setText(defaultText, false, false);
        }
    }

    private void doOpenLink(Object href) {
        String sHref = (String)href;
        if (sHref.startsWith("command://")) {
            this.doRunCommand(sHref.substring(10));
        } else {
            this.parent.showURL(sHref);
        }
    }

    private void doRunCommand(String serialization) {
        ExecuteCommandAction action = new ExecuteCommandAction();
        action.setInitializationString(serialization);
        action.run();
    }

    private void updateDescription(String helpText) {
        if (this.getSection().isExpanded()) {
            this.updateText(helpText);
        }
        this.savedDescription = helpText;
    }

    private void updateSearchExpression() {
        String title;
        String providerSearchExpression;
        if (this.lastProvider != null && (providerSearchExpression = this.lastProvider.getSearchExpression((Object)this.lastControl)) != null) {
            this.updateSearchExpression(providerSearchExpression, this.lastControl);
            return;
        }
        if (this.lastContext instanceof IContext2 && (title = ((IContext2)this.lastContext).getTitle()) != null) {
            this.updateSearchExpression(title, this.lastControl);
            return;
        }
        if (this.lastControl != null) {
            this.updateSearchExpression(null, this.lastControl);
        }
    }

    public void handleActivation(IContextProvider provider, IContext context, Control c, IWorkbenchPart part, boolean isExplicitRequest) {
        if (this.text.isDisposed()) {
            return;
        }
        if (DefaultHelpUI.isOpeningHelpView()) {
            return;
        }
        if (this.checkForRecentExplicitActivation(isExplicitRequest)) {
            return;
        }
        this.lastControl = c;
        this.lastProvider = provider;
        this.lastContext = context;
        this.lastPart = part;
        if (provider != null && (context == null || context instanceof Context && "org.eclipse.ui.missing".equals(((Context)context).getId()))) {
            this.lastContext = provider.getContext((Object)c);
        }
        this.updateSearchExpression();
        String helpText = this.lastContext != null ? this.formatHelpContext(this.lastContext) : this.createContextHelp(c);
        this.updateTitle(c);
        this.updateDescription(helpText);
        if (RelatedTopicsPart.isUseDynamicHelp()) {
            this.updateDynamicHelp();
        }
    }

    private boolean checkForRecentExplicitActivation(boolean isExplicitRequest) {
        if (isExplicitRequest) {
            this.lastUpdate = System.currentTimeMillis();
            return false;
        }
        if (this.lastUpdate == 0L) {
            return false;
        }
        long previousUpdate = this.lastUpdate;
        this.lastUpdate = 0L;
        return System.currentTimeMillis() - previousUpdate < 500L;
    }

    private void updateTitle(Control c) {
        String[] searchTerms;
        String title = null;
        if (this.lastContext != null && this.lastContext instanceof IContext2) {
            IContext2 c2 = (IContext2)this.lastContext;
            title = c2.getTitle();
        }
        if (title == null && this.lastPart != null) {
            title = NLS.bind((String)Messages.ContextHelpPart_aboutP, (Object)this.lastPart.getSite().getRegisteredName());
        }
        if (title == null && (searchTerms = this.computeSearchTerms(c)).length > 0) {
            title = NLS.bind((String)Messages.ContextHelpPart_aboutP, (Object)searchTerms[0]);
        }
        if (title == null) {
            title = Messages.ContextHelpPart_about;
        }
        this.getSection().setText(EscapeUtils.escapeForLabel(title));
    }

    private void updateText(String helpText) {
        try {
            this.text.setText(helpText != null ? helpText : this.defaultText, helpText != null, false);
            this.getSection().layout();
            this.getManagedForm().reflow(true);
        }
        catch (Exception e) {
            HelpUIPlugin.logError("Error displaying context help text " + helpText, e);
        }
    }

    private void updateSearchExpression(String expression, Control c) {
        this.searchTerms = expression == null ? this.computeSearchTerms(c) : new String[]{expression};
    }

    private void updateDynamicHelp() {
        RelatedTopicsPart part = (RelatedTopicsPart)this.parent.findPart("related-topics");
        if (part != null && this.searchTerms != null) {
            if (HelpPlugin.DEBUG_CONTEXT) {
                System.out.println("Dynamic help - search for " + this.searchTerms);
            }
            part.startSearch(this.buildSearchExpression(this.searchTerms), this.lastContext);
        }
    }

    private String buildSearchExpression(String[] searchTerms) {
        StringBuffer buff = new StringBuffer();
        int i = 0;
        while (i < searchTerms.length) {
            if (buff.length() > 0) {
                buff.append(" OR ");
            }
            buff.append('\"');
            buff.append(searchTerms[i]);
            buff.append('\"');
            ++i;
        }
        return buff.length() > 0 ? buff.toString().trim() : null;
    }

    private String[] computeSearchTerms(Control c) {
        Composite container = c instanceof Composite ? (Composite)c : c.getParent();
        SearchTerms searchTerms = new SearchTerms();
        while (container != null) {
            Object data = container.getData();
            if (data instanceof IWizardContainer) {
                IWizardContainer wc = (IWizardContainer)data;
                searchTerms.add(wc.getCurrentPage().getTitle());
                searchTerms.add(wc.getCurrentPage().getWizard().getWindowTitle());
                break;
            }
            if (data instanceof IWorkbenchWindow) {
                IWorkbenchPart part;
                IWorkbenchWindow window = (IWorkbenchWindow)data;
                IWorkbenchPage page = window.getActivePage();
                if (page == null || (part = this.lastPart) == null) break;
                if (part instanceof IViewPart) {
                    searchTerms.add(NLS.bind((String)Messages.ContextHelpPart_query_view, (Object)part.getSite().getRegisteredName()));
                    break;
                }
                if (!(part instanceof IEditorPart) || part.getSite() == null || part.getSite().getRegisteredName() == null) break;
                searchTerms.add(part.getSite().getRegisteredName());
                break;
            }
            if (data instanceof Window) {
                Object page;
                String pageName;
                Window w = (Window)data;
                if (w instanceof IPageChangeProvider && (pageName = this.getPageName(c, page = ((IPageChangeProvider)w).getSelectedPage())) != null) {
                    searchTerms.add(pageName);
                }
                searchTerms.add(w.getShell().getText());
                break;
            }
            container = container.getParent();
        }
        return searchTerms.toArray();
    }

    private String getPageName(Control focusControl, Object page) {
        if (page instanceof IDialogPage) {
            return ((IDialogPage)page).getTitle();
        }
        if (focusControl == null) {
            return null;
        }
        Composite parent = focusControl.getParent();
        while (parent != null) {
            CTabItem selection;
            if (parent instanceof TabFolder) {
                selection = ((TabFolder)parent).getSelection();
                if (((TabItem[])selection).length == 1) {
                    return this.stripMnemonic(selection[0].getText());
                }
            } else if (parent instanceof CTabFolder) {
                selection = ((CTabFolder)parent).getSelection();
                return this.stripMnemonic(selection.getText());
            }
            parent = parent.getParent();
        }
        return null;
    }

    private String stripMnemonic(String name) {
        int loc = name.indexOf(38);
        if (loc != -1) {
            return String.valueOf(name.substring(0, loc)) + name.substring(loc + 1);
        }
        return name;
    }

    private String createContextHelp(Control page) {
        IContext helpContext;
        String text = null;
        this.lastContext = null;
        if (page != null && page != null && !page.isDisposed() && (helpContext = ContextHelpPart.findHelpContext(page)) != null) {
            text = this.formatHelpContext(helpContext);
            this.lastContext = helpContext;
        }
        return text;
    }

    public static IContext findHelpContext(Control c) {
        String contextId = null;
        Control node = c;
        while ((contextId = (String)node.getData(HELP_KEY)) == null && (node = node.getParent()) != null) {
        }
        if (contextId != null) {
            return HelpSystem.getContext((String)contextId);
        }
        return null;
    }

    private String formatHelpContext(IContext context) {
        Object[] links;
        String locale = Platform.getNL();
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("<form>");
        sbuf.append("<p>");
        sbuf.append(this.decodeContextBoldTags(context));
        sbuf.append("</p>");
        ICommandLink[] commands = null;
        if (context instanceof IContext3) {
            commands = ((IContext3)context).getRelatedCommands();
        }
        String category = new String();
        if (commands != null && commands.length > 0) {
            int i = 0;
            while (i < commands.length) {
                if (!UAContentFilter.isFiltered((Object)commands[i], (IEvaluationContext)HelpEvaluationContext.getContext())) {
                    if (category != null) {
                        this.addCategory(sbuf, null);
                    }
                    category = null;
                    sbuf.append("<li style=\"image\" value=\"");
                    sbuf.append("obj16/command_small.gif");
                    sbuf.append("\" indent=\"21\">");
                    sbuf.append("<a href=\"command://");
                    sbuf.append(commands[i].getSerialization());
                    sbuf.append("\">");
                    sbuf.append(EscapeUtils.escapeSpecialChars(commands[i].getLabel()));
                    sbuf.append("</a>");
                    sbuf.append("</li>");
                }
                ++i;
            }
        }
        if ((links = context.getRelatedTopics()) != null && context instanceof IContext2) {
            ContextHelpSorter sorter = new ContextHelpSorter((IContext2)context);
            sorter.sort(null, links);
        }
        if (links != null && links.length > 0) {
            int i = 0;
            while (i < links.length) {
                Object link = links[i];
                if (!UAContentFilter.isFiltered((Object)link, (IEvaluationContext)HelpEvaluationContext.getContext())) {
                    String cat = null;
                    if (context instanceof IContext2) {
                        cat = ((IContext2)context).getCategory((IHelpResource)link);
                    }
                    if (cat == null && category != null || cat != null && category == null || cat != null && category != null && !cat.equals(category)) {
                        this.addCategory(sbuf, cat);
                    }
                    category = cat;
                    sbuf.append("<li style=\"image\" value=\"");
                    sbuf.append("obj16/topic_small.gif");
                    sbuf.append("\" indent=\"21\">");
                    sbuf.append("<a href=\"");
                    sbuf.append(EscapeUtils.escapeAmpersand(link.getHref()));
                    String tcat = this.getTopicCategory(link.getHref(), locale);
                    if (tcat != null && !Platform.getWS().equals("gtk")) {
                        sbuf.append("\" alt=\"");
                        sbuf.append(EscapeUtils.escapeSpecialChars(tcat));
                    }
                    sbuf.append("\">");
                    sbuf.append(EscapeUtils.escapeSpecialChars(link.getLabel()));
                    sbuf.append("</a>");
                    sbuf.append("</li>");
                } else if (HelpPlugin.DEBUG_CONTEXT) {
                    System.out.println("Link is filtered out: " + link.getLabel());
                }
                ++i;
            }
        }
        if (!RelatedTopicsPart.isUseDynamicHelp() && this.searchTerms != null && this.searchTerms.length > 0) {
            sbuf.append("<p><span color=\"");
            sbuf.append("org.eclipse.ui.forms.TITLE");
            sbuf.append("\">");
            sbuf.append(Messages.ContextHelpPart_more);
            sbuf.append("</span></p>");
            int term = 0;
            while (term < this.searchTerms.length) {
                sbuf.append("<p><img href=\"");
                sbuf.append("etool16/helpsearch_co.gif");
                sbuf.append("\"/>");
                sbuf.append(" <a href=\"");
                sbuf.append(MORE_HREF);
                sbuf.append(term);
                sbuf.append("\">");
                String searchForMessage = NLS.bind((String)Messages.ContextHelpPart_searchFor, (Object)this.searchTerms[term]);
                sbuf.append(EscapeUtils.escapeSpecialChars(searchForMessage));
                sbuf.append("</a></p>");
                ++term;
            }
        }
        sbuf.append("</form>");
        return sbuf.toString();
    }

    private void addCategory(StringBuffer sbuf, String category) {
        if (category == null) {
            category = Messages.ContextHelpPart_seeAlso;
        }
        sbuf.append("<p><span color=\"");
        sbuf.append("org.eclipse.ui.forms.TITLE");
        sbuf.append("\">");
        sbuf.append(category);
        sbuf.append("</span></p>");
    }

    private String getTopicCategory(String href, String locale) {
        Toc[] tocs = HelpPlugin.getTocManager().getTocs(locale);
        int i = 0;
        while (i < tocs.length) {
            ITopic topic = tocs[i].getTopic(href);
            if (topic != null) {
                return tocs[i].getLabel();
            }
            ++i;
        }
        return null;
    }

    private String decodeContextBoldTags(IContext context) {
        String styledText;
        if (context instanceof IContext2) {
            styledText = ((IContext2)context).getStyledText();
            if (styledText == null) {
                styledText = context.getText();
            }
        } else {
            styledText = context.getText();
        }
        if (styledText == null) {
            return Messages.ContextHelpPart_noDescription;
        }
        String decodedString = styledText.replaceAll("<@#\\$b>", "<b>");
        decodedString = decodedString.replaceAll("</@#\\$b>", "</b>");
        decodedString = EscapeUtils.escapeSpecialCharsLeavinggBold(decodedString);
        decodedString = decodedString.replaceAll("\r\n|\n|\r", "<br/>");
        return decodedString;
    }

    public boolean setFormInput(Object input) {
        if (input instanceof ContextHelpProviderInput) {
            ContextHelpProviderInput chinput = (ContextHelpProviderInput)input;
            this.handleActivation(chinput.getProvider(), chinput.getContext(), chinput.getControl(), chinput.getPart(), chinput.isExplicitRequest());
            return true;
        }
        return false;
    }

    public void setFocus() {
        if (this.text != null) {
            this.text.setFocus();
        }
    }

    public boolean fillContextMenu(IMenuManager manager) {
        return this.parent.fillFormContextMenu(this.text, manager);
    }

    public boolean hasFocusControl(Control control) {
        return this.text.equals(control);
    }

    public IAction getGlobalAction(String id) {
        if (id.equals(ActionFactory.COPY.getId())) {
            return this.parent.getCopyAction();
        }
        return null;
    }

    public void stop() {
    }

    public void toggleRoleFilter() {
    }

    public void refilter() {
    }

    public void saveState(IMemento memento) {
    }

    private void doMore(String moreText) {
        int index = Integer.parseInt(moreText);
        this.parent.startSearch(this.searchTerms[index]);
    }

    private class SearchTerms {
        private List terms = new ArrayList();
        private Set termSet = new HashSet();

        private SearchTerms() {
        }

        public void add(String term) {
            String lowerCaseTerm = term.toLowerCase();
            if (!this.termSet.contains(lowerCaseTerm)) {
                this.termSet.add(lowerCaseTerm);
                this.terms.add(term);
            }
        }

        public String[] toArray() {
            return this.terms.toArray(new String[this.terms.size()]);
        }
    }
}

