/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.views;

import com.ibm.icu.text.Collator;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.help.IContext;
import org.eclipse.help.IContextProvider;
import org.eclipse.help.IHelpResource;
import org.eclipse.help.IIndexEntry;
import org.eclipse.help.IToc;
import org.eclipse.help.ITopic;
import org.eclipse.help.UAContentFilter;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.base.HelpEvaluationContext;
import org.eclipse.help.internal.base.util.LinkUtil;
import org.eclipse.help.internal.protocols.HelpURLConnection;
import org.eclipse.help.internal.search.federated.IndexerJob;
import org.eclipse.help.internal.util.ProductPreferences;
import org.eclipse.help.search.ISearchEngine2;
import org.eclipse.help.ui.internal.DefaultHelpUI;
import org.eclipse.help.ui.internal.HelpUIPlugin;
import org.eclipse.help.ui.internal.HelpUIResources;
import org.eclipse.help.ui.internal.IHelpUIConstants;
import org.eclipse.help.ui.internal.Messages;
import org.eclipse.help.ui.internal.views.AllTopicsPart;
import org.eclipse.help.ui.internal.views.BookmarksPart;
import org.eclipse.help.ui.internal.views.BrowserPart;
import org.eclipse.help.ui.internal.views.ContextHelpPart;
import org.eclipse.help.ui.internal.views.ContextHelpProviderInput;
import org.eclipse.help.ui.internal.views.DynamicHelpPart;
import org.eclipse.help.ui.internal.views.EngineDescriptor;
import org.eclipse.help.ui.internal.views.EngineDescriptorManager;
import org.eclipse.help.ui.internal.views.HistoryEntry;
import org.eclipse.help.ui.internal.views.IHelpPart;
import org.eclipse.help.ui.internal.views.IHelpPartPage;
import org.eclipse.help.ui.internal.views.IndexPart;
import org.eclipse.help.ui.internal.views.IndexTypeinPart;
import org.eclipse.help.ui.internal.views.RelatedTopicsPart;
import org.eclipse.help.ui.internal.views.ReusableHelpPartHistory;
import org.eclipse.help.ui.internal.views.ScopeSelectPart;
import org.eclipse.help.ui.internal.views.SearchPart;
import org.eclipse.help.ui.internal.views.SearchResultsPart;
import org.eclipse.help.ui.internal.views.SeeAlsoPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.SubMenuManager;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.action.SubToolBarManager;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.SubActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.activities.ActivityManagerEvent;
import org.eclipse.ui.activities.IActivityManagerListener;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.ManagedForm;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ILayoutExtension;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class ReusableHelpPart
implements IHelpUIConstants,
IActivityManagerListener {
    public static final int ALL_TOPICS = 2;
    public static final int CONTEXT_HELP = 4;
    public static final int SEARCH = 8;
    public static final int BOOKMARKS = 16;
    public static final int INDEX = 32;
    public static final Collator SHARED_COLLATOR = Collator.getInstance();
    private static final String PROMPT_KEY = "askShowAll";
    private static final int STATE_START = 1;
    private static final int STATE_LT = 2;
    private static final int STATE_LT_B = 3;
    private static final int STATE_LT_BR = 4;
    private static ReusableHelpPart lastActiveInstance;
    private RoleFilter roleFilter;
    private UAFilter uaFilter;
    private ManagedForm mform;
    private int verticalSpacing = 15;
    private int bmargin = 5;
    private String defaultContextHelpText;
    private ArrayList pages;
    private Action backAction;
    private Action nextAction;
    private CopyAction copyAction;
    private Action openInfoCenterAction;
    private OpenHrefAction openAction;
    private OpenHrefAction openInHelpAction;
    private OpenHrefAction bookmarkAction;
    private Action showAllAction;
    private ReusableHelpPartHistory history;
    private HelpPartPage currentPage;
    private int style;
    private IMemento memento;
    private boolean showDocumentsInPlace = true;
    private int numberOfInPlaceHits = 8;
    private IRunnableContext runnableContext;
    private IToolBarManager toolBarManager;
    private IStatusLineManager statusLineManager;
    private IActionBars actionBars;
    private EngineDescriptorManager engineManager;
    public IMenuManager menuManager;

    public ReusableHelpPart(IRunnableContext runnableContext) {
        this(runnableContext, ReusableHelpPart.getDefaultStyle());
    }

    public ReusableHelpPart(IRunnableContext runnableContext, int style) {
        this.runnableContext = runnableContext;
        this.history = new ReusableHelpPartHistory();
        this.style = style;
        this.ensureHelpIndexed();
        PlatformUI.getWorkbench().getActivitySupport().getActivityManager().addActivityManagerListener((IActivityManagerListener)this);
    }

    public static ReusableHelpPart getLastActiveInstance() {
        return lastActiveInstance;
    }

    private void ensureHelpIndexed() {
        Job[] jobs = Job.getJobManager().find((Object)"org.eclipse.help.base.indexer");
        if (jobs.length == 0) {
            IndexerJob indexerJob = new IndexerJob();
            indexerJob.schedule();
        }
    }

    public void addPage(IHelpPartPage page) {
        this.pages.add(page);
    }

    public void addPart(String id, IHelpPart part) {
        part.init(this, id, this.memento);
        this.mform.addPart((IFormPart)part);
    }

    public IHelpPartPage createPage(String id, String text, String iconId) {
        return new HelpPartPage(id, text, iconId);
    }

    private void definePages() {
        this.pages = new ArrayList();
        HelpPartPage page = new HelpPartPage("fsearch-page", Messages.ReusableHelpPart_searchPage_name, "etool16/helpsearch_co.gif");
        page.setVerticalSpacing(0);
        page.addPart("fsearch", false);
        page.addPart("fsearch-result", true);
        page.addPart("see-also", false);
        this.pages.add(page);
        page = new HelpPartPage("all-topics-page", Messages.ReusableHelpPart_allTopicsPage_name, "etool16/alltopics_co.gif");
        page.setVerticalSpacing(0);
        page.setHorizontalMargin(0);
        page.addPart("scope-select", false);
        page.addPart("topic-tree", true);
        page.addPart("see-also", false);
        this.pages.add(page);
        page = new HelpPartPage("bookmarks-page", Messages.ReusableHelpPart_bookmarksPage_name, "obj16/bookmarks_view.gif");
        page.setVerticalSpacing(0);
        page.setHorizontalMargin(0);
        page.addPart("bookmarks-tree", true);
        page.addPart("see-also", false);
        this.pages.add(page);
        page = new HelpPartPage("browser-page", null);
        page.setVerticalSpacing(0);
        page.addPart("browser", true);
        page.addPart("see-also", false);
        this.pages.add(page);
        page = new HelpPartPage("context-help-page", Messages.ReusableHelpPart_contextHelpPage_name, "etool16/reltopics_co.gif");
        page.setVerticalSpacing(0);
        page.setHorizontalMargin(0);
        page.addPart("related-topics", true);
        page.addPart("see-also", false);
        this.pages.add(page);
        page = new HelpPartPage("index-page", Messages.ReusableHelpPart_indexPage_name, "etool16/index_co.gif");
        page.setVerticalSpacing(0);
        page.addPart("scope-select", false);
        page.addPart("index-typein", false);
        page.addPart("index", true);
        page.addPart("see-also", false);
        this.pages.add(page);
    }

    public void init(IActionBars bars, IToolBarManager toolBarManager, IStatusLineManager statusLineManager, IMenuManager menuManager, IMemento memento) {
        this.memento = memento;
        this.actionBars = bars;
        this.toolBarManager = toolBarManager;
        this.menuManager = menuManager;
        this.statusLineManager = statusLineManager;
        this.definePages();
        this.makeActions();
    }

    private void makeActions() {
        this.backAction = new Action("back"){

            public void run() {
                ReusableHelpPart.this.doBack();
            }
        };
        this.backAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_BACK"));
        this.backAction.setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_BACK_DISABLED"));
        this.backAction.setEnabled(false);
        this.backAction.setText(Messages.ReusableHelpPart_back_label);
        this.backAction.setToolTipText(Messages.ReusableHelpPart_back_tooltip);
        this.backAction.setId("back");
        this.nextAction = new Action("next"){

            public void run() {
                ReusableHelpPart.this.doNext();
            }
        };
        this.nextAction.setText(Messages.ReusableHelpPart_forward_label);
        this.nextAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_FORWARD"));
        this.nextAction.setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_FORWARD_DISABLED"));
        this.nextAction.setEnabled(false);
        this.nextAction.setToolTipText(Messages.ReusableHelpPart_forward_tooltip);
        this.nextAction.setId("next");
        this.toolBarManager.add((IAction)this.backAction);
        this.toolBarManager.add((IAction)this.nextAction);
        this.openInfoCenterAction = new BusyRunAction("openInfoCenter"){

            protected void busyRun() {
                PlatformUI.getWorkbench().getHelpSystem().displayHelp();
            }
        };
        this.openInfoCenterAction.setText(Messages.ReusableHelpPart_openInfoCenterAction_label);
        this.openAction = new OpenHrefAction("open"){

            protected void busyRun() {
                ReusableHelpPart.this.doOpen(this.getTarget(), ReusableHelpPart.this.getShowDocumentsInPlace());
            }
        };
        this.openAction.setText(Messages.ReusableHelpPart_openAction_label);
        this.openInHelpAction = new OpenHrefAction(""){

            protected void busyRun() {
                ReusableHelpPart.this.doOpenInHelp(this.getTarget());
            }
        };
        this.openInHelpAction.setText(Messages.ReusableHelpPart_openInHelpContentsAction_label);
        this.copyAction = new CopyAction();
        this.copyAction.setText(Messages.ReusableHelpPart_copyAction_label);
        this.bookmarkAction = new OpenHrefAction("bookmark"){

            protected void busyRun() {
                ReusableHelpPart.this.doBookmark(this.getTarget());
            }
        };
        this.bookmarkAction.setText(Messages.ReusableHelpPart_bookmarkAction_label);
        this.bookmarkAction.setImageDescriptor(HelpUIResources.getImageDescriptor("elcl16/addbkmrk_co.gif"));
        if (this.actionBars != null && this.actionBars.getMenuManager() != null) {
            this.contributeToDropDownMenu(this.actionBars.getMenuManager());
        }
        this.roleFilter = new RoleFilter();
        this.uaFilter = new UAFilter();
        if (HelpBasePlugin.getActivitySupport().isUserCanToggleFiltering()) {
            this.showAllAction = new Action(){

                public void run() {
                    BusyIndicator.showWhile((Display)ReusableHelpPart.this.getControl().getDisplay(), (Runnable)new Runnable(this){
                        final /* synthetic */ 8 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            ReusableHelpPart.access$13(8.access$0(this.this$1), ReusableHelpPart.access$12(8.access$0(this.this$1)).isChecked());
                        }
                    });
                }

                static /* synthetic */ ReusableHelpPart access$0(8 var0) {
                    return var0.ReusableHelpPart.this;
                }
            };
            this.showAllAction.setImageDescriptor(HelpUIResources.getImageDescriptor("elcl16/show_all.gif"));
            this.showAllAction.setToolTipText(Messages.AllTopicsPart_showAll_tooltip);
            this.toolBarManager.insertBefore("back", (IAction)this.showAllAction);
            this.toolBarManager.insertBefore("back", (IContributionItem)new Separator());
            this.showAllAction.setChecked(!HelpBasePlugin.getActivitySupport().isFilteringEnabled());
        }
    }

    ViewerFilter getRoleFilter() {
        return this.roleFilter;
    }

    ViewerFilter getUAFilter() {
        return this.uaFilter;
    }

    public void activityManagerChanged(ActivityManagerEvent activityManagerEvent) {
        if (this.pages != null) {
            int i = 0;
            while (i < this.pages.size()) {
                HelpPartPage page = (HelpPartPage)this.pages.get(i);
                page.refilter();
                ++i;
            }
        }
    }

    boolean isFilteredByRoles() {
        return HelpBasePlugin.getActivitySupport().isFilteringEnabled();
    }

    private void doBack() {
        HistoryEntry entry;
        String id = this.getCurrentPageId();
        if (id.equals("browser-page")) {
            BrowserPart part = (BrowserPart)this.findPart("browser");
            part.stop();
        }
        if ((entry = this.history.prev()) != null) {
            this.executeHistoryEntry(entry);
        }
    }

    private void doNext() {
        HistoryEntry entry = this.history.next();
        if (entry != null) {
            this.executeHistoryEntry(entry);
        }
    }

    private void executeHistoryEntry(HistoryEntry entry) {
        this.history.setBlocked(true);
        if (entry.getType() == 2) {
            this.showPage(entry.getTarget(), true);
            this.mform.setInput(entry.getData());
        } else if (entry.getType() == 1) {
            String relativeUrl = (String)entry.getData();
            this.showURL(relativeUrl != null ? relativeUrl : entry.getTarget(), true);
        }
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        ScrolledForm form = toolkit.createScrolledForm(parent);
        form.getBody().setLayout((Layout)new HelpPartLayout());
        this.mform = new ManagedForm(toolkit, form);
        this.mform.getForm().setDelayedReflow(false);
        toolkit.decorateFormHeading(this.mform.getForm().getForm());
        MenuManager manager = new MenuManager();
        IMenuListener listener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ReusableHelpPart.this.contextMenuAboutToShow(manager);
            }
        };
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(listener);
        Menu contextMenu = manager.createContextMenu((Control)form.getForm());
        form.getForm().setMenu(contextMenu);
        form.addListener(26, new Listener(){

            public void handleEvent(Event event) {
                lastActiveInstance = ReusableHelpPart.this;
            }
        });
    }

    public HelpPartPage showPage(String id) {
        HelpPartPage page;
        String currentPageId;
        String string = currentPageId = this.currentPage == null ? null : this.currentPage.getId();
        if (id.equals(currentPageId)) {
            return this.currentPage;
        }
        if ("browser-page".equals(currentPageId)) {
            BrowserPart part = (BrowserPart)this.findPart("browser");
            part.clearBrowser();
        }
        if ((page = this.findPage(id)) != null) {
            page.refreshPage();
            boolean success = this.flipPages(this.currentPage, page);
            return success ? page : null;
        }
        return null;
    }

    public HelpPartPage showPage(String id, boolean setFocus) {
        HelpPartPage page = this.showPage(id);
        if (page != null && setFocus) {
            page.setFocus();
        }
        return page;
    }

    public void startSearch(String phrase) {
        this.showPage("fsearch-page", true);
        SearchPart part = (SearchPart)this.findPart("fsearch");
        if (part != null && phrase != null) {
            part.startSearch(phrase);
        }
    }

    public void showDynamicHelp(IWorkbenchPart wpart, Control c) {
        this.showPage("context-help-page", true);
        RelatedTopicsPart part = (RelatedTopicsPart)this.findPart("related-topics");
        if (part != null) {
            part.handleActivation(c, wpart);
        }
    }

    private boolean flipPages(HelpPartPage oldPage, HelpPartPage newPage) {
        if (!newPage.canOpen()) {
            return false;
        }
        if (oldPage != null) {
            oldPage.stop();
            oldPage.setVisible(false);
        }
        this.mform.getForm().setText(newPage.getText());
        this.mform.getForm().getForm().setSeparatorVisible(newPage.getText() != null);
        Image newImage = null;
        String iconId = newPage.getIconId();
        if (iconId != null) {
            newImage = HelpUIResources.getImage(iconId);
        }
        this.mform.getForm().setImage(newImage);
        newPage.setVisible(true);
        this.toolBarManager.update(true);
        this.currentPage = newPage;
        if (this.mform.isStale()) {
            this.mform.refresh();
        }
        this.mform.getForm().getBody().layout(true);
        this.mform.reflow(true);
        if (!newPage.getId().equals("browser-page")) {
            if (!this.history.isBlocked()) {
                this.history.addEntry(new HistoryEntry(2, newPage.getId(), null));
            }
            this.updateNavigation();
        }
        return true;
    }

    public HelpPartPage getCurrentPage() {
        return this.currentPage;
    }

    public String getCurrentPageId() {
        return this.currentPage != null ? this.currentPage.getId() : null;
    }

    void browserChanged(String url) {
        if (!this.history.isBlocked()) {
            try {
                this.history.addEntry(new HistoryEntry(1, url, BaseHelpSystem.unresolve((URL)new URL(url))));
            }
            catch (MalformedURLException malformedURLException) {}
        }
        this.updateNavigation();
    }

    private void updateNavigation() {
        this.backAction.setEnabled(this.history.hasPrev());
        this.nextAction.setEnabled(this.history.hasNext());
        this.history.setBlocked(false);
    }

    public boolean isMonitoringContextHelp() {
        return this.currentPage != null && this.currentPage.getId().equals("context-help-page");
    }

    public Control getControl() {
        return this.mform.getForm();
    }

    public ManagedForm getForm() {
        return this.mform;
    }

    public void reflow() {
        this.mform.getForm().getBody().layout();
        this.mform.reflow(true);
    }

    public void dispose() {
        if (lastActiveInstance == this) {
            lastActiveInstance = null;
        }
        int i = 0;
        while (i < this.pages.size()) {
            HelpPartPage page = (HelpPartPage)this.pages.get(i);
            page.dispose();
            ++i;
        }
        this.pages = null;
        if (this.mform != null) {
            this.mform.dispose();
            this.mform = null;
        }
        PlatformUI.getWorkbench().getActivitySupport().getActivityManager().removeActivityManagerListener((IActivityManagerListener)this);
    }

    public void setFocus() {
        if (this.currentPage != null) {
            this.currentPage.setFocus();
        } else {
            this.mform.setFocus();
        }
    }

    public void update(IWorkbenchPart part, Control control) {
        this.update(null, null, part, control, false);
    }

    public void update(IContextProvider provider, IContext context, IWorkbenchPart part, Control control, boolean isExplicitRequest) {
        this.mform.setInput((Object)new ContextHelpProviderInput(provider, context, control, part, isExplicitRequest));
    }

    private IHelpPart createPart(String id, IToolBarManager tbm, IMenuManager menuManager) {
        IHelpPart part = null;
        Composite parent = this.mform.getForm().getBody();
        part = this.findPart(id);
        if (part != null) {
            return part;
        }
        if (id.equals("topic-tree")) {
            part = new AllTopicsPart(parent, this.mform.getToolkit(), tbm);
        } else if (id.equals("context-help")) {
            part = new ContextHelpPart(parent, this.mform.getToolkit());
            ((ContextHelpPart)part).setDefaultText(this.getDefaultContextHelpText());
        } else if (id.equals("related-topics")) {
            part = new RelatedTopicsPart(parent, this.mform.getToolkit());
            ((RelatedTopicsPart)part).setDefaultText(this.getDefaultContextHelpText());
        } else if (id.equals("browser")) {
            part = new BrowserPart(parent, this.mform.getToolkit(), tbm, menuManager);
        } else if (id.equals("search-result")) {
            part = new DynamicHelpPart(parent, this.mform.getToolkit());
        } else if (id.equals("fsearch-result")) {
            part = new SearchResultsPart(parent, this.mform.getToolkit(), tbm);
        } else if (id.equals("scope-select")) {
            part = new ScopeSelectPart(parent, this.mform.getToolkit());
        } else if (id.equals("see-also")) {
            part = new SeeAlsoPart(parent, this.mform.getToolkit());
        } else if (id.equals("fsearch")) {
            part = new SearchPart(parent, this.mform.getToolkit());
        } else if (id.equals("bookmarks-tree")) {
            part = new BookmarksPart(parent, this.mform.getToolkit(), tbm);
        } else if (id.equals("index")) {
            part = new IndexPart(parent, this.mform.getToolkit(), tbm);
        } else if (id.equals("index-typein")) {
            part = new IndexTypeinPart(parent, this.mform.getToolkit(), tbm);
        }
        if (part != null) {
            this.mform.addPart((IFormPart)part);
            part.init(this, id, this.memento);
        }
        return part;
    }

    public IRunnableContext getRunnableContext() {
        return this.runnableContext;
    }

    public boolean isInWorkbenchWindow() {
        return this.runnableContext instanceof IWorkbenchWindow;
    }

    public String getDefaultContextHelpText() {
        return this.defaultContextHelpText;
    }

    public void setDefaultContextHelpText(String defaultContextHelpText) {
        this.defaultContextHelpText = defaultContextHelpText;
    }

    public void showURL(final String url) {
        BusyIndicator.showWhile((Display)this.getControl().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                ReusableHelpPart.this.showURL(url, ReusableHelpPart.this.getShowDocumentsInPlace());
            }
        });
    }

    public void showURL(String url, boolean replace) {
        if (url == null) {
            return;
        }
        if (url.startsWith("nw:")) {
            replace = false;
            url = url.substring(3);
        } else if (url.startsWith("open:")) {
            int col = url.indexOf(58);
            int qloc = url.indexOf(63);
            String engineId = url.substring(col + 1, qloc);
            EngineDescriptor desc = this.getEngineManager().findEngine(engineId);
            if (desc == null) {
                return;
            }
            HashMap args = new HashMap();
            HelpURLConnection.parseQuery((String)url.substring(qloc + 1), args);
            ((ISearchEngine2)desc.getEngine()).open((String)args.get("id"));
            return;
        }
        if (replace && this.openInternalBrowser(url)) {
            return;
        }
        this.showExternalURL(url);
    }

    private boolean openInternalBrowser(String url) {
        boolean isDialog;
        String openMode = Platform.getPreferencesService().getString("org.eclipse.help.base", "help_view_open_mode", "in_place", null);
        boolean openInEditor = "in editor".equals(openMode);
        boolean openInBrowser = "in browser".equals(openMode);
        Shell windowShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        Shell helpShell = this.mform.getForm().getShell();
        boolean bl = isDialog = helpShell != windowShell;
        if (!isDialog && openInEditor) {
            return DefaultHelpUI.showInWorkbenchBrowser(url, true);
        }
        if (openInBrowser) {
            BaseHelpSystem.getHelpDisplay().displayHelpResource(url, false);
            return true;
        }
        this.showPage("browser-page");
        BrowserPart bpart = (BrowserPart)this.findPart("browser");
        if (bpart != null) {
            bpart.showURL(BaseHelpSystem.resolve((String)url, (String)"/help/ntopic").toString());
            return true;
        }
        return false;
    }

    public void showExternalURL(String url) {
        if (this.isHelpResource(url)) {
            PlatformUI.getWorkbench().getHelpSystem().displayHelpResource(url);
        } else {
            try {
                String aurl = BaseHelpSystem.resolve((String)url, (boolean)true).toString();
                PlatformUI.getWorkbench().getHelpSystem().displayHelpResource(aurl);
            }
            catch (Exception e) {
                HelpUIPlugin.logError("Error opening browser", e);
            }
        }
    }

    public IHelpPart findPart(String id) {
        if (this.mform == null) {
            return null;
        }
        IFormPart[] parts = this.mform.getParts();
        int i = 0;
        while (i < parts.length) {
            IHelpPart part = (IHelpPart)parts[i];
            if (part.getId().equals(id)) {
                return part;
            }
            ++i;
        }
        return null;
    }

    public boolean isHelpResource(String url) {
        return url == null || url.indexOf("://") == -1;
    }

    private void contextMenuAboutToShow(IMenuManager manager) {
        IFormPart[] parts = this.mform.getParts();
        boolean hasContext = false;
        Control focusControl = this.getControl().getDisplay().getFocusControl();
        int i = 0;
        while (i < parts.length) {
            IHelpPart part = (IHelpPart)parts[i];
            if (part.hasFocusControl(focusControl)) {
                hasContext = part.fillContextMenu(manager);
                break;
            }
            ++i;
        }
        if (hasContext) {
            manager.add((IContributionItem)new Separator());
        }
        manager.add((IAction)this.backAction);
        manager.add((IAction)this.nextAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.openInfoCenterAction);
    }

    private void contributeToDropDownMenu(IMenuManager manager) {
        this.addPageAction(manager, "context-help-page");
        this.addPageAction(manager, "all-topics-page");
        this.addPageAction(manager, "index-page");
        this.addPageAction(manager, "fsearch-page");
        this.addPageAction(manager, "bookmarks-page");
    }

    private void addPageAction(IMenuManager manager, final String pageId) {
        HelpPartPage page = this.findPage(pageId);
        if (page == null) {
            return;
        }
        Action action = new Action(pageId, 2){

            public void run() {
                BusyIndicator.showWhile((Display)ReusableHelpPart.this.mform.getForm().getDisplay(), (Runnable)new Runnable(this, pageId){
                    final /* synthetic */ 13 this$1;
                    private final /* synthetic */ String val$pageId;
                    {
                        this.this$1 = var1_1;
                        this.val$pageId = string;
                    }

                    public void run() {
                        13.access$0(this.this$1).showPage(this.val$pageId);
                    }
                });
            }

            static /* synthetic */ ReusableHelpPart access$0(13 var0) {
                return var0.ReusableHelpPart.this;
            }
        };
        action.setText(page.getText());
        String iconId = page.getIconId();
        if (iconId != null) {
            action.setImageDescriptor(HelpUIResources.getImageDescriptor(iconId));
        }
        manager.add((IAction)action);
        page.pageAction = action;
    }

    private HelpPartPage findPage(String id) {
        int i = 0;
        while (i < this.pages.size()) {
            HelpPartPage page = (HelpPartPage)this.pages.get(i);
            if (page.getId().equals(id)) {
                return page;
            }
            ++i;
        }
        return null;
    }

    boolean fillSelectionProviderMenu(ISelectionProvider provider, IMenuManager manager, boolean addBookmarks) {
        boolean value = this.fillOpenActions(provider, manager);
        if (value && addBookmarks) {
            manager.add((IContributionItem)new Separator());
            this.bookmarkAction.setTarget(provider);
            manager.add((IAction)this.bookmarkAction);
        }
        return true;
    }

    private boolean fillOpenActions(Object target, IMenuManager manager) {
        String href = this.getHref(target);
        if (href != null && !href.startsWith("__")) {
            this.openAction.setTarget(target);
            manager.add((IAction)this.openAction);
            if (!href.startsWith("nw:") && !href.startsWith("open:")) {
                this.openInHelpAction.setTarget(target);
                manager.add((IAction)this.openInHelpAction);
            }
            return true;
        }
        return false;
    }

    void hookFormText(FormText text) {
        this.copyAction.hook(text);
    }

    void unhookFormText(FormText text) {
        this.copyAction.unhook(text);
    }

    boolean fillFormContextMenu(FormText text, IMenuManager manager) {
        if (this.fillOpenActions(text, manager)) {
            manager.add((IContributionItem)new Separator());
        }
        manager.add((IAction)this.copyAction);
        this.copyAction.setTarget(text);
        if (text.getSelectedLinkHref() != null) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.bookmarkAction);
            this.bookmarkAction.setTarget(this.getResource(text));
        }
        return true;
    }

    IAction getCopyAction() {
        return this.copyAction;
    }

    private String getHref(Object target) {
        FormText text;
        Object href;
        if (target instanceof ISelectionProvider) {
            ISelectionProvider provider = (ISelectionProvider)target;
            IStructuredSelection ssel = (IStructuredSelection)provider.getSelection();
            Object obj = ssel.getFirstElement();
            if (obj instanceof IToc) {
                return null;
            }
            if (obj instanceof IHelpResource) {
                IHelpResource res = (IHelpResource)obj;
                return res.getHref();
            }
            if (obj instanceof IIndexEntry) {
                ITopic[] topics = ((IIndexEntry)obj).getTopics();
                if (topics.length == 1) {
                    return topics[0].getHref();
                }
                return null;
            }
        } else if (target instanceof FormText && (href = (text = (FormText)target).getSelectedLinkHref()) != null) {
            return href.toString();
        }
        return null;
    }

    private IHelpResource getResource(Object target) {
        if (target instanceof ISelectionProvider) {
            ISelectionProvider provider = (ISelectionProvider)target;
            IStructuredSelection ssel = (IStructuredSelection)provider.getSelection();
            Object obj = ssel.getFirstElement();
            if (obj instanceof ITopic) {
                return (ITopic)obj;
            }
            if (obj instanceof IIndexEntry) {
                IIndexEntry entry = (IIndexEntry)obj;
                ITopic[] topics = entry.getTopics();
                if (topics.length == 1) {
                    final String href = topics[0].getHref();
                    final String label = entry.getKeyword();
                    return new IHelpResource(){

                        public String getHref() {
                            return href;
                        }

                        public String getLabel() {
                            return label;
                        }
                    };
                }
                return null;
            }
            if (obj instanceof IHelpResource) {
                return (IHelpResource)obj;
            }
        } else if (target instanceof FormText) {
            FormText text = (FormText)target;
            String rawHref = text.getSelectedLinkHref().toString();
            final String href = rawHref.startsWith("open") ? rawHref : LinkUtil.stripParams((String)text.getSelectedLinkHref().toString());
            final String label = text.getSelectedLinkText();
            if (href != null) {
                return new IHelpResource(){

                    public String getHref() {
                        return href;
                    }

                    public String getLabel() {
                        return label;
                    }
                };
            }
        }
        return null;
    }

    private void doBookmark(Object target) {
        IHelpResource res = null;
        res = target instanceof IHelpResource ? (IHelpResource)target : this.getResource(target);
        if (res != null) {
            BaseHelpSystem.getBookmarkManager().addBookmark(res.getHref(), res.getLabel());
        }
    }

    private void doOpen(Object target, boolean replace) {
        String href = this.getHref(target);
        if (href != null) {
            this.showURL(href, replace);
        }
    }

    private void doOpenInHelp(Object target) {
        String href = this.getHref(target);
        if (href != null) {
            this.showURL(href, false);
        }
    }

    public IStatusLineManager getStatusLineManager() {
        return this.statusLineManager;
    }

    public boolean getShowDocumentsInPlace() {
        return this.showDocumentsInPlace;
    }

    public void setShowDocumentsInPlace(boolean showDocumentsInPlace) {
        this.showDocumentsInPlace = showDocumentsInPlace;
    }

    public int getStyle() {
        return this.style;
    }

    public int getNumberOfInPlaceHits() {
        return this.numberOfInPlaceHits;
    }

    public void setNumberOfInPlaceHits(int numberOfInPlaceHits) {
        this.numberOfInPlaceHits = numberOfInPlaceHits;
    }

    void handleLinkEntered(HyperlinkEvent e) {
        IStatusLineManager mng = this.getRoot(this.getStatusLineManager());
        if (mng != null) {
            String label = e.getLabel();
            String href = (String)e.getHref();
            if (href != null && href.startsWith("__")) {
                href = null;
            }
            if (href != null) {
                try {
                    href = URLDecoder.decode(href, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            }
            if (label != null && href != null) {
                String message = NLS.bind((String)Messages.ReusableHelpPart_status, (Object)label, (Object)href);
                mng.setMessage(message);
            } else if (label != null) {
                mng.setMessage(label);
            } else {
                mng.setMessage(href);
            }
        }
    }

    private IStatusLineManager getRoot(IStatusLineManager mng) {
        while (mng != null) {
            if (!(mng instanceof SubStatusLineManager)) break;
            SubStatusLineManager smng = (SubStatusLineManager)mng;
            IContributionManager parent = smng.getParent();
            if (parent == null) {
                return smng;
            }
            if (!(parent instanceof IStatusLineManager)) {
                return smng;
            }
            mng = (IStatusLineManager)parent;
        }
        return mng;
    }

    void handleLinkExited(HyperlinkEvent e) {
        IStatusLineManager mng = this.getRoot(this.getStatusLineManager());
        if (mng != null) {
            mng.setMessage(null);
        }
    }

    private void toggleShowAll(boolean checked) {
        MessageDialogWithToggle dialog;
        IPreferenceStore store;
        String value;
        if (checked && (value = (store = HelpUIPlugin.getDefault().getPreferenceStore()).getString(PROMPT_KEY)).length() == 0 && (dialog = MessageDialogWithToggle.openOkCancelConfirm(null, (String)Messages.AskShowAll_dialogTitle, (String)this.getShowAllMessage(), (String)Messages.AskShowAll_toggleMessage, (boolean)false, (IPreferenceStore)store, (String)PROMPT_KEY)).getReturnCode() != 0) {
            this.showAllAction.setChecked(false);
            return;
        }
        HelpBasePlugin.getActivitySupport().setFilteringEnabled(!checked);
        int i = 0;
        while (i < this.pages.size()) {
            HelpPartPage page = (HelpPartPage)this.pages.get(i);
            page.toggleRoleFilter();
            ++i;
        }
    }

    public void saveState(IMemento memento) {
        int i = 0;
        while (i < this.pages.size()) {
            HelpPartPage page = (HelpPartPage)this.pages.get(i);
            page.saveState(memento);
            ++i;
        }
    }

    private String getShowAllMessage() {
        String message = HelpBasePlugin.getActivitySupport().getShowAllMessage();
        if (message == null) {
            return Messages.AskShowAll_message;
        }
        StringBuffer buff = new StringBuffer();
        int state = 1;
        int i = 0;
        while (i < message.length()) {
            char c = message.charAt(i);
            switch (state) {
                case 1: {
                    if (c == '<') {
                        state = 2;
                        break;
                    }
                    buff.append(c);
                    break;
                }
                case 2: {
                    if (c != 'b' && c != 'B') break;
                    state = 3;
                    break;
                }
                case 3: {
                    if (c != 'r' && c != 'R') break;
                    state = 4;
                    break;
                }
                case 4: {
                    if (c == '>') {
                        buff.append('\n');
                    }
                    state = 1;
                    break;
                }
                default: {
                    buff.append(c);
                }
            }
            ++i;
        }
        return buff.toString();
    }

    EngineDescriptorManager getEngineManager() {
        if (this.engineManager == null) {
            this.engineManager = new EngineDescriptorManager();
        }
        return this.engineManager;
    }

    public static int getDefaultStyle() {
        int style = 14;
        if (ProductPreferences.getBoolean((Plugin)HelpBasePlugin.getDefault(), (String)"indexView")) {
            style |= 0x20;
        }
        if (ProductPreferences.getBoolean((Plugin)HelpBasePlugin.getDefault(), (String)"bookmarksView")) {
            style |= 0x10;
        }
        return style;
    }

    static /* synthetic */ Action access$12(ReusableHelpPart reusableHelpPart) {
        return reusableHelpPart.showAllAction;
    }

    static /* synthetic */ void access$13(ReusableHelpPart reusableHelpPart, boolean bl) {
        reusableHelpPart.toggleShowAll(bl);
    }

    private abstract class BusyRunAction
    extends Action {
        public BusyRunAction(String name) {
            super(name);
        }

        public void run() {
            BusyIndicator.showWhile((Display)ReusableHelpPart.this.getControl().getDisplay(), (Runnable)new Runnable(this){
                final /* synthetic */ BusyRunAction this$1;
                {
                    this.this$1 = busyRunAction;
                }

                public void run() {
                    this.this$1.busyRun();
                }
            });
        }

        protected abstract void busyRun();
    }

    private class CopyAction
    extends Action
    implements FocusListener,
    SelectionListener {
        private FormText target;

        public CopyAction() {
            super("copy");
        }

        public void hook(FormText text) {
            text.addFocusListener((FocusListener)this);
        }

        public void unhook(FormText text) {
            text.removeFocusListener((FocusListener)this);
            if (this.target == text) {
                this.setTarget(null);
            }
        }

        public void focusGained(FocusEvent e) {
            FormText text = (FormText)e.widget;
            text.addSelectionListener((SelectionListener)this);
            this.setTarget(text);
        }

        public void focusLost(FocusEvent e) {
            FormText text = (FormText)e.widget;
            text.removeSelectionListener((SelectionListener)this);
            this.setTarget(null);
        }

        public void setTarget(FormText target) {
            this.target = target;
            this.updateState();
        }

        private void updateState() {
            this.setEnabled(this.target != null && this.target.canCopy());
        }

        public void run() {
            if (this.target != null) {
                this.target.copy();
            }
        }

        public void widgetSelected(SelectionEvent e) {
            FormText text = (FormText)e.widget;
            if (text == this.target) {
                this.updateState();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    class HelpPartLayout
    extends Layout
    implements ILayoutExtension {
        HelpPartLayout() {
        }

        public int computeMaximumWidth(Composite parent, boolean changed) {
            return this.computeSize((Composite)parent, (int)-1, (int)-1, (boolean)changed).x;
        }

        public int computeMinimumWidth(Composite parent, boolean changed) {
            return this.computeSize((Composite)parent, (int)0, (int)-1, (boolean)changed).x;
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            if (ReusableHelpPart.this.currentPage == null) {
                return new Point(0, 0);
            }
            PartRec[] parts = ReusableHelpPart.this.currentPage.getParts();
            int hmargin = ReusableHelpPart.this.currentPage.getHorizontalMargin();
            int innerWhint = wHint != -1 ? wHint - 2 * hmargin : wHint;
            Point result = new Point(0, 0);
            int i = 0;
            while (i < parts.length) {
                PartRec partRec = parts[i];
                if (!partRec.flexible) {
                    Control c = partRec.part.getControl();
                    Point size = c.computeSize(innerWhint, -1, flushCache);
                    result.x = Math.max(result.x, size.x);
                    result.y += size.y;
                }
                if (i < parts.length - 1) {
                    result.y += ReusableHelpPart.this.currentPage.getVerticalSpacing();
                }
                ++i;
            }
            result.x += hmargin * 2;
            result.y += ReusableHelpPart.this.bmargin;
            return result;
        }

        protected void layout(Composite composite, boolean flushCache) {
            if (ReusableHelpPart.this.currentPage == null) {
                return;
            }
            Rectangle clientArea = composite.getClientArea();
            PartRec[] parts = ReusableHelpPart.this.currentPage.getParts();
            int hmargin = ReusableHelpPart.this.currentPage.getHorizontalMargin();
            int nfixedParts = parts.length - ReusableHelpPart.this.currentPage.getNumberOfFlexibleParts();
            Point[] fixedSizes = new Point[nfixedParts];
            int fixedHeight = 0;
            int index = 0;
            int innerWidth = clientArea.width - hmargin * 2;
            int i = 0;
            while (i < parts.length) {
                PartRec partRec = parts[i];
                if (!partRec.flexible) {
                    Control c = partRec.part.getControl();
                    Point size = c.computeSize(innerWidth, -1, false);
                    fixedSizes[index++] = size;
                    if (!partRec.grabVertical) {
                        fixedHeight += size.y;
                    }
                }
                if (i < parts.length - 1) {
                    fixedHeight += ReusableHelpPart.this.currentPage.getVerticalSpacing();
                }
                ++i;
            }
            int flexHeight = clientArea.height - (fixedHeight += ReusableHelpPart.this.bmargin);
            int flexPortion = 0;
            if (ReusableHelpPart.this.currentPage.getNumberOfFlexibleParts() > 0) {
                flexPortion = flexHeight / ReusableHelpPart.this.currentPage.getNumberOfFlexibleParts();
            }
            int usedFlexHeight = 0;
            int y = 0;
            index = 0;
            int nflexParts = 0;
            int i2 = 0;
            while (i2 < parts.length) {
                PartRec partRec = parts[i2];
                Control c = partRec.part.getControl();
                if (partRec.flexible) {
                    int height;
                    if (++nflexParts == ReusableHelpPart.this.currentPage.getNumberOfFlexibleParts()) {
                        height = flexHeight - usedFlexHeight;
                    } else {
                        height = flexPortion;
                        usedFlexHeight += height;
                    }
                    c.setBounds(0, y, clientArea.width, height);
                } else {
                    Point fixedSize = fixedSizes[index++];
                    if (fixedSize.y < flexHeight && partRec.grabVertical) {
                        c.setBounds(hmargin, y, innerWidth, flexHeight);
                    } else {
                        c.setBounds(hmargin, y, innerWidth, fixedSize.y);
                    }
                }
                if (i2 < parts.length - 1) {
                    y += c.getSize().y + ReusableHelpPart.this.currentPage.getVerticalSpacing();
                }
                ++i2;
            }
        }
    }

    private class HelpPartPage
    implements IHelpPartPage {
        private String id;
        private String iconId;
        Action pageAction;
        private int vspacing;
        private int horizontalMargin;
        private String text;
        private SubActionBars bars;
        private IToolBarManager subToolBarManager;
        private IMenuManager subMenuManager;
        protected ArrayList partRecs;
        private int nflexible;

        public HelpPartPage(String id, String text) {
            this.vspacing = ReusableHelpPart.this.verticalSpacing;
            this.horizontalMargin = 0;
            this.id = id;
            this.text = text;
            this.partRecs = new ArrayList();
            if (ReusableHelpPart.this.actionBars != null) {
                this.bars = new SubActionBars(ReusableHelpPart.this.actionBars);
                this.subToolBarManager = this.bars.getToolBarManager();
                this.subMenuManager = this.bars.getMenuManager();
            } else {
                this.subToolBarManager = new SubToolBarManager(ReusableHelpPart.this.toolBarManager);
                this.subMenuManager = ReusableHelpPart.this.menuManager != null ? new SubMenuManager(ReusableHelpPart.this.menuManager) : null;
            }
        }

        public HelpPartPage(String id, String text, String iconId) {
            this(id, text);
            this.iconId = iconId;
        }

        public void dispose() {
            if (this.bars != null) {
                this.bars.dispose();
                this.bars = null;
                this.subToolBarManager = null;
                this.subMenuManager = null;
            } else {
                try {
                    ((SubToolBarManager)this.subToolBarManager).disposeManager();
                    if (this.subMenuManager != null) {
                        ((SubMenuManager)this.subMenuManager).disposeManager();
                    }
                }
                catch (RuntimeException runtimeException) {}
            }
            this.partRecs = null;
        }

        public void setVerticalSpacing(int value) {
            this.vspacing = value;
        }

        public int getVerticalSpacing() {
            return this.vspacing;
        }

        public void setHorizontalMargin(int value) {
            this.horizontalMargin = value;
        }

        public int getHorizontalMargin() {
            return this.horizontalMargin;
        }

        public IToolBarManager getToolBarManager() {
            return this.subToolBarManager;
        }

        public String getId() {
            return this.id;
        }

        public String getText() {
            return this.text;
        }

        public String getIconId() {
            return this.iconId;
        }

        public void addPart(String id, boolean flexible) {
            this.addPart(id, flexible, false);
        }

        public void addPart(String id, boolean flexible, boolean grabVertical) {
            this.partRecs.add(new PartRec(id, flexible, grabVertical));
            if (flexible) {
                ++this.nflexible;
            }
        }

        public PartRec[] getParts() {
            return this.partRecs.toArray(new PartRec[this.partRecs.size()]);
        }

        public void refreshPage() {
            PartRec[] parts = this.getParts();
            if (parts == null) {
                return;
            }
            int p = 0;
            while (p < parts.length) {
                if (parts[p] != null && parts[p].part != null && parts[p].part.isStale()) {
                    parts[p].part.refresh();
                }
                ++p;
            }
        }

        public int getNumberOfFlexibleParts() {
            return this.nflexible;
        }

        public boolean canOpen() {
            int i = 0;
            while (i < this.partRecs.size()) {
                PartRec rec = (PartRec)this.partRecs.get(i);
                if (rec.id.equals("browser")) {
                    try {
                        this.createRecPart(rec);
                        rec.part.setVisible(false);
                    }
                    catch (SWTError sWTError) {
                        return false;
                    }
                }
                ++i;
            }
            return true;
        }

        public void stop() {
            int i = 0;
            while (i < this.partRecs.size()) {
                PartRec rec = (PartRec)this.partRecs.get(i);
                if (rec.part != null) {
                    rec.part.stop();
                }
                ++i;
            }
        }

        public void saveState(IMemento memento) {
            int i = 0;
            while (i < this.partRecs.size()) {
                PartRec rec = (PartRec)this.partRecs.get(i);
                if (rec.part != null) {
                    rec.part.saveState(memento);
                }
                ++i;
            }
        }

        public void toggleRoleFilter() {
            int i = 0;
            while (i < this.partRecs.size()) {
                PartRec rec = (PartRec)this.partRecs.get(i);
                if (rec.part != null) {
                    rec.part.toggleRoleFilter();
                }
                ++i;
            }
        }

        public void refilter() {
            int i = 0;
            while (i < this.partRecs.size()) {
                PartRec rec = (PartRec)this.partRecs.get(i);
                if (rec.part != null) {
                    rec.part.refilter();
                }
                ++i;
            }
        }

        public void setVisible(boolean visible) {
            if (this.bars != null) {
                this.bars.clearGlobalActionHandlers();
            }
            ArrayList<Control> tabList = new ArrayList<Control>();
            int i = 0;
            while (i < this.partRecs.size()) {
                PartRec rec = (PartRec)this.partRecs.get(i);
                if (visible) {
                    this.createRecPart(rec);
                    this.hookGlobalAction(ActionFactory.PRINT.getId(), rec.part);
                    this.hookGlobalAction(ActionFactory.COPY.getId(), rec.part);
                    this.hookGlobalAction(ActionFactory.DELETE.getId(), rec.part);
                    tabList.add(rec.part.getControl());
                }
                rec.part.setVisible(visible);
                ++i;
            }
            Composite parent = ReusableHelpPart.this.mform.getForm().getBody();
            parent.setTabList(tabList.toArray(new Control[tabList.size()]));
            if (ReusableHelpPart.this.actionBars != null) {
                Map handlers;
                ReusableHelpPart.this.actionBars.clearGlobalActionHandlers();
                if (visible && (handlers = this.bars.getGlobalActionHandlers()) != null) {
                    Set keys = handlers.keySet();
                    Iterator iter = keys.iterator();
                    while (iter.hasNext()) {
                        String key = (String)iter.next();
                        ReusableHelpPart.this.actionBars.setGlobalActionHandler(key, (IAction)handlers.get(key));
                    }
                }
                if (this.pageAction != null) {
                    this.pageAction.setChecked(visible);
                }
            }
            if (this.bars != null) {
                if (visible) {
                    this.bars.activate();
                } else {
                    this.bars.deactivate();
                }
                this.bars.updateActionBars();
            } else {
                ((SubToolBarManager)this.subToolBarManager).setVisible(visible);
                if (this.subMenuManager != null) {
                    ((SubMenuManager)this.subMenuManager).setVisible(visible);
                }
                ReusableHelpPart.this.toolBarManager.update(true);
                ReusableHelpPart.this.getControl().getParent().layout();
            }
        }

        private void hookGlobalAction(String id, IHelpPart part) {
            if (this.bars == null) {
                return;
            }
            IAction action = part.getGlobalAction(id);
            if (action != null) {
                this.bars.setGlobalActionHandler(id, action);
            }
        }

        private void createRecPart(PartRec rec) throws SWTError {
            if (rec.part == null) {
                rec.part = ReusableHelpPart.this.createPart(rec.id, this.subToolBarManager, this.subMenuManager);
            }
        }

        public IHelpPart findPart(String id) {
            int i = 0;
            while (i < this.partRecs.size()) {
                PartRec rec = (PartRec)this.partRecs.get(i);
                if (rec.id.equals(id)) {
                    return rec.part;
                }
                ++i;
            }
            return null;
        }

        public void setFocus() {
            if (this.partRecs.size() == 0) {
                return;
            }
            PartRec rec = (PartRec)this.partRecs.get(0);
            rec.part.setFocus();
        }
    }

    private abstract class OpenHrefAction
    extends BusyRunAction {
        private Object target;

        public OpenHrefAction(String name) {
            super(name);
        }

        public void setTarget(Object target) {
            this.target = target;
        }

        public Object getTarget() {
            return this.target;
        }
    }

    private static class PartRec {
        String id;
        boolean flexible;
        boolean grabVertical;
        IHelpPart part;

        PartRec(String id, boolean flexible, boolean grabVertical) {
            this.id = id;
            this.flexible = flexible;
            this.grabVertical = grabVertical;
        }
    }

    class RoleFilter
    extends ViewerFilter {
        RoleFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            IHelpResource res = (IHelpResource)element;
            String href = res.getHref();
            if (href == null) {
                return true;
            }
            return HelpBasePlugin.getActivitySupport().isEnabled(href);
        }
    }

    class UAFilter
    extends ViewerFilter {
        UAFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return !UAContentFilter.isFiltered((Object)element, (IEvaluationContext)HelpEvaluationContext.getContext());
        }
    }
}

