/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.indexing;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.sse.core.internal.Logger;
import org.eclipse.wst.sse.core.internal.SSECoreMessages;

public abstract class AbstractIndexManager {
    private static final String ENCODING_UTF16 = "utf16";
    private static final int WAIT_TIME = 300;
    private static final int UNKNOWN_WORK = 100;
    private static final int BATCH_UP_AMOUNT = 100;
    private static final String RE_PROCESS_FILE_NAME = ".re-process";
    private static final String LOG_ERROR_INDEX_INVALID = "Index may become invalid, incomplete, or enter some other inconsistent state.";
    private static final byte STATE_DISABLED = 0;
    private static final byte STATE_ENABLED = 1;
    protected static final byte ACTION_ADD = 0;
    protected static final byte ACTION_REMOVE = 1;
    protected static final byte ACTION_ADD_MOVE_FROM = 2;
    protected static final byte ACTION_REMOVE_MOVE_TO = 3;
    protected static final byte SOURCE_RESOURCE_CHANGE = 0;
    protected static final byte SOURCE_WORKSPACE_SCAN = 1;
    protected static final byte SOURCE_SAVED_STATE = 2;
    protected static final byte SOURCE_PRESERVED_RESOURCES_TO_INDEX = 3;
    private String fName;
    private ResourceChangeListener fResourceChangeListener;
    private ResourceEventProcessingJob fResourceEventProcessingJob;
    private Job fWorkspaceVisitorJob;
    private volatile byte fState;
    private Object fStartStopLock = new Object();
    private boolean fStarting;

    protected AbstractIndexManager(String name) {
        this.fName = name;
        this.fState = 0;
        this.fResourceChangeListener = new ResourceChangeListener();
        this.fResourceEventProcessingJob = new ResourceEventProcessingJob();
        this.fStarting = false;
    }

    protected AbstractIndexManager(String name, String messageRunning, String messagegInitializing, String messageProcessingFiles) {
        this(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start(IResourceDelta savedStateDelta, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        Object object = this.fStartStopLock;
        synchronized (object) {
            this.fStarting = true;
            if (this.fState == 0) {
                progress.beginTask(NLS.bind((String)SSECoreMessages.IndexManager_0_starting, (Object)this.fName), 2);
                this.fResourceChangeListener.start();
                boolean forcedFullReIndexNeeded = this.isForcedFullReIndexNeeded();
                forcedFullReIndexNeeded = !this.fResourceEventProcessingJob.start(!forcedFullReIndexNeeded, progress.newChild(1));
                progress.setWorkRemaining(1);
                if (!forcedFullReIndexNeeded) {
                    if (savedStateDelta != null) {
                        forcedFullReIndexNeeded = false;
                        try {
                            SubMonitor savedStateProgress = progress.newChild(1, 0);
                            savedStateProgress.setTaskName(NLS.bind((String)SSECoreMessages.IndexManager_0_starting_1, (Object[])new String[]{this.fName, SSECoreMessages.IndexManager_processing_deferred_resource_changes}));
                            ResourceDeltaVisitor visitor = new ResourceDeltaVisitor(savedStateProgress, 2);
                            savedStateDelta.accept((IResourceDeltaVisitor)visitor);
                            visitor.processBatchedResourceEvents();
                        }
                        catch (CoreException e) {
                            forcedFullReIndexNeeded = true;
                            Logger.logException(String.valueOf(this.fName) + ": Could not process saved state. " + "Forced to do a full workspace re-index.", e);
                        }
                    } else {
                        forcedFullReIndexNeeded = true;
                    }
                }
                progress.worked(1);
                if (forcedFullReIndexNeeded) {
                    this.fWorkspaceVisitorJob = new WorkspaceVisitorJob();
                    this.fWorkspaceVisitorJob.schedule();
                }
                this.fState = 1;
            }
            this.fStarting = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() throws InterruptedException {
        Object object = this.fStartStopLock;
        synchronized (object) {
            if (this.fState != 0) {
                this.fResourceChangeListener.stop();
                boolean forceFullReIndexNextStart = false;
                if (this.fWorkspaceVisitorJob != null && this.fWorkspaceVisitorJob.getState() != 0) {
                    this.fWorkspaceVisitorJob.cancel();
                    this.forceFullReIndexNextStart();
                    forceFullReIndexNextStart = true;
                }
                boolean bl = forceFullReIndexNextStart = !this.fResourceEventProcessingJob.stop(!forceFullReIndexNextStart);
                if (forceFullReIndexNextStart) {
                    this.forceFullReIndexNextStart();
                }
                this.fState = 0;
            }
        }
    }

    protected String getName() {
        return this.fName;
    }

    public final boolean waitForConsistent(IProgressMonitor monitor) {
        SubMonitor workspaceVisitorProgress;
        boolean success = true;
        boolean interupted = false;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        int remainingWork = 4;
        progress.beginTask(NLS.bind((String)SSECoreMessages.IndexManager_Waiting_for_0, (Object)this.fName), remainingWork);
        if (this.fStarting && !monitor.isCanceled()) {
            SubMonitor startingProgress = progress.newChild(1);
            startingProgress.subTask(NLS.bind((String)SSECoreMessages.IndexManager_0_starting, (Object)this.fName));
            while (this.fStarting && !monitor.isCanceled()) {
                startingProgress.setWorkRemaining(100);
                startingProgress.newChild(1).worked(1);
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException interruptedException) {
                    interupted = true;
                }
            }
        }
        progress.setWorkRemaining(--remainingWork);
        if (this.fWorkspaceVisitorJob != null && this.fWorkspaceVisitorJob.getState() != 0 && !monitor.isCanceled()) {
            workspaceVisitorProgress = progress.newChild(1);
            workspaceVisitorProgress.subTask(SSECoreMessages.IndexManager_Processing_entire_workspace_for_the_first_time);
            while (this.fWorkspaceVisitorJob.getState() != 0 && !monitor.isCanceled()) {
                workspaceVisitorProgress.setWorkRemaining(100);
                workspaceVisitorProgress.newChild(1).worked(1);
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException interruptedException) {
                    interupted = true;
                }
            }
        }
        progress.setWorkRemaining(--remainingWork);
        if (this.fResourceChangeListener.isProcessingEvents() && !monitor.isCanceled()) {
            workspaceVisitorProgress = progress.newChild(1);
            workspaceVisitorProgress.subTask(SSECoreMessages.IndexManager_processing_recent_resource_changes);
            while (this.fResourceChangeListener.isProcessingEvents() && !monitor.isCanceled()) {
                workspaceVisitorProgress.setWorkRemaining(100);
                workspaceVisitorProgress.newChild(1).worked(1);
                try {
                    this.fResourceChangeListener.waitForCurrentEvent(300);
                }
                catch (InterruptedException interruptedException) {
                    interupted = true;
                }
            }
        }
        progress.setWorkRemaining(--remainingWork);
        if (this.fResourceEventProcessingJob.getNumResourceEventsToProcess() != 0 && !monitor.isCanceled()) {
            SubMonitor indexingProgress = progress.newChild(1);
            int numResources = this.fResourceEventProcessingJob.getNumResourceEventsToProcess();
            while (numResources != 0 && !monitor.isCanceled()) {
                indexingProgress.subTask(NLS.bind((String)SSECoreMessages.IndexManager_0_Indexing_1_Files, (Object[])new Object[]{this.fName, "" + numResources}));
                indexingProgress.setWorkRemaining(numResources);
                int prevNumResrouces = numResources;
                numResources = this.fResourceEventProcessingJob.getNumResourceEventsToProcess();
                int numProcessed = prevNumResrouces - numResources;
                indexingProgress.worked(numProcessed > 0 ? numProcessed : 0);
                try {
                    this.fResourceEventProcessingJob.waitForConsistant(300);
                }
                catch (InterruptedException interruptedException) {
                    interupted = true;
                }
            }
        }
        progress.setWorkRemaining(--remainingWork);
        if (monitor.isCanceled()) {
            success = false;
        }
        if (interupted) {
            Thread.currentThread().interrupt();
        }
        return success;
    }

    protected abstract boolean isResourceToIndex(int var1, IPath var2);

    protected abstract void performAction(byte var1, byte var2, IResource var3, IPath var4);

    protected abstract IPath getWorkingLocation();

    private void forceFullReIndexNextStart() {
        IPath reIndexPath = this.getWorkingLocation().append(RE_PROCESS_FILE_NAME);
        File file = new File(reIndexPath.toOSString());
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            Logger.logException(String.valueOf(this.fName) + ": Could not create file to tell manager to" + " do a full re-index on next load. " + LOG_ERROR_INDEX_INVALID, e);
        }
    }

    private boolean isForcedFullReIndexNeeded() {
        boolean forcedFullReIndexNeeded = false;
        IPath reIndexPath = this.getWorkingLocation().append(RE_PROCESS_FILE_NAME);
        File file = new File(reIndexPath.toOSString());
        if (file.exists()) {
            file.delete();
            forcedFullReIndexNeeded = true;
        }
        return forcedFullReIndexNeeded;
    }

    private class ResourceChangeListener
    implements IResourceChangeListener {
        private volatile int fEventsBeingProcessed = 0;
        private final Object fEventsBeingProcessedLock = new Object();
        private volatile byte fState = 0;

        protected ResourceChangeListener() {
        }

        protected void start() {
            this.fState = 1;
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        }

        protected void stop() throws InterruptedException {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
            this.waitForCurrentEvent(0);
            this.fState = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void waitForCurrentEvent(int timeout) throws InterruptedException {
            Object object = this.fEventsBeingProcessedLock;
            synchronized (object) {
                if (this.fEventsBeingProcessed != 0) {
                    this.fEventsBeingProcessedLock.wait(timeout);
                }
            }
        }

        protected boolean isProcessingEvents() {
            return this.fEventsBeingProcessed != 0;
        }

        /*
         * Exception decompiling
         */
        public void resourceChanged(IResourceChangeEvent event) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [4 : 292->296)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private class ResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        private SubMonitor fProgress;
        private byte fSource;
        private int fPredictedWorkRemaining;
        private Map fBatchedResourceEvents;

        protected ResourceDeltaVisitor(byte source) {
            this(SubMonitor.convert(null), source);
        }

        protected ResourceDeltaVisitor(SubMonitor progress, byte source) {
            this.fProgress = progress;
            this.fSource = source;
            this.fBatchedResourceEvents = new LinkedHashMap(100);
            this.fPredictedWorkRemaining = 1;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            this.fProgress.subTask(NLS.bind((String)SSECoreMessages.IndexManager_0_resources_to_go_1, (Object[])new Object[]{"" + this.fPredictedWorkRemaining, delta.getFullPath().toString()}));
            boolean visitChildren = false;
            if (delta.getFullPath().toString().equals("/")) {
                visitChildren = true;
            } else {
                IResource resource = delta.getResource();
                if (AbstractIndexManager.this.isResourceToIndex(resource.getType(), resource.getFullPath())) {
                    if (resource.getType() == 1) {
                        switch (delta.getKind()) {
                            case 4: {
                                if ((delta.getFlags() & 0x100) == 0 && (delta.getFlags() & 0x40000) == 0 && (delta.getFlags() & 0x8000) == 0 && (delta.getFlags() & 0x1000) == 0) break;
                            }
                            case 1: {
                                if ((delta.getFlags() & 0x1000) != 0) {
                                    this.fBatchedResourceEvents.put(resource, new ResourceEvent(this.fSource, 2, delta.getMovedFromPath()));
                                    break;
                                }
                                this.fBatchedResourceEvents.put(resource, new ResourceEvent(this.fSource, 0, null));
                                break;
                            }
                            case 2: {
                                if ((delta.getFlags() & 0x2000) != 0) {
                                    this.fBatchedResourceEvents.put(resource, new ResourceEvent(this.fSource, 3, delta.getMovedToPath()));
                                    break;
                                }
                                this.fBatchedResourceEvents.put(resource, new ResourceEvent(this.fSource, 1, null));
                            }
                        }
                    }
                    visitChildren = true;
                } else {
                    visitChildren = false;
                }
                if (visitChildren) {
                    this.fPredictedWorkRemaining += delta.getAffectedChildren().length;
                }
                this.fProgress.setWorkRemaining(this.fPredictedWorkRemaining);
                this.fProgress.worked(1);
                --this.fPredictedWorkRemaining;
                if (this.fBatchedResourceEvents.size() >= 100) {
                    this.processBatchedResourceEvents();
                }
            }
            return visitChildren;
        }

        protected void processBatchedResourceEvents() {
            AbstractIndexManager.this.fResourceEventProcessingJob.addResourceEvents(this.fBatchedResourceEvents);
            this.fBatchedResourceEvents.clear();
        }
    }

    private static class ResourceEvent {
        protected byte fSource;
        protected byte fAction;
        protected IPath fMovePath;

        protected ResourceEvent(byte source, byte action, IPath movePath) {
            this.fSource = source;
            this.fAction = action;
            this.fMovePath = movePath;
        }
    }

    private class ResourceEventProcessingJob
    extends Job {
        private static final int DELAY = 500;
        private static final String PRESERVED_RESOURCE_EVENTS_TO_PROCESS_FILE_NAME = ".preservedResourceEvents";
        private static final long serialVersionUID = 1L;
        private volatile boolean fIsPaused;
        private Map fResourceEvents;
        private final Object fResourceEventsLock = new Object();
        private final Object fToNotifyLock = new Object();

        protected ResourceEventProcessingJob() {
            super(NLS.bind((String)SSECoreMessages.IndexManager_0_Processing_resource_events, (Object)AbstractIndexManager.this.fName));
            this.setUser(false);
            this.setSystem(true);
            this.setPriority(30);
            this.fIsPaused = false;
            this.fResourceEvents = new LinkedHashMap();
        }

        protected synchronized boolean start(boolean loadPreservedResourceEvents, SubMonitor progress) {
            boolean successLoadingPreserved = true;
            if (!loadPreservedResourceEvents) {
                File preservedResourceEventsFile = this.getPreservedResourceEventsFile();
                preservedResourceEventsFile.delete();
            } else {
                successLoadingPreserved = this.loadPreservedReceivedResourceEvents(progress);
            }
            this.schedule();
            return successLoadingPreserved;
        }

        protected synchronized boolean stop(boolean preserveResourceEvents) throws InterruptedException {
            this.cancel();
            this.join();
            boolean success = true;
            if (preserveResourceEvents && this.hasResourceEventsToProcess()) {
                success = this.preserveReceivedResourceEvents();
            } else {
                this.getPreservedResourceEventsFile().delete();
            }
            return success;
        }

        protected synchronized boolean isProcessing() {
            return this.getState() != 0 || this.fIsPaused;
        }

        protected synchronized void unPause() {
            this.fIsPaused = false;
            if (this.getState() == 1) {
                this.wakeUp(500L);
            } else {
                this.schedule(500L);
            }
        }

        protected synchronized void pause() {
            this.fIsPaused = true;
            this.sleep();
        }

        protected void addResourceEvents(Map resourceEvents) {
            Iterator iter = resourceEvents.keySet().iterator();
            while (iter.hasNext()) {
                IResource resource = (IResource)iter.next();
                ResourceEvent resourceEvent = (ResourceEvent)resourceEvents.get(resource);
                this.addResourceEvent(resource, resourceEvent);
            }
            if (!this.isProcessing()) {
                this.unPause();
            }
        }

        protected int getNumResourceEventsToProcess() {
            return this.fResourceEvents.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void waitForConsistant(int timeout) throws InterruptedException {
            if (this.hasResourceEventsToProcess() || this.isProcessing()) {
                Object object = this.fToNotifyLock;
                synchronized (object) {
                    this.fToNotifyLock.wait(timeout);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected IStatus run(IProgressMonitor monitor) {
            try {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
                while (true) {
                    block7: {
                        if (!this.fIsPaused && !monitor.isCanceled() && this.hasResourceEventsToProcess()) break block7;
                        monitor.done();
                        break;
                    }
                    progress.setTaskName(NLS.bind((String)SSECoreMessages.IndexManager_0_Indexing_1_Files, (Object[])new Object[]{AbstractIndexManager.this.fName, "" + this.getNumResourceEventsToProcess()}));
                    progress.setWorkRemaining(this.getNumResourceEventsToProcess());
                    ResourceEvent resourceEvent = null;
                    IResource resource = null;
                    Object object = this.fResourceEventsLock;
                    synchronized (object) {
                        resource = (IResource)this.fResourceEvents.keySet().iterator().next();
                        resourceEvent = (ResourceEvent)this.fResourceEvents.remove(resource);
                    }
                    monitor.subTask(resource.getName());
                    byte source = resourceEvent.fSource;
                    byte action = resourceEvent.fAction;
                    IResource finResource = resource;
                    IPath movePath = resourceEvent.fMovePath;
                    SafeRunner.run((ISafeRunnable)new ISafeRunnable(this, source, action, finResource, movePath){
                        final /* synthetic */ ResourceEventProcessingJob this$1;
                        private final /* synthetic */ byte val$source;
                        private final /* synthetic */ byte val$action;
                        private final /* synthetic */ IResource val$finResource;
                        private final /* synthetic */ IPath val$movePath;
                        {
                            this.this$1 = resourceEventProcessingJob;
                            this.val$source = by;
                            this.val$action = by2;
                            this.val$finResource = iResource;
                            this.val$movePath = iPath;
                        }

                        public void run() throws Exception {
                            ResourceEventProcessingJob.access$0(this.this$1).performAction(this.val$source, this.val$action, this.val$finResource, this.val$movePath);
                        }

                        public void handleException(Throwable e) {
                            Logger.logException("Error while performing an update to the index. Index may become invalid, incomplete, or enter some other inconsistent state.", e);
                        }
                    });
                    progress.worked(1);
                    Job.getJobManager().currentJob().yieldRule(monitor);
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                this.notifyIfConsistant();
                throw throwable;
            }
            {
                Object var9_12 = null;
                this.notifyIfConsistant();
            }
            if (!monitor.isCanceled()) return Status.OK_STATUS;
            return Status.CANCEL_STATUS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addResourceEvent(IResource resource, ResourceEvent resourceEvent) {
            Object object = this.fResourceEventsLock;
            synchronized (object) {
                if (!this.fResourceEvents.containsKey(resource)) {
                    this.fResourceEvents.put(resource, resourceEvent);
                } else if (resourceEvent.fSource == 0) {
                    ((ResourceEvent)this.fResourceEvents.get((Object)resource)).fAction = resourceEvent.fAction;
                }
            }
        }

        private boolean hasResourceEventsToProcess() {
            return !this.fResourceEvents.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean preserveReceivedResourceEvents() {
            preservedResourceEventsFile = this.getPreservedResourceEventsFile();
            success = true;
            var3_3 = this.fResourceEventsLock;
            synchronized (var3_3) {
                block16: {
                    dos = null;
                    try {
                        try {
                            if (preservedResourceEventsFile.exists()) {
                                preservedResourceEventsFile.delete();
                                preservedResourceEventsFile.createNewFile();
                            }
                            fos = new FileOutputStream(preservedResourceEventsFile);
                            bos = new BufferedOutputStream(fos);
                            dos = new DataOutputStream(bos);
                            dos.writeLong(1L);
                            dos.writeInt(this.getNumResourceEventsToProcess());
                            iter = this.fResourceEvents.keySet().iterator();
                            while (true) {
                                if (!iter.hasNext()) {
                                    this.fResourceEvents.clear();
                                    dos.flush();
                                }
                                resource = (IResource)iter.next();
                                resourceEvent = (ResourceEvent)this.fResourceEvents.get(resource);
                                if (resourceEvent.fSource == 1) continue;
                                dos.writeByte(resourceEvent.fAction);
                                dos.writeByte(resource.getType());
                                pathBytes = resource.getFullPath().toString().getBytes("utf16");
                                dos.write(pathBytes);
                                dos.writeByte(0);
                                if (resourceEvent.fMovePath != null) {
                                    dos.writeBytes(resourceEvent.fMovePath.toPortableString());
                                }
                                dos.writeByte(0);
                            }
                        }
                        catch (FileNotFoundException e) {
                            Logger.logException(String.valueOf(AbstractIndexManager.access$1(AbstractIndexManager.this)) + ": Exception while opening file to preserve resrouces to index.", e);
                            success = false;
                        }
                        catch (IOException e) {
                            Logger.logException(String.valueOf(AbstractIndexManager.access$1(AbstractIndexManager.this)) + ": Exception while writing to file to preserve resrouces to index.", e);
                            success = false;
                        }
                    }
                    catch (Throwable var12_13) {
                        var11_14 = null;
                        if (dos == null) throw var12_13;
                        try {
                            dos.close();
                            throw var12_13;
                        }
                        catch (IOException e) {
                            Logger.logException(String.valueOf(AbstractIndexManager.access$1(AbstractIndexManager.this)) + ": Exception while closing file with preserved resources to index.", e);
                            success = false;
                        }
                        throw var12_13;
                    }
                    {
                        var11_15 = null;
                        if (dos == null) break block16;
                    }
                    ** try [egrp 3[TRYBLOCK] [5 : 339->347)] { 
lbl59:
                    // 1 sources

                    dos.close();
                    break block16;
lbl61:
                    // 1 sources

                    catch (IOException e) {
                        Logger.logException(String.valueOf(AbstractIndexManager.access$1(AbstractIndexManager.this)) + ": Exception while closing file with preserved resources to index.", e);
                        success = false;
                    }
                }
                if (success != false) return success;
                preservedResourceEventsFile.delete();
                return success;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean loadPreservedReceivedResourceEvents(SubMonitor progress) {
            block22: {
                progress.subTask(SSECoreMessages.IndexManager_processing_deferred_resource_changes);
                success = true;
                preservedResourceEventsFile = this.getPreservedResourceEventsFile();
                if (preservedResourceEventsFile.exists() == false) return success;
                preservedResourceEvents = null;
                dis = null;
                try {
                    try {
                        fis = new FileInputStream(preservedResourceEventsFile);
                        bis = new BufferedInputStream(fis);
                        dis = new DataInputStream(bis);
                        preservedSerialVersionUID = dis.readLong();
                        if (preservedSerialVersionUID == 1L) {
                            numberOfRecords = dis.readInt();
                            preservedResourceEvents = new LinkedHashMap<IFile, ResourceEvent>(numberOfRecords);
                            progress.setWorkRemaining(numberOfRecords);
                            i = 0;
                            while (i < numberOfRecords) {
                                action = dis.readByte();
                                fileType = dis.readByte();
                                resourceLocoationBOS = new ByteArrayOutputStream();
                                b = dis.readByte();
                                while (true) {
                                    if (b == 0) break;
                                    resourceLocoationBOS.write(b);
                                    b = dis.readByte();
                                }
                                movePathBOS = new ByteArrayOutputStream();
                                b = dis.readByte();
                                while (true) {
                                    if (b == 0) {
                                        resource /* !! */  = null;
                                        resourcePath = new Path(new String(resourceLocoationBOS.toByteArray(), "utf16"));
                                        resource /* !! */  = fileType == 1 ? ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)resourcePath) : ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)resourcePath);
                                    }
                                    movePathBOS.write(b);
                                    b = dis.readByte();
                                }
                                movePath = null;
                                if (movePathBOS.size() != 0) {
                                    movePath = new Path(new String(movePathBOS.toByteArray(), "utf16"));
                                }
                                preservedResourceEvents.put(resource /* !! */ , new ResourceEvent(3, action, (IPath)movePath));
                                progress.worked(1);
                                ++i;
                            }
                        } else {
                            success = false;
                        }
                    }
                    catch (FileNotFoundException e) {
                        Logger.logException(String.valueOf(AbstractIndexManager.access$1(AbstractIndexManager.this)) + ": Exception while opening file to read preserved resources to index.", e);
                        success = false;
                    }
                    catch (IOException e) {
                        Logger.logException(String.valueOf(AbstractIndexManager.access$1(AbstractIndexManager.this)) + ": Exception while reading from file of preserved resources to index.", e);
                        success = false;
                    }
                }
                catch (Throwable var21_22) {
                    var20_23 = null;
                    if (dis == null) throw var21_22;
                    try {
                        dis.close();
                        throw var21_22;
                    }
                    catch (IOException e) {
                        Logger.logException(String.valueOf(AbstractIndexManager.access$1(AbstractIndexManager.this)) + ": Exception while closing file of preserved resources" + " to index that was just read.  This should have no" + " effect on the consistency of the index.", e);
                    }
                    throw var21_22;
                }
                {
                    var20_24 = null;
                    if (dis == null) break block22;
                }
                ** try [egrp 2[TRYBLOCK] [5 : 435->443)] { 
lbl71:
                // 1 sources

                dis.close();
                break block22;
lbl73:
                // 1 sources

                catch (IOException e) {
                    Logger.logException(String.valueOf(AbstractIndexManager.access$1(AbstractIndexManager.this)) + ": Exception while closing file of preserved resources" + " to index that was just read.  This should have no" + " effect on the consistency of the index.", e);
                }
            }
            if (!success) {
                preservedResourceEventsFile.delete();
                return success;
            }
            var6_6 = this.fResourceEventsLock;
            synchronized (var6_6) {
                iter = preservedResourceEvents.keySet().iterator();
                while (true) {
                    if (!iter.hasNext()) {
                        return success;
                    }
                    resource = (IResource)iter.next();
                    event = (ResourceEvent)preservedResourceEvents.get(resource);
                    this.fResourceEvents.put(resource, event);
                }
            }
        }

        private File getPreservedResourceEventsFile() {
            IPath preservedResroucesToIndexPath = AbstractIndexManager.this.getWorkingLocation().append(PRESERVED_RESOURCE_EVENTS_TO_PROCESS_FILE_NAME);
            return new File(preservedResroucesToIndexPath.toOSString());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyIfConsistant() {
            if (!this.hasResourceEventsToProcess()) {
                Object object = this.fToNotifyLock;
                synchronized (object) {
                    this.fToNotifyLock.notifyAll();
                }
            }
        }

        static /* synthetic */ AbstractIndexManager access$0(ResourceEventProcessingJob resourceEventProcessingJob) {
            return resourceEventProcessingJob.AbstractIndexManager.this;
        }
    }

    private class WorkspaceVisitorJob
    extends Job {
        protected WorkspaceVisitorJob() {
            super(NLS.bind((String)SSECoreMessages.IndexManager_0_Processing_entire_workspace_for_the_first_time, (Object)AbstractIndexManager.this.fName));
            this.setUser(false);
            this.setSystem(true);
            this.setPriority(30);
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                monitor.beginTask(NLS.bind((String)SSECoreMessages.IndexManager_0_Processing_entire_workspace_for_the_first_time, (Object)AbstractIndexManager.this.fName), -1);
                WorkspaceVisitor visitor = new WorkspaceVisitor(monitor);
                ResourcesPlugin.getWorkspace().getRoot().accept((IResourceProxyVisitor)visitor, 0);
                visitor.processBatchedResourceEvents();
            }
            catch (CoreException e) {
                Logger.logException(String.valueOf(AbstractIndexManager.this.fName) + ": Failed visiting entire workspace for initial index. " + AbstractIndexManager.LOG_ERROR_INDEX_INVALID, e);
            }
            IStatus status = monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
            return status;
        }

        private class WorkspaceVisitor
        implements IResourceProxyVisitor {
            private SubMonitor fProgress;
            private Map fBatchedResourceEvents;

            protected WorkspaceVisitor(IProgressMonitor monitor) {
                this.fProgress = SubMonitor.convert((IProgressMonitor)monitor);
                this.fBatchedResourceEvents = new LinkedHashMap(100);
            }

            public boolean visit(IResourceProxy proxy) throws CoreException {
                this.fProgress.subTask(proxy.getName());
                boolean visitChildren = false;
                if (!this.fProgress.isCanceled()) {
                    IPath path = proxy.requestFullPath();
                    if (path.toString().equals("/")) {
                        visitChildren = true;
                    } else if (AbstractIndexManager.this.isResourceToIndex(proxy.getType(), path)) {
                        IFile file;
                        if (proxy.getType() == 1 && (file = (IFile)proxy.requestResource()).exists()) {
                            this.fBatchedResourceEvents.put(file, new ResourceEvent(1, 0, null));
                        }
                        visitChildren = true;
                    }
                }
                if (this.fBatchedResourceEvents.size() >= 100) {
                    this.processBatchedResourceEvents();
                }
                return visitChildren;
            }

            protected void processBatchedResourceEvents() {
                AbstractIndexManager.this.fResourceEventProcessingJob.addResourceEvents(this.fBatchedResourceEvents);
                this.fBatchedResourceEvents.clear();
            }
        }
    }
}

