/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import com.ibm.icu.util.ULocale;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.birt.report.model.api.CascadingParameterGroupHandle;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.EmbeddedImageHandle;
import org.eclipse.birt.report.model.api.IVersionInfo;
import org.eclipse.birt.report.model.api.IllegalOperationException;
import org.eclipse.birt.report.model.api.JointDataSetHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.MasterPageHandle;
import org.eclipse.birt.report.model.api.ModuleOption;
import org.eclipse.birt.report.model.api.ParameterHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ReportItemThemeHandle;
import org.eclipse.birt.report.model.api.ScriptLibHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.TemplateDataSetHandle;
import org.eclipse.birt.report.model.api.TemplateParameterDefinitionHandle;
import org.eclipse.birt.report.model.api.ThemeHandle;
import org.eclipse.birt.report.model.api.TranslationHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.CustomMsgException;
import org.eclipse.birt.report.model.api.core.AttributeEvent;
import org.eclipse.birt.report.model.api.core.DisposeEvent;
import org.eclipse.birt.report.model.api.core.IAttributeListener;
import org.eclipse.birt.report.model.api.core.IDesignElement;
import org.eclipse.birt.report.model.api.core.IDisposeListener;
import org.eclipse.birt.report.model.api.core.IModuleModel;
import org.eclipse.birt.report.model.api.core.IResourceChangeListener;
import org.eclipse.birt.report.model.api.css.CssStyleSheetHandle;
import org.eclipse.birt.report.model.api.css.StyleSheetException;
import org.eclipse.birt.report.model.api.elements.structures.ConfigVariable;
import org.eclipse.birt.report.model.api.elements.structures.CustomColor;
import org.eclipse.birt.report.model.api.elements.structures.EmbeddedImage;
import org.eclipse.birt.report.model.api.elements.structures.IncludeScript;
import org.eclipse.birt.report.model.api.elements.structures.ScriptLib;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.LevelHandle;
import org.eclipse.birt.report.model.api.util.PropertyValueValidationUtil;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.api.util.URIUtil;
import org.eclipse.birt.report.model.api.validators.IValidationListener;
import org.eclipse.birt.report.model.api.validators.ValidationEvent;
import org.eclipse.birt.report.model.command.ComplexPropertyCommand;
import org.eclipse.birt.report.model.core.ContainerContext;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.StructureContext;
import org.eclipse.birt.report.model.core.StyleElement;
import org.eclipse.birt.report.model.elements.CascadingParameterGroup;
import org.eclipse.birt.report.model.elements.DataSet;
import org.eclipse.birt.report.model.elements.JointDataSet;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.elements.Parameter;
import org.eclipse.birt.report.model.elements.ReportItemTheme;
import org.eclipse.birt.report.model.elements.TemplateParameterDefinition;
import org.eclipse.birt.report.model.elements.Theme;
import org.eclipse.birt.report.model.elements.Translation;
import org.eclipse.birt.report.model.elements.strategy.DummyCopyPolicy;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.util.ModelUtil;
import org.eclipse.birt.report.model.util.URIUtilImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModuleHandleImpl
extends DesignElementHandle
implements IModuleModel {
    protected boolean isInitialized = false;

    public ModuleHandleImpl(Module module) {
        super(module);
        this.initializeSlotHandles();
        this.cachePropertyHandles();
    }

    public void addConfigVariable(ConfigVariable configVar) throws SemanticException {
        throw new IllegalOperationException();
    }

    public void addImage(EmbeddedImage image) throws SemanticException {
        throw new IllegalOperationException();
    }

    public final void rename(EmbeddedImage image) {
        this.module.rename(image);
    }

    public void addTranslation(String resourceKey, String locale, String text) throws CustomMsgException {
        throw new IllegalOperationException();
    }

    public final void addValidationListener(IValidationListener listener) {
        this.module.addValidationListener(listener);
    }

    public final void checkReport() {
        this.module.semanticCheck(this.module);
        ValidationEvent event = new ValidationEvent(this.module, null, this.getErrorList());
        this.module.broadcastValidationEvent(this.module, event);
    }

    public final void close() {
        this.module.close();
        DisposeEvent event = new DisposeEvent(this.module);
        this.module.broadcastDisposeEvent(event);
    }

    final List getFilteredStructureList(String propName, String nameMember) {
        ArrayList<StructureHandle> list = new ArrayList<StructureHandle>();
        PropertyHandle propHandle = this.getPropertyHandle(propName);
        if (propHandle == null) {
            return Collections.emptyList();
        }
        HashSet<String> names = new HashSet<String>();
        Iterator iter = propHandle.iterator();
        while (iter.hasNext()) {
            StructureHandle s = (StructureHandle)iter.next();
            String nameValue = (String)s.getProperty(nameMember);
            if (names.contains(nameValue)) continue;
            list.add(s);
            names.add(nameValue);
        }
        List theLibraries = this.getLibraries();
        int size = theLibraries.size();
        int i = 0;
        while (i < size) {
            LibraryHandle library = (LibraryHandle)theLibraries.get(i);
            if (library.isValid()) {
                for (StructureHandle s : library.getFilteredStructureList(propName, nameMember)) {
                    String nameValue = (String)s.getProperty(nameMember);
                    if (names.contains(nameValue)) continue;
                    list.add(s);
                    names.add(nameValue);
                }
            }
            ++i;
        }
        return list;
    }

    final List getStructureList(String propName) {
        ArrayList list = new ArrayList();
        List tempList = this.getNativeStructureList(propName);
        if (!tempList.isEmpty()) {
            list.addAll(tempList);
        }
        List theLibraries = this.getLibraries();
        int size = theLibraries.size();
        int i = 0;
        while (i < size) {
            LibraryHandle library = (LibraryHandle)theLibraries.get(i);
            tempList = library.getStructureList(propName);
            if (!tempList.isEmpty()) {
                list.addAll(tempList);
            }
            ++i;
        }
        return list;
    }

    protected final List getNativeStructureList(String propName) {
        ArrayList<StructureHandle> list = new ArrayList<StructureHandle>();
        PropertyHandle propHandle = this.getPropertyHandle(propName);
        if (propHandle == null) {
            return Collections.emptyList();
        }
        Iterator iter = propHandle.iterator();
        while (iter.hasNext()) {
            StructureHandle s = (StructureHandle)iter.next();
            list.add(s);
        }
        return list;
    }

    public final Iterator configVariablesIterator() {
        return this.getFilteredStructureList("configVars", "name").iterator();
    }

    public final Iterator customColorsIterator() {
        return this.getStructureList("colorPalette").iterator();
    }

    public void dropConfigVariable(String name) throws SemanticException {
        throw new IllegalOperationException();
    }

    public void dropImage(List images) throws SemanticException {
        throw new IllegalOperationException();
    }

    public void dropImage(String name) throws SemanticException {
        throw new IllegalOperationException();
    }

    public void dropTranslation(String resourceKey, String locale) throws CustomMsgException {
        throw new IllegalOperationException();
    }

    public final DataSetHandle findDataSet(String name) {
        DesignElement element = this.module.findDataSet(name);
        if (!(element instanceof DataSet)) {
            return null;
        }
        return (DataSetHandle)element.getHandle(element.getRoot());
    }

    public final JointDataSetHandle findJointDataSet(String name) {
        DesignElement element = this.module.findDataSet(name);
        if (!(element instanceof JointDataSet)) {
            return null;
        }
        return (JointDataSetHandle)element.getHandle(element.getRoot());
    }

    public final TemplateDataSetHandle findTemplateDataSet(String name) {
        DesignElement element = this.module.findDataSet(name);
        if (element == null) {
            return null;
        }
        return (TemplateDataSetHandle)element.getHandle(element.getRoot());
    }

    public final DataSourceHandle findDataSource(String name) {
        DesignElement element = this.module.findDataSource(name);
        if (element == null) {
            return null;
        }
        return (DataSourceHandle)element.getHandle(element.getRoot());
    }

    public final DesignElementHandle findElement(String name) {
        DesignElement element = this.module.findElement(name);
        if (element == null) {
            return null;
        }
        return element.getHandle(element.getRoot());
    }

    public final CubeHandle findCube(String name) {
        DesignElement element = this.module.findOLAPElement(name);
        if (element == null) {
            return null;
        }
        return element.getDefn().isKindOf(MetaDataDictionary.getInstance().getElement("Cube")) ? (CubeHandle)element.getHandle(element.getRoot()) : null;
    }

    public final LevelHandle findLevel(String name) {
        DesignElement element = this.module.findLevel(name);
        if (element == null) {
            return null;
        }
        return (LevelHandle)element.getHandle(element.getRoot());
    }

    public final EmbeddedImage findImage(String name) {
        return this.module.findImage(name);
    }

    public final ConfigVariable findConfigVariable(String name) {
        return this.module.findConfigVariabel(name);
    }

    public final CustomColor findColor(String name) {
        return this.module.findColor(name);
    }

    public final MasterPageHandle findMasterPage(String name) {
        DesignElement element = this.module.findPage(name);
        if (element == null) {
            return null;
        }
        return (MasterPageHandle)element.getHandle(element.getRoot());
    }

    public final ParameterHandle findParameter(String name) {
        DesignElement element = this.module.findParameter(name);
        if (element == null || !(element instanceof Parameter)) {
            return null;
        }
        return (ParameterHandle)element.getHandle(element.getRoot());
    }

    public final SharedStyleHandle findNativeStyle(String name) {
        StyleElement style = this.module.findNativeStyle(name);
        if (style == null) {
            return null;
        }
        return (SharedStyleHandle)style.getHandle(this.module);
    }

    public final SharedStyleHandle findStyle(String name) {
        StyleElement style = this.module.findStyle(name);
        if (style == null) {
            return null;
        }
        return (SharedStyleHandle)style.getHandle(style.getRoot());
    }

    public final ThemeHandle findTheme(String name) {
        Theme theme = this.module.findTheme(name);
        if (theme == null) {
            return null;
        }
        return (ThemeHandle)theme.getHandle(theme.getRoot());
    }

    public final ReportItemThemeHandle findReportItemTheme(String name) {
        ReportItemTheme theme = this.module.findReportItemTheme(name);
        if (theme == null) {
            return null;
        }
        return (ReportItemThemeHandle)theme.getHandle(theme.getRoot());
    }

    public final String getAuthor() {
        return this.getStringProperty("author");
    }

    public final String getSubject() {
        return this.getStringProperty("subject");
    }

    public final void setSubject(String subject) throws SemanticException {
        this.setStringProperty("subject", subject);
    }

    public final String getComments() {
        return this.getStringProperty("comments");
    }

    public final void setComments(String comments) throws SemanticException {
        this.setStringProperty("comments", comments);
    }

    public final CommandStack getCommandStack() {
        return this.module.getActivityStack();
    }

    public SlotHandle getComponents() {
        return null;
    }

    public final String getCreatedBy() {
        return this.getStringProperty("createdBy");
    }

    public SlotHandle getDataSets() {
        return null;
    }

    public abstract SlotHandle getCubes();

    public SlotHandle getDataSources() {
        return null;
    }

    public final String getDefaultUnits() {
        return this.module.getUnits();
    }

    public final void setDefaultUnits(String units) throws SemanticException {
        this.setStringProperty("units", units);
    }

    @Override
    public final DesignElement getElement() {
        return this.module;
    }

    public final DesignElementHandle getElementByID(long id) {
        DesignElement element = this.module.getElementByID(id);
        if (element == null) {
            return null;
        }
        return element.getHandle(this.module);
    }

    public final List getErrorList() {
        return this.module.getErrorList();
    }

    public final String getFileName() {
        return this.module.getFileName();
    }

    public List getFlattenParameters() {
        return Collections.emptyList();
    }

    public final String getHelpGuide() {
        return this.getStringProperty("helpGuide");
    }

    public final String getInitialize() {
        return this.getStringProperty("initialize");
    }

    public SlotHandle getMasterPages() {
        return null;
    }

    public final String getMessage(String resourceKey) {
        return this.getModule().getMessage(resourceKey);
    }

    public final String getMessage(String resourceKey, Locale locale) {
        return this.getModule().getMessage(resourceKey, ULocale.forLocale((Locale)locale));
    }

    public final String getMessage(String resourceKey, ULocale locale) {
        return this.getModule().getMessage(resourceKey, locale);
    }

    public final List getMessageKeys() {
        return this.getModule().getMessageKeys();
    }

    public SlotHandle getParameters() {
        return null;
    }

    public final CascadingParameterGroupHandle findCascadingParameterGroup(String groupName) {
        DesignElement element = this.module.findParameter(groupName);
        if (element == null || !(element instanceof CascadingParameterGroup)) {
            return null;
        }
        return (CascadingParameterGroupHandle)element.getHandle(element.getRoot());
    }

    public SlotHandle getStyles() {
        return null;
    }

    public final TranslationHandle getTranslation(String resourceKey, String locale) {
        Translation translation = this.module.findTranslation(resourceKey, locale);
        if (translation != null) {
            return translation.handle(this.getModule());
        }
        return null;
    }

    public final String[] getTranslationKeys() {
        return this.module.getTranslationResourceKeys();
    }

    public final List getTranslations() {
        List<Translation> translations = this.module.getTranslations();
        if (translations == null) {
            return null;
        }
        ArrayList<TranslationHandle> translationHandles = new ArrayList<TranslationHandle>();
        int i = 0;
        while (i < translations.size()) {
            translationHandles.add(translations.get(i).handle(this.getModule()));
            ++i;
        }
        return translationHandles;
    }

    public final List getWarningList() {
        return this.module.getWarningList();
    }

    public Iterator imagesIterator() {
        return Collections.emptyList().iterator();
    }

    public final List getAllImages() {
        return this.getStructureList("images");
    }

    public final boolean needsSave() {
        List<IVersionInfo> versionInfos;
        String version = this.module.getVersionManager().getVersion();
        if (version != null && !(versionInfos = ModelUtil.checkVersion(version)).isEmpty()) {
            return true;
        }
        return this.module.isDirty();
    }

    public final void onSave() {
        this.module.onSave();
    }

    public final boolean removeValidationListener(IValidationListener listener) {
        return this.getModule().removeValidationListener(listener);
    }

    public final void rename(DesignElementHandle elementHandle) {
        this.rename(null, elementHandle);
    }

    public final void rename(DesignElementHandle containerHandle, DesignElementHandle elementHandle) {
        if (elementHandle == null) {
            return;
        }
        if (containerHandle == null) {
            this.module.rename(elementHandle.getElement());
            return;
        }
        if (elementHandle instanceof StyleHandle) {
            if (containerHandle instanceof ThemeHandle) {
                String name = ((ThemeHandle)containerHandle).makeUniqueStyleName(elementHandle.getName());
                elementHandle.getElement().setName(name);
            } else if (containerHandle instanceof ReportDesignHandle) {
                this.module.rename(elementHandle.getElement());
            }
            return;
        }
        this.module.rename(containerHandle.getElement(), elementHandle.getElement());
    }

    public void replaceConfigVariable(ConfigVariable oldVar, ConfigVariable newVar) throws SemanticException {
        throw new IllegalOperationException();
    }

    public void replaceImage(EmbeddedImage oldVar, EmbeddedImage newVar) throws SemanticException {
        throw new IllegalOperationException();
    }

    public final void save() throws IOException {
        String fileName = this.getFileName();
        if (fileName == null) {
            return;
        }
        this.module.prepareToSave();
        String resolvedFileName = URIUtil.getLocalPath(fileName);
        if (resolvedFileName != null) {
            fileName = resolvedFileName;
        }
        this.module.getWriter().write(new File(fileName));
        this.module.onSave();
    }

    public final void saveAs(String newName) throws IOException {
        this.setFileName(newName);
        this.save();
    }

    public final void serialize(OutputStream out) throws IOException {
        assert (out != null);
        this.module.prepareToSave();
        this.module.getWriter().write(out);
        this.module.onSave();
    }

    public final void setAuthor(String author) {
        try {
            this.setStringProperty("author", author);
        }
        catch (SemanticException semanticException) {
            throw new IllegalOperationException();
        }
    }

    public final void setCreatedBy(String toolName) {
        try {
            this.setStringProperty("createdBy", toolName);
        }
        catch (SemanticException semanticException) {
            throw new IllegalOperationException();
        }
    }

    public final void setFileName(String newName) {
        this.module.setFileName(newName);
        if (!StringUtil.isBlank(newName)) {
            URL systemId = URIUtilImpl.getDirectory(newName);
            if (systemId != null) {
                this.module.setSystemId(systemId);
            }
            URL location = URIUtilImpl.getURLPresentation(newName);
            this.module.setLocation(location);
        }
        AttributeEvent event = new AttributeEvent(this.module, "fileName");
        this.module.broadcastFileNameEvent(event);
    }

    public final void setHelpGuide(String helpGuide) {
        try {
            this.setStringProperty("helpGuide", helpGuide);
        }
        catch (SemanticException semanticException) {
            throw new IllegalOperationException();
        }
    }

    public final void setInitialize(String value) {
        try {
            this.setStringProperty("initialize", value);
        }
        catch (SemanticException semanticException) {
            throw new IllegalOperationException();
        }
    }

    public List getAllStyles() {
        return Collections.emptyList();
    }

    public List getVisibleThemes(int level) {
        return Collections.emptyList();
    }

    public List<ReportItemThemeHandle> getVisibleReportItemThemes(int level, String type) {
        return Collections.emptyList();
    }

    public List getParametersAndParameterGroups() {
        return Collections.emptyList();
    }

    public final List getAllDataSources() {
        List<DesignElement> elementList = this.module.getNameHelper().getElements(3, Integer.MAX_VALUE);
        return this.generateHandleList(elementList);
    }

    public final List getVisibleDataSources() {
        List<DesignElement> elementList = this.module.getNameHelper().getElements(3, 0);
        return this.generateHandleList(this.sortVisibleElements(elementList, 0));
    }

    public final List getAllDataSets() {
        List<DesignElement> elementList = this.module.getNameHelper().getElements(4, Integer.MAX_VALUE);
        return this.generateHandleList(elementList);
    }

    public final List getVisibleDataSets() {
        List<DesignElement> elementList = this.module.getNameHelper().getElements(4, 0);
        return this.generateHandleList(this.sortVisibleElements(elementList, 0));
    }

    public final List getAllCubes() {
        List<DesignElement> elementList = this.module.getNameHelper().getElements(8, Integer.MAX_VALUE);
        List cubeList = this.getCubeList(elementList);
        return this.generateHandleList(cubeList);
    }

    private List getCubeList(List elements) {
        if (elements == null) {
            return null;
        }
        ArrayList<DesignElement> cubes = new ArrayList<DesignElement>();
        int i = 0;
        while (i < elements.size()) {
            DesignElement element = (DesignElement)elements.get(i);
            if (element.getDefn().isKindOf(MetaDataDictionary.getInstance().getElement("Cube"))) {
                cubes.add(element);
            }
            ++i;
        }
        return cubes;
    }

    public final List getVisibleCubes() {
        List<DesignElement> elementList = this.module.getNameHelper().getElements(8, 0);
        List cubeList = this.getCubeList(elementList);
        return this.generateHandleList(this.sortVisibleElements(cubeList, 0));
    }

    public final List getVisibleImages() {
        List images = this.getNativeStructureList("images");
        return images;
    }

    public List getAllPages() {
        return Collections.emptyList();
    }

    public final List getAllParameters() {
        List<DesignElement> elementList = this.module.getNameHelper().getNameSpace(2).getElements();
        return this.generateHandleList(elementList);
    }

    public final List getAllLibraries() {
        return this.getLibraries(Integer.MAX_VALUE);
    }

    protected final List getLibraries(int level) {
        List<Library> libraries = this.module.getLibraries(level);
        ArrayList<LibraryHandle> retLibs = new ArrayList<LibraryHandle>();
        for (Library library : libraries) {
            retLibs.add(library.handle());
        }
        return Collections.unmodifiableList(retLibs);
    }

    public final List getLibraries() {
        return this.getLibraries(1);
    }

    public final LibraryHandle getLibrary(String namespace) {
        Library library = this.module.getLibraryWithNamespace(namespace, 1);
        if (library == null) {
            return null;
        }
        return (LibraryHandle)library.getHandle(library);
    }

    public final LibraryHandle findLibrary(String fileName) {
        URL url = this.module.findResource(fileName, 2);
        if (url == null) {
            return null;
        }
        Library library = this.module.getLibraryByLocation(url.toString());
        if (library == null) {
            return null;
        }
        return (LibraryHandle)library.getHandle(library);
    }

    public void shiftLibrary(LibraryHandle library, int toPosn) throws SemanticException {
        throw new IllegalOperationException();
    }

    public final boolean isReadOnly() {
        return this.module.isReadOnly();
    }

    public Iterator includeLibrariesIterator() {
        return Collections.emptyList().iterator();
    }

    public void includeLibrary(String libraryFileName, String namespace) throws DesignFileException, SemanticException {
        throw new IllegalOperationException();
    }

    public void dropLibrary(LibraryHandle library) throws SemanticException {
        throw new IllegalOperationException();
    }

    public void reloadLibrary(LibraryHandle libraryToReload) throws SemanticException, DesignFileException {
        throw new IllegalOperationException();
    }

    public void reloadLibraries() throws SemanticException, DesignFileException {
        throw new IllegalOperationException();
    }

    public void reloadLibrary(String reloadPath) throws SemanticException, DesignFileException {
        throw new IllegalOperationException();
    }

    public void dropLibraryAndBreakExtends(LibraryHandle library) throws SemanticException {
        throw new IllegalOperationException();
    }

    public final void addAttributeListener(IAttributeListener listener) {
        this.module.addAttributeListener(listener);
    }

    public final boolean removeAttributeListener(IAttributeListener listener) {
        return this.module.removeAttributeListener(listener);
    }

    public final void addDisposeListener(IDisposeListener listener) {
        this.module.addDisposeListener(listener);
    }

    public final void addResourceChangeListener(IResourceChangeListener listener) {
        this.module.addResourceChangeListener(listener);
    }

    public final boolean removeDisposeListener(IDisposeListener listener) {
        return this.module.removeDisposeListener(listener);
    }

    public final boolean removeResourceChangeListener(IResourceChangeListener listener) {
        return this.module.removeResourceChangeListener(listener);
    }

    @Override
    public final void drop() throws SemanticException {
        throw new IllegalOperationException();
    }

    @Override
    public final void dropAndClear() throws SemanticException {
        throw new IllegalOperationException();
    }

    public final String getIncludeResource() {
        return this.getStringProperty("includeResource");
    }

    public final List<String> getIncludeResources() {
        return this.getListProperty("includeResource");
    }

    public final void setIncludeResource(String baseName) {
        try {
            this.setProperty("includeResource", baseName);
        }
        catch (SemanticException semanticException) {
            throw new IllegalOperationException();
        }
    }

    public final void setIncludeResources(List<String> baseNameList) {
        try {
            this.setProperty("includeResource", baseNameList);
        }
        catch (SemanticException semanticException) {
            throw new IllegalOperationException();
        }
    }

    public final URL findResource(String fileName, int fileType) {
        return this.module.findResource(fileName, fileType);
    }

    public final URL findResource(String fileName, int fileType, Map appContext) {
        return this.module.findResource(fileName, fileType, appContext);
    }

    public CssStyleSheetHandle openCssStyleSheet(String fileName) throws StyleSheetException {
        throw new IllegalOperationException();
    }

    public CssStyleSheetHandle openCssStyleSheet(InputStream is) throws StyleSheetException {
        throw new IllegalOperationException();
    }

    public void importCssStyles(CssStyleSheetHandle stylesheet, List selectedStyles) {
        throw new IllegalOperationException();
    }

    public void setThemeName(String themeName) throws SemanticException {
        throw new IllegalOperationException();
    }

    public final ThemeHandle getTheme() {
        Theme theme = this.module.getTheme(this.module);
        if (theme == null) {
            return null;
        }
        return (ThemeHandle)theme.getHandle(theme.getRoot());
    }

    public void setTheme(ThemeHandle theme) throws SemanticException {
        throw new IllegalOperationException();
    }

    final String getLocation() {
        return this.module.getLocation();
    }

    public final boolean isInclude(LibraryHandle library) {
        return this.module.getLibraryByLocation(library.getLocation()) != null;
    }

    final TemplateParameterDefinitionHandle findTemplateParameterDefinition(String name) {
        TemplateParameterDefinition templateParam = this.module.findTemplateParameterDefinition(name);
        if (templateParam == null) {
            return null;
        }
        return templateParam.handle(templateParam.getRoot());
    }

    List getAllTemplateParameterDefinitions() {
        return Collections.emptyList();
    }

    public final String getDescription() {
        return this.getStringProperty("description");
    }

    public final String getDisplayDescription() {
        return this.getExternalizedValue("descriptionID", "description");
    }

    public final void setDescription(String description) throws SemanticException {
        this.setStringProperty("description", description);
    }

    public final String getDescriptionKey() {
        return this.getStringProperty("descriptionID");
    }

    public final void setDescriptionKey(String resourceKey) throws SemanticException {
        this.setStringProperty("descriptionID", resourceKey);
    }

    public final String getTitle() {
        return this.getStringProperty("title");
    }

    public final void setTitle(String title) throws SemanticException {
        this.setStringProperty("title", title);
    }

    public final String getTitleKey() {
        return this.getStringProperty("titleID");
    }

    public final void setTitleKey(String titleKey) throws SemanticException {
        this.setStringProperty("titleID", titleKey);
    }

    public final void initializeModule(Map properties) throws SemanticException {
        if (this.isInitialized) {
            return;
        }
        Module root = (Module)this.getElement();
        for (Map.Entry entry : properties.entrySet()) {
            String name = (String)entry.getKey();
            try {
                Object value = PropertyValueValidationUtil.validateProperty(this, name, entry.getValue());
                root.setProperty(name, value);
            }
            catch (SemanticException semanticException) {}
        }
        this.isInitialized = true;
    }

    public final String getFileEncoding() {
        return "UTF-8";
    }

    public final String getSymbolicName() {
        return null;
    }

    public final void setSymbolicName(String symbolicName) throws SemanticException {
    }

    public final URL getSystemId() {
        return this.module.getSystemId();
    }

    public final void dropScriptLib(ScriptLib scriptLib) throws SemanticException {
        ElementPropertyDefn propDefn = this.module.getPropertyDefn("scriptLibs");
        if (scriptLib == null) {
            return;
        }
        ComplexPropertyCommand cmd = new ComplexPropertyCommand(this.getModule(), this.getElement());
        cmd.removeItem(new StructureContext(this.getElement(), propDefn, null), scriptLib);
    }

    public final void dropIncludeScript(IncludeScript includeScript) throws SemanticException {
        if (includeScript == null) {
            return;
        }
        ElementPropertyDefn propDefn = this.module.getPropertyDefn("includeScripts");
        ComplexPropertyCommand cmd = new ComplexPropertyCommand(this.getModule(), this.getElement());
        cmd.removeItem(new StructureContext(this.getElement(), propDefn, null), includeScript);
    }

    public final void dropScriptLib(ScriptLibHandle scriptLibHandle) throws SemanticException {
        ElementPropertyDefn propDefn = this.module.getPropertyDefn("scriptLibs");
        if (scriptLibHandle == null) {
            return;
        }
        ComplexPropertyCommand cmd = new ComplexPropertyCommand(this.getModule(), this.getElement());
        cmd.removeItem(new StructureContext(this.getElement(), propDefn, null), scriptLibHandle.getStructure());
    }

    public final void dropAllScriptLibs() throws SemanticException {
        List scriptLibs = this.getFilteredStructureList("scriptLibs", "name");
        if (scriptLibs == null) {
            return;
        }
        int count = scriptLibs.size();
        int i = count - 1;
        while (i >= 0) {
            ScriptLibHandle scriptLibHandle = (ScriptLibHandle)scriptLibs.get(i);
            this.dropScriptLib(scriptLibHandle);
            --i;
        }
    }

    public final Iterator scriptLibsIterator() {
        return this.getFilteredStructureList("scriptLibs", "name").iterator();
    }

    public final List getAllScriptLibs() {
        return this.getFilteredStructureList("scriptLibs", "name");
    }

    public final ScriptLib findScriptLib(String name) {
        List scriptLibs = this.getListProperty("scriptLibs");
        if (scriptLibs == null || scriptLibs.isEmpty()) {
            return null;
        }
        int i = 0;
        while (i < scriptLibs.size()) {
            ScriptLib scriptLib = (ScriptLib)scriptLibs.get(i);
            if (scriptLib.getName().equals(name)) {
                return scriptLib;
            }
            ++i;
        }
        return null;
    }

    public final void shiftScriptLibs(int sourceIndex, int destIndex) throws SemanticException {
        ElementPropertyDefn propDefn = this.module.getPropertyDefn("scriptLibs");
        ComplexPropertyCommand cmd = new ComplexPropertyCommand(this.getModule(), this.getElement());
        cmd.moveItem(new StructureContext(this.getElement(), propDefn, null), sourceIndex, destIndex);
    }

    public final void shifIncludeScripts(int sourceIndex, int destIndex) throws SemanticException {
        ElementPropertyDefn propDefn = this.module.getPropertyDefn("includeScripts");
        ComplexPropertyCommand cmd = new ComplexPropertyCommand(this.getModule(), this.getElement());
        cmd.moveItem(new StructureContext(this.getElement(), propDefn, null), sourceIndex, destIndex);
    }

    public final void addScriptLib(ScriptLib scriptLib) throws SemanticException {
        ElementPropertyDefn propDefn = this.module.getPropertyDefn("scriptLibs");
        ComplexPropertyCommand cmd = new ComplexPropertyCommand(this.getModule(), this.getElement());
        cmd.addItem(new StructureContext(this.getElement(), propDefn, null), (Object)scriptLib);
    }

    public final void addIncludeScript(IncludeScript includeScript) throws SemanticException {
        ElementPropertyDefn propDefn = this.module.getPropertyDefn("includeScripts");
        ComplexPropertyCommand cmd = new ComplexPropertyCommand(this.getModule(), this.getElement());
        cmd.addItem(new StructureContext(this.getElement(), propDefn, null), (Object)includeScript);
    }

    public final void setResourceFolder(String resourceFolder) {
        this.module.setResourceFolder(resourceFolder);
    }

    public final String getResourceFolder() {
        return this.module.getResourceFolder();
    }

    public final int getLineNoByID(long id) {
        return this.module.getLineNoByID(id);
    }

    public final int getLineNo(Object obj) {
        if (obj instanceof EmbeddedImageHandle) {
            return this.module.getLineNo(((EmbeddedImageHandle)obj).getStructure());
        }
        if (obj instanceof DesignElementHandle) {
            return this.module.getLineNo(((DesignElementHandle)obj).getElement());
        }
        if (obj instanceof SlotHandle) {
            SlotHandle slot = (SlotHandle)obj;
            return this.module.getLineNo(new ContainerContext(slot.getElement(), slot.getSlotID()));
        }
        return 1;
    }

    public final String getVersion() {
        String retVersion = this.module.getVersionManager().getVersion();
        return retVersion;
    }

    public final Iterator includeScriptsIterator() {
        PropertyHandle propHandle = this.getPropertyHandle("includeScripts");
        return propHandle == null ? Collections.emptyList().iterator() : propHandle.iterator();
    }

    public final List getAllIncludeScripts() {
        return this.getFilteredStructureList("includeScripts", "fileName");
    }

    @Override
    public final IDesignElement copy() {
        try {
            return (IDesignElement)((Module)this.getElement()).doClone(DummyCopyPolicy.getInstance());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            assert (false);
            return null;
        }
    }

    protected final List sortVisibleElements(List nameSpaceList, int level) {
        List<Object> modules = new ArrayList();
        if (nameSpaceList.size() == 0) {
            return modules;
        }
        modules = this.getVisibleModules(level);
        return this.checkVisibleElements(nameSpaceList, modules);
    }

    protected List<ModuleHandleImpl> getVisibleModules(int level) {
        ArrayList<ModuleHandleImpl> modules = new ArrayList<ModuleHandleImpl>();
        modules.add(this);
        modules.addAll(this.getLibraries(level));
        return modules;
    }

    private List checkVisibleElements(List nameSpaceList, List modules) {
        assert (modules != null);
        ArrayList<DesignElement> resultList = new ArrayList<DesignElement>();
        ArrayList<Module> moduleList = new ArrayList<Module>();
        int i = 0;
        while (i < modules.size()) {
            ModuleHandleImpl moduleHandle = (ModuleHandleImpl)modules.get(i);
            moduleList.add(moduleHandle.getModule());
            ++i;
        }
        i = 0;
        while (i < nameSpaceList.size()) {
            DesignElement content = (DesignElement)nameSpaceList.get(i);
            if (moduleList.contains(content.getRoot())) {
                resultList.add(content);
            }
            ++i;
        }
        return resultList;
    }

    protected List generateHandleList(List elementList) {
        ArrayList<DesignElementHandle> handleList = new ArrayList<DesignElementHandle>();
        for (DesignElement element : elementList) {
            Module root = element.getRoot();
            assert (root != null);
            handleList.add(element.getHandle(root));
        }
        return handleList;
    }

    public List<DimensionHandle> getAllSharedDimensions() {
        return Collections.emptyList();
    }

    public void checkReportIfNecessary() {
        ModuleOption options = this.module.getOptions();
        if (options == null || options.useSemanticCheck()) {
            this.checkReport();
        }
    }
}

