/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import org.eclipse.birt.report.model.activity.SimpleRecord;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.command.CustomMsgEvent;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.elements.Translation;
import org.eclipse.birt.report.model.util.CommandLabelFactory;

public class CustomMsgRecord
extends SimpleRecord {
    private ReportDesign design = null;
    private Translation translation = null;
    private int action = -1;
    public static final int ADD = 0;
    public static final int DROP = 1;
    public static final int CHANGE_LOCALE = 2;
    public static final int CHANGE_TEXT = 3;
    private String newValue;
    private String oldValue;

    public CustomMsgRecord(ReportDesign design, Translation translation, int action) {
        assert (design != null);
        assert (translation != null);
        assert (action == 0 || action == 1);
        this.action = action;
        this.design = design;
        this.translation = translation;
        if (action == 0) {
            this.label = CommandLabelFactory.getCommandLabel("Message.AddTranslation");
        } else if (action == 1) {
            this.label = CommandLabelFactory.getCommandLabel("Message.DropTranslation");
        }
    }

    public CustomMsgRecord(ReportDesign design, Translation translation, String value, int action) {
        assert (design != null);
        assert (translation != null);
        assert (action == 3 || action == 2);
        this.design = design;
        this.action = action;
        this.translation = translation;
        this.newValue = value;
        if (action == 3) {
            this.oldValue = translation.getText();
        } else if (action == 2) {
            this.oldValue = translation.getLocale();
        }
        this.label = CommandLabelFactory.getCommandLabel("Message.ChangeTranslation");
    }

    protected void perform(boolean undo) {
        switch (this.action) {
            case 0: {
                if (undo) {
                    this.design.dropTranslation(this.translation);
                    break;
                }
                this.design.addTranslation(this.translation);
                break;
            }
            case 1: {
                if (undo) {
                    this.design.addTranslation(this.translation);
                    break;
                }
                this.design.dropTranslation(this.translation);
                break;
            }
            case 2: {
                if (undo) {
                    this.translation.setLocale(this.oldValue);
                    break;
                }
                this.translation.setLocale(this.newValue);
                break;
            }
            case 3: {
                if (undo) {
                    this.translation.setText(this.oldValue);
                    break;
                }
                this.translation.setText(this.newValue);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public DesignElement getTarget() {
        return this.design;
    }

    public NotificationEvent getEvent() {
        assert (this.state == 1 || this.state == 2 || this.state == 3);
        int event = 0;
        switch (this.action) {
            case 0: {
                event = 0;
                break;
            }
            case 1: {
                event = 1;
                break;
            }
            case 2: 
            case 3: {
                event = 2;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return new CustomMsgEvent(this.design, this.translation, event);
    }
}

