/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.search;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IDecorationContext;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.mylyn.internal.tasks.ui.search.SearchResultsLabelProvider;
import org.eclipse.search.internal.ui.text.DecoratingFileSearchLabelProvider;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.misc.StringMatcher;

public class RepositorySearchStyledLabelProvider
extends DecoratingStyledCellLabelProvider
implements IPropertyChangeListener,
ILabelProvider {
    public static final String HIGHLIGHT_BG_COLOR_NAME = "org.eclipse.jdt.ui.ColoredLabels.match_highlight";
    private final ILabelProvider labelProvider;

    public RepositorySearchStyledLabelProvider(SearchResultsLabelProvider labelProvider, ILabelDecorator decorator, IDecorationContext decorationContext) {
        super((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new PatternStyledLabelProvider(labelProvider), decorator, decorationContext);
        this.labelProvider = labelProvider;
    }

    public void initialize(ColumnViewer viewer, ViewerColumn column) {
        PlatformUI.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        JFaceResources.getColorRegistry().addListener((IPropertyChangeListener)this);
        this.setOwnerDrawEnabled(PlatformUI.getPreferenceStore().getBoolean("USE_COLORED_LABELS"));
        super.initialize(viewer, column);
    }

    public ILabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public void dispose() {
        PlatformUI.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        JFaceResources.getColorRegistry().removeListener((IPropertyChangeListener)this);
        this.labelProvider.dispose();
        super.dispose();
    }

    public void setPattern(String pattern) {
        ((PatternStyledLabelProvider)this.getStyledStringProvider()).setPattern(pattern);
    }

    protected void refresh() {
        boolean coloredLabels;
        ColumnViewer viewer = this.getViewer();
        if (viewer != null && ((coloredLabels = PlatformUI.getPreferenceStore().getBoolean("USE_COLORED_LABELS")) || coloredLabels != this.isOwnerDrawEnabled())) {
            this.setOwnerDrawEnabled(coloredLabels);
            viewer.refresh();
        }
    }

    protected void scheduleRefresh() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                RepositorySearchStyledLabelProvider.this.refresh();
            }
        });
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if ("USE_COLORED_LABELS".equals(property) || HIGHLIGHT_BG_COLOR_NAME.equals(property)) {
            this.scheduleRefresh();
        }
    }

    public String getText(Object element) {
        return this.labelProvider.getText(element);
    }

    protected StyleRange prepareStyleRange(StyleRange styleRange, boolean applyColors) {
        boolean addBorder = !applyColors && styleRange.background != null;
        styleRange = super.prepareStyleRange(styleRange, applyColors);
        if (addBorder) {
            styleRange.borderStyle = 4;
        }
        return styleRange;
    }

    private static class PatternStyledLabelProvider
    extends StyledCellLabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider,
    IColorProvider,
    IFontProvider {
        private final SearchResultsLabelProvider labelProvider;
        private StringMatcher matcher = null;

        public PatternStyledLabelProvider(SearchResultsLabelProvider provider) {
            this.labelProvider = provider;
        }

        public void setPattern(String pattern) {
            this.matcher = pattern != null && pattern.length() > 0 ? new StringMatcher(pattern, true, false) : null;
        }

        public StyledString getStyledText(Object element) {
            StyledString styled = null;
            String label = this.labelProvider.getText(element);
            if (this.matcher == null || label.length() == 0) {
                styled = new StyledString(label);
            } else {
                styled = new StyledString();
                int start = 0;
                int end = 0;
                int length = label.length();
                StringMatcher.Position position = this.matcher.find(label, start, length);
                while (position != null) {
                    end = position.getStart();
                    styled.append(label.substring(start, end));
                    start = position.getEnd();
                    styled.append(label.substring(end, start), DecoratingFileSearchLabelProvider.HIGHLIGHT_STYLE);
                    position = this.matcher.find(label, start, length);
                }
                if (start > 0 && start < length) {
                    styled.append(label.substring(start));
                }
            }
            return styled;
        }

        public Image getImage(Object element) {
            return this.labelProvider.getImage(element);
        }

        public Font getFont(Object element) {
            return this.labelProvider.getFont(element);
        }

        public Color getForeground(Object element) {
            return this.labelProvider.getForeground(element);
        }

        public Color getBackground(Object element) {
            return this.labelProvider.getBackground(element);
        }
    }
}

