/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc.ui.editors;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.birt.report.data.bidi.utils.core.BidiTransform;
import org.eclipse.birt.report.data.oda.jdbc.ui.JdbcPlugin;
import org.eclipse.birt.report.data.oda.jdbc.ui.editors.MetaDataRetriever;
import org.eclipse.birt.report.data.oda.jdbc.ui.editors.OdaConnectionProvider;
import org.eclipse.birt.report.data.oda.jdbc.ui.editors.SQLPartitionScanner;
import org.eclipse.birt.report.data.oda.jdbc.ui.editors.SQLSourceViewerConfiguration;
import org.eclipse.birt.report.data.oda.jdbc.ui.editors.SQLUtility;
import org.eclipse.birt.report.data.oda.jdbc.ui.editors.TextMenuManager;
import org.eclipse.birt.report.data.oda.jdbc.ui.model.ChildrenAllowedNode;
import org.eclipse.birt.report.data.oda.jdbc.ui.model.DBNodeUtil;
import org.eclipse.birt.report.data.oda.jdbc.ui.model.FilterConfig;
import org.eclipse.birt.report.data.oda.jdbc.ui.model.IDBNode;
import org.eclipse.birt.report.data.oda.jdbc.ui.model.RootNode;
import org.eclipse.birt.report.data.oda.jdbc.ui.provider.JdbcMetaDataProvider;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.ExceptionHandler;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.Utility;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.datatools.connectivity.oda.IParameterMetaData;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DesignSessionUtil;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.DataSetWizardPage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.BidiSegmentEvent;
import org.eclipse.swt.custom.BidiSegmentListener;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;

public class SQLDataSetEditorPage
extends DataSetWizardPage {
    private Document doc = null;
    private SourceViewer viewer = null;
    private Text searchTxt = null;
    private ComboViewer filterComboViewer = null;
    private Combo schemaCombo = null;
    private Menu treeMenu = null;
    private ScrolledComposite sComposite;
    private Composite tablescomposite;
    private Label schemaLabel = null;
    private Tree availableDbObjectsTree = null;
    private Button identifierQuoteStringCheckBox = null;
    private Button showSystemTableCheckBox = null;
    private Button includeSchemaCheckBox = null;
    private DataSetDesign dataSetDesign;
    private static String DEFAULT_MESSAGE = JdbcPlugin.getResourceString("dataset.new.query");
    private int maxSchemaCount;
    private int maxTableCountPerSchema;
    private int timeOutLimit;
    private boolean enableCodeAssist;
    boolean prefetchSchema;
    private FilterConfig fc;
    String formerQueryTxt;
    private OdaConnectionProvider odaConnectionProvider;
    String metadataBidiFormatStr = null;

    public SQLDataSetEditorPage(String pageName) {
        super(pageName);
    }

    private void readPreferences() {
        this.setDefaultPereferencesIfNeed();
        Preferences preferences = JdbcPlugin.getDefault().getPluginPreferences();
        if ("YES".equals(preferences.getString("shemas_prefetch_config"))) {
            this.prefetchSchema = true;
        }
        if ("YES".equals(preferences.getString("enable_code_assit"))) {
            this.enableCodeAssist = true;
        }
        this.maxSchemaCount = preferences.getInt("user_max_num_of_schema");
        this.maxTableCountPerSchema = preferences.getInt("user_max_num_of_table_each_schema");
        this.timeOutLimit = preferences.getInt("user_timeout_limit");
        if (this.maxSchemaCount <= 0) {
            this.maxSchemaCount = Integer.MAX_VALUE;
        }
        if (this.maxTableCountPerSchema <= 0) {
            this.maxTableCountPerSchema = Integer.MAX_VALUE;
        }
        if (this.timeOutLimit < 0) {
            this.timeOutLimit = 0;
        }
    }

    private void setDefaultPereferencesIfNeed() {
        Preferences preferences = JdbcPlugin.getDefault().getPluginPreferences();
        if (!preferences.contains("shemas_prefetch_config")) {
            preferences.setValue("shemas_prefetch_config", "YES");
        }
        if (!preferences.contains("enable_code_assit")) {
            preferences.setValue("enable_code_assit", "YES");
        }
        if (!preferences.contains("user_max_num_of_schema")) {
            preferences.setValue("user_max_num_of_schema", String.valueOf(20));
        }
        if (!preferences.contains("user_max_num_of_table_each_schema")) {
            preferences.setValue("user_max_num_of_table_each_schema", String.valueOf(100));
        }
        if (!preferences.contains("user_timeout_limit")) {
            preferences.setValue("user_timeout_limit", String.valueOf(60));
        }
    }

    private void prepareJDBCMetaDataProvider(DataSetDesign dataSetDesign) {
        JdbcMetaDataProvider.createInstance(dataSetDesign);
        try {
            JdbcMetaDataProvider.getInstance().reconnect();
        }
        catch (Exception e) {
            ExceptionHandler.showException(PlatformUI.getWorkbench().getDisplay().getActiveShell(), JdbcPlugin.getResourceString("exceptionHandler.title.error"), e.getLocalizedMessage(), e);
        }
    }

    public void createPageCustomControl(Composite parent) {
        this.dataSetDesign = this.getInitializationDesign();
        try {
            Properties connProps = DesignSessionUtil.getEffectiveDataSourceProperties((DataSourceDesign)this.dataSetDesign.getDataSourceDesign());
            this.metadataBidiFormatStr = connProps.getProperty("metadataBidiFormatStr");
        }
        catch (OdaException odaException) {
            this.metadataBidiFormatStr = null;
        }
        this.readPreferences();
        this.prepareJDBCMetaDataProvider(this.dataSetDesign);
        this.odaConnectionProvider = new OdaConnectionProvider(this.dataSetDesign.getDataSourceDesign());
        this.setControl(this.createPageControl(parent));
        this.initializeControl();
        this.formerQueryTxt = this.dataSetDesign.getQueryText();
        Utility.setSystemHelp(this.getControl(), "org.eclipse.birt.cshelp.Wizard_JDBCDataset_ID");
    }

    private Control createPageControl(Composite parent) {
        SashForm pageContainer = new SashForm(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 2;
        pageContainer.setLayout((Layout)layout);
        pageContainer.setLayoutData((Object)new GridData(1808));
        pageContainer.setSashWidth(3);
        Control left = this.createDBMetaDataSelectionComposite((Composite)pageContainer);
        Control right = this.createTextualQueryComposite((Composite)pageContainer);
        this.setWidthHints(pageContainer, left, right);
        return pageContainer;
    }

    private void setWidthHints(SashForm pageContainer, Control left, Control right) {
        int leftWidth = left.computeSize((int)-1, (int)-1).x;
        int rightWidth = right.computeSize((int)-1, (int)-1).x;
        pageContainer.setWeights(new int[]{leftWidth, rightWidth});
    }

    private void initializeControl() {
        DEFAULT_MESSAGE = JdbcPlugin.getResourceString("dataset.new.query");
        this.setMessage(DEFAULT_MESSAGE, 0);
        this.viewer.getTextWidget().setFocus();
    }

    private Control createDBMetaDataSelectionComposite(Composite parent) {
        this.sComposite = new ScrolledComposite(parent, 768);
        this.sComposite.setLayoutData((Object)new GridData(1808));
        this.sComposite.setExpandHorizontal(true);
        this.sComposite.setExpandVertical(true);
        this.sComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                SQLDataSetEditorPage.this.computeSize();
            }
        });
        boolean supportsSchema = JdbcMetaDataProvider.getInstance().isSupportSchema();
        boolean supportsProcedure = JdbcMetaDataProvider.getInstance().isSupportProcedure();
        this.tablescomposite = new Composite((Composite)this.sComposite, 0);
        this.tablescomposite.setLayout((Layout)new GridLayout());
        GridData data = new GridData(1808);
        data.grabExcessVerticalSpace = true;
        this.tablescomposite.setLayoutData((Object)data);
        this.createDBObjectTree(this.tablescomposite);
        this.createObjectTreeMenu();
        this.createSchemaFilterComposite(supportsSchema, supportsProcedure, this.tablescomposite);
        this.createSQLOptionGroup(this.tablescomposite);
        this.addDragSupportToTree();
        this.addFetchDbObjectListener(this.metadataBidiFormatStr);
        this.sComposite.setContent((Control)this.tablescomposite);
        return this.tablescomposite;
    }

    private void computeSize() {
        this.sComposite.setMinSize(this.tablescomposite.computeSize(-1, -1));
        this.tablescomposite.layout();
    }

    private void createDBObjectTree(Composite tablescomposite) {
        Label dataSourceLabel = new Label(tablescomposite, 16384);
        dataSourceLabel.setText(JdbcPlugin.getResourceString("tablepage.label.availableItems"));
        GridData labelData = new GridData();
        dataSourceLabel.setLayoutData((Object)labelData);
        this.availableDbObjectsTree = new Tree(tablescomposite, 2050);
        GridData treeData = new GridData(1808);
        treeData.minimumHeight = 150;
        this.availableDbObjectsTree.setLayoutData((Object)treeData);
        this.availableDbObjectsTree.addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent e) {
                TreeItem item;
                if (SQLDataSetEditorPage.this.availableDbObjectsTree.getSelectionCount() > 0 && (item = SQLDataSetEditorPage.this.availableDbObjectsTree.getSelection()[0]).getParentItem() != null && SQLDataSetEditorPage.this.treeMenu != null) {
                    SQLDataSetEditorPage.this.treeMenu.setLocation(e.x, e.y);
                    return;
                }
                e.doit = false;
            }
        });
        this.availableDbObjectsTree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                SQLDataSetEditorPage.this.insertTreeItemText();
            }
        });
    }

    private void createObjectTreeMenu() {
        this.treeMenu = new Menu((Control)this.availableDbObjectsTree);
        MenuItem insert = new MenuItem(this.treeMenu, 0);
        insert.setText(JdbcPlugin.getResourceString("sqleditor.objectTree.menuItem.insert"));
        insert.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SQLDataSetEditorPage.this.insertTreeItemText();
            }
        });
        this.availableDbObjectsTree.setMenu(this.treeMenu);
    }

    private void createSchemaFilterComposite(boolean supportsSchema, boolean supportsProcedure, Composite tablescomposite) {
        Group selectTableGroup = new Group(tablescomposite, 4);
        GridLayout groupLayout = new GridLayout();
        groupLayout.numColumns = 3;
        groupLayout.verticalSpacing = 10;
        selectTableGroup.setLayout((Layout)groupLayout);
        GridData selectTableData = new GridData(768);
        selectTableGroup.setLayoutData((Object)selectTableData);
        this.schemaLabel = new Label((Composite)selectTableGroup, 16384);
        this.schemaLabel.setText(JdbcPlugin.getResourceString("tablepage.label.schema"));
        this.schemaCombo = new Combo((Composite)selectTableGroup, this.prefetchSchema ? 8 : 4);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.schemaCombo.setLayoutData((Object)gd);
        this.schemaCombo.setVisibleItemCount(30);
        Label FilterLabel = new Label((Composite)selectTableGroup, 16384);
        FilterLabel.setText(JdbcPlugin.getResourceString("tablepage.label.filter"));
        this.searchTxt = new Text((Composite)selectTableGroup, 2048);
        GridData searchTxtData = new GridData(768);
        searchTxtData.horizontalSpan = 2;
        this.searchTxt.setLayoutData((Object)searchTxtData);
        Label selectTypeLabel = new Label((Composite)selectTableGroup, 0);
        selectTypeLabel.setText(JdbcPlugin.getResourceString("tablepage.label.selecttype"));
        this.filterComboViewer = new ComboViewer((Composite)selectTableGroup, 8);
        this.setFilterComboContents(this.filterComboViewer, supportsProcedure);
        GridData filterData = new GridData(768);
        filterData.horizontalSpan = 2;
        this.filterComboViewer.getControl().setLayoutData((Object)filterData);
        this.setupShowSystemTableCheckBox(selectTableGroup);
        Button findButton = new Button((Composite)selectTableGroup, 0);
        GridData btnData = new GridData(64);
        btnData.horizontalSpan = 3;
        findButton.setLayoutData((Object)btnData);
        findButton.setText(JdbcPlugin.getResourceString("tablepage.button.filter"));
        findButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        SQLDataSetEditorPage.this.fc = SQLDataSetEditorPage.this.populateFilterConfig();
                        DBNodeUtil.createTreeRoot(SQLDataSetEditorPage.this.availableDbObjectsTree, new RootNode(SQLDataSetEditorPage.this.dataSetDesign.getDataSourceDesign().getName()), SQLDataSetEditorPage.this.fc, (this).SQLDataSetEditorPage.this.metadataBidiFormatStr, SQLDataSetEditorPage.this.timeOutLimit * 1000);
                    }
                });
            }
        });
        String[] allSchemaNames = null;
        if (supportsSchema) {
            String allFlag = JdbcPlugin.getResourceString("tablepage.text.All");
            this.schemaCombo.add(allFlag);
            if (this.prefetchSchema) {
                String[] stringArray = allSchemaNames = JdbcMetaDataProvider.getInstance().getAllSchemaNames(this.timeOutLimit * 1000);
                int n = allSchemaNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String name = stringArray[n2];
                    this.schemaCombo.add(BidiTransform.transform((String)name, (String)this.metadataBidiFormatStr, (String)"ILYNN"));
                    ++n2;
                }
            }
            this.schemaCombo.select(0);
        } else {
            this.schemaCombo.removeAll();
            this.schemaCombo.setEnabled(false);
            this.schemaLabel.setEnabled(false);
        }
        if (this.prefetchSchema) {
            this.fc = this.populateFilterConfig();
            DBNodeUtil.createTreeRoot(this.availableDbObjectsTree, new RootNode(this.dataSetDesign.getDataSourceDesign().getName(), allSchemaNames), this.fc, this.metadataBidiFormatStr, this.timeOutLimit * 1000);
        } else {
            DBNodeUtil.createRootTip(this.availableDbObjectsTree, new RootNode(this.dataSetDesign.getDataSourceDesign().getName()), this.metadataBidiFormatStr);
        }
    }

    private void createSQLOptionGroup(Composite tablescomposite) {
        Group sqlOptionGroup = new Group(tablescomposite, 4);
        sqlOptionGroup.setText(JdbcPlugin.getResourceString("tablepage.group.title"));
        GridLayout sqlOptionGroupLayout = new GridLayout();
        sqlOptionGroupLayout.verticalSpacing = 10;
        sqlOptionGroup.setLayout((Layout)sqlOptionGroupLayout);
        GridData sqlOptionGroupData = new GridData(768);
        sqlOptionGroup.setLayoutData((Object)sqlOptionGroupData);
        this.setupIdentifierQuoteStringCheckBox(sqlOptionGroup);
        this.setupIncludeSchemaCheckBox(sqlOptionGroup);
    }

    private FilterConfig populateFilterConfig() {
        String schemaName = null;
        if (this.schemaCombo.isEnabled() && this.schemaCombo.getSelectionIndex() != 0) {
            schemaName = this.schemaCombo.getText();
            schemaName = BidiTransform.transform((String)schemaName, (String)"ILYNN", (String)this.metadataBidiFormatStr);
        }
        FilterConfig.Type type = this.getSelectedFilterType();
        String namePattern = this.searchTxt.getText();
        boolean isShowSystemTable = this.showSystemTableCheckBox.getSelection();
        FilterConfig result = new FilterConfig(schemaName, type, namePattern, isShowSystemTable, this.maxSchemaCount, this.maxTableCountPerSchema);
        return result;
    }

    protected DataSetDesign collectDataSetDesign(DataSetDesign design) {
        if (this.doc != null) {
            design.setQueryText(this.doc.get());
            if (!design.getQueryText().equals(this.formerQueryTxt)) {
                MetaDataRetriever retriever = new MetaDataRetriever(this.odaConnectionProvider, design);
                IResultSetMetaData resultsetMeta = retriever.getResultSetMetaData();
                IParameterMetaData paramMeta = retriever.getParameterMetaData();
                SQLUtility.saveDataSetDesign(design, resultsetMeta, paramMeta);
                this.formerQueryTxt = design.getQueryText();
                retriever.close();
            }
        }
        return design;
    }

    private void setupIdentifierQuoteStringCheckBox(Group group) {
        GridData layoutData = new GridData(768);
        layoutData.horizontalSpan = 3;
        this.identifierQuoteStringCheckBox = new Button((Composite)group, 32);
        this.identifierQuoteStringCheckBox.setText(JdbcPlugin.getResourceString("tablepage.button.dnd"));
        this.identifierQuoteStringCheckBox.setSelection(false);
        this.identifierQuoteStringCheckBox.setLayoutData((Object)layoutData);
    }

    private void setupShowSystemTableCheckBox(Group group) {
        GridData layoutData = new GridData(32);
        layoutData.horizontalSpan = 2;
        this.showSystemTableCheckBox = new Button((Composite)group, 32);
        this.showSystemTableCheckBox.setText(JdbcPlugin.getResourceString("tablepage.button.showSystemTables"));
        this.showSystemTableCheckBox.setSelection(false);
        this.showSystemTableCheckBox.setLayoutData((Object)layoutData);
        this.showSystemTableCheckBox.setEnabled(true);
    }

    private void setupIncludeSchemaCheckBox(Group group) {
        GridData layoutData = new GridData(32);
        layoutData.horizontalSpan = 2;
        this.includeSchemaCheckBox = new Button((Composite)group, 32);
        this.includeSchemaCheckBox.setText(JdbcPlugin.getResourceString("tablepage.button.includeSchemaInfo"));
        this.includeSchemaCheckBox.setSelection(true);
        this.includeSchemaCheckBox.setLayoutData((Object)layoutData);
        this.includeSchemaCheckBox.setEnabled(true);
    }

    private void setFilterComboContents(ComboViewer filterComboViewer, boolean supportsProcedure) {
        if (filterComboViewer == null) {
            return;
        }
        ArrayList<FilterConfig.Type> types = new ArrayList<FilterConfig.Type>();
        types.add(FilterConfig.Type.ALL);
        types.add(FilterConfig.Type.TABLE);
        types.add(FilterConfig.Type.VIEW);
        if (supportsProcedure) {
            types.add(FilterConfig.Type.PROCEDURE);
        }
        filterComboViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return ((List)inputElement).toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        filterComboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object inputElement) {
                FilterConfig.Type type = (FilterConfig.Type)((Object)inputElement);
                return FilterConfig.getTypeDisplayText(type);
            }
        });
        filterComboViewer.setInput(types);
        filterComboViewer.getCombo().select(0);
        filterComboViewer.getCombo().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilterConfig.Type type = SQLDataSetEditorPage.this.getSelectedFilterType();
                if (type == FilterConfig.Type.ALL || type == FilterConfig.Type.TABLE) {
                    SQLDataSetEditorPage.this.showSystemTableCheckBox.setEnabled(true);
                } else {
                    SQLDataSetEditorPage.this.showSystemTableCheckBox.setEnabled(false);
                }
            }
        });
    }

    private FilterConfig.Type getSelectedFilterType() {
        IStructuredSelection selection = (IStructuredSelection)this.filterComboViewer.getSelection();
        FilterConfig.Type type = FilterConfig.Type.ALL;
        if (selection != null && selection.getFirstElement() != null) {
            return (FilterConfig.Type)((Object)selection.getFirstElement());
        }
        return type;
    }

    private void addFetchDbObjectListener(final String metadataBidiFormatStr) {
        this.availableDbObjectsTree.addListener(17, new Listener(){

            public void handleEvent(final Event event) {
                TreeItem item = (TreeItem)event.item;
                BusyIndicator.showWhile((Display)item.getDisplay(), (Runnable)new Runnable(){

                    public void run() {
                        this.listChildren(event, metadataBidiFormatStr);
                    }
                });
            }

            private void listChildren(Event event, String metadataBidiFormatStr2) {
                ChildrenAllowedNode parent;
                TreeItem item = (TreeItem)event.item;
                IDBNode node = (IDBNode)item.getData();
                if (node instanceof ChildrenAllowedNode && !(parent = (ChildrenAllowedNode)node).isChildrenPrepared()) {
                    item.removeAll();
                    parent.prepareChildren(SQLDataSetEditorPage.this.fc, SQLDataSetEditorPage.this.timeOutLimit * 1000);
                    if (parent.getChildren() != null) {
                        IDBNode[] iDBNodeArray = parent.getChildren();
                        int n = iDBNodeArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IDBNode child = iDBNodeArray[n2];
                            DBNodeUtil.createTreeItem(item, child, metadataBidiFormatStr2);
                            ++n2;
                        }
                    }
                }
            }
        });
    }

    private void addDragSupportToTree() {
        DragSource dragSource = new DragSource((Control)this.availableDbObjectsTree, 1);
        dragSource.setTransfer(new Transfer[]{TextTransfer.getInstance()});
        dragSource.addDragListener((DragSourceListener)new DragSourceAdapter(){
            private String textToInsert;

            public void dragStart(DragSourceEvent event) {
                event.doit = false;
                this.textToInsert = SQLDataSetEditorPage.this.getTextToInsert();
                if (this.textToInsert.length() > 0) {
                    event.doit = true;
                }
            }

            public void dragSetData(DragSourceEvent event) {
                if (TextTransfer.getInstance().isSupportedType(event.dataType)) {
                    event.data = this.textToInsert;
                }
            }
        });
    }

    private String getTextToInsert() {
        String result;
        TreeItem[] selection = this.availableDbObjectsTree.getSelection();
        StringBuffer data = new StringBuffer();
        if (selection != null && selection.length > 0) {
            int i = 0;
            while (i < selection.length) {
                IDBNode dbNode = (IDBNode)selection[i].getData();
                String sql = dbNode.getQualifiedNameInSQL(this.identifierQuoteStringCheckBox.getSelection(), this.includeSchemaCheckBox.getSelection(), this.metadataBidiFormatStr);
                if (sql != null) {
                    data.append(sql).append(",");
                }
                ++i;
            }
        }
        if ((result = data.toString()).length() > 0) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    private void addDropSupportToViewer() {
        final StyledText text = this.viewer.getTextWidget();
        DropTarget dropTarget = new DropTarget((Control)text, 17);
        dropTarget.setTransfer(new Transfer[]{TextTransfer.getInstance()});
        dropTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dragEnter(DropTargetEvent event) {
                text.setFocus();
                if (event.detail == 16) {
                    event.detail = 1;
                }
                if (event.detail != 1) {
                    event.detail = 0;
                }
            }

            public void dragOver(DropTargetEvent event) {
                event.feedback = 9;
            }

            public void dragOperationChanged(DropTargetEvent event) {
                this.dragEnter(event);
            }

            public void drop(DropTargetEvent event) {
                if (event.data instanceof String && !event.data.equals("")) {
                    SQLDataSetEditorPage.this.insertText((String)event.data);
                }
            }
        });
    }

    private void insertText(String text) {
        if (text == null) {
            return;
        }
        StyledText textWidget = this.viewer.getTextWidget();
        int selectionStart = textWidget.getSelection().x;
        textWidget.insert(text);
        textWidget.setSelection(selectionStart + text.length());
        textWidget.setFocus();
    }

    private Control createTextualQueryComposite(Composite parent) {
        Composite composite = new Composite(parent, 0x2000004);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Label queryTextLabel = new Label(composite, 0);
        queryTextLabel.setText(JdbcPlugin.getResourceString("tablepage.label.queryText"));
        CompositeRuler ruler = new CompositeRuler();
        LineNumberRulerColumn lineNumbers = new LineNumberRulerColumn();
        ruler.addDecorator(0, (IVerticalRulerColumn)lineNumbers);
        this.viewer = new SourceViewer(composite, (IVerticalRuler)ruler, 768);
        SQLSourceViewerConfiguration svc = new SQLSourceViewerConfiguration(this.dataSetDesign.getDataSourceDesign(), this.timeOutLimit * 1000, this.enableCodeAssist);
        this.viewer.configure((SourceViewerConfiguration)svc);
        this.doc = new Document(this.getQueryText());
        FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new SQLPartitionScanner(), new String[]{"sql_quote_string1", "sql_comment", "__dftl_partition_content_type"});
        partitioner.connect((IDocument)this.doc);
        this.doc.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        this.viewer.setDocument((IDocument)this.doc);
        this.viewer.getTextWidget().setFont(JFaceResources.getTextFont());
        this.viewer.getTextWidget().addBidiSegmentListener(new BidiSegmentListener(){

            public void lineGetSegments(BidiSegmentEvent event) {
                event.segments = SQLUtility.getBidiLineSegments(event.lineText);
            }
        });
        this.attachMenus(this.viewer);
        GridData data = new GridData(1808);
        data.widthHint = 500;
        this.viewer.getControl().setLayoutData((Object)data);
        this.addDropSupportToViewer();
        this.viewer.getTextWidget().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (this.isUndoKeyPress(e)) {
                    SQLDataSetEditorPage.this.viewer.doOperation(1);
                } else if (this.isRedoKeyPress(e)) {
                    SQLDataSetEditorPage.this.viewer.doOperation(2);
                }
            }

            private boolean isUndoKeyPress(KeyEvent e) {
                return (e.stateMask & 0x40000) > 0 && (e.keyCode == 122 || e.keyCode == 90);
            }

            private boolean isRedoKeyPress(KeyEvent e) {
                return (e.stateMask & 0x40000) > 0 && (e.keyCode == 121 || e.keyCode == 89);
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        return composite;
    }

    private final void attachMenus(SourceViewer viewer) {
        StyledText widget = viewer.getTextWidget();
        TextMenuManager menuManager = new TextMenuManager((TextViewer)viewer);
        widget.setMenu(menuManager.getContextMenu((Control)widget));
    }

    protected void refresh(DataSetDesign dataSetDesign) {
        this.dataSetDesign = dataSetDesign;
        this.initializeControl();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.getControl().setFocus();
    }

    private String getQueryText() {
        String queryText = this.dataSetDesign.getQueryText();
        if (queryText != null && queryText.trim().length() > 0) {
            return queryText;
        }
        return SQLUtility.getQueryPresetTextString(this.dataSetDesign.getOdaExtensionDataSetId());
    }

    protected void cleanup() {
        JdbcMetaDataProvider.release();
        if (this.odaConnectionProvider != null) {
            this.odaConnectionProvider.release();
            this.odaConnectionProvider = null;
        }
        this.dataSetDesign = null;
    }

    private void insertTreeItemText() {
        String text = this.getTextToInsert();
        if (text.length() > 0) {
            this.insertText(text);
        }
    }
}

