/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.debug.ui.breakpoints;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Pattern;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaLineBreakpoint;
import org.eclipse.jdt.internal.debug.ui.BreakpointUtils;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.JDISourceViewer;
import org.eclipse.jdt.internal.debug.ui.breakpoints.AbstractJavaBreakpointEditor;
import org.eclipse.jdt.internal.debug.ui.contentassist.JavaDebugContentAssistProcessor;
import org.eclipse.jdt.internal.debug.ui.contentassist.TypeContext;
import org.eclipse.jdt.internal.debug.ui.display.DisplayViewerConfiguration;
import org.eclipse.jdt.internal.debug.ui.propertypages.PropertyPageMessages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.TextViewerUndoManager;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;

public final class JavaBreakpointConditionEditor
extends AbstractJavaBreakpointEditor {
    private Button fConditional;
    private Button fWhenTrue;
    private Button fWhenChange;
    private JDISourceViewer fViewer;
    private IContentAssistProcessor fCompletionProcessor;
    private IJavaLineBreakpoint fBreakpoint;
    private IHandlerService fHandlerService;
    private IHandler fHandler;
    private IHandlerActivation fActivation;
    private IDocumentListener fDocumentListener;
    private Combo fConditionHistory;
    private IDialogSettings fConditionHistoryDialogSettings;
    private boolean fReplaceConditionInHistory;
    private Map fLocalConditionHistory;
    private int fSeparatorIndex;
    public static final int PROP_CONDITION = 4097;
    public static final int PROP_CONDITION_ENABLED = 4098;
    public static final int PROP_CONDITION_SUSPEND_POLICY = 4099;
    private static final int MAX_HISTORY_SIZE = 10;
    private static final String DS_SECTION_CONDITION_HISTORY = "conditionHistory";
    private static final String DS_KEY_HISTORY_ENTRY_COUNT = "conditionHistoryEntryCount";
    private static final String DS_KEY_HISTORY_ENTRY_PREFIX = "conditionHistoryEntry_";
    private static final Pattern NEWLINE_PATTERN = Pattern.compile("\r\n|\r|\n");
    static /* synthetic */ Class class$0;

    public JavaBreakpointConditionEditor() {
    }

    public JavaBreakpointConditionEditor(IDialogSettings dialogSettings) {
        this.fConditionHistoryDialogSettings = dialogSettings != null ? dialogSettings : DialogSettings.getOrCreateSection((IDialogSettings)JDIDebugUIPlugin.getDefault().getDialogSettings(), (String)DS_SECTION_CONDITION_HISTORY);
    }

    public void addPropertyListener(IPropertyListener listener) {
        super.addPropertyListener(listener);
    }

    public void removePropertyListener(IPropertyListener listener) {
        super.removePropertyListener(listener);
    }

    public void setInput(Object input) throws CoreException {
        try {
            boolean sameBreakpoint = this.fBreakpoint == input;
            this.suppressPropertyChanges(true);
            if (input instanceof IJavaLineBreakpoint) {
                this.setBreakpoint((IJavaLineBreakpoint)input);
            } else {
                this.setBreakpoint(null);
            }
            if (this.hasConditionHistory()) {
                if (!sameBreakpoint) {
                    this.fReplaceConditionInHistory = false;
                }
                this.initializeConditionHistoryDropDown();
            }
        }
        finally {
            this.suppressPropertyChanges(false);
        }
    }

    private void setBreakpoint(IJavaLineBreakpoint breakpoint) throws CoreException {
        this.fBreakpoint = breakpoint;
        if (this.fDocumentListener != null) {
            this.fViewer.getDocument().removeDocumentListener(this.fDocumentListener);
            this.fDocumentListener = null;
        }
        this.fViewer.unconfigure();
        Document document = new Document();
        JDIDebugUIPlugin.getDefault().getJavaTextTools().setupJavaDocumentPartitioner((IDocument)document, "___java_partitioning");
        this.fViewer.setInput(document);
        String condition = null;
        IType type = null;
        boolean controlsEnabled = false;
        boolean conditionEnabled = false;
        boolean whenTrue = true;
        if (breakpoint != null) {
            controlsEnabled = true;
            if (breakpoint.supportsCondition()) {
                condition = breakpoint.getCondition();
                conditionEnabled = breakpoint.isConditionEnabled();
                whenTrue = breakpoint.isConditionSuspendOnTrue();
                type = BreakpointUtils.getType((IJavaBreakpoint)breakpoint);
            }
        }
        TypeContext context = null;
        if (type == null || breakpoint == null) {
            context = new TypeContext(null, -1);
        } else {
            String source = null;
            ICompilationUnit compilationUnit = type.getCompilationUnit();
            if (compilationUnit != null && compilationUnit.getJavaProject().getProject().exists()) {
                source = compilationUnit.getSource();
            } else {
                IClassFile classFile = type.getClassFile();
                if (classFile != null) {
                    source = classFile.getSource();
                }
            }
            int lineNumber = breakpoint.getMarker().getAttribute("lineNumber", -1);
            int position = -1;
            if (source != null && lineNumber != -1) {
                try {
                    position = new Document(source).getLineOffset(lineNumber - 1);
                }
                catch (BadLocationException e) {
                    JDIDebugUIPlugin.log(e);
                }
            }
            context = new TypeContext(type, position);
        }
        this.fCompletionProcessor = new JavaDebugContentAssistProcessor(context);
        this.fViewer.configure((SourceViewerConfiguration)new DisplayViewerConfiguration(){

            public IContentAssistProcessor getContentAssistantProcessor() {
                return JavaBreakpointConditionEditor.this.fCompletionProcessor;
            }
        });
        document.set(condition == null ? "" : condition);
        this.fViewer.setUndoManager((IUndoManager)new TextViewerUndoManager(10));
        this.fViewer.getUndoManager().connect((ITextViewer)this.fViewer);
        this.fDocumentListener = new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                JavaBreakpointConditionEditor.this.setDirty(4097);
            }
        };
        this.fViewer.getDocument().addDocumentListener(this.fDocumentListener);
        this.fConditional.setEnabled(controlsEnabled);
        this.fConditional.setSelection(conditionEnabled);
        this.fWhenTrue.setSelection(whenTrue);
        this.fWhenChange.setSelection(!whenTrue);
        this.setEnabled(conditionEnabled && breakpoint != null && breakpoint.supportsCondition(), false);
        this.setDirty(false);
    }

    public Control createControl(Composite parent) {
        Composite controls = SWTFactory.createComposite((Composite)parent, (Font)parent.getFont(), (int)2, (int)1, (int)768, (int)0, (int)0);
        this.fConditional = SWTFactory.createCheckButton((Composite)controls, (String)this.processMnemonics(PropertyPageMessages.JavaBreakpointConditionEditor_0), null, (boolean)false, (int)1);
        this.fConditional.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.fConditional.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean checked = JavaBreakpointConditionEditor.this.fConditional.getSelection();
                JavaBreakpointConditionEditor.this.setEnabled(checked, true);
                JavaBreakpointConditionEditor.this.setDirty(4098);
            }
        });
        Composite radios = SWTFactory.createComposite((Composite)controls, (Font)controls.getFont(), (int)2, (int)1, (int)768, (int)0, (int)0);
        this.fWhenTrue = SWTFactory.createRadioButton((Composite)radios, (String)this.processMnemonics(PropertyPageMessages.JavaBreakpointConditionEditor_1));
        this.fWhenTrue.setLayoutData((Object)new GridData());
        this.fWhenChange = SWTFactory.createRadioButton((Composite)radios, (String)this.processMnemonics(PropertyPageMessages.JavaBreakpointConditionEditor_2));
        this.fWhenChange.setLayoutData((Object)new GridData());
        this.fWhenTrue.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavaBreakpointConditionEditor.this.setDirty(4099);
            }
        });
        this.fWhenChange.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavaBreakpointConditionEditor.this.setDirty(4099);
            }
        });
        if (this.fConditionHistoryDialogSettings != null) {
            this.fLocalConditionHistory = new HashMap();
            this.fConditionHistory = SWTFactory.createCombo((Composite)parent, (int)12, (int)1, null);
            this.initializeConditionHistoryDropDown();
            this.fConditionHistory.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int historyIndex = JavaBreakpointConditionEditor.this.fConditionHistory.getSelectionIndex() - 1;
                    if (historyIndex >= 0 && historyIndex != JavaBreakpointConditionEditor.this.fSeparatorIndex) {
                        JavaBreakpointConditionEditor.this.fViewer.getDocument().set(JavaBreakpointConditionEditor.this.getConditionHistory()[historyIndex]);
                    }
                }
            });
            GridData data = new GridData(768);
            data.widthHint = 10;
            this.fConditionHistory.setLayoutData((Object)data);
            this.fLocalConditionHistory = new HashMap(10);
        }
        this.fViewer = new JDISourceViewer(parent, null, 0x2000B00);
        this.fViewer.setEditable(false);
        ControlDecoration decoration = new ControlDecoration(this.fViewer.getControl(), 16512);
        decoration.setShowOnlyOnFocus(true);
        FieldDecoration dec = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL");
        decoration.setImage(dec.getImage());
        decoration.setDescriptionText(dec.getDescription());
        GridData gd = new GridData(4, 4, true, true);
        GC gc = new GC((Drawable)this.fViewer.getTextWidget());
        gc.setFont(this.fViewer.getTextWidget().getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gd.widthHint = Dialog.convertWidthInCharsToPixels((FontMetrics)fontMetrics, (int)40);
        gc.dispose();
        this.fViewer.getControl().setLayoutData((Object)gd);
        this.fHandler = new AbstractHandler(){

            public Object execute(ExecutionEvent event) throws ExecutionException {
                JavaBreakpointConditionEditor.this.fViewer.doOperation(13);
                return null;
            }
        };
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.handlers.IHandlerService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fHandlerService = (IHandlerService)iWorkbench.getAdapter((Class)clazz);
        this.fViewer.getControl().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                JavaBreakpointConditionEditor.this.activateContentAssist();
            }

            public void focusLost(FocusEvent e) {
                JavaBreakpointConditionEditor.this.deactivateContentAssist();
            }
        });
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                JavaBreakpointConditionEditor.this.dispose();
            }
        });
        return parent;
    }

    protected void dispose() {
        super.dispose();
        this.deactivateContentAssist();
        if (this.fDocumentListener != null) {
            this.fViewer.getDocument().removeDocumentListener(this.fDocumentListener);
        }
        this.fViewer.dispose();
    }

    public void setFocus() {
        this.fViewer.getControl().setFocus();
    }

    public void doSave() throws CoreException {
        if (this.fBreakpoint != null && this.isDirty()) {
            this.fBreakpoint.setCondition(this.fViewer.getDocument().get().trim());
            this.fBreakpoint.setConditionEnabled(this.fConditional.getSelection());
            this.fBreakpoint.setConditionSuspendOnTrue(this.fWhenTrue.getSelection());
            this.setDirty(false);
            if (this.hasConditionHistory()) {
                this.updateConditionHistories();
            }
        }
    }

    public IStatus getStatus() {
        if (this.fBreakpoint != null && this.fBreakpoint.supportsCondition() && this.fConditional.getSelection() && this.fViewer.getDocument().get().trim().length() == 0) {
            return new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), PropertyPageMessages.BreakpointConditionEditor_1);
        }
        return Status.OK_STATUS;
    }

    public boolean isDirty() {
        return super.isDirty();
    }

    public void setMnemonics(boolean mnemonics) {
        super.setMnemonics(mnemonics);
    }

    private void activateContentAssist() {
        this.fActivation = this.fHandlerService.activateHandler("org.eclipse.ui.edit.text.contentAssist.proposals", this.fHandler);
    }

    private void deactivateContentAssist() {
        if (this.fActivation != null) {
            this.fHandlerService.deactivateHandler(this.fActivation);
            this.fActivation = null;
        }
    }

    private void setEnabled(boolean enabled, boolean focus) {
        this.fViewer.setEditable(enabled);
        this.fViewer.getTextWidget().setEnabled(enabled);
        this.fWhenChange.setEnabled(enabled);
        this.fWhenTrue.setEnabled(enabled);
        if (enabled) {
            this.fViewer.updateViewerColors();
            if (focus) {
                this.setFocus();
            }
        } else {
            Color color = this.fViewer.getControl().getDisplay().getSystemColor(22);
            this.fViewer.getTextWidget().setBackground(color);
        }
        if (this.hasConditionHistory()) {
            this.fConditionHistory.setEnabled(enabled);
        }
    }

    public Object getInput() {
        return this.fBreakpoint;
    }

    private boolean hasConditionHistory() {
        return this.fConditionHistory != null;
    }

    private void initializeConditionHistoryDropDown() {
        this.fConditionHistory.setItems(this.getConditionHistoryLabels());
        String userHint = PropertyPageMessages.JavaBreakpointConditionEditor_choosePreviousCondition;
        this.fConditionHistory.add(userHint, 0);
        this.fConditionHistory.setText(userHint);
    }

    private String[] getConditionHistoryLabels() {
        String[] conditions = this.getConditionHistory();
        String[] labels = new String[conditions.length];
        int i = 0;
        while (i < conditions.length) {
            labels[i] = NEWLINE_PATTERN.matcher(conditions[i]).replaceAll(" ");
            ++i;
        }
        return labels;
    }

    private String[] getConditionHistory() {
        this.fSeparatorIndex = -1;
        String[] globalItems = JavaBreakpointConditionEditor.readConditionHistory(this.fConditionHistoryDialogSettings);
        Stack localHistory = (Stack)this.fLocalConditionHistory.get(this.fBreakpoint);
        if (localHistory == null) {
            return globalItems;
        }
        int localHistorySize = Math.min(localHistory.size(), 10);
        String[] historyItems = new String[localHistorySize + globalItems.length + 1];
        int i = 0;
        while (i < localHistorySize) {
            historyItems[i] = (String)localHistory.get(localHistory.size() - i - 1);
            ++i;
        }
        this.fSeparatorIndex = localHistorySize;
        historyItems[localHistorySize] = this.getSeparatorLabel();
        System.arraycopy(globalItems, 0, historyItems, localHistorySize + 1, globalItems.length);
        return historyItems;
    }

    private void updateConditionHistories() {
        String newItem = this.fViewer.getDocument().get();
        if (newItem.length() == 0) {
            return;
        }
        Stack<String> localHistory = (Stack<String>)this.fLocalConditionHistory.get(this.fBreakpoint);
        if (localHistory == null) {
            localHistory = new Stack<String>();
            this.fLocalConditionHistory.put(this.fBreakpoint, localHistory);
        }
        localHistory.remove(newItem);
        localHistory.push(newItem);
        String[] globalItems = JavaBreakpointConditionEditor.readConditionHistory(this.fConditionHistoryDialogSettings);
        if (globalItems.length > 0 && newItem.equals(globalItems[0])) {
            return;
        }
        if (!this.fReplaceConditionInHistory) {
            String[] tempItems = new String[globalItems.length + 1];
            System.arraycopy(globalItems, 0, tempItems, 1, globalItems.length);
            globalItems = tempItems;
        } else if (globalItems.length == 0) {
            globalItems = new String[1];
        }
        this.fReplaceConditionInHistory = true;
        globalItems[0] = newItem;
        JavaBreakpointConditionEditor.storeConditionHistory(globalItems, this.fConditionHistoryDialogSettings);
    }

    private static String[] readConditionHistory(IDialogSettings dialogSettings) {
        int count = 0;
        try {
            count = dialogSettings.getInt(DS_KEY_HISTORY_ENTRY_COUNT);
        }
        catch (NumberFormatException numberFormatException) {}
        count = Math.min(count, 10);
        String[] conditions = new String[count];
        int i = 0;
        while (i < count) {
            conditions[i] = dialogSettings.get(DS_KEY_HISTORY_ENTRY_PREFIX + i);
            ++i;
        }
        return conditions;
    }

    private static void storeConditionHistory(String[] conditions, IDialogSettings dialogSettings) {
        int length = Math.min(conditions.length, 10);
        int count = 0;
        int i = 0;
        block0: while (i < length) {
            int j = 0;
            while (j < i) {
                if (conditions[i].equals(conditions[j])) break block0;
                ++j;
            }
            dialogSettings.put(DS_KEY_HISTORY_ENTRY_PREFIX + count, conditions[i]);
            ++count;
            ++i;
        }
        dialogSettings.put(DS_KEY_HISTORY_ENTRY_COUNT, count);
    }

    private String getSeparatorLabel() {
        int borderWidth = this.fConditionHistory.computeTrim((int)0, (int)0, (int)0, (int)0).width;
        Rectangle rect = this.fConditionHistory.getBounds();
        int width = rect.width - borderWidth;
        GC gc = new GC((Drawable)this.fConditionHistory);
        gc.setFont(this.fConditionHistory.getFont());
        int fSeparatorWidth = gc.getAdvanceWidth('-');
        String separatorLabel = PropertyPageMessages.JavaBreakpointConditionEditor_historySeparator;
        int fMessageLength = gc.textExtent((String)separatorLabel).x;
        gc.dispose();
        StringBuffer dashes = new StringBuffer();
        int chars = (width - fMessageLength) / fSeparatorWidth / 2 - 2;
        int i = 0;
        while (i < chars) {
            dashes.append('-');
            ++i;
        }
        StringBuffer result = new StringBuffer();
        result.append(dashes);
        result.append(" " + separatorLabel + " ");
        result.append(dashes);
        return result.toString().trim();
    }
}

