/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.provisional.commons.ui;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.mylyn.internal.commons.ui.CommonsUiPlugin;
import org.eclipse.mylyn.internal.commons.ui.CompositeContainerImageDescriptor;
import org.eclipse.mylyn.internal.commons.ui.CompositeElementImageDescriptor;
import org.eclipse.mylyn.internal.commons.ui.CompositeSyncImageDescriptor;
import org.eclipse.mylyn.internal.commons.ui.TaskListImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class CommonImages {
    private static final URL baseURL = CommonsUiPlugin.getDefault().getBundle().getEntry("/icons/");
    private static ImageRegistry imageRegistry;
    private static final String T_ELCL = "elcl16";
    private static final String T_EVIEW = "eview16";
    private static final String T_TOOL = "etool16";
    private static final String T_OBJ = "obj16";
    private static final String T_OBJ_32 = "obj32";
    private static final String T_WIZBAN = "wizban";
    private static final String T_OVR = "ovr16";
    public static final ImageDescriptor PRIORITY_1;
    public static final ImageDescriptor PRIORITY_2;
    public static final ImageDescriptor PRIORITY_3;
    public static final ImageDescriptor PRIORITY_4;
    public static final ImageDescriptor PRIORITY_5;
    public static final ImageDescriptor PRIORITY_1_LARGE;
    public static final ImageDescriptor PRIORITY_2_LARGE;
    public static final ImageDescriptor PRIORITY_3_LARGE;
    public static final ImageDescriptor PRIORITY_4_LARGE;
    public static final ImageDescriptor PRIORITY_5_LARGE;
    public static final ImageDescriptor CALENDAR;
    public static final ImageDescriptor CALENDAR_SMALL;
    public static final ImageDescriptor SCHEDULE;
    public static final ImageDescriptor SCHEDULE_DAY;
    public static final ImageDescriptor SCHEDULE_WEEK;
    public static final ImageDescriptor PERSON;
    public static final ImageDescriptor PERSON_NARROW;
    public static final ImageDescriptor PERSON_ME;
    public static final ImageDescriptor PERSON_ME_SMALL;
    public static final ImageDescriptor PERSON_ME_NARROW;
    public static final ImageDescriptor NOTIFICATION_CLOSE;
    public static final ImageDescriptor NOTIFICATION_CLOSE_HOVER;
    public static final ImageDescriptor NOTIFICATION_PREFERENCES_HOVER;
    public static final ImageDescriptor NOTIFICATION_PREFERENCES;
    public static final ImageDescriptor OVERLAY_DATE_DUE;
    public static final ImageDescriptor OVERLAY_DATE_OVERDUE;
    public static final ImageDescriptor OVERLAY_SYNC_IN_PROGRESS;
    public static final ImageDescriptor OVERLAY_SYNC_INCOMMING;
    public static final ImageDescriptor OVERLAY_SYNC_INCOMMING_NEW;
    public static final ImageDescriptor OVERLAY_SYNC_OUTGOING;
    public static final ImageDescriptor OVERLAY_SYNC_OUTGOING_NEW;
    public static final ImageDescriptor OVERLAY_SYNC_CONFLICT;
    public static final ImageDescriptor OVERLAY_SYNC_WARNING;
    public static final ImageDescriptor OVERLAY_WARNING;
    public static final ImageDescriptor OVERLAY_SUCCESS;
    public static final ImageDescriptor OVERLAY_ERROR;
    public static final ImageDescriptor OVERLAY_FAILED;
    public static final ImageDescriptor OVERLAY_SYNC_OLD_INCOMMING;
    public static final ImageDescriptor OVERLAY_SYNC_OLD_INCOMMING_NEW;
    public static final ImageDescriptor OVERLAY_SYNC_OLD_OUTGOING;
    public static final ImageDescriptor OVERLAY_CLEAR;
    public static final ImageDescriptor OVERLAY_WHITE;
    public static final ImageDescriptor BANNER_SCREENSHOT;
    public static final ImageDescriptor BANNER_IMPORT;
    public static final ImageDescriptor BANNER_EXPORT;
    public static final ImageDescriptor DISCOVERY;
    public static final ImageDescriptor BANNER_DISOVERY;
    public static final ImageDescriptor COMPLETE;
    public static final ImageDescriptor CHECKED;
    public static final ImageDescriptor REMOVE;
    public static final ImageDescriptor DELETE;
    public static final ImageDescriptor WARNING;
    public static final ImageDescriptor FILTER_COMPLETE;
    public static final ImageDescriptor FILTER_ARCHIVE;
    public static final ImageDescriptor FILTER_PRIORITY;
    public static final ImageDescriptor COLOR_PALETTE;
    public static final ImageDescriptor FILTER;
    public static final ImageDescriptor FIND_CLEAR;
    public static final ImageDescriptor FIND_CLEAR_DISABLED;
    public static final ImageDescriptor BROWSER_SMALL;
    public static final ImageDescriptor BROWSER_OPEN_TASK;
    public static final ImageDescriptor TOOLBAR_ARROW_RIGHT;
    public static final ImageDescriptor TOOLBAR_ARROW_DOWN;
    public static final ImageDescriptor LINK_EDITOR;
    public static final ImageDescriptor CLEAR;
    public static final ImageDescriptor EDIT;
    public static final ImageDescriptor EDIT_SMALL;
    public static final ImageDescriptor CUT;
    public static final ImageDescriptor UNDO;
    public static final ImageDescriptor REDO;
    public static final ImageDescriptor STATUS_NORMAL;
    public static final ImageDescriptor STATUS_CONTEXT;
    public static final ImageDescriptor PRESENTATION;
    public static final ImageDescriptor GROUPING;
    public static final ImageDescriptor COPY;
    public static final ImageDescriptor GO_UP;
    public static final ImageDescriptor GO_INTO;
    public static final ImageDescriptor REFRESH;
    public static final ImageDescriptor REFRESH_SMALL;
    public static final ImageDescriptor COLLAPSE_ALL;
    public static final ImageDescriptor COLLAPSE_ALL_SMALL;
    public static final ImageDescriptor EXPAND_ALL;
    public static final ImageDescriptor EXPAND_ALL_SMALL;
    public static final ImageDescriptor BLANK;
    public static final ImageDescriptor IMAGE_CAPTURE;
    public static final ImageDescriptor IMAGE_FIT;
    public static final ImageDescriptor IMAGE_FILE;
    public static final ImageDescriptor FILE_PLAIN;
    public static final ImageDescriptor FILE_PLAIN_SMALL;
    public static final ImageDescriptor NOTES_SMALL;
    public static final ImageDescriptor QUESTION;
    public static final ImageDescriptor INFORMATION;
    public static final ImageDescriptor SEPARATOR_LIST;
    public static final ImageDescriptor PART_MAXIMIZE;
    public static final ImageDescriptor PREVIEW_WEB;
    public static final ImageDescriptor WEB;
    public static final ImageDescriptor FIND;
    public static final ImageDescriptor SAVE;
    public static final ImageDescriptor VALIDATE;
    public static final ImageDescriptor NOTIFICATION_CONFIGURE;
    public static final ImageDescriptor NOTIFICATION_CONFIGURE_HOVER;
    private static Image[] progressImages;

    static {
        PRIORITY_1 = CommonImages.create(T_OBJ, "priority-1.gif");
        PRIORITY_2 = CommonImages.create(T_OBJ, "priority-2.gif");
        PRIORITY_3 = CommonImages.create(T_OBJ, "priority-3.gif");
        PRIORITY_4 = CommonImages.create(T_OBJ, "priority-4.gif");
        PRIORITY_5 = CommonImages.create(T_OBJ, "priority-5.gif");
        PRIORITY_1_LARGE = CommonImages.create(T_OBJ_32, "priority-critical.png");
        PRIORITY_2_LARGE = CommonImages.create(T_OBJ_32, "priority-high.png");
        PRIORITY_3_LARGE = CommonImages.create(T_OBJ_32, "priority-normal.png");
        PRIORITY_4_LARGE = CommonImages.create(T_OBJ_32, "priority-low.png");
        PRIORITY_5_LARGE = CommonImages.create(T_OBJ_32, "priority-very-low.png");
        CALENDAR = CommonImages.create(T_TOOL, "calendar.gif");
        CALENDAR_SMALL = CommonImages.create(T_OBJ, "calendar-small.gif");
        SCHEDULE = CommonImages.create(T_TOOL, "schedule.png");
        SCHEDULE_DAY = CommonImages.create(T_TOOL, "schedule-day.png");
        SCHEDULE_WEEK = CommonImages.create(T_TOOL, "schedule-week.png");
        PERSON = CommonImages.create(T_TOOL, "person.gif");
        PERSON_NARROW = CommonImages.create(T_TOOL, "person-narrow.gif");
        PERSON_ME = CommonImages.create(T_TOOL, "person-me.gif");
        PERSON_ME_SMALL = CommonImages.create(T_TOOL, "person-me-small.png");
        PERSON_ME_NARROW = CommonImages.create(T_TOOL, "person-me-narrow.gif");
        NOTIFICATION_CLOSE = CommonImages.create(T_EVIEW, "notification-close.gif");
        NOTIFICATION_CLOSE_HOVER = CommonImages.create(T_EVIEW, "notification-close-active.gif");
        NOTIFICATION_PREFERENCES_HOVER = CommonImages.create(T_EVIEW, "notification-preferences-active.png");
        NOTIFICATION_PREFERENCES = CommonImages.create(T_EVIEW, "notification-preferences-inactive.png");
        OVERLAY_DATE_DUE = CommonImages.create(T_EVIEW, "overlay-has-due.gif");
        OVERLAY_DATE_OVERDUE = CommonImages.create(T_EVIEW, "overlay-overdue.gif");
        OVERLAY_SYNC_IN_PROGRESS = CommonImages.create(T_EVIEW, "overlay-synchronizing.gif");
        OVERLAY_SYNC_INCOMMING = CommonImages.create(T_EVIEW, "overlay-incoming.gif");
        OVERLAY_SYNC_INCOMMING_NEW = CommonImages.create(T_EVIEW, "overlay-incoming-new.gif");
        OVERLAY_SYNC_OUTGOING = CommonImages.create(T_EVIEW, "overlay-outgoing.gif");
        OVERLAY_SYNC_OUTGOING_NEW = CommonImages.create(T_EVIEW, "overlay-outgoing-new.gif");
        OVERLAY_SYNC_CONFLICT = CommonImages.create(T_EVIEW, "overlay-conflict.gif");
        OVERLAY_SYNC_WARNING = CommonImages.create(T_OVR, "overlay-sync-warning.gif");
        OVERLAY_WARNING = CommonImages.create(T_OVR, "warning_ovr.gif");
        OVERLAY_SUCCESS = CommonImages.create(T_OVR, "success_ovr.gif");
        OVERLAY_ERROR = CommonImages.create(T_OVR, "error_ovr.gif");
        OVERLAY_FAILED = CommonImages.create(T_OVR, "failed_ovr.gif");
        OVERLAY_SYNC_OLD_INCOMMING = CommonImages.create(T_EVIEW, "overlay-synch-incoming.gif");
        OVERLAY_SYNC_OLD_INCOMMING_NEW = CommonImages.create(T_EVIEW, "overlay-synch-incoming-new.gif");
        OVERLAY_SYNC_OLD_OUTGOING = CommonImages.create(T_EVIEW, "overlay-synch-outgoing.gif");
        OVERLAY_CLEAR = CommonImages.create(T_OVR, "overlay-blank.gif");
        OVERLAY_WHITE = CommonImages.create(T_OVR, "solid-white.gif");
        BANNER_SCREENSHOT = CommonImages.create(T_WIZBAN, "banner-screenshot.png");
        BANNER_IMPORT = CommonImages.create(T_WIZBAN, "banner-import.gif");
        BANNER_EXPORT = CommonImages.create(T_WIZBAN, "banner-export.gif");
        DISCOVERY = CommonImages.create(T_TOOL, "discovery.png");
        BANNER_DISOVERY = CommonImages.create(T_WIZBAN, "banner-discovery.png");
        COMPLETE = CommonImages.create(T_OBJ, "complete.gif");
        CHECKED = CommonImages.create(T_OBJ, "checked.gif");
        REMOVE = CommonImages.create(T_ELCL, "remove.gif");
        DELETE = CommonImages.create(T_ELCL, "delete.gif");
        WARNING = CommonImages.create(T_ELCL, "warning.gif");
        FILTER_COMPLETE = CommonImages.create(T_ELCL, "filter-complete.gif");
        FILTER_ARCHIVE = CommonImages.create(T_ELCL, "filter-archive.gif");
        FILTER_PRIORITY = CommonImages.create(T_ELCL, "filter-priority.gif");
        COLOR_PALETTE = CommonImages.create(T_ELCL, "color-palette.gif");
        FILTER = CommonImages.create(T_TOOL, "view-filter.gif");
        FIND_CLEAR = CommonImages.create(T_TOOL, "find-clear.gif");
        FIND_CLEAR_DISABLED = CommonImages.create(T_TOOL, "find-clear-disabled.gif");
        BROWSER_SMALL = CommonImages.create(T_OBJ, "browser-small.gif");
        BROWSER_OPEN_TASK = CommonImages.create(T_TOOL, "open-browser.gif");
        TOOLBAR_ARROW_RIGHT = CommonImages.create(T_TOOL, "toolbar-arrow-right.gif");
        TOOLBAR_ARROW_DOWN = CommonImages.create(T_TOOL, "toolbar-arrow-down.gif");
        LINK_EDITOR = CommonImages.create(T_TOOL, "link-editor.gif");
        CLEAR = CommonImages.create(T_TOOL, "clear.gif");
        EDIT = CommonImages.create(T_TOOL, "edit.gif");
        EDIT_SMALL = CommonImages.create(T_TOOL, "edit-small.png");
        CUT = CommonImages.create(T_TOOL, "cut.gif");
        UNDO = CommonImages.create(T_TOOL, "undo_edit.gif");
        REDO = CommonImages.create(T_TOOL, "redo_edit.gif");
        STATUS_NORMAL = CommonImages.create(T_EVIEW, "status-normal.gif");
        STATUS_CONTEXT = CommonImages.create(T_EVIEW, "status-server-context.gif");
        PRESENTATION = CommonImages.create(T_TOOL, "presentation.gif");
        GROUPING = CommonImages.create(T_TOOL, "grouping.gif");
        COPY = CommonImages.create(T_TOOL, "copy.png");
        GO_UP = CommonImages.create(T_TOOL, "go-up.gif");
        GO_INTO = CommonImages.create(T_TOOL, "go-into.gif");
        REFRESH = CommonImages.create(T_ELCL, "refresh.gif");
        REFRESH_SMALL = CommonImages.create(T_ELCL, "refresh-small.gif");
        COLLAPSE_ALL = CommonImages.create(T_ELCL, "collapseall.png");
        COLLAPSE_ALL_SMALL = CommonImages.create(T_ELCL, "collapseall-small.png");
        EXPAND_ALL = CommonImages.create(T_ELCL, "expandall.gif");
        EXPAND_ALL_SMALL = CommonImages.create(T_ELCL, "expandall-small.png");
        BLANK = CommonImages.create(T_ELCL, "blank.gif");
        IMAGE_CAPTURE = CommonImages.create(T_TOOL, "capture-screen.png");
        IMAGE_FIT = CommonImages.create(T_TOOL, "capture-fit.png");
        IMAGE_FILE = CommonImages.create(T_OBJ, "file-image.gif");
        FILE_PLAIN = CommonImages.create(T_OBJ, "file-plain.png");
        FILE_PLAIN_SMALL = CommonImages.create(T_OBJ, "file-small.png");
        NOTES_SMALL = CommonImages.create(T_OBJ, "notes-small.png");
        QUESTION = CommonImages.create(T_OBJ, "question.gif");
        INFORMATION = CommonImages.create(T_OBJ, "message_info.gif");
        SEPARATOR_LIST = CommonImages.create(T_TOOL, "content-assist-separator.gif");
        PART_MAXIMIZE = CommonImages.create(T_TOOL, "maximize.png");
        PREVIEW_WEB = CommonImages.create(T_TOOL, "preview-web.png");
        WEB = CommonImages.create(T_TOOL, "web.png");
        FIND = CommonImages.create(T_TOOL, "find.gif");
        SAVE = CommonImages.create(T_TOOL, "save.gif");
        VALIDATE = CommonImages.create(T_OBJ, "resource_obj.gif");
        NOTIFICATION_CONFIGURE = CommonImages.create(T_TOOL, "notification-configure.gif");
        NOTIFICATION_CONFIGURE_HOVER = CommonImages.create(T_TOOL, "notification-configure-active.gif");
    }

    private static ImageDescriptor create(String prefix, String name) {
        try {
            return ImageDescriptor.createFromURL((URL)CommonImages.makeIconFileURL(prefix, name));
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    public static Image getImage(ImageDescriptor imageDescriptor) {
        ImageRegistry imageRegistry = CommonImages.getImageRegistry();
        Image image = imageRegistry.get("" + imageDescriptor.hashCode());
        if (image == null) {
            image = imageDescriptor.createImage(true);
            imageRegistry.put("" + imageDescriptor.hashCode(), image);
        }
        return image;
    }

    public static Image getImageWithOverlay(ImageDescriptor icon, ImageDescriptor overlay, boolean top, boolean left) {
        if (icon == null) {
            return null;
        }
        String key = "" + icon.hashCode();
        if (overlay != null) {
            key = String.valueOf(key) + overlay.hashCode();
        }
        key = String.valueOf(key) + new Boolean(top).hashCode();
        key = String.valueOf(key) + new Boolean(left).hashCode();
        Image image = CommonImages.getImageRegistry().get(key);
        if (image == null) {
            TaskListImageDescriptor imageDescriptor = new TaskListImageDescriptor(icon, overlay, top, left);
            image = imageDescriptor.createImage(true);
            CommonImages.getImageRegistry().put(key, image);
        }
        return image;
    }

    public static Image getCompositeTaskImage(ImageDescriptor icon, ImageDescriptor overlayKind, boolean wide) {
        Image image;
        if (icon == null) {
            return null;
        }
        String key = "" + icon.hashCode();
        if (overlayKind != null) {
            key = String.valueOf(key) + overlayKind.hashCode();
        }
        if (wide) {
            key = String.valueOf(key) + ".wide";
        }
        if ((image = CommonImages.getImageRegistry().get(key)) == null) {
            CompositeElementImageDescriptor imageDescriptor = new CompositeElementImageDescriptor(icon, overlayKind, wide);
            image = imageDescriptor.createImage(true);
            CommonImages.getImageRegistry().put(key, image);
        }
        return image;
    }

    public static Image getCompositeContainerImage(ImageDescriptor icon, boolean wide) {
        Image image;
        if (icon == null) {
            return null;
        }
        String key = "" + icon.hashCode();
        if (wide) {
            key = String.valueOf(key) + ".wide";
        }
        if ((image = CommonImages.getImageRegistry().get(key)) == null) {
            CompositeContainerImageDescriptor imageDescriptor = new CompositeContainerImageDescriptor(icon, OVERLAY_CLEAR, wide);
            image = imageDescriptor.createImage(true);
            CommonImages.getImageRegistry().put(key, image);
        }
        return image;
    }

    public static Image getCompositeSynchImage(ImageDescriptor icon, boolean background) {
        Image image;
        String key = "" + icon.hashCode();
        if (background) {
            key = String.valueOf(key) + ".background";
        }
        if ((image = CommonImages.getImageRegistry().get(key)) == null) {
            CompositeSyncImageDescriptor imageDescriptor = new CompositeSyncImageDescriptor(icon, background);
            image = imageDescriptor.createImage(true);
            CommonImages.getImageRegistry().put(key, image);
        }
        return image;
    }

    private static ImageRegistry getImageRegistry() {
        if (imageRegistry == null) {
            imageRegistry = new ImageRegistry();
        }
        return imageRegistry;
    }

    private static URL makeIconFileURL(String prefix, String name) throws MalformedURLException {
        if (baseURL == null) {
            throw new MalformedURLException();
        }
        StringBuffer buffer = new StringBuffer(prefix);
        buffer.append('/');
        buffer.append(name);
        return new URL(baseURL, buffer.toString());
    }

    public static Image[] getProgressImages() {
        if (progressImages != null) {
            return progressImages;
        }
        progressImages = new Image[8];
        int i = 1;
        while (i <= 8) {
            ImageDescriptor imageDescriptor = CommonImages.create("eview16/progress", String.valueOf(i) + ".png");
            CommonImages.progressImages[i - 1] = CommonImages.getImage(imageDescriptor);
            ++i;
        }
        return progressImages;
    }
}

