/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.provisional.commons.ui;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Calendar;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.mylyn.internal.commons.ui.CommonsUiPlugin;
import org.eclipse.mylyn.internal.commons.ui.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.IIdentifier;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.internal.browser.WebBrowserPreference;
import org.eclipse.ui.internal.browser.WorkbenchBrowserSupport;

public class WorkbenchUtil {
    public static final QualifiedName SHOW_IN_TASKBAR_ICON_PROPERTY = new QualifiedName("org.eclipse.ui.workbench.progress", "inTaskBarIcon");
    private static final boolean TEST_MODE;

    static {
        String application = System.getProperty("eclipse.application", "");
        if (application.length() > 0) {
            TEST_MODE = application.endsWith("testapplication");
        } else {
            String commands = System.getProperty("eclipse.commands", "");
            TEST_MODE = commands.contains("testapplication\n");
        }
    }

    public static IViewPart showViewInActiveWindow(String viewId) {
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            try {
                return page.showView(viewId);
            }
            catch (PartInitException partInitException) {}
        }
        return null;
    }

    private static Shell getModalShellExcluding(Shell shell) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        Shell[] shells = workbench.getDisplay().getShells();
        int modal = 229376;
        Shell[] shellArray = shells;
        int n = shells.length;
        int n2 = 0;
        while (n2 < n) {
            int style;
            Shell shell2 = shellArray[n2];
            if (shell2.equals(shell)) break;
            if (shell2.isVisible() && ((style = shell2.getStyle()) & modal) != 0) {
                return shell2;
            }
            ++n2;
        }
        return null;
    }

    public static Shell getShell() {
        if (!PlatformUI.isWorkbenchRunning() || PlatformUI.getWorkbench().isClosing()) {
            return null;
        }
        Shell modal = WorkbenchUtil.getModalShellExcluding(null);
        if (modal != null) {
            return modal;
        }
        return WorkbenchUtil.getNonModalShell();
    }

    private static Shell getNonModalShell() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            if (windows.length > 0) {
                return windows[0].getShell();
            }
        } else {
            return window.getShell();
        }
        return null;
    }

    public static final boolean isFiltering() {
        return !PlatformUI.getWorkbench().getActivitySupport().getActivityManager().getDefinedActivityIds().isEmpty();
    }

    public static boolean allowUseOf(Object object) {
        IPluginContribution contribution;
        if (!WorkbenchUtil.isFiltering()) {
            return true;
        }
        if (object instanceof IPluginContribution && (contribution = (IPluginContribution)object).getPluginId() != null) {
            IWorkbenchActivitySupport workbenchActivitySupport = PlatformUI.getWorkbench().getActivitySupport();
            IIdentifier identifier = workbenchActivitySupport.getActivityManager().getIdentifier(WorkbenchUtil.createUnifiedId(contribution));
            return identifier.isEnabled();
        }
        if (object instanceof String) {
            IWorkbenchActivitySupport workbenchActivitySupport = PlatformUI.getWorkbench().getActivitySupport();
            IIdentifier identifier = workbenchActivitySupport.getActivityManager().getIdentifier((String)object);
            return identifier.isEnabled();
        }
        return true;
    }

    private static final String createUnifiedId(IPluginContribution contribution) {
        if (contribution.getPluginId() != null) {
            return String.valueOf(contribution.getPluginId()) + '/' + contribution.getLocalId();
        }
        return contribution.getLocalId();
    }

    public static void openUrl(String location) {
        WorkbenchUtil.openUrl(location, 0);
    }

    public static void openUrl(String location, int customFlags) {
        try {
            URL url = null;
            if (location != null) {
                url = new URL(location);
            }
            if (WebBrowserPreference.getBrowserChoice() == 1 || (customFlags & 0x80) != 0) {
                try {
                    IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
                    support.getExternalBrowser().openURL(url);
                }
                catch (PartInitException partInitException) {
                    Status status = new Status(4, "org.eclipse.mylyn.commons.ui", Messages.WorkbenchUtil_Browser_Initialization_Failed);
                    CommonsUiPlugin.getDefault().getLog().log((IStatus)status);
                    if (!TEST_MODE) {
                        MessageDialog.openError((Shell)WorkbenchUtil.getShell(), (String)Messages.WorkbenchUtil_Open_Location_Title, (String)status.getMessage());
                    }
                }
            } else {
                IWebBrowser browser = null;
                int flags = customFlags;
                flags = WorkbenchBrowserSupport.getInstance().isInternalWebBrowserAvailable() ? (flags |= 0x26) : (flags |= 0x86);
                String generatedId = "org.eclipse.mylyn.web.browser-" + Calendar.getInstance().getTimeInMillis();
                browser = WorkbenchBrowserSupport.getInstance().createBrowser(flags, generatedId, null, null);
                browser.openURL(url);
            }
        }
        catch (PartInitException e) {
            Status status = new Status(4, "org.eclipse.mylyn.commons.ui", Messages.WorkbenchUtil_Browser_Initialization_Failed, (Throwable)e);
            CommonsUiPlugin.getDefault().getLog().log((IStatus)status);
            if (!TEST_MODE) {
                MessageDialog.openError((Shell)WorkbenchUtil.getShell(), (String)Messages.WorkbenchUtil_Open_Location_Title, (String)status.getMessage());
            }
        }
        catch (MalformedURLException e) {
            if (location != null && location.trim().equals("")) {
                Status status = new Status(2, "org.eclipse.mylyn.commons.ui", Messages.WorkbenchUtil_No_URL_Error, (Throwable)e);
                if (!TEST_MODE) {
                    MessageDialog.openWarning((Shell)WorkbenchUtil.getShell(), (String)Messages.WorkbenchUtil_Open_Location_Title, (String)status.getMessage());
                } else {
                    CommonsUiPlugin.getDefault().getLog().log((IStatus)status);
                }
            }
            Status status = new Status(4, "org.eclipse.mylyn.commons.ui", NLS.bind((String)Messages.WorkbenchUtil_Invalid_URL_Error, (Object)location), (Throwable)e);
            if (!TEST_MODE) {
                MessageDialog.openError((Shell)WorkbenchUtil.getShell(), (String)Messages.WorkbenchUtil_Open_Location_Title, (String)status.getMessage());
            }
            CommonsUiPlugin.getDefault().getLog().log((IStatus)status);
        }
    }
}

