/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.commons.repositories;

import java.io.IOException;
import org.eclipse.equinox.security.storage.EncodingUtils;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.mylyn.commons.repositories.auth.ICredentialsStore;

public class SecureCredentialsStore
implements ICredentialsStore {
    private static final String ID_PLUGIN = "org.eclipse.mylyn.commons.repository";
    private final String url;

    public SecureCredentialsStore(String url) {
        this.url = url;
    }

    public void clear() {
        this.getSecurePreferences().removeNode();
    }

    public void flush() throws IOException {
        this.getSecurePreferences().flush();
    }

    public String get(String key, String def) throws StorageException {
        return this.getSecurePreferences().get(key, def);
    }

    public byte[] getByteArray(String key, byte[] def) throws StorageException {
        return this.getSecurePreferences().getByteArray(key, def);
    }

    private ISecurePreferences getSecurePreferences() {
        ISecurePreferences securePreferences = SecurePreferencesFactory.getDefault().node(ID_PLUGIN);
        securePreferences = securePreferences.node(EncodingUtils.encodeSlashes((String)this.getUrl()));
        return securePreferences;
    }

    public String getUrl() {
        return this.url;
    }

    public String[] keys() {
        return this.getSecurePreferences().keys();
    }

    public void put(String key, String value, boolean encrypt) throws StorageException {
        this.getSecurePreferences().put(key, value, encrypt);
    }

    public void putByteArray(String key, byte[] value, boolean encrypt) throws StorageException {
        this.getSecurePreferences().putByteArray(key, value, encrypt);
    }

    public void remove(String key) {
        this.getSecurePreferences().remove(key);
    }

    public void copyTo(ICredentialsStore target) throws StorageException {
        ISecurePreferences preferences = this.getSecurePreferences();
        String[] stringArray = preferences.keys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            target.put(key, preferences.get(key, null), preferences.isEncrypted(key));
            ++n2;
        }
    }
}

